/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgresbase;

import com.intellij.database.DataGridBundle;
import com.intellij.database.connection.throwable.KnownDatabaseException;
import com.intellij.database.connection.throwable.info.ErrorInfo;
import com.intellij.database.dataSource.DatabaseConnectionInterceptor;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.DatabaseFastConnectionInterceptor;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.dialects.BaseDatabaseErrorHandler;
import com.intellij.database.dialects.DatabaseFixFactory;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PgBaseUrlCheckingInterceptor
extends DatabaseFastConnectionInterceptor {
    @Override
    public boolean interceptConnectionFast(@NotNull DatabaseConnectionInterceptor.ProtoConnection proto2, boolean silent) {
        if (proto2 == null) {
            PgBaseUrlCheckingInterceptor.$$$reportNull$$$0(0);
        }
        return proto2.getConnectionPoint().getDbms().isPostgres();
    }

    @Override
    public boolean handleNullConnectionFast(@NotNull DatabaseConnectionInterceptor.ProtoConnection proto2, boolean silent, int attempt) {
        if (proto2 == null) {
            PgBaseUrlCheckingInterceptor.$$$reportNull$$$0(1);
        }
        if (PgBaseUrlCheckingInterceptor.canFixUrl(proto2.getConnectionPoint())) {
            throw new KnownDatabaseException(new UrlMissingSlashInfo(proto2.getConnectionPoint().getDataSource()));
        }
        return false;
    }

    @NotNull
    public static String fixUrl(@NotNull String url, @NotNull LocalDataSource dataSource2) {
        String fixed;
        if (url == null) {
            PgBaseUrlCheckingInterceptor.$$$reportNull$$$0(2);
        }
        if (dataSource2 == null) {
            PgBaseUrlCheckingInterceptor.$$$reportNull$$$0(3);
        }
        if (PgBaseUrlCheckingInterceptor.isValidUrl(dataSource2, url)) {
            String string = url;
            if (string == null) {
                PgBaseUrlCheckingInterceptor.$$$reportNull$$$0(4);
            }
            return string;
        }
        int qIdx = url.indexOf("?");
        if (qIdx == -1) {
            if (url.endsWith("/")) {
                String string = url;
                if (string == null) {
                    PgBaseUrlCheckingInterceptor.$$$reportNull$$$0(5);
                }
                return string;
            }
            fixed = url + "/";
        } else {
            if (qIdx == 0 || url.charAt(qIdx - 1) == '/') {
                String string = url;
                if (string == null) {
                    PgBaseUrlCheckingInterceptor.$$$reportNull$$$0(6);
                }
                return string;
            }
            fixed = url.substring(0, qIdx) + "/" + url.substring(qIdx);
        }
        if (PgBaseUrlCheckingInterceptor.isValidUrl(dataSource2, fixed)) {
            String string = fixed;
            if (string == null) {
                PgBaseUrlCheckingInterceptor.$$$reportNull$$$0(7);
            }
            return string;
        }
        String string = url;
        if (string == null) {
            PgBaseUrlCheckingInterceptor.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static boolean isValidUrl(@NotNull LocalDataSource dataSource2, @NotNull String url) {
        if (dataSource2 == null) {
            PgBaseUrlCheckingInterceptor.$$$reportNull$$$0(9);
        }
        if (url == null) {
            PgBaseUrlCheckingInterceptor.$$$reportNull$$$0(10);
        }
        return JdbcUrlParserUtil.select(dataSource2, url) != null;
    }

    public static boolean canFixUrl(@NotNull DatabaseConnectionPoint point) {
        String url;
        if (point == null) {
            PgBaseUrlCheckingInterceptor.$$$reportNull$$$0(11);
        }
        if ((url = point.getUrl()) == null) {
            return false;
        }
        String fixed = PgBaseUrlCheckingInterceptor.fixUrl(url, point.getDataSource());
        return !url.equals(fixed);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "proto";
                break;
            }
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/postgresbase/PgBaseUrlCheckingInterceptor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/postgresbase/PgBaseUrlCheckingInterceptor";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "fixUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "interceptConnectionFast";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "handleNullConnectionFast";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fixUrl";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isValidUrl";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "canFixUrl";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 8 -> new IllegalStateException(string);
        };
    }

    public static class UrlMissingSlashInfo
    extends BaseDatabaseErrorHandler.DatabaseErrorInfo {
        public UrlMissingSlashInfo(@Nullable LocalDataSource dataSource2) {
            this(dataSource2, new Throwable());
        }

        private UrlMissingSlashInfo(@Nullable LocalDataSource dataSource2, @NotNull Throwable original) {
            if (original == null) {
                UrlMissingSlashInfo.$$$reportNull$$$0(0);
            }
            this(dataSource2, original, original);
        }

        public UrlMissingSlashInfo(@Nullable LocalDataSource dataSource2, @NotNull Throwable original, @NotNull Throwable cause) {
            if (original == null) {
                UrlMissingSlashInfo.$$$reportNull$$$0(1);
            }
            if (cause == null) {
                UrlMissingSlashInfo.$$$reportNull$$$0(2);
            }
            super(dataSource2, original, cause);
        }

        @Override
        protected void fillInfoData(@Nls @NotNull StringBuilder sb, @NotNull List<ErrorInfo.Fix> fixes) {
            String url;
            if (sb == null) {
                UrlMissingSlashInfo.$$$reportNull$$$0(3);
            }
            if (fixes == null) {
                UrlMissingSlashInfo.$$$reportNull$$$0(4);
            }
            sb.append(DataGridBundle.message((String)"looks.like.the.connection.string.is.missing", (Object[])new Object[0]));
            LocalDataSource dataSource2 = this.getDataSource();
            DatabaseFixFactory ff = DatabaseFixFactory.getInstance();
            String string = url = dataSource2 == null ? null : dataSource2.getUrl();
            if (ff != null && url != null) {
                fixes.add(ff.setUrl(dataSource2, DataGridBundle.message((String)"add.to.connection.string", (Object[])new Object[0]), PgBaseUrlCheckingInterceptor.fixUrl(url, dataSource2)));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cause";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sb";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fixes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dialects/postgresbase/PgBaseUrlCheckingInterceptor$UrlMissingSlashInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fillInfoData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

