/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.tns;

import com.intellij.database.dialects.oracle.tns.OraTnsLexer;
import com.intellij.database.dialects.oracle.tns.OraTnsToken;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.Consumer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;

public abstract class OraTnsNamesExtractor {
    private final OraTnsLexer myLexer = new OraTnsLexer();

    public static void extract(@NotNull File file, @NotNull Consumer<String> consumer2) throws IOException {
        if (file == null) {
            OraTnsNamesExtractor.$$$reportNull$$$0(0);
        }
        if (consumer2 == null) {
            OraTnsNamesExtractor.$$$reportNull$$$0(1);
        }
        OraTnsNamesExtractor.extract(FileUtil.loadFile((File)file), consumer2);
    }

    public static void extract(@NotNull CharSequence seq, final @NotNull Consumer<String> consumer2) {
        if (seq == null) {
            OraTnsNamesExtractor.$$$reportNull$$$0(2);
        }
        if (consumer2 == null) {
            OraTnsNamesExtractor.$$$reportNull$$$0(3);
        }
        new OraTnsNamesExtractor(){

            @Override
            protected boolean processDescription(@NotNull String alias, @Nullable String description) {
                if (alias == null) {
                    1.$$$reportNull$$$0(0);
                }
                consumer2.consume((Object)alias);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "alias", "com/intellij/database/dialects/oracle/tns/OraTnsNamesExtractor$1", "processDescription"));
            }
        }.run(seq);
    }

    private OraTnsNamesExtractor() {
    }

    protected void run(@NotNull CharSequence seq) {
        if (seq == null) {
            OraTnsNamesExtractor.$$$reportNull$$$0(4);
        }
        this.myLexer.start(seq);
        while (this.myLexer.getTokenType() != null) {
            if (this.consumeParameter()) continue;
            return;
        }
    }

    protected boolean extractDescription(@NotNull String alias) {
        if (alias == null) {
            OraTnsNamesExtractor.$$$reportNull$$$0(5);
        }
        return false;
    }

    protected abstract boolean processDescription(@NotNull String var1, @Nullable String var2);

    private static void optAdd(@NotNull List<String> list, @Nullable String s2) {
        if (list == null) {
            OraTnsNamesExtractor.$$$reportNull$$$0(6);
        }
        if (s2 != null) {
            list.add(s2);
        }
    }

    private boolean consumeParameter() {
        ArrayList<String> aliases = new ArrayList<String>();
        OraTnsNamesExtractor.optAdd(aliases, this.getAlias());
        while (this.myLexer.getTokenType() == OraTnsToken.COMMA) {
            this.myLexer.advance();
            OraTnsNamesExtractor.optAdd(aliases, this.getAlias());
        }
        while (this.myLexer.getTokenType() != null && this.myLexer.getTokenType() != OraTnsToken.LPAREN && this.myLexer.getTokenType() != OraTnsToken.EQUALS) {
            this.myLexer.advance();
        }
        if (this.myLexer.getTokenType() == null) {
            return false;
        }
        boolean tnsName = false;
        if (this.myLexer.getTokenType() == OraTnsToken.EQUALS) {
            this.myLexer.advance();
            tnsName = true;
        }
        int start2 = this.myLexer.getTokenStart();
        if (tnsName &= this.consumeBraced()) {
            boolean extractDesc = false;
            for (String alias : aliases) {
                extractDesc |= this.extractDescription(alias);
            }
            String desc = extractDesc ? this.myLexer.getBufferSequence().subSequence(start2, this.myLexer.getTokenStart()).toString() : null;
            for (String alias : aliases) {
                if (this.processDescription(alias, desc)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean consumeBraced() {
        int braceCount = 0;
        int tokenCount = 0;
        boolean tnsName = false;
        while (this.myLexer.getTokenType() != null && (braceCount != 0 || this.myLexer.getTokenType() != OraTnsToken.IDENTIFIER)) {
            if (tokenCount == 0) {
                tnsName = this.myLexer.getTokenType() == OraTnsToken.LPAREN;
            } else if (tokenCount == 1) {
                tnsName &= this.myLexer.getTokenType() == OraTnsToken.IDENTIFIER;
                tnsName &= this.myLexer.getTokenText().equalsIgnoreCase("description_list") || this.myLexer.getTokenText().equalsIgnoreCase("description");
            }
            ++tokenCount;
            if (this.myLexer.getTokenType() == OraTnsToken.LPAREN) {
                ++braceCount;
            }
            if (this.myLexer.getTokenType() == OraTnsToken.RPAREN) {
                --braceCount;
            }
            if (braceCount < 0) {
                braceCount = 0;
            }
            this.myLexer.advance();
        }
        return tnsName;
    }

    @Nullable
    private String getAlias() {
        if (this.myLexer.getTokenType() != OraTnsToken.IDENTIFIER) {
            return null;
        }
        String res2 = this.myLexer.getTokenText();
        this.myLexer.advance();
        return res2;
    }

    public static String extractAlias(@NotNull File file, @NotNull String alias) throws IOException {
        if (file == null) {
            OraTnsNamesExtractor.$$$reportNull$$$0(7);
        }
        if (alias == null) {
            OraTnsNamesExtractor.$$$reportNull$$$0(8);
        }
        return OraTnsNamesExtractor.extractAlias(FileUtil.loadFile((File)file), alias);
    }

    public static String extractAlias(@NotNull CharSequence seq, @NotNull String alias) {
        if (seq == null) {
            OraTnsNamesExtractor.$$$reportNull$$$0(9);
        }
        if (alias == null) {
            OraTnsNamesExtractor.$$$reportNull$$$0(10);
        }
        class E
        extends OraTnsNamesExtractor {
            String desc;
            final /* synthetic */ String val$alias;

            E(String string) {
                this.val$alias = string;
            }

            @Override
            protected boolean extractDescription(@NotNull String a) {
                if (a == null) {
                    E.$$$reportNull$$$0(0);
                }
                return a.equals(this.val$alias);
            }

            @Override
            protected boolean processDescription(@NotNull String a, @Nullable String description) {
                if (a == null) {
                    E.$$$reportNull$$$0(1);
                }
                if (this.val$alias.equals(a)) {
                    this.desc = description;
                    return false;
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "a";
                objectArray2[1] = "com/intellij/database/dialects/oracle/tns/OraTnsNamesExtractor$1E";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extractDescription";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processDescription";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        E ex = new E(alias);
        ex.run(seq);
        return ex.desc;
    }

    @NotNull
    public static File getTnsNamesOra(@SystemIndependent @NotNull String tnsAdminDir) {
        if (tnsAdminDir == null) {
            OraTnsNamesExtractor.$$$reportNull$$$0(11);
        }
        return new File(FileUtil.toSystemDependentName((String)tnsAdminDir), "tnsnames.ora");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 2: 
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "seq";
                break;
            }
            case 5: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alias";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tnsAdminDir";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/dialects/oracle/tns/OraTnsNamesExtractor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "extract";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "run";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "extractDescription";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "optAdd";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "extractAlias";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "getTnsNamesOra";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

