/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.testing.utplsql.coverage;

import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageSuite;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcFileSystemCore;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.dialects.base.DataSourceRunConfigurationOptions;
import com.intellij.database.dialects.oracle.testing.utplsql.UtPlSqlRunConfiguration;
import com.intellij.database.dialects.oracle.testing.utplsql.UtPlSqlRunConfigurationOptions;
import com.intellij.database.dialects.oracle.testing.utplsql.coverage.UtPlSqlCoverageEngine;
import com.intellij.database.dialects.oracle.testing.utplsql.coverage.UtPlSqlCoverageRunner;
import com.intellij.database.dialects.oracle.testing.utplsql.coverage.UtPlSqlCoverageSuite;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.QNameUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.util.Function;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;
import org.codehaus.jettison.json.JSONTokener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\bH\u0016J\b\u0010\r\u001a\u00020\bH\u0016J\b\u0010\u000e\u001a\u00020\bH\u0016J\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0018"}, d2={"Lcom/intellij/database/dialects/oracle/testing/utplsql/coverage/UtPlSqlCoverageRunner;", "Lcom/intellij/coverage/CoverageRunner;", "()V", "acceptsCoverageEngine", "", "engine", "Lcom/intellij/coverage/CoverageEngine;", "extractFilePath", "", "objName", "suite", "Lcom/intellij/database/dialects/oracle/testing/utplsql/coverage/UtPlSqlCoverageSuite;", "getDataFileExtension", "getId", "getPresentableName", "loadCoverageData", "Lcom/intellij/rt/coverage/data/ProjectData;", "sessionDataFile", "Ljava/io/File;", "baseCoverageSuite", "Lcom/intellij/coverage/CoverageSuite;", "loadData", "json", "Lorg/codehaus/jettison/json/JSONObject;", "intellij.database.dialects.oracle.ex"})
@SourceDebugExtension(value={"SMAP\nUtPlSqlCoverageRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UtPlSqlCoverageRunner.kt\ncom/intellij/database/dialects/oracle/testing/utplsql/coverage/UtPlSqlCoverageRunner\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,321:1\n1855#2:322\n1855#2,2:323\n1856#2:327\n37#3,2:325\n*S KotlinDebug\n*F\n+ 1 UtPlSqlCoverageRunner.kt\ncom/intellij/database/dialects/oracle/testing/utplsql/coverage/UtPlSqlCoverageRunner\n*L\n68#1:322\n72#1:323,2\n68#1:327\n82#1:325,2\n*E\n"})
public final class UtPlSqlCoverageRunner
extends CoverageRunner {
    @NotNull
    public String getPresentableName() {
        return "utPLSQL";
    }

    @NotNull
    public String getDataFileExtension() {
        return "json";
    }

    @NotNull
    public String getId() {
        return "utPlSqlCoverageRunner";
    }

    public boolean acceptsCoverageEngine(@NotNull CoverageEngine engine) {
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        return engine instanceof UtPlSqlCoverageEngine;
    }

    @Nullable
    public ProjectData loadCoverageData(@NotNull File sessionDataFile, @Nullable CoverageSuite baseCoverageSuite) {
        Intrinsics.checkNotNullParameter((Object)sessionDataFile, (String)"sessionDataFile");
        UtPlSqlCoverageSuite utPlSqlCoverageSuite = baseCoverageSuite instanceof UtPlSqlCoverageSuite ? (UtPlSqlCoverageSuite)baseCoverageSuite : null;
        if (utPlSqlCoverageSuite == null) {
            return null;
        }
        UtPlSqlCoverageSuite suite = utPlSqlCoverageSuite;
        JSONObject json = new JSONObject(new JSONTokener(FileUtil.loadFile((File)sessionDataFile)));
        return this.loadData(json, suite);
    }

    /*
     * WARNING - void declaration
     */
    private final ProjectData loadData(JSONObject json, UtPlSqlCoverageSuite suite) {
        ProjectData res2 = new ProjectData();
        JSONArray files2 = json.getJSONArray("source_files");
        res2.getClasses();
        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)files2.length());
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int idx = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            JSONObject file = files2.getJSONObject(idx);
            JSONArray coverage = file.getJSONArray("coverage");
            ArrayList<LineData> lines = new ArrayList<LineData>();
            Iterable $this$forEach$iv2 = (Iterable)RangesKt.until((int)0, (int)coverage.length());
            boolean $i$f$forEach2 = false;
            Iterator iterator2 = $this$forEach$iv2.iterator();
            while (iterator2.hasNext()) {
                void $this$loadData_u24lambda_u242_u24lambda_u241_u24lambda_u240;
                LineData lineData;
                int element$iv2;
                int ln = element$iv2 = ((IntIterator)iterator2).nextInt();
                boolean bl2 = false;
                int ht = coverage.optInt(ln, -1);
                if (ht < 0) continue;
                LineData lineData2 = lineData = new LineData(ln + 1, null);
                ArrayList<LineData> arrayList = lines;
                boolean bl3 = false;
                $this$loadData_u24lambda_u242_u24lambda_u241_u24lambda_u240.setHits(ht);
                arrayList.add(lineData);
            }
            String string = file.getString("name");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            String name2 = this.extractFilePath(string, suite);
            ClassData classData = res2.getOrCreateClassData(name2);
            Collection $this$toTypedArray$iv = lines;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            classData.setLines(thisCollection$iv.toArray(new LineData[0]));
        }
        return res2;
    }

    private final String extractFilePath(String objName, UtPlSqlCoverageSuite suite) {
        Object object = suite.getConfiguration();
        if (object == null || (object = (UtPlSqlRunConfigurationOptions)((Object)object.getState())) == null || (object = ((DataSourceRunConfigurationOptions)((Object)object)).getDataSourceId()) == null) {
            return null;
        }
        UtPlSqlRunConfiguration dsId = object;
        DbDataSource dbDataSource = DbPsiFacade.getInstance(suite.getProject()).findDataSource((String)((Object)dsId));
        if (dbDataSource == null) {
            return null;
        }
        DbDataSource dataSource2 = dbDataSource;
        BasicSourceAware obj2 = (BasicSourceAware)QNameUtil.findByQName(dataSource2.getModel(), objName, (Function<? super DasObject, String>)((Function)arg_0 -> UtPlSqlCoverageRunner.extractFilePath$lambda$3(extractFilePath.obj.1.INSTANCE, arg_0))).filterMap(arg_0 -> UtPlSqlCoverageRunner.extractFilePath$lambda$4(extractFilePath.obj.2.INSTANCE, arg_0)).filter(BasicSourceAware.class).first();
        Project project = suite.getProject();
        LocalDataSource localDataSource = DbImplUtil.getMaybeLocalDataSource(dataSource2);
        Intrinsics.checkNotNull((Object)localDataSource);
        return DbSrcUtils.getPath(project, localDataSource, obj2, dataSource2.getModel(), DbSrcFileSystemCore.ItemType.SRC);
    }

    private static final String extractFilePath$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    private static final DasObject extractFilePath$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (DasObject)$tmp0.invoke(p0);
    }
}

