/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.introspector.jdbc;

import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.ClosableIt;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.DatabaseMetaDataWrapper;
import com.intellij.database.remote.jdbc.RemoteDatabaseMetaData;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.remote.jdbc.RemoteStatement;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.util.DbUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.JBIterable;
import java.sql.SQLException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OraMetadataWrapper
extends DatabaseMetaDataWrapper {
    public static final List<String> BAD_PREFIXES = List.of("BIN$", "CREATE$", "JAVA$", "DR$", "XDB$", "DRV$", "RUPD$", "MLOG$");

    OraMetadataWrapper(@NotNull DatabaseConnectionCore connection2, @NotNull RemoteDatabaseMetaData data) {
        if (connection2 == null) {
            OraMetadataWrapper.$$$reportNull$$$0(0);
        }
        if (data == null) {
            OraMetadataWrapper.$$$reportNull$$$0(1);
        }
        super(connection2, data);
    }

    @Override
    public ClosableIt<DatabaseMetaDataWrapper.Schema> schemas(@NotNull JBIterable<String> catalogs, @Nullable String current) {
        if (catalogs == null) {
            OraMetadataWrapper.$$$reportNull$$$0(2);
        }
        return ClosableIt.lazyAppendIfEmpty(OraMetadataWrapper.oracleSchemas(this), () -> super.schemas(catalogs, current));
    }

    /*
     * Loose catch block
     */
    @NotNull
    private static ClosableIt<DatabaseMetaDataWrapper.Schema> oracleSchemas(@NotNull DatabaseMetaDataWrapper meta) {
        if (meta == null) {
            OraMetadataWrapper.$$$reportNull$$$0(3);
        }
        String queryText2 = "select username                                                       \nfrom sys.all_users U                                                  \nwhere exists (select 1 from sys.all_objects where owner = U.username) \n   or username = user                                                 \n   or username = sys_context('userenv','current_schema')              \n";
        RemoteStatement statement2 = (RemoteStatement)JdbcNativeUtil.computeSafe(() -> meta.getConnection().getRemoteConnection().createStatement());
        if (statement2 == null) {
            ClosableIt<DatabaseMetaDataWrapper.Schema> closableIt = ClosableIt.empty();
            if (closableIt == null) {
                OraMetadataWrapper.$$$reportNull$$$0(4);
            }
            return closableIt;
        }
        ClosableIt.AutoCloseableGuard<AutoCloseable> g2 = ClosableIt.AutoCloseableGuard.guarded(() -> ((RemoteStatement)statement2).close());
        1 res2 = meta.setUp(new ClosableIt.ResultSetDelegateIt<DatabaseMetaDataWrapper.Schema>((RemoteResultSet)JdbcNativeUtil.computeRemote(() -> statement2.executeQuery(queryText2)), g2.get()){

            @Override
            protected DatabaseMetaDataWrapper.Schema calcValue() throws SQLException {
                return new DatabaseMetaDataWrapper.Schema(DbUtil.intern(this.myRs.getString("USERNAME", 1)), null);
            }
        });
        g2.release();
        1 var5_7 = res2;
        if (g2 != null) {
            g2.close();
        }
        1 v1 = var5_7;
        if (v1 == null) {
            OraMetadataWrapper.$$$reportNull$$$0(5);
        }
        return v1;
        {
            catch (Throwable throwable) {
                try {
                    if (g2 != null) {
                        try {
                            g2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e2) {
                    LOG.debug((Throwable)e2);
                    ClosableIt<DatabaseMetaDataWrapper.Schema> closableIt = ClosableIt.empty();
                    if (closableIt == null) {
                        OraMetadataWrapper.$$$reportNull$$$0(6);
                    }
                    return closableIt;
                }
            }
        }
    }

    @Override
    @NotNull
    public ClosableIt<? extends DatabaseMetaDataWrapper.Table> tables(@NotNull DatabaseMetaDataWrapper.Schema schema2, @Nullable String name2, String @Nullable [] types2) throws SQLException {
        if (schema2 == null) {
            OraMetadataWrapper.$$$reportNull$$$0(7);
        }
        ClosableIt<? extends DatabaseMetaDataWrapper.Table> tableIt = super.tables(schema2, name2, types2);
        tableIt.filter(OraMetadataWrapper::isValidTable);
        ClosableIt<? extends DatabaseMetaDataWrapper.Table> closableIt = tableIt;
        if (closableIt == null) {
            OraMetadataWrapper.$$$reportNull$$$0(8);
        }
        return closableIt;
    }

    @Override
    @NotNull
    public ClosableIt<DatabaseMetaDataWrapper.Routine> routines(@NotNull DatabaseMetaDataWrapper.Schema schema2, @Nullable String pkg, @Nullable String name2) throws SQLException {
        if (schema2 == null) {
            OraMetadataWrapper.$$$reportNull$$$0(9);
        }
        ClosableIt<DatabaseMetaDataWrapper.Routine> routineIt = super.routines(schema2, pkg, name2);
        routineIt.filter(OraMetadataWrapper::isValidRoutine);
        ClosableIt<DatabaseMetaDataWrapper.Routine> closableIt = routineIt;
        if (closableIt == null) {
            OraMetadataWrapper.$$$reportNull$$$0(10);
        }
        return closableIt;
    }

    @Override
    protected boolean isUnimplemented(SQLException e2) {
        String message2 = e2.getMessage();
        if (this.getConnection().getVersion().eqCoarse(10) && message2 != null && message2.contains("ORA-00904") && ApplicationManager.getApplication().isUnitTestMode()) {
            LOG.warn((Throwable)e2);
            return true;
        }
        return super.isUnimplemented(e2);
    }

    private static boolean startsWithBadPrefix(@Nullable String s2) {
        if (s2 != null) {
            for (String prefix : BAD_PREFIXES) {
                if (!StringUtil.startsWithIgnoreCase((String)s2, (String)prefix)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isSys(@NotNull DatabaseMetaDataWrapper.Schema schema2) {
        if (schema2 == null) {
            OraMetadataWrapper.$$$reportNull$$$0(11);
        }
        return Comparing.equal((String)"sys", (String)schema2.schema, (boolean)false) || Comparing.equal((String)"sys", (String)schema2.schema, (boolean)true);
    }

    private static boolean isValidSysName(@Nullable String s2) {
        return s2 == null || !s2.contains("$");
    }

    private static boolean isValidRoutine(@NotNull DatabaseMetaDataWrapper.Routine routine2) {
        if (routine2 == null) {
            OraMetadataWrapper.$$$reportNull$$$0(12);
        }
        if (OraMetadataWrapper.isSys(routine2.schema)) {
            return OraMetadataWrapper.isValidSysName(routine2.pkg) && OraMetadataWrapper.isValidSysName(routine2.name);
        }
        return !OraMetadataWrapper.startsWithBadPrefix(routine2.pkg) && !OraMetadataWrapper.startsWithBadPrefix(routine2.name);
    }

    private static boolean isValidTable(@NotNull DatabaseMetaDataWrapper.Table table) {
        if (table == null) {
            OraMetadataWrapper.$$$reportNull$$$0(13);
        }
        if (OraMetadataWrapper.isSys(table.schema)) {
            return OraMetadataWrapper.isValidSysName(table.name);
        }
        return !OraMetadataWrapper.startsWithBadPrefix(table.name);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 8, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "catalogs";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "meta";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/oracle/introspector/jdbc/OraMetadataWrapper";
                break;
            }
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "routine";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/oracle/introspector/jdbc/OraMetadataWrapper";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "oracleSchemas";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "tables";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "routines";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "schemas";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "oracleSchemas";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "tables";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "routines";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isSys";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isValidRoutine";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isValidTable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 8, 10 -> new IllegalStateException(string);
        };
    }

    public static final class Factory
    extends DatabaseMetaDataWrapper.MDFactory {
        @Override
        @NotNull
        public DatabaseMetaDataWrapper create(@NotNull DatabaseConnectionCore connection2, @NotNull RemoteDatabaseMetaData metaData) {
            if (connection2 == null) {
                Factory.$$$reportNull$$$0(0);
            }
            if (metaData == null) {
                Factory.$$$reportNull$$$0(1);
            }
            return new OraMetadataWrapper(connection2, metaData);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "connection";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "metaData";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/dialects/oracle/introspector/jdbc/OraMetadataWrapper$Factory";
            objectArray[2] = "create";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

