/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.introspector;

import com.intellij.database.dialects.oracle.introspector.OraIntrospectorFunctions;
import com.intellij.database.dialects.oracle.introspector.OraLevelAutoSelectionStrategy;
import com.intellij.database.dialects.oracle.model.OraMajorObject;
import com.intellij.database.dialects.oracle.model.OraMatView;
import com.intellij.database.dialects.oracle.model.OraSchema;
import com.intellij.database.dialects.oracle.model.OraTable;
import com.intellij.database.dialects.oracle.model.OraView;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.properties.Level;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lcom/intellij/database/dialects/oracle/introspector/SimpleStrategy;", "Lcom/intellij/database/dialects/oracle/introspector/OraLevelAutoSelectionStrategy;", "()V", "name", "", "getName", "()Ljava/lang/String;", "countObjectsInSchema", "", "schema", "Lcom/intellij/database/dialects/oracle/model/OraSchema;", "selectSchemaLevel", "Lcom/intellij/database/model/properties/Level;", "intellij.database.dialects.oracle"})
@SourceDebugExtension(value={"SMAP\nOraLevelAutoSelectionStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OraLevelAutoSelectionStrategy.kt\ncom/intellij/database/dialects/oracle/introspector/SimpleStrategy\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,178:1\n1855#2,2:179\n1855#2,2:181\n1855#2,2:183\n*S KotlinDebug\n*F\n+ 1 OraLevelAutoSelectionStrategy.kt\ncom/intellij/database/dialects/oracle/introspector/SimpleStrategy\n*L\n154#1:179,2\n155#1:181,2\n156#1:183,2\n*E\n"})
final class SimpleStrategy
extends OraLevelAutoSelectionStrategy {
    @NotNull
    private final String name;

    public SimpleStrategy() {
        super(null);
        this.name = "SIMPLE";
    }

    @Override
    @NotNull
    protected String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public Level selectSchemaLevel(@NotNull OraSchema schema2) {
        Intrinsics.checkNotNullParameter((Object)schema2, (String)"schema");
        String string = schema2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String name2 = string;
        boolean isSystem = OraIntrospectorFunctions.getSYSTEM_SCHEMAS().contains(name2);
        boolean isCurrent = schema2.isCurrent();
        if (isSystem && !isCurrent) {
            this.trace("Auto-selected level L1 for schema " + name2 + " because this schema is system and not current");
            return Level.L1;
        }
        int count = this.countObjectsInSchema(schema2);
        Level level = null;
        Object reason = null;
        if (isCurrent) {
            if (count == 0 && !isSystem) {
                level = Level.L3;
                reason = "schema is current and empty";
            } else if (count <= 3000) {
                if (isSystem) {
                    level = Level.L2;
                    reason = "schema is system but contains " + count + " objects that is not so big";
                } else if (count <= 1000) {
                    level = Level.L3;
                    reason = "schema is current and contains " + count + " objects that looks OK to retrieve them with sources";
                } else {
                    level = Level.L2;
                    reason = "schema is current and contains " + count + " objects that is so-so";
                }
            } else {
                level = Level.L1;
                reason = "schema is current but contains " + count + " objects that is too many";
            }
        } else if (count <= 100) {
            level = Level.L2;
            reason = "schema is not current but contains a small number (" + count + ") of objects";
        } else {
            level = Level.L1;
            reason = "schema is not current and contains a large number (" + count + ") of objects";
        }
        this.trace("Auto-selected level " + level + " for schema " + name2 + " because: " + (String)reason);
        return level;
    }

    private final int countObjectsInSchema(OraSchema schema2) {
        OraMajorObject it2;
        int cnt = 0;
        ModNamingIdentifyingFamily<? extends OraTable> modNamingIdentifyingFamily = schema2.getTables();
        Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"getTables(...)");
        Iterable $this$forEach$iv = modNamingIdentifyingFamily;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it2 = (OraTable)element$iv;
            boolean bl = false;
            cnt += it2.getTriggers().size();
        }
        ModNamingIdentifyingFamily<? extends OraMatView> modNamingIdentifyingFamily2 = schema2.getMatViews();
        Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily2, (String)"getMatViews(...)");
        $this$forEach$iv = modNamingIdentifyingFamily2;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it2 = (OraMatView)element$iv;
            boolean bl = false;
            cnt += it2.getTriggers().size() + 1;
        }
        ModNamingIdentifyingFamily<? extends OraView> modNamingIdentifyingFamily3 = schema2.getViews();
        Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily3, (String)"getViews(...)");
        $this$forEach$iv = modNamingIdentifyingFamily3;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it2 = (OraView)element$iv;
            boolean bl = false;
            cnt += it2.getTriggers().size() + 1;
        }
        return cnt += schema2.getObjectTypes().size() + schema2.getPackages().size() + schema2.getRoutines().size();
    }
}

