/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.generator.producers;

import com.intellij.database.dialects.base.generator.AbstractScriptGeneratorKt;
import com.intellij.database.dialects.base.generator.BaseProducer;
import com.intellij.database.dialects.base.generator.ScriptingContext;
import com.intellij.database.dialects.base.generator.producers.CreateProducerBase;
import com.intellij.database.dialects.oracle.generator.producers.OraCreateTablespace;
import com.intellij.database.dialects.oracle.generator.producers.OraTablespaceProducersKt;
import com.intellij.database.dialects.oracle.introspector.OraIntrospectorSourcesHelperKt;
import com.intellij.database.dialects.oracle.model.OraDataFile;
import com.intellij.database.dialects.oracle.model.OraTablespace;
import com.intellij.database.dialects.oracle.model.properties.OraTablespaceContentCategory;
import com.intellij.database.dialects.oracle.model.properties.OraTablespaceLogging;
import com.intellij.database.dialects.oracle.model.properties.OraTablespaceStatus;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.script.generator.CodeTextBuilder;
import com.intellij.database.script.generator.ScriptingCapabilities;
import com.intellij.database.script.generator.ScriptingOptionStatic;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/database/dialects/oracle/generator/producers/OraCreateTablespace;", "Lcom/intellij/database/dialects/base/generator/producers/CreateProducerBase;", "Lcom/intellij/database/dialects/oracle/model/OraTablespace;", "context", "Lcom/intellij/database/dialects/base/generator/ScriptingContext;", "element", "(Lcom/intellij/database/dialects/base/generator/ScriptingContext;Lcom/intellij/database/dialects/oracle/model/OraTablespace;)V", "canCreate", "Lcom/intellij/database/script/generator/ScriptingCapabilities$VersionedCapability;", "", "produceCreate", "", "intellij.database.dialects.oracle"})
public final class OraCreateTablespace
extends CreateProducerBase<OraTablespace> {
    public OraCreateTablespace(@NotNull ScriptingContext context, @NotNull OraTablespace element2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        super(context, (BasicElement)element2);
    }

    @Override
    @NotNull
    public ScriptingCapabilities.VersionedCapability<Boolean> canCreate() {
        return AbstractScriptGeneratorKt.getSUPPORTED();
    }

    @Override
    public void produceCreate() {
        OraTablespace ts2 = (OraTablespace)this.getElement();
        OraTablespaceContentCategory oraTablespaceContentCategory = ts2.getContentCategory();
        String contentWord = switch (oraTablespaceContentCategory == null ? -1 : WhenMappings.$EnumSwitchMapping$0[oraTablespaceContentCategory.ordinal()]) {
            case 1 -> null;
            case 2 -> "temporary";
            case 3 -> "undo";
            default -> null;
        };
        String bigfileWord = ts2.isBigFile() ? "bigfile" : null;
        String fileWord = ts2.getContentCategory() == OraTablespaceContentCategory.TS_TEMPORARY ? "tempfile" : "datafile";
        String reuseWord = this.getContext().getOptions().get(ScriptingOptionStatic.CREATE_OR_REPLACE) != false ? "reuse" : null;
        BaseProducer.coding$default(this, null, false, (Function0)new Function0<Unit>(this, bigfileWord, contentWord, ts2, fileWord, reuseWord){
            final /* synthetic */ OraCreateTablespace this$0;
            final /* synthetic */ String $bigfileWord;
            final /* synthetic */ String $contentWord;
            final /* synthetic */ OraTablespace $ts;
            final /* synthetic */ String $fileWord;
            final /* synthetic */ String $reuseWord;
            {
                this.this$0 = $receiver;
                this.$bigfileWord = $bigfileWord;
                this.$contentWord = $contentWord;
                this.$ts = $ts;
                this.$fileWord = $fileWord;
                this.$reuseWord = $reuseWord;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public final void invoke() {
                void this_$iv;
                Object object = new CharSequence[]{"create", this.$bigfileWord, this.$contentWord, "tablespace", this.this$0.fqName()};
                this.this$0.getBuilder().phrase((CharSequence)object);
                object = this.this$0.getBuilder();
                OraTablespace oraTablespace = this.$ts;
                String string = this.$fileWord;
                OraCreateTablespace oraCreateTablespace = this.this$0;
                String string2 = this.$reuseWord;
                boolean $i$f$indenting = false;
                CodeTextBuilder.indent$default((CodeTextBuilder)this_$iv, null, 1, null);
                try {
                    CharSequence[] charSequenceArray;
                    CharSequence[] charSequenceArray2;
                    boolean bl = false;
                    boolean first2 = true;
                    for (OraDataFile oraDataFile : oraTablespace.getDataFiles()) {
                        String w = first2 ? string : "       ,";
                        String string3 = oraDataFile.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
                        String fileName = OraIntrospectorSourcesHelperKt.quoteAsOraLiteral(string3);
                        int blockSize = oraTablespace.getBlockSize();
                        long size = oraDataFile.getFileSize() * (long)blockSize;
                        String sizeStr = OraTablespaceProducersKt.access$asOraFileSize(size);
                        Object xWord = null;
                        if (oraDataFile.isAutoExtensible()) {
                            xWord = "autoextend ON";
                            if (oraDataFile.getIncrementBy() > 0L) {
                                xWord = (String)xWord + " next " + OraTablespaceProducersKt.access$asOraFileSize(oraDataFile.getIncrementBy() * (long)blockSize);
                            }
                            if (oraDataFile.getMaxSize() >= 0xFFFFFFFDL) {
                                xWord = (String)xWord + " maxsize unlimited";
                            } else if (oraDataFile.getMaxSize() > 0L) {
                                xWord = (String)xWord + " maxsize " + OraTablespaceProducersKt.access$asOraFileSize(oraDataFile.getMaxSize() * (long)blockSize);
                            }
                        }
                        CharSequence[] charSequenceArray3 = new CharSequence[]{w, fileName, "size", sizeStr, string2, xWord};
                        oraCreateTablespace.getBuilder().phrase(charSequenceArray3);
                        first2 = false;
                    }
                    if (oraTablespace.getBlockSize() > 0) {
                        charSequenceArray2 = new CharSequence[]{"blocksize", OraTablespaceProducersKt.access$asOraFileSize(oraTablespace.getBlockSize())};
                        oraCreateTablespace.getBuilder().phrase(charSequenceArray2);
                    }
                    OraTablespaceLogging oraTablespaceLogging = oraTablespace.getLogging();
                    switch (oraTablespaceLogging == null ? -1 : produceCreate.WhenMappings.$EnumSwitchMapping$0[oraTablespaceLogging.ordinal()]) {
                        case 1: {
                            charSequenceArray = new CharSequence[]{"nologging"};
                            oraCreateTablespace.getBuilder().phrase(charSequenceArray);
                            break;
                        }
                        case 2: {
                            charSequenceArray = new CharSequence[]{"logging"};
                            oraCreateTablespace.getBuilder().phrase(charSequenceArray);
                            break;
                        }
                        case 3: {
                            charSequenceArray = new CharSequence[]{"force logging"};
                            oraCreateTablespace.getBuilder().phrase(charSequenceArray);
                        }
                    }
                    OraTablespaceStatus oraTablespaceStatus = oraTablespace.getStatus();
                    switch (oraTablespaceStatus == null ? -1 : produceCreate.WhenMappings.$EnumSwitchMapping$1[oraTablespaceStatus.ordinal()]) {
                        case 1: {
                            charSequenceArray = new CharSequence[]{"online"};
                            oraCreateTablespace.getBuilder().phrase(charSequenceArray);
                            break;
                        }
                        case 2: {
                            charSequenceArray = new CharSequence[]{"offline"};
                            oraCreateTablespace.getBuilder().phrase(charSequenceArray);
                        }
                    }
                    if (oraTablespace.isLocalExtentManagement()) {
                        charSequenceArray2 = new CharSequence[]{"extent management local"};
                        oraCreateTablespace.getBuilder().phrase(charSequenceArray2);
                    }
                    if (oraTablespace.isAutoSegmentManagement()) {
                        charSequenceArray2 = new CharSequence[]{"segment space management auto"};
                        oraCreateTablespace.getBuilder().phrase(charSequenceArray2);
                    }
                }
                finally {
                    this_$iv.unindent();
                }
            }
        }, 3, null);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OraTablespaceContentCategory.values().length];
            try {
                nArray[OraTablespaceContentCategory.TS_PERMANENT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OraTablespaceContentCategory.TS_TEMPORARY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OraTablespaceContentCategory.TS_UNDO.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

