/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.generator.producers;

import com.intellij.database.dialects.base.generator.AbstractScriptGeneratorKt;
import com.intellij.database.dialects.base.generator.BaseProducer;
import com.intellij.database.dialects.base.generator.ElementProducer;
import com.intellij.database.dialects.base.generator.ScriptingContext;
import com.intellij.database.dialects.base.generator.ScriptingFun;
import com.intellij.database.dialects.base.generator.producers.CreateTable;
import com.intellij.database.dialects.base.generator.producers.ProducerUtilsKt;
import com.intellij.database.dialects.oracle.model.OraTable;
import com.intellij.database.dialects.oracle.model.properties.OraTableType;
import com.intellij.database.dialects.oracle.model.properties.TableOrganization;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.meta.BasicMetaId;
import com.intellij.database.script.generator.ScriptingCapabilities;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0014J\b\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001a\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\t2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u000bH\u0016J\b\u0010\u0014\u001a\u00020\u000bH\u0014J\u0010\u0010\u0015\u001a\u00020\u000b*\u00060\u0016R\u00020\u0004H\u0014\u00a8\u0006\u0017"}, d2={"Lcom/intellij/database/dialects/oracle/generator/producers/OraCreateTable;", "Lcom/intellij/database/dialects/base/generator/producers/CreateTable;", "Lcom/intellij/database/dialects/oracle/model/OraTable;", "context", "Lcom/intellij/database/dialects/base/generator/ScriptingContext;", "element", "(Lcom/intellij/database/dialects/base/generator/ScriptingContext;Lcom/intellij/database/dialects/oracle/model/OraTable;)V", "canComment", "Lcom/intellij/database/script/generator/ScriptingCapabilities$VersionedCapability;", "", "generateObjectTable", "", "isConditional", "id", "Lcom/intellij/database/model/meta/BasicMetaId;", "produceComment", "exists", "comment", "", "produceCreate", "produceFooter", "produceHeader", "Lcom/intellij/database/dialects/base/generator/ScriptingContext$NewCodingAdapter;", "intellij.database.dialects.oracle"})
@SourceDebugExtension(value={"SMAP\nOraTableProducers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OraTableProducers.kt\ncom/intellij/database/dialects/oracle/generator/producers/OraCreateTable\n+ 2 ElementProducer.kt\ncom/intellij/database/dialects/base/generator/BaseProducer\n*L\n1#1,132:1\n98#2:133\n*S KotlinDebug\n*F\n+ 1 OraTableProducers.kt\ncom/intellij/database/dialects/oracle/generator/producers/OraCreateTable\n*L\n33#1:133\n*E\n"})
public final class OraCreateTable
extends CreateTable<OraTable> {
    public OraCreateTable(@NotNull ScriptingContext context, @NotNull OraTable element2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        super(context, (BasicTable)element2);
    }

    @Override
    public void produceCreate() {
        if (((OraTable)this.getElement()).getRowTypeObjectName() != null) {
            this.generateObjectTable();
        } else {
            super.produceCreate();
        }
    }

    private final void generateObjectTable() {
        Object object;
        String objectSchemaName = ((OraTable)this.getElement()).getRowTypeSchemaName();
        if (Intrinsics.areEqual((Object)objectSchemaName, (Object)((OraTable)this.getElement()).getSchemaName())) {
            objectSchemaName = null;
        }
        String string = ((OraTable)this.getElement()).getRowTypeObjectName();
        Intrinsics.checkNotNull((Object)string);
        String objectName = string;
        if (objectSchemaName == null) {
            BaseProducer baseProducer = this;
            $this$scr$iv = objectName;
            $i$f$getScr = false;
            object = this_$iv.getContext().getNamingService().catToScript($this$scr$iv, null, this_$iv.getStyle().getQuotesPriority(), ScriptingFun.getForceQuoting(this_$iv.getContext()));
        } else {
            this_$iv = this;
            $this$scr$iv = objectSchemaName;
            $i$f$getScr = false;
            String string2 = this_$iv.getContext().getNamingService().catToScript($this$scr$iv, null, this_$iv.getStyle().getQuotesPriority(), ScriptingFun.getForceQuoting(this_$iv.getContext()));
            this_$iv = this;
            $this$scr$iv = objectName;
            $i$f$getScr = false;
            object = string2 + "." + this_$iv.getContext().getNamingService().catToScript($this$scr$iv, null, this_$iv.getStyle().getQuotesPriority(), ScriptingFun.getForceQuoting(this_$iv.getContext()));
        }
        String n = object;
        this.newCoding((Function1<? super ScriptingContext.NewCodingAdapter, Unit>)((Function1)new Function1<ScriptingContext.NewCodingAdapter, Unit>(this, n){
            final /* synthetic */ OraCreateTable this$0;
            final /* synthetic */ String $n;
            {
                this.this$0 = $receiver;
                this.$n = $n;
                super(1);
            }

            public final void invoke(@NotNull ScriptingContext.NewCodingAdapter $this$newCoding) {
                Intrinsics.checkNotNullParameter((Object)$this$newCoding, (String)"$this$newCoding");
                $this$newCoding.plus($this$newCoding.plus($this$newCoding.plus($this$newCoding.unaryPlus("create table"), this.this$0.fqName()), "of"), this.$n);
            }
        }));
    }

    @Override
    protected void produceHeader(@NotNull ScriptingContext.NewCodingAdapter $this$produceHeader) {
        Intrinsics.checkNotNullParameter((Object)$this$produceHeader, (String)"<this>");
        String name2 = this.fqName();
        if (((OraTable)this.getElement()).isTemporary()) {
            ScriptingContext.NewCodingAdapter newCodingAdapter = $this$produceHeader.unaryPlus("create global temporary table");
            ElementProducer elementProducer = this;
            ObjectKind objectKind = ((OraTable)this.getElement()).getKind();
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"getKind(...)");
            $this$produceHeader.plus($this$produceHeader.plus(newCodingAdapter, ProducerUtilsKt.ifNotExists(elementProducer, objectKind, false)), name2);
        } else {
            ScriptingContext.NewCodingAdapter newCodingAdapter = $this$produceHeader.unaryPlus("create table");
            ElementProducer elementProducer = this;
            ObjectKind objectKind = ((OraTable)this.getElement()).getKind();
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"getKind(...)");
            $this$produceHeader.plus($this$produceHeader.plus(newCodingAdapter, ProducerUtilsKt.ifNotExists(elementProducer, objectKind, false)), name2);
        }
    }

    @Override
    protected void produceFooter() {
        this.sqlClause((Function1<? super ScriptingContext.NewCodingAdapter, Unit>)((Function1)new Function1<ScriptingContext.NewCodingAdapter, Unit>(this){
            final /* synthetic */ OraCreateTable this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull ScriptingContext.NewCodingAdapter $this$sqlClause) {
                Intrinsics.checkNotNullParameter((Object)$this$sqlClause, (String)"$this$sqlClause");
                OraTable tab2 = (OraTable)this.this$0.getElement();
                if (tab2.getClusterRef() != null) {
                    void this_$iv;
                    String string = this.this$0.extractName(tab2.getClusterRefInfo());
                    if (string == null) {
                        string = "???";
                    }
                    String cn = string;
                    BaseProducer baseProducer = this.this$0;
                    List<String> list = tab2.getClusterColNames();
                    Intrinsics.checkNotNullExpressionValue(list, (String)"getClusterColNames(...)");
                    Iterable $this$scr$iv = list;
                    boolean $i$f$getScr = false;
                    String cols2 = CollectionsKt.joinToString$default((Iterable)$this$scr$iv, null, null, null, (int)0, null, (Function1)((Function1)new Function1<String, CharSequence>((BaseProducer)this_$iv){
                        final /* synthetic */ BaseProducer this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        /*
                         * WARNING - void declaration
                         */
                        @NotNull
                        public final CharSequence invoke(@NotNull String it2) {
                            void this_$iv;
                            Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                            BaseProducer baseProducer = this.this$0;
                            String $this$scr$iv = it2;
                            boolean $i$f$getScr = false;
                            return this_$iv.getContext().getNamingService().catToScript($this$scr$iv, null, this_$iv.getStyle().getQuotesPriority(), ScriptingFun.getForceQuoting(this_$iv.getContext()));
                        }
                    }), (int)31, null);
                    $this$sqlClause.minus($this$sqlClause.minus($this$sqlClause.plus($this$sqlClause.plus($this$sqlClause.unaryPlus("cluster"), cn), "("), cols2), ")");
                } else if (tab2.getOrganization() == TableOrganization.INDEX) {
                    $this$sqlClause.unaryPlus("organization index");
                } else if (tab2.isTemporary()) {
                    if (tab2.isTemporaryPreserve()) {
                        $this$sqlClause.unaryPlus("on commit preserve rows");
                    } else {
                        $this$sqlClause.unaryPlus("on commit delete rows");
                    }
                }
            }
        }));
    }

    @Override
    @NotNull
    protected ScriptingCapabilities.VersionedCapability<Boolean> canComment() {
        return ((OraTable)this.getElement()).getTableType() == OraTableType.BASIC ? AbstractScriptGeneratorKt.getSUPPORTED() : AbstractScriptGeneratorKt.getUNSUPPORTED();
    }

    @Override
    public void produceComment(boolean exists, @Nullable String comment) {
        ProducerUtilsKt.commentStatement$default(this, "table", comment, null, 4, null);
    }

    @Override
    public boolean isConditional(@NotNull BasicMetaId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        BasicMetaId basicMetaId = id;
        return Intrinsics.areEqual((Object)basicMetaId, (Object)OraTable.TABLESPACE_REF) ? true : (Intrinsics.areEqual((Object)basicMetaId, OraTable.ORGANIZATION) ? true : super.isConditional(id));
    }
}

