/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.generator;

import com.intellij.database.dialects.base.generator.AbstractCodeGenerator;
import com.intellij.database.dialects.base.generator.BaseExecuteGenerator;
import com.intellij.database.dialects.base.generator.ElementProducer;
import com.intellij.database.dialects.base.generator.Operation;
import com.intellij.database.dialects.base.generator.ScriptingContext;
import com.intellij.database.dialects.oracle.generator.OraExecuteGenerator;
import com.intellij.database.dialects.oracle.generator.OraRoutineArgumentsAnalyzer;
import com.intellij.database.dialects.oracle.model.OraArgument;
import com.intellij.database.dialects.oracle.model.OraPackage;
import com.intellij.database.dialects.oracle.model.OraPackageBody;
import com.intellij.database.dialects.oracle.model.OraPackageRoutine;
import com.intellij.database.dialects.oracle.model.OraRoutine;
import com.intellij.database.dialects.oracle.model.OraSingleRoutine;
import com.intellij.database.dialects.oracle.types.OraRefCursorType;
import com.intellij.database.dialects.oracle.types.OraTypeSystem;
import com.intellij.database.model.ArgumentDirection;
import com.intellij.database.model.DasUserDefinedType;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicRoutine;
import com.intellij.database.model.basic.BasicUserDefinedType;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.script.generator.ScriptingOptionStatic;
import com.intellij.database.types.DasBuiltinType;
import com.intellij.database.types.DasBuiltinTypeClass;
import com.intellij.database.types.DasBuiltinTypeWithLength;
import com.intellij.database.types.DasDefinedType;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeCategory;
import com.intellij.database.types.DasTypeClass;
import com.intellij.database.types.DasTypeUtilsKt;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0003\u001c\u001d\u001eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0014J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0013H\u0016J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u0013H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a*\u0006\u0012\u0002\b\u00030\u001bH\u0002\u00a8\u0006\u001f"}, d2={"Lcom/intellij/database/dialects/oracle/generator/OraExecuteGenerator;", "Lcom/intellij/database/dialects/base/generator/BaseExecuteGenerator;", "context", "Lcom/intellij/database/dialects/base/generator/ScriptingContext;", "(Lcom/intellij/database/dialects/base/generator/ScriptingContext;)V", "argumentName", "", "argument", "Lcom/intellij/database/dialects/oracle/model/OraArgument;", "generateRoutine", "", "producer", "Lcom/intellij/database/dialects/base/generator/ElementProducer;", "Lcom/intellij/database/model/basic/BasicRoutine;", "getTypeSpecification", "guessDefaultValue", "dt", "Lcom/intellij/database/types/DasType;", "makeExecuteOperation", "Lcom/intellij/database/dialects/base/generator/Operation;", "element", "Lcom/intellij/database/model/basic/BasicElement;", "root", "makeExecutePackage", "Lcom/intellij/database/dialects/oracle/model/OraPackage;", "forcedPrecision", "", "Lcom/intellij/database/types/DasBuiltinTypeClass;", "AsResultSets", "DataProducingWay", "DbmsOutput", "intellij.database.dialects.oracle"})
@SourceDebugExtension(value={"SMAP\nOraExecuteGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OraExecuteGenerator.kt\ncom/intellij/database/dialects/oracle/generator/OraExecuteGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,305:1\n1855#2,2:306\n*S KotlinDebug\n*F\n+ 1 OraExecuteGenerator.kt\ncom/intellij/database/dialects/oracle/generator/OraExecuteGenerator\n*L\n28#1:306,2\n*E\n"})
public final class OraExecuteGenerator
extends BaseExecuteGenerator {
    public OraExecuteGenerator(@NotNull ScriptingContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
    }

    @Override
    @Nullable
    public Operation makeExecuteOperation(@NotNull BasicElement element2, @NotNull Operation root2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
        return element2 instanceof OraPackage ? this.makeExecutePackage((OraPackage)element2, root2) : super.makeExecuteOperation(element2, root2);
    }

    private final Operation makeExecutePackage(OraPackage element2, Operation root2) {
        ModNamingFamily<? extends OraPackageRoutine> modNamingFamily = element2.getRoutines();
        Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getRoutines(...)");
        Iterable $this$forEach$iv = modNamingFamily;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OraPackageRoutine it2 = (OraPackageRoutine)element$iv;
            boolean bl = false;
            BaseExecuteGenerator baseExecuteGenerator = this;
            Intrinsics.checkNotNull((Object)it2);
            BaseExecuteGenerator.prepareElement$default(baseExecuteGenerator, it2, root2, false, 4, null);
        }
        return null;
    }

    @Override
    protected void generateRoutine(@NotNull ElementProducer<BasicRoutine> producer) {
        Object object;
        OraRoutine routine2;
        Intrinsics.checkNotNullParameter(producer, (String)"producer");
        BasicRoutine basicRoutine = producer.getElement();
        Intrinsics.checkNotNull((Object)basicRoutine, (String)"null cannot be cast to non-null type com.intellij.database.dialects.oracle.model.OraRoutine");
        OraRoutine oraRoutine = routine2 = (OraRoutine)basicRoutine;
        if (oraRoutine instanceof OraSingleRoutine) {
            object = AbstractCodeGenerator.currentScopeName$default(this, routine2, null, 1, null);
        } else if (oraRoutine instanceof OraPackageRoutine) {
            AbstractCodeGenerator abstractCodeGenerator = this;
            OraPackage oraPackage = ((OraPackageRoutine)routine2).getPackage();
            Intrinsics.checkNotNull((Object)oraPackage);
            object = AbstractCodeGenerator.currentScopeName$default(abstractCodeGenerator, oraPackage, null, 1, null) + "." + AbstractCodeGenerator.quote$default(this, routine2, null, 2, null);
        } else {
            return;
        }
        String callName = object;
        PositioningNamingFamily positioningNamingFamily = routine2.getArguments();
        Intrinsics.checkNotNullExpressionValue((Object)positioningNamingFamily, (String)"getArguments(...)");
        List arguments = CollectionsKt.toList((Iterable)positioningNamingFamily);
        int n = arguments.size();
        OraRoutineArgumentsAnalyzer analyzer = new OraRoutineArgumentsAnalyzer(routine2);
        OraArgument ret = analyzer.getReturnArgument();
        List<OraArgument> cursors = analyzer.getCursorArguments();
        List<OraArgument> associative = analyzer.getAssociativeArrayArguments();
        List<OraArgument> sqlArrays = analyzer.getSqlTypeArrayArguments();
        List<OraArgument> plArrays = analyzer.getPlTypeArrayArguments();
        List<OraArgument> sqlTables = analyzer.getSqlTypeNestedTableArguments();
        List<OraArgument> plTables = analyzer.getPlTypeNestedTableArguments();
        List<OraRoutineArgumentsAnalyzer.PrimitivesPack> primitives = analyzer.getPrimitives(this.getContext().getTask().getVersion());
        DataProducingWay way = this.getContext().getOptions().get(ScriptingOptionStatic.CALL) != false ? (DataProducingWay)new AsResultSets(this) : (DataProducingWay)new DbmsOutput(this);
        this.newCoding((Function1<? super ScriptingContext.NewCodingAdapter, Unit>)((Function1)new Function1<ScriptingContext.NewCodingAdapter, Unit>(n, (List<? extends OraArgument>)arguments, this, ret, callName, way, plArrays, plTables, associative, cursors, sqlArrays, sqlTables, primitives){
            final /* synthetic */ int $n;
            final /* synthetic */ List<OraArgument> $arguments;
            final /* synthetic */ OraExecuteGenerator this$0;
            final /* synthetic */ OraArgument $ret;
            final /* synthetic */ String $callName;
            final /* synthetic */ DataProducingWay $way;
            final /* synthetic */ List<OraArgument> $plArrays;
            final /* synthetic */ List<OraArgument> $plTables;
            final /* synthetic */ List<OraArgument> $associative;
            final /* synthetic */ List<OraArgument> $cursors;
            final /* synthetic */ List<OraArgument> $sqlArrays;
            final /* synthetic */ List<OraArgument> $sqlTables;
            final /* synthetic */ List<OraRoutineArgumentsAnalyzer.PrimitivesPack> $primitives;
            {
                this.$n = $n;
                this.$arguments = $arguments;
                this.this$0 = $receiver;
                this.$ret = $ret;
                this.$callName = $callName;
                this.$way = $way;
                this.$plArrays = $plArrays;
                this.$plTables = $plTables;
                this.$associative = $associative;
                this.$cursors = $cursors;
                this.$sqlArrays = $sqlArrays;
                this.$sqlTables = $sqlTables;
                this.$primitives = $primitives;
                super(1);
            }

            public final void invoke(@NotNull ScriptingContext.NewCodingAdapter $this$newCoding) {
                Object object;
                Intrinsics.checkNotNullParameter((Object)$this$newCoding, (String)"$this$newCoding");
                List<OraArgument> list = this.$arguments;
                OraExecuteGenerator oraExecuteGenerator = this.this$0;
                boolean nl$iv = true;
                boolean $i$f$withNewLines232 = false;
                boolean prev$iv232 = $this$newCoding.getStartWithNewLine();
                $this$newCoding.setStartWithNewLine(nl$iv);
                boolean $i$a$-withNewLines$default-OraExecuteGenerator$generateRoutine$1$232 = false;
                if (!((Collection)list).isEmpty()) {
                    $this$newCoding.unaryPlus("declare");
                    ScriptingContext.NewCodingAdapter this_$iv2 = $this$newCoding;
                    boolean $i$f$indenting = false;
                    boolean prev$iv = this_$iv2.getOnNewLine();
                    int length$iv = this_$iv2.getBuilder().getLength();
                    this_$iv2.newLine();
                    this_$iv2.indent();
                    boolean bl = false;
                    object = list.iterator();
                    while (object.hasNext()) {
                        ArgumentDirection dir;
                        OraArgument a2 = (OraArgument)object.next();
                        Intrinsics.checkNotNullExpressionValue((Object)((Object)a2.getArgumentDirection()), (String)"getArgumentDirection(...)");
                        Intrinsics.checkNotNullExpressionValue((Object)a2.getDasType(), (String)"getDasType(...)");
                        Intrinsics.checkNotNull((Object)a2);
                        String specification = OraExecuteGenerator.access$getTypeSpecification(oraExecuteGenerator, a2);
                        String line = switch (generateRoutine.WhenMappings.$EnumSwitchMapping$0[dir.ordinal()]) {
                            case 1, 2 -> {
                                DasType dt;
                                String defaultValue = OraExecuteGenerator.access$guessDefaultValue(oraExecuteGenerator, dt);
                                yield OraExecuteGenerator.access$argumentName(oraExecuteGenerator, a2) + " " + specification + " := " + defaultValue + ";";
                            }
                            case 3, 4 -> OraExecuteGenerator.access$argumentName(oraExecuteGenerator, a2) + " " + specification + ";";
                            default -> null;
                        };
                        $this$newCoding.unaryPlus(line);
                    }
                    this_$iv2.unindent();
                    if (length$iv == this_$iv2.getBuilder().getLength()) {
                        this_$iv2.setOnNewLine(prev$iv);
                    }
                }
                $this$newCoding.unaryPlus("begin");
                $this$newCoding.setStartWithNewLine(prev$iv232);
                ArrayList<CallSite> passing = new ArrayList<CallSite>(this.$n);
                for (OraArgument oraArgument : this.$arguments) {
                    switch (generateRoutine.WhenMappings.$EnumSwitchMapping$0[oraArgument.getArgumentDirection().ordinal()]) {
                        case 1: 
                        case 2: 
                        case 3: {
                            Intrinsics.checkNotNull((Object)oraArgument);
                            passing.add((CallSite)((Object)(OraExecuteGenerator.access$argumentName(this.this$0, oraArgument) + " => " + OraExecuteGenerator.access$argumentName(this.this$0, oraArgument))));
                        }
                    }
                }
                String retClause = this.$ret != null ? "result :=" : null;
                ScriptingContext.NewCodingAdapter newCodingAdapter = $this$newCoding;
                String $i$f$withNewLines232 = this.$callName;
                DataProducingWay prev$iv232 = this.$way;
                List<OraArgument> $i$a$-withNewLines$default-OraExecuteGenerator$generateRoutine$1$232 = this.$plArrays;
                List<OraArgument> list2 = this.$plTables;
                List<OraArgument> list3 = this.$associative;
                List<OraArgument> list4 = this.$cursors;
                List<OraArgument> list5 = this.$sqlArrays;
                List<OraArgument> list6 = this.$sqlTables;
                object = this.$primitives;
                boolean $i$f$indenting = false;
                boolean prev$iv = newCodingAdapter.getOnNewLine();
                int length$iv = newCodingAdapter.getBuilder().getLength();
                newCodingAdapter.newLine();
                newCodingAdapter.indent();
                boolean bl = false;
                $this$newCoding.unaryPlus(retClause);
                switch (passing.size()) {
                    case 0: {
                        $this$newCoding.unaryPlus($i$f$withNewLines232 + ";");
                        break;
                    }
                    case 1: {
                        String passingText = (String)CollectionsKt.first((List)passing);
                        $this$newCoding.unaryPlus($i$f$withNewLines232 + "(" + passingText + ");");
                        break;
                    }
                    default: {
                        $this$newCoding.unaryPlus($i$f$withNewLines232 + "(");
                        boolean nl$iv2 = true;
                        boolean $i$f$withNewLines = false;
                        boolean prev$iv3 = $this$newCoding.getStartWithNewLine();
                        $this$newCoding.setStartWithNewLine(nl$iv2);
                        boolean bl2 = false;
                        ScriptingContext.NewCodingAdapter this_$iv3 = $this$newCoding;
                        boolean $i$f$indenting2 = false;
                        boolean prev$iv4 = this_$iv3.getOnNewLine();
                        int length$iv2 = this_$iv3.getBuilder().getLength();
                        this_$iv3.newLine();
                        this_$iv3.indent();
                        boolean bl3 = false;
                        Iterator<E> iterator = passing.iterator();
                        int n = 0;
                        while (iterator.hasNext()) {
                            int i2 = n++;
                            String p2 = (String)iterator.next();
                            $this$newCoding.unaryPlus((CharSequence)(i2 + 1 < passing.size() ? p2 + "," : p2));
                        }
                        this_$iv3.unindent();
                        if (length$iv2 == this_$iv3.getBuilder().getLength()) {
                            this_$iv3.setOnNewLine(prev$iv4);
                        }
                        $this$newCoding.unaryPlus(");");
                        $this$newCoding.setStartWithNewLine(prev$iv3);
                    }
                }
                boolean nl$iv3 = true;
                boolean $i$f$withNewLines = false;
                boolean prev$iv5 = $this$newCoding.getStartWithNewLine();
                $this$newCoding.setStartWithNewLine(nl$iv3);
                boolean bl4 = false;
                prev$iv232.producePlArrays($this$newCoding, $i$a$-withNewLines$default-OraExecuteGenerator$generateRoutine$1$232);
                prev$iv232.producePlTables($this$newCoding, list2);
                prev$iv232.produceAssociativeArrays($this$newCoding, list3);
                prev$iv232.produceCursors($this$newCoding, list4);
                prev$iv232.produceSqlArrays($this$newCoding, list5);
                prev$iv232.produceSqlTables($this$newCoding, list6);
                prev$iv232.producePrimitives($this$newCoding, (List<OraRoutineArgumentsAnalyzer.PrimitivesPack>)object);
                $this$newCoding.setStartWithNewLine(prev$iv5);
                newCodingAdapter.unindent();
                if (length$iv == newCodingAdapter.getBuilder().getLength()) {
                    newCodingAdapter.setOnNewLine(prev$iv);
                }
                boolean bl2 = true;
                boolean $i$f$withNewLines3 = false;
                boolean prev$iv6 = $this$newCoding.getStartWithNewLine();
                $this$newCoding.setStartWithNewLine(bl2);
                boolean bl5 = false;
                $this$newCoding.unaryPlus("end;");
                $this$newCoding.setStartWithNewLine(prev$iv6);
            }
        }));
    }

    private final String argumentName(OraArgument argument) {
        return argument.getArgumentDirection() == ArgumentDirection.RETURN ? "result" : AbstractCodeGenerator.quote$default(this, argument, null, 2, null);
    }

    private final String getTypeSpecification(OraArgument argument) {
        DasType dasType = argument.getDasType();
        Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getDasType(...)");
        DasType dasType2 = DasTypeUtilsKt.unwrap$default(dasType, false, argument, 1, null);
        if (dasType2 instanceof DasBuiltinType) {
            DasType resultType = dasType2;
            if (resultType instanceof DasBuiltinTypeWithLength && ((DasBuiltinTypeWithLength)resultType).getTypeClass().getCategory() == DasTypeCategory.STRING && ((DasBuiltinTypeWithLength)resultType).getLength() == -1) {
                DasBuiltinTypeWithLength dasBuiltinTypeWithLength = (DasBuiltinTypeWithLength)resultType;
                DasTypeClass dasTypeClass = ((DasBuiltinTypeWithLength)resultType).getTypeClass();
                Intrinsics.checkNotNullExpressionValue((Object)dasTypeClass, (String)"getTypeClass(...)");
                DasBuiltinTypeWithLength dasBuiltinTypeWithLength2 = dasBuiltinTypeWithLength.copy(this.forcedPrecision((DasBuiltinTypeClass<?>)dasTypeClass));
                Intrinsics.checkNotNullExpressionValue(dasBuiltinTypeWithLength2, (String)"copy(...)");
                resultType = dasBuiltinTypeWithLength2;
            }
            String string = resultType.getSpecification();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSpecification(...)");
            return string;
        }
        if (dasType2 instanceof DasDefinedType) {
            DasUserDefinedType dasUserDefinedType = ((DasDefinedType)dasType2).getTypeClass().getDefinition();
            Intrinsics.checkNotNull((Object)dasUserDefinedType, (String)"null cannot be cast to non-null type com.intellij.database.model.basic.BasicUserDefinedType");
            BasicUserDefinedType definition2 = (BasicUserDefinedType)dasUserDefinedType;
            BasicElement parent2 = definition2.getParent();
            return parent2 instanceof OraPackage || parent2 instanceof OraPackageBody ? AbstractCodeGenerator.currentScopeName$default(this, parent2, null, 1, null) + "." + AbstractCodeGenerator.quote$default(this, definition2, null, 2, null) : AbstractCodeGenerator.currentScopeName$default(this, definition2, null, 1, null);
        }
        if (dasType2 instanceof OraRefCursorType) {
            return "sys_refcursor";
        }
        DasType dasType3 = argument.getDasType();
        Intrinsics.checkNotNullExpressionValue((Object)dasType3, (String)"getDasType(...)");
        return this.script(dasType3);
    }

    private final int forcedPrecision(DasBuiltinTypeClass<?> $this$forcedPrecision) {
        DasBuiltinTypeClass<?> dasBuiltinTypeClass = $this$forcedPrecision.getCanonical();
        return (Intrinsics.areEqual(dasBuiltinTypeClass, (Object)OraTypeSystem.CHAR.getTypeClass()) ? true : Intrinsics.areEqual(dasBuiltinTypeClass, (Object)OraTypeSystem.NCHAR.getTypeClass())) ? 50 : 4000;
    }

    private final String guessDefaultValue(DasType dt) {
        if (!(dt instanceof DasBuiltinType)) {
            return "null";
        }
        return switch (WhenMappings.$EnumSwitchMapping$0[((DasBuiltinType)dt).getTypeClass().getCategory().ordinal()]) {
            case 1, 2 -> "0";
            case 3 -> "sysdate";
            case 4 -> "''";
            default -> "null";
        };
    }

    public static final /* synthetic */ String access$getTypeSpecification(OraExecuteGenerator $this, OraArgument argument) {
        return $this.getTypeSpecification(argument);
    }

    public static final /* synthetic */ String access$guessDefaultValue(OraExecuteGenerator $this, DasType dt) {
        return $this.guessDefaultValue(dt);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0002J\"\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u00060\nR\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\"\u0010\u000f\u001a\u00020\b2\n\u0010\t\u001a\u00060\nR\u00020\u000b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\"\u0010\u0011\u001a\u00020\b2\n\u0010\t\u001a\u00060\nR\u00020\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\"\u0010\u0013\u001a\u00020\b2\n\u0010\t\u001a\u00060\nR\u00020\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\"\u0010\u0014\u001a\u00020\b2\n\u0010\t\u001a\u00060\nR\u00020\u000b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\rH\u0016J\"\u0010\u0017\u001a\u00020\b2\n\u0010\t\u001a\u00060\nR\u00020\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\"\u0010\u0018\u001a\u00020\b2\n\u0010\t\u001a\u00060\nR\u00020\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/database/dialects/oracle/generator/OraExecuteGenerator$AsResultSets;", "Lcom/intellij/database/dialects/oracle/generator/OraExecuteGenerator$DataProducingWay;", "generator", "Lcom/intellij/database/dialects/oracle/generator/OraExecuteGenerator;", "(Lcom/intellij/database/dialects/oracle/generator/OraExecuteGenerator;)V", "commentMaybe", "", "produceAssociativeArrays", "", "adapter", "Lcom/intellij/database/dialects/base/generator/ScriptingContext$NewCodingAdapter;", "Lcom/intellij/database/dialects/base/generator/ScriptingContext;", "associative", "", "Lcom/intellij/database/dialects/oracle/model/OraArgument;", "produceCursors", "cursors", "producePlArrays", "arrays", "producePlTables", "producePrimitives", "primitives", "Lcom/intellij/database/dialects/oracle/generator/OraRoutineArgumentsAnalyzer$PrimitivesPack;", "produceSqlArrays", "produceSqlTables", "intellij.database.dialects.oracle"})
    private static final class AsResultSets
    implements DataProducingWay {
        @NotNull
        private final OraExecuteGenerator generator;

        public AsResultSets(@NotNull OraExecuteGenerator generator) {
            Intrinsics.checkNotNullParameter((Object)generator, (String)"generator");
            this.generator = generator;
        }

        @Override
        public void producePrimitives(@NotNull ScriptingContext.NewCodingAdapter adapter, @NotNull List<OraRoutineArgumentsAnalyzer.PrimitivesPack> primitives) {
            ScriptingContext.NewCodingAdapter newCodingAdapter;
            Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
            Intrinsics.checkNotNullParameter(primitives, (String)"primitives");
            if (primitives.isEmpty()) {
                return;
            }
            ScriptingContext.NewCodingAdapter $this$producePrimitives_u24lambda_u240 = newCodingAdapter = adapter;
            boolean bl = false;
            for (OraRoutineArgumentsAnalyzer.PrimitivesPack pack : primitives) {
                $this$producePrimitives_u24lambda_u240.plus($this$producePrimitives_u24lambda_u240.plus($this$producePrimitives_u24lambda_u240.unaryPlus((pack.getEnabled() ? "" : "-- ") + "open ? for select "), CollectionsKt.joinToString$default((Iterable)pack.getArguments(), null, null, null, (int)0, null, (Function1)((Function1)new Function1<OraArgument, CharSequence>(this){
                    final /* synthetic */ AsResultSets this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final CharSequence invoke(@NotNull OraArgument it2) {
                        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                        String argumentName = OraExecuteGenerator.access$argumentName(AsResultSets.access$getGenerator$p(this.this$0), it2);
                        return argumentName + " as " + argumentName;
                    }
                }), (int)31, null)), "from dual;");
            }
        }

        @Override
        public void produceCursors(@NotNull ScriptingContext.NewCodingAdapter adapter, @NotNull List<? extends OraArgument> cursors) {
            ScriptingContext.NewCodingAdapter newCodingAdapter;
            Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
            Intrinsics.checkNotNullParameter(cursors, (String)"cursors");
            ScriptingContext.NewCodingAdapter $this$produceCursors_u24lambda_u241 = newCodingAdapter = adapter;
            boolean bl = false;
            for (OraArgument oraArgument : cursors) {
                $this$produceCursors_u24lambda_u241.unaryPlus("? := " + this.generator.argumentName(oraArgument) + ";");
            }
        }

        @Override
        public void produceSqlArrays(@NotNull ScriptingContext.NewCodingAdapter adapter, @NotNull List<? extends OraArgument> arrays) {
            ScriptingContext.NewCodingAdapter newCodingAdapter;
            Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
            Intrinsics.checkNotNullParameter(arrays, (String)"arrays");
            ScriptingContext.NewCodingAdapter $this$produceSqlArrays_u24lambda_u242 = newCodingAdapter = adapter;
            boolean bl = false;
            for (OraArgument oraArgument : arrays) {
                $this$produceSqlArrays_u24lambda_u242.unaryPlus("open ? for select * from table(" + this.generator.argumentName(oraArgument) + ");");
            }
        }

        @Override
        public void producePlArrays(@NotNull ScriptingContext.NewCodingAdapter adapter, @NotNull List<? extends OraArgument> arrays) {
            ScriptingContext.NewCodingAdapter newCodingAdapter;
            Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
            Intrinsics.checkNotNullParameter(arrays, (String)"arrays");
            ScriptingContext.NewCodingAdapter $this$producePlArrays_u24lambda_u243 = newCodingAdapter = adapter;
            boolean bl = false;
            for (OraArgument oraArgument : arrays) {
                $this$producePlArrays_u24lambda_u243.unaryPlus(this.commentMaybe() + "open ? for select * from table(" + this.generator.argumentName(oraArgument) + ");");
            }
        }

        @Override
        public void produceSqlTables(@NotNull ScriptingContext.NewCodingAdapter adapter, @NotNull List<? extends OraArgument> arrays) {
            ScriptingContext.NewCodingAdapter newCodingAdapter;
            Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
            Intrinsics.checkNotNullParameter(arrays, (String)"arrays");
            ScriptingContext.NewCodingAdapter $this$produceSqlTables_u24lambda_u244 = newCodingAdapter = adapter;
            boolean bl = false;
            for (OraArgument oraArgument : arrays) {
                $this$produceSqlTables_u24lambda_u244.unaryPlus("open ? for select * from table(" + this.generator.argumentName(oraArgument) + ");");
            }
        }

        @Override
        public void producePlTables(@NotNull ScriptingContext.NewCodingAdapter adapter, @NotNull List<? extends OraArgument> arrays) {
            ScriptingContext.NewCodingAdapter newCodingAdapter;
            Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
            Intrinsics.checkNotNullParameter(arrays, (String)"arrays");
            ScriptingContext.NewCodingAdapter $this$producePlTables_u24lambda_u245 = newCodingAdapter = adapter;
            boolean bl = false;
            for (OraArgument oraArgument : arrays) {
                $this$producePlTables_u24lambda_u245.unaryPlus(this.commentMaybe() + "open ? for select * from table(" + this.generator.argumentName(oraArgument) + ");");
            }
        }

        @Override
        public void produceAssociativeArrays(@NotNull ScriptingContext.NewCodingAdapter adapter, @NotNull List<? extends OraArgument> associative) {
            ScriptingContext.NewCodingAdapter newCodingAdapter;
            Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
            Intrinsics.checkNotNullParameter(associative, (String)"associative");
            ScriptingContext.NewCodingAdapter $this$produceAssociativeArrays_u24lambda_u246 = newCodingAdapter = adapter;
            boolean bl = false;
            for (OraArgument oraArgument : associative) {
                $this$produceAssociativeArrays_u24lambda_u246.unaryPlus("-- open ? for select * from table(" + this.generator.argumentName(oraArgument) + ");");
            }
        }

        private final String commentMaybe() {
            return OraRoutineArgumentsAnalyzer.Companion.supportPlTypesInSql(this.generator.getContext().getTask().getVersion()) ? "" : "-- ";
        }

        public static final /* synthetic */ OraExecuteGenerator access$getGenerator$p(AsResultSets $this) {
            return $this.generator;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\bb\u0018\u00002\u00020\u0001J\"\u0010\u0002\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005R\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH&J\"\u0010\n\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005R\u00020\u00062\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\bH&J\"\u0010\f\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005R\u00020\u00062\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\bH&J\"\u0010\u000e\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005R\u00020\u00062\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\bH&J\"\u0010\u000f\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005R\u00020\u00062\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\bH&J\"\u0010\u0012\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005R\u00020\u00062\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\bH&J\"\u0010\u0013\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005R\u00020\u00062\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\bH&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0014\u00c0\u0006\u0001"}, d2={"Lcom/intellij/database/dialects/oracle/generator/OraExecuteGenerator$DataProducingWay;", "", "produceAssociativeArrays", "", "adapter", "Lcom/intellij/database/dialects/base/generator/ScriptingContext$NewCodingAdapter;", "Lcom/intellij/database/dialects/base/generator/ScriptingContext;", "associative", "", "Lcom/intellij/database/dialects/oracle/model/OraArgument;", "produceCursors", "cursors", "producePlArrays", "arrays", "producePlTables", "producePrimitives", "primitives", "Lcom/intellij/database/dialects/oracle/generator/OraRoutineArgumentsAnalyzer$PrimitivesPack;", "produceSqlArrays", "produceSqlTables", "intellij.database.dialects.oracle"})
    private static interface DataProducingWay {
        public void producePrimitives(@NotNull ScriptingContext.NewCodingAdapter var1, @NotNull List<OraRoutineArgumentsAnalyzer.PrimitivesPack> var2);

        public void produceCursors(@NotNull ScriptingContext.NewCodingAdapter var1, @NotNull List<? extends OraArgument> var2);

        public void produceSqlArrays(@NotNull ScriptingContext.NewCodingAdapter var1, @NotNull List<? extends OraArgument> var2);

        public void producePlArrays(@NotNull ScriptingContext.NewCodingAdapter var1, @NotNull List<? extends OraArgument> var2);

        public void produceSqlTables(@NotNull ScriptingContext.NewCodingAdapter var1, @NotNull List<? extends OraArgument> var2);

        public void producePlTables(@NotNull ScriptingContext.NewCodingAdapter var1, @NotNull List<? extends OraArgument> var2);

        public void produceAssociativeArrays(@NotNull ScriptingContext.NewCodingAdapter var1, @NotNull List<? extends OraArgument> var2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J*\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u00060\bR\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\"\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u00060\bR\u00020\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\"\u0010\u000f\u001a\u00020\u00062\n\u0010\u0007\u001a\u00060\bR\u00020\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\"\u0010\u0010\u001a\u00020\u00062\n\u0010\u0007\u001a\u00060\bR\u00020\t2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\"\u0010\u0012\u001a\u00020\u00062\n\u0010\u0007\u001a\u00060\bR\u00020\t2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\"\u0010\u0014\u001a\u00020\u00062\n\u0010\u0007\u001a\u00060\bR\u00020\t2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\"\u0010\u0016\u001a\u00020\u00062\n\u0010\u0007\u001a\u00060\bR\u00020\t2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\"\u0010\u0017\u001a\u00020\u00062\n\u0010\u0007\u001a\u00060\bR\u00020\t2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\rH\u0016J\"\u0010\u001a\u001a\u00020\u00062\n\u0010\u0007\u001a\u00060\bR\u00020\t2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\"\u0010\u001b\u001a\u00020\u00062\n\u0010\u0007\u001a\u00060\bR\u00020\t2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/database/dialects/oracle/generator/OraExecuteGenerator$DbmsOutput;", "Lcom/intellij/database/dialects/oracle/generator/OraExecuteGenerator$DataProducingWay;", "generator", "Lcom/intellij/database/dialects/oracle/generator/OraExecuteGenerator;", "(Lcom/intellij/database/dialects/oracle/generator/OraExecuteGenerator;)V", "print", "", "adapter", "Lcom/intellij/database/dialects/base/generator/ScriptingContext$NewCodingAdapter;", "Lcom/intellij/database/dialects/base/generator/ScriptingContext;", "prefix", "", "arguments", "", "Lcom/intellij/database/dialects/oracle/model/OraArgument;", "printCommented", "produceAssociativeArrays", "associative", "produceCursors", "cursors", "producePlArrays", "arrays", "producePlTables", "producePrimitives", "primitives", "Lcom/intellij/database/dialects/oracle/generator/OraRoutineArgumentsAnalyzer$PrimitivesPack;", "produceSqlArrays", "produceSqlTables", "intellij.database.dialects.oracle"})
    @SourceDebugExtension(value={"SMAP\nOraExecuteGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OraExecuteGenerator.kt\ncom/intellij/database/dialects/oracle/generator/OraExecuteGenerator$DbmsOutput\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,305:1\n1360#2:306\n1446#2,5:307\n766#2:312\n857#2,2:313\n766#2:315\n857#2,2:316\n*S KotlinDebug\n*F\n+ 1 OraExecuteGenerator.kt\ncom/intellij/database/dialects/oracle/generator/OraExecuteGenerator$DbmsOutput\n*L\n258#1:306\n258#1:307,5\n259#1:312\n259#1:313,2\n260#1:315\n260#1:316,2\n*E\n"})
    private static final class DbmsOutput
    implements DataProducingWay {
        @NotNull
        private final OraExecuteGenerator generator;

        public DbmsOutput(@NotNull OraExecuteGenerator generator) {
            Intrinsics.checkNotNullParameter((Object)generator, (String)"generator");
            this.generator = generator;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void producePrimitives(@NotNull ScriptingContext.NewCodingAdapter adapter, @NotNull List<OraRoutineArgumentsAnalyzer.PrimitivesPack> primitives) {
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Object it2;
            void $this$flatMapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
            Intrinsics.checkNotNullParameter(primitives, (String)"primitives");
            Iterable $this$flatMap$iv = primitives;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                it2 = (OraRoutineArgumentsAnalyzer.PrimitivesPack)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = ((OraRoutineArgumentsAnalyzer.PrimitivesPack)it2).getArguments();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List arguments = (List)destination$iv$iv;
            $this$flatMap$iv = arguments;
            ScriptingContext.NewCodingAdapter newCodingAdapter = adapter;
            DbmsOutput dbmsOutput = this;
            boolean $i$f$filter = false;
            $this$flatMapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it2 = (OraArgument)element$iv$iv;
                boolean bl = false;
                if (!it2.getDasType().toDataType().custom) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list = (List)destination$iv$iv;
            dbmsOutput.printCommented(newCodingAdapter, list);
            $this$filter$iv = arguments;
            newCodingAdapter = adapter;
            dbmsOutput = this;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it2 = (OraArgument)element$iv$iv;
                boolean bl = false;
                if (!(!it2.getDasType().toDataType().custom)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
            dbmsOutput.print(newCodingAdapter, list);
        }

        @Override
        public void produceCursors(@NotNull ScriptingContext.NewCodingAdapter adapter, @NotNull List<? extends OraArgument> cursors) {
            Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
            Intrinsics.checkNotNullParameter(cursors, (String)"cursors");
            this.printCommented(adapter, cursors);
        }

        @Override
        public void produceSqlArrays(@NotNull ScriptingContext.NewCodingAdapter adapter, @NotNull List<? extends OraArgument> arrays) {
            Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
            Intrinsics.checkNotNullParameter(arrays, (String)"arrays");
            this.printCommented(adapter, arrays);
        }

        @Override
        public void producePlArrays(@NotNull ScriptingContext.NewCodingAdapter adapter, @NotNull List<? extends OraArgument> arrays) {
            Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
            Intrinsics.checkNotNullParameter(arrays, (String)"arrays");
            this.printCommented(adapter, arrays);
        }

        @Override
        public void producePlTables(@NotNull ScriptingContext.NewCodingAdapter adapter, @NotNull List<? extends OraArgument> arrays) {
            Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
            Intrinsics.checkNotNullParameter(arrays, (String)"arrays");
            this.printCommented(adapter, arrays);
        }

        @Override
        public void produceSqlTables(@NotNull ScriptingContext.NewCodingAdapter adapter, @NotNull List<? extends OraArgument> arrays) {
            Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
            Intrinsics.checkNotNullParameter(arrays, (String)"arrays");
            this.printCommented(adapter, arrays);
        }

        @Override
        public void produceAssociativeArrays(@NotNull ScriptingContext.NewCodingAdapter adapter, @NotNull List<? extends OraArgument> associative) {
            Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
            Intrinsics.checkNotNullParameter(associative, (String)"associative");
            this.printCommented(adapter, associative);
        }

        private final void printCommented(ScriptingContext.NewCodingAdapter adapter, List<? extends OraArgument> arguments) {
            this.print(adapter, "-- ", arguments);
        }

        private final void print(ScriptingContext.NewCodingAdapter adapter, List<? extends OraArgument> arguments) {
            this.print(adapter, "", arguments);
        }

        private final void print(ScriptingContext.NewCodingAdapter adapter, String prefix, List<? extends OraArgument> arguments) {
            ScriptingContext.NewCodingAdapter newCodingAdapter;
            ScriptingContext.NewCodingAdapter $this$print_u24lambda_u243 = newCodingAdapter = adapter;
            boolean bl = false;
            for (OraArgument oraArgument : arguments) {
                String argumentName = this.generator.argumentName(oraArgument);
                $this$print_u24lambda_u243.unaryPlus(prefix + "dbms_output.put_line('" + argumentName + " = ' || " + argumentName + ");");
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DasTypeCategory.values().length];
            try {
                nArray[DasTypeCategory.INTEGER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.REAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.DATE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.STRING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

