/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.debugger;

import com.intellij.database.console.session.DatabaseSessionManager;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.DatabaseDepartment;
import com.intellij.database.dataSource.connection.statements.CallableStatementBasis;
import com.intellij.database.dataSource.connection.statements.CallableStatementData;
import com.intellij.database.dataSource.connection.statements.Configuration;
import com.intellij.database.dataSource.connection.statements.IndexedOutParameter;
import com.intellij.database.dataSource.connection.statements.NoisyStatement;
import com.intellij.database.dataSource.connection.statements.OutParameter;
import com.intellij.database.dataSource.connection.statements.ParameterizedStatementDecoration;
import com.intellij.database.dataSource.connection.statements.ResultsProducer;
import com.intellij.database.dataSource.connection.statements.SmartStatementSource;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.connection.statements.StatementParameters;
import com.intellij.database.dialects.oracle.debugger.CallDefinition;
import com.intellij.database.dialects.oracle.debugger.DebuggerUnableException;
import com.intellij.database.util.GuardedRef;
import com.intellij.database.util.Version;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u00a6\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0003\u001a\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u001a\u001b\u0010\u000f\u001a\u00020\u00102\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u0012\u00a2\u0006\u0002\u0010\u0014\u001a)\u0010\u000f\u001a\u00020\u00102\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u00162\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u0012\u00a2\u0006\u0002\u0010\u0017\u001a\u001c\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\n\u0010\u001c\u001a\u00060\u001dj\u0002`\u001eH\u0002\u001a&\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0000\u001aO\u0010(\u001a\u0002H)\"\b\b\u0000\u0010**\u00020+\"\u0004\b\u0001\u0010)*\u00020!2\u0006\u0010,\u001a\u0002H*2\u0012\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u0012\"\u00020\u00132\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u0002H)0.\u00a2\u0006\u0002\u00100\u001a_\u0010(\u001a\u000e\u0012\u0004\u0012\u0002H2\u0012\u0004\u0012\u0002H301\"\u0004\b\u0000\u00102\"\u0004\b\u0001\u00103*\u00020!2\u0006\u00104\u001a\u00020\f2\f\u00105\u001a\b\u0012\u0004\u0012\u0002H20\b2\f\u00106\u001a\b\u0012\u0004\u0012\u0002H30\b2\u0012\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u0012\"\u00020\u0013\u00a2\u0006\u0002\u00107\u001a?\u0010(\u001a\u0002H8\"\u0004\b\u0000\u00108*\u00020!2\u0006\u00104\u001a\u00020\f2\f\u00109\u001a\b\u0012\u0004\u0012\u0002H80\b2\u0012\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u0012\"\u00020\u0013\u00a2\u0006\u0002\u0010:\u001a?\u0010;\u001a\u0002H8\"\u0004\b\u0000\u00108*\u00020!2\u0006\u0010<\u001a\u00020\f2\f\u00109\u001a\b\u0012\u0004\u0012\u0002H80\b2\u0012\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u0012\"\u00020\u0013\u00a2\u0006\u0002\u0010:\u001a+\u0010=\u001a\u00020\u0019*\u00020!2\u0006\u0010>\u001a\u00020\f2\u0012\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u0012\"\u00020\u0013\u00a2\u0006\u0002\u0010?\u001a\u0010\u0010@\u001a\b\u0012\u0004\u0012\u00020B0A*\u00020!\u001a+\u0010C\u001a\u00020\u0019*\u00020!2\u0006\u00104\u001a\u00020\f2\u0012\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u0012\"\u00020\u0013\u00a2\u0006\u0002\u0010?\u001a\u0016\u0010D\u001a\u00020\f*\u00020E2\n\b\u0002\u0010F\u001a\u0004\u0018\u00010\f\u001a\n\u0010G\u001a\u00020E*\u00020E\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"'\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005*\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\b0\u00078F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006H"}, d2={"ourOracleDebuggerLogger", "Lcom/intellij/openapi/diagnostic/Logger;", "getOurOracleDebuggerLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "indices", "Ljava/util/SortedSet;", "", "", "Lcom/intellij/database/dataSource/connection/statements/IndexedOutParameter;", "getIndices", "(Ljava/util/List;)Ljava/util/SortedSet;", "checkForProblems", "", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "decorateInParameters", "Lcom/intellij/database/dataSource/connection/statements/ParameterizedStatementDecoration;", "parameters", "", "", "([Ljava/lang/Object;)Lcom/intellij/database/dataSource/connection/statements/ParameterizedStatementDecoration;", "skip", "", "(Ljava/util/Set;[Ljava/lang/Object;)Lcom/intellij/database/dataSource/connection/statements/ParameterizedStatementDecoration;", "handleException", "", "statement", "", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "obtainGuardedConnection", "Lcom/intellij/database/util/GuardedRef;", "Lcom/intellij/database/dataSource/DatabaseConnection;", "project", "Lcom/intellij/openapi/project/Project;", "connectionPoint", "Lcom/intellij/database/dataSource/DatabaseConnectionPoint;", "department", "Lcom/intellij/database/dataSource/connection/DatabaseDepartment;", "call", "R", "D", "Lcom/intellij/database/dialects/oracle/debugger/CallDefinition;", "definition", "handler", "Lkotlin/Function1;", "Lcom/intellij/database/dataSource/connection/statements/ResultsProducer;", "(Lcom/intellij/database/dataSource/DatabaseConnection;Lcom/intellij/database/dialects/oracle/debugger/CallDefinition;[Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "Lkotlin/Pair;", "V1", "V2", "statementText", "outParam1", "outParam2", "(Lcom/intellij/database/dataSource/DatabaseConnection;Ljava/lang/String;Lcom/intellij/database/dataSource/connection/statements/IndexedOutParameter;Lcom/intellij/database/dataSource/connection/statements/IndexedOutParameter;[Ljava/lang/Object;)Lkotlin/Pair;", "V", "resultParam", "(Lcom/intellij/database/dataSource/DatabaseConnection;Ljava/lang/String;Lcom/intellij/database/dataSource/connection/statements/IndexedOutParameter;[Ljava/lang/Object;)Ljava/lang/Object;", "callFunction", "function", "callProcedure", "procedure", "(Lcom/intellij/database/dataSource/DatabaseConnection;Ljava/lang/String;[Ljava/lang/Object;)V", "executor", "Lcom/intellij/database/dataSource/connection/statements/NoisyStatement;", "Lcom/intellij/database/dataSource/connection/statements/CallableStatementData;", "perform", "prepareGoodMessage", "", "prefix", "unwrapException", "intellij.database.dialects.oracle.ex"})
@SourceDebugExtension(value={"SMAP\nOraConnectionHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OraConnectionHelper.kt\ncom/intellij/database/dialects/oracle/debugger/OraConnectionHelperKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,263:1\n1620#2,3:264\n*S KotlinDebug\n*F\n+ 1 OraConnectionHelper.kt\ncom/intellij/database/dialects/oracle/debugger/OraConnectionHelperKt\n*L\n221#1:264,3\n*E\n"})
public final class OraConnectionHelperKt {
    @NotNull
    private static final Logger ourOracleDebuggerLogger;

    @NotNull
    public static final Logger getOurOracleDebuggerLogger() {
        return ourOracleDebuggerLogger;
    }

    @NotNull
    public static final GuardedRef<DatabaseConnection> obtainGuardedConnection(@NotNull Project project, @NotNull DatabaseConnectionPoint connectionPoint, @NotNull DatabaseDepartment department) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)connectionPoint, (String)"connectionPoint");
        Intrinsics.checkNotNullParameter((Object)department, (String)"department");
        LocalDataSource localDataSource = connectionPoint.getDataSource();
        Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"getDataSource(...)");
        String problem = OraConnectionHelperKt.checkForProblems(localDataSource);
        if (problem != null) {
            throw new DebuggerUnableException(problem);
        }
        return DatabaseSessionManager.getFacade(project, connectionPoint, null, null, false, null, department).connect();
    }

    @Nullable
    public static final String checkForProblems(@NotNull LocalDataSource dataSource2) {
        Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
        if (dataSource2.isSingleConnection()) {
            return "Debugging in the single connection mode is not possible";
        }
        Version version = dataSource2.getExactDriverVersion();
        Intrinsics.checkNotNullExpressionValue((Object)version, (String)"getExactDriverVersion(...)");
        Version driverVersion = version;
        int driverMajor = driverVersion.get(0);
        int driverMinor = driverVersion.get(1);
        Version version2 = dataSource2.getVersion();
        Intrinsics.checkNotNullExpressionValue((Object)version2, (String)"getVersion(...)");
        Version serverVersion = version2;
        int serverMajor = serverVersion.get(0);
        int serverMinor = serverVersion.get(1);
        if (driverMajor < 12 || serverMajor < 10) {
            if (driverMajor != serverMajor) {
                return "Driver version must be the same as the server version.\n\tServer version: " + serverVersion + "\n\tDriver version: " + driverVersion + "\n";
            }
            if (driverMinor < serverMinor) {
                return "Driver is not up to date.\n\tServer version: " + serverVersion + "\n\tDriver version: " + driverVersion + "\n";
            }
        }
        return null;
    }

    public static final void callProcedure(@NotNull DatabaseConnection $this$callProcedure, @NotNull String procedure, Object ... parameters2) {
        Intrinsics.checkNotNullParameter((Object)$this$callProcedure, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)procedure, (String)"procedure");
        Intrinsics.checkNotNullParameter((Object)parameters2, (String)"parameters");
        String statementText = "{ call " + procedure + " }";
        OraConnectionHelperKt.perform($this$callProcedure, statementText, Arrays.copyOf(parameters2, parameters2.length));
    }

    public static final <V> V callFunction(@NotNull DatabaseConnection $this$callFunction, @NotNull String function2, @NotNull IndexedOutParameter<V> resultParam, Object ... parameters2) {
        Intrinsics.checkNotNullParameter((Object)$this$callFunction, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        Intrinsics.checkNotNullParameter(resultParam, (String)"resultParam");
        Intrinsics.checkNotNullParameter((Object)parameters2, (String)"parameters");
        String statementText = "{ ? = call " + function2 + " }";
        return OraConnectionHelperKt.call($this$callFunction, statementText, resultParam, Arrays.copyOf(parameters2, parameters2.length));
    }

    public static final <V> V call(@NotNull DatabaseConnection $this$call, @NotNull String statementText, @NotNull IndexedOutParameter<V> resultParam, Object ... parameters2) {
        Intrinsics.checkNotNullParameter((Object)$this$call, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)statementText, (String)"statementText");
        Intrinsics.checkNotNullParameter(resultParam, (String)"resultParam");
        Intrinsics.checkNotNullParameter((Object)parameters2, (String)"parameters");
        try {
            CallableStatementBasis basis = new CallableStatementBasis(statementText, new BitSet(0), CollectionsKt.listOf(resultParam));
            ParameterizedStatementDecoration decor = OraConnectionHelperKt.decorateInParameters(SetsKt.setOf((Object)resultParam.getIndex()), parameters2);
            CallableStatementData csd = new CallableStatementData(basis, decor);
            NoisyStatement<CallableStatementData> executor = OraConnectionHelperKt.executor($this$call);
            return (V)executor.execute(csd, (Function1)new Function1<ResultsProducer, V>(resultParam){
                final /* synthetic */ IndexedOutParameter<V> $resultParam;
                {
                    this.$resultParam = $resultParam;
                    super(1);
                }

                public final V invoke(@NotNull ResultsProducer it2) {
                    Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                    return (V)it2.getParameterValue((OutParameter)this.$resultParam);
                }
            });
        }
        catch (Exception e2) {
            OraConnectionHelperKt.handleException(statementText, e2);
            throw e2;
        }
    }

    @NotNull
    public static final <V1, V2> Pair<V1, V2> call(@NotNull DatabaseConnection $this$call, @NotNull String statementText, @NotNull IndexedOutParameter<V1> outParam1, @NotNull IndexedOutParameter<V2> outParam2, Object ... parameters2) {
        Intrinsics.checkNotNullParameter((Object)$this$call, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)statementText, (String)"statementText");
        Intrinsics.checkNotNullParameter(outParam1, (String)"outParam1");
        Intrinsics.checkNotNullParameter(outParam2, (String)"outParam2");
        Intrinsics.checkNotNullParameter((Object)parameters2, (String)"parameters");
        try {
            Object[] objectArray = new IndexedOutParameter[]{outParam1, outParam2};
            List outParameters = CollectionsKt.listOf((Object[])objectArray);
            CallableStatementBasis basis = new CallableStatementBasis(statementText, new BitSet(0), outParameters);
            ParameterizedStatementDecoration decor = OraConnectionHelperKt.decorateInParameters((Set<Integer>)OraConnectionHelperKt.getIndices(outParameters), parameters2);
            CallableStatementData csd = new CallableStatementData(basis, decor);
            NoisyStatement<CallableStatementData> executor = OraConnectionHelperKt.executor($this$call);
            return (Pair)executor.execute(csd, (Function1)new Function1<ResultsProducer, Pair<? extends V1, ? extends V2>>(outParam1, outParam2){
                final /* synthetic */ IndexedOutParameter<V1> $outParam1;
                final /* synthetic */ IndexedOutParameter<V2> $outParam2;
                {
                    this.$outParam1 = $outParam1;
                    this.$outParam2 = $outParam2;
                    super(1);
                }

                @NotNull
                public final Pair<V1, V2> invoke(@NotNull ResultsProducer it2) {
                    Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                    T value1 = it2.getParameterValue((OutParameter)this.$outParam1);
                    T value2 = it2.getParameterValue((OutParameter)this.$outParam2);
                    return new Pair(value1, value2);
                }
            });
        }
        catch (Exception e2) {
            OraConnectionHelperKt.handleException(statementText, e2);
            throw e2;
        }
    }

    public static final <D extends CallDefinition, R> R call(@NotNull DatabaseConnection $this$call, @NotNull D definition2, @NotNull Object[] parameters2, @NotNull Function1<? super ResultsProducer, ? extends R> handler2) throws SQLException {
        Intrinsics.checkNotNullParameter((Object)$this$call, (String)"<this>");
        Intrinsics.checkNotNullParameter(definition2, (String)"definition");
        Intrinsics.checkNotNullParameter((Object)parameters2, (String)"parameters");
        Intrinsics.checkNotNullParameter(handler2, (String)"handler");
        try {
            CallableStatementBasis basis = new CallableStatementBasis(definition2.getText(), new BitSet(0), definition2.getOutParams());
            ParameterizedStatementDecoration decor = OraConnectionHelperKt.decorateInParameters((Set<Integer>)OraConnectionHelperKt.getIndices(definition2.getOutParams()), parameters2);
            CallableStatementData csd = new CallableStatementData(basis, decor);
            NoisyStatement<CallableStatementData> executor = OraConnectionHelperKt.executor($this$call);
            return executor.execute(csd, handler2);
        }
        catch (Exception e2) {
            OraConnectionHelperKt.handleException(definition2.getText(), e2);
            throw e2;
        }
    }

    public static final void perform(@NotNull DatabaseConnection $this$perform, @NotNull String statementText, Object ... parameters2) {
        Intrinsics.checkNotNullParameter((Object)$this$perform, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)statementText, (String)"statementText");
        Intrinsics.checkNotNullParameter((Object)parameters2, (String)"parameters");
        try {
            CallableStatementBasis basis = new CallableStatementBasis(statementText, new BitSet(0), CollectionsKt.emptyList());
            ParameterizedStatementDecoration decor = OraConnectionHelperKt.decorateInParameters(parameters2);
            CallableStatementData csd = new CallableStatementData(basis, decor);
            NoisyStatement<CallableStatementData> executor = OraConnectionHelperKt.executor($this$perform);
            NoisyStatement.execute$default(executor, csd, null, 2, null);
        }
        catch (Exception e2) {
            OraConnectionHelperKt.handleException(statementText, e2);
            throw e2;
        }
    }

    @NotNull
    public static final NoisyStatement<CallableStatementData> executor(@NotNull DatabaseConnection $this$executor) {
        Intrinsics.checkNotNullParameter((Object)$this$executor, (String)"<this>");
        return SmartStatements.Companion.poweredBy($this$executor).call(Configuration.Companion.sourced(SmartStatementSource.SYSTEM)).noisy();
    }

    @NotNull
    public static final ParameterizedStatementDecoration decorateInParameters(@NotNull Object[] parameters2) {
        Intrinsics.checkNotNullParameter((Object)parameters2, (String)"parameters");
        return OraConnectionHelperKt.decorateInParameters(SetsKt.emptySet(), parameters2);
    }

    @NotNull
    public static final ParameterizedStatementDecoration decorateInParameters(@NotNull Set<Integer> skip, @NotNull Object[] parameters2) {
        Intrinsics.checkNotNullParameter(skip, (String)"skip");
        Intrinsics.checkNotNullParameter((Object)parameters2, (String)"parameters");
        StatementParameters x = new StatementParameters();
        int k = 0;
        for (Object p2 : parameters2) {
            ++k;
            while (skip.contains(k)) {
                ++k;
            }
            Object object = p2;
            if (object instanceof Boolean) {
                x.integer(k, (Boolean)p2 != false ? 1 : 0);
                continue;
            }
            if (object instanceof Byte) {
                x.byteValue(k, (Byte)p2);
                continue;
            }
            if (object instanceof Short) {
                x.shortValue(k, (Short)p2);
                continue;
            }
            if (object instanceof Integer) {
                x.integer(k, (Integer)p2);
                continue;
            }
            if (object instanceof String) {
                x.text(k, (String)p2);
                continue;
            }
            x.obj(k, p2);
        }
        return x.asDecoration();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final SortedSet<Integer> getIndices(@NotNull List<? extends IndexedOutParameter<?>> $this$indices) {
        void var2_2;
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter($this$indices, (String)"<this>");
        Iterable iterable = $this$indices;
        Collection destination$iv = new TreeSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void p0;
            IndexedOutParameter indexedOutParameter = (IndexedOutParameter)item$iv;
            Collection collection2 = destination$iv;
            boolean bl = false;
            collection2.add(p0.getIndex());
        }
        return (SortedSet)var2_2;
    }

    @NotNull
    public static final Throwable unwrapException(@NotNull Throwable $this$unwrapException) {
        Intrinsics.checkNotNullParameter((Object)$this$unwrapException, (String)"<this>");
        Throwable e2 = $this$unwrapException;
        while (e2 instanceof RuntimeException && e2.getCause() != null) {
            Intrinsics.checkNotNull((Object)e2.getCause());
        }
        return e2;
    }

    @NotNull
    public static final String prepareGoodMessage(@NotNull Throwable $this$prepareGoodMessage, @Nullable String prefix) {
        Intrinsics.checkNotNullParameter((Object)$this$prepareGoodMessage, (String)"<this>");
        StringBuilder b2 = new StringBuilder(256);
        if (prefix != null) {
            b2.append(prefix).append(':').append(' ');
        }
        if ($this$prepareGoodMessage instanceof SQLException) {
            b2.append("Error ").append(((SQLException)$this$prepareGoodMessage).getErrorCode()).append(" SQL state ").append(((SQLException)$this$prepareGoodMessage).getSQLState());
        } else {
            b2.append("Exception ").append($this$prepareGoodMessage.getClass().getSimpleName());
        }
        boolean wasMessage = false;
        for (Throwable e2 = $this$prepareGoodMessage; e2 != null; e2 = e2.getCause()) {
            String m = e2.getMessage();
            if (m == null || StringsKt.contains$default((CharSequence)b2, (CharSequence)m, (boolean)false, (int)2, null)) continue;
            b2.append(':').append(' ').append(m);
            wasMessage = true;
        }
        if (!wasMessage) {
            b2.append(" (no message)");
        }
        String string = b2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public static /* synthetic */ String prepareGoodMessage$default(Throwable throwable, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return OraConnectionHelperKt.prepareGoodMessage(throwable, string);
    }

    private static final void handleException(CharSequence statement2, Exception e2) {
        if (ourOracleDebuggerLogger.isDebugEnabled()) {
            String exceptionDescription = e2 instanceof SQLException ? "SQL error " + ((SQLException)e2).getErrorCode() + " [" + ((SQLException)e2).getSQLState() + "]: " + e2.getMessage() : e2.getClass().getSimpleName() + ": " + e2.getMessage();
            String message2 = "Error occurred during Oracle debugger session:\n" + exceptionDescription + "\nStatement:\n" + statement2;
            ourOracleDebuggerLogger.debug(message2);
        }
    }

    static {
        Logger logger2 = Logger.getInstance((String)"com.intellij.database.oracle.Debugger");
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        ourOracleDebuggerLogger = logger2;
    }
}

