/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mysqlbase.plan;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.connection.statements.ReusableSmartStatement;
import com.intellij.database.dialects.base.plan.RawPlanData;
import com.intellij.database.plan.PlanRetrievalException;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ThrowableConsumer;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;

public class MysqlBaseRawPlanData
extends RawPlanData {
    public final List<PlanRow> rows = new ArrayList<PlanRow>();
    public Slicing slicing;

    @Override
    public void load(final @NotNull DatabaseConnectionCore connection2, final @NotNull String statement2, boolean run2) {
        if (connection2 == null) {
            MysqlBaseRawPlanData.$$$reportNull$$$0(0);
        }
        if (statement2 == null) {
            MysqlBaseRawPlanData.$$$reportNull$$$0(1);
        }
        MysqlBaseRawPlanData.useStatementWithPreserved(connection2, (RawPlanData.ResourceUser<? super ReusableSmartStatement<String>>)new RawPlanData.ResourceUser<ReusableSmartStatement<String>>(){

            @Override
            public void use(ReusableSmartStatement<String> s2) throws PlanRetrievalException, SQLException {
                Dbms dbms = connection2.getDbms();
                Version version = connection2.getVersion();
                boolean extended = MysqlBaseRawPlanData.alreadyExtended(dbms, version);
                s2.noisy().execute("EXPLAIN " + (!extended ? "EXTENDED " : "") + statement2, MysqlBaseRawPlanData.processing((ThrowableConsumer<? super RemoteResultSet, ? extends Exception>)rs -> {
                    while (rs.next()) {
                        MysqlBaseRawPlanData.this.rows.add(new PlanRow(rs.getInt("id"), rs.getString("key_len"), rs.getDouble("filtered"), rs.getString("select_type"), rs.getString("table"), rs.getString("type"), rs.getString("possible_keys"), rs.getString("key"), rs.getString("ref"), rs.getBigDecimal("rows"), StringUtil.notNullize((String)rs.getString("Extra"))));
                    }
                    if (MysqlBaseRawPlanData.this.rows.isEmpty()) {
                        MysqlBaseRawPlanData.failWithEmptyResultSetError();
                    }
                }));
            }
        }, new RawPlanData.StateSaver[0]);
        this.initSlicing();
    }

    private void initSlicing() {
        int max = -1;
        for (PlanRow row : this.rows) {
            max = Math.max(max, row.id);
        }
        this.slicing = new Slicing(max);
    }

    static boolean alreadyExtended(Dbms dbms, Version version) {
        if (dbms == Dbms.MARIA) {
            return false;
        }
        if (dbms == Dbms.MYSQL_AURORA) {
            return version.isOrGreater(3, 0);
        }
        return version.isOrGreater(8, 0);
    }

    @Override
    public String dump() {
        StringBuilder sb = new StringBuilder();
        for (PlanRow row : this.rows) {
            sb.append("\t").append(row.id).append("\t").append(row.selectType).append("\t").append(row.table).append("\t").append(row.type).append("\t").append(row.possibleKeys).append("\t").append(row.key).append("\t").append(row.keyLen).append("\t").append(row.ref).append("\t").append(row.rows).append("\t").append(row.filtered).append("\t").append(row.extra).append("\n");
        }
        return sb.toString();
    }

    @Override
    public void load(@NotNull String dump2) {
        if (dump2 == null) {
            MysqlBaseRawPlanData.$$$reportNull$$$0(2);
        }
        this.rows.clear();
        for (String line : dump2.split("\\r?\\n")) {
            ArrayList<String> split = new ArrayList<String>(StringUtil.split((String)line, (String)"\t", (boolean)true, (boolean)false));
            assert (split.size() == 12);
            if (((String)split.get(11)).equals(".")) {
                split.set(11, "");
            }
            this.rows.add(new PlanRow(Integer.parseInt((String)split.get(1)), (String)split.get(7), Double.parseDouble((String)split.get(10)), (String)split.get(2), (String)split.get(3), (String)split.get(4), (String)split.get(5), (String)split.get(6), (String)split.get(8), "null".equals(split.get(9)) ? null : new BigDecimal((String)split.get(9)), (String)split.get(11)));
        }
        this.initSlicing();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "connection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "statement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "dump";
                break;
            }
        }
        objectArray[1] = "com/intellij/database/dialects/mysqlbase/plan/MysqlBaseRawPlanData";
        objectArray[2] = "load";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static final class PlanRow {
        public final int id;
        public final BigDecimal rows;
        public final double filtered;
        public final String selectType;
        public final String table;
        public final String type;
        public final String possibleKeys;
        public final String key;
        public final String keyLen;
        public final String ref;
        public final String extra;

        private PlanRow(int id, String keyLen, double filtered2, String selectType, String table, String type2, String possibleKeys, String key2, String ref2, BigDecimal rows, String extra) {
            this.id = id;
            this.keyLen = keyLen;
            this.filtered = filtered2;
            this.selectType = selectType;
            this.table = table;
            this.type = type2;
            this.possibleKeys = possibleKeys;
            this.key = key2;
            this.ref = ref2;
            this.rows = rows;
            this.extra = extra;
        }
    }

    public static final class Slicing {
        private final int myMax;
        private final SortedSet<Integer> mySlicePoints = new TreeSet<Integer>();

        private Slicing(int max) {
            this.myMax = max;
        }

        public void slice(int point) {
            this.mySlicePoints.add(point);
        }

        public int next(int point) {
            SortedSet<Integer> head = this.mySlicePoints.tailSet(point + 1);
            return head.isEmpty() ? this.myMax : head.first();
        }
    }
}

