/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mysqlbase.generator.producers;

import com.intellij.database.dialects.base.generator.AbstractScriptGeneratorKt;
import com.intellij.database.dialects.base.generator.ScriptGeneratorHelperKt;
import com.intellij.database.dialects.base.generator.ScriptingContext;
import com.intellij.database.dialects.base.generator.producers.AlterRoutine;
import com.intellij.database.dialects.base.generator.producers.Flags;
import com.intellij.database.dialects.base.generator.producers.RoutineProducerKt;
import com.intellij.database.dialects.base.generator.producers.SourceAwareProducersKt;
import com.intellij.database.dialects.mysqlbase.generator.MysqlBaseScriptGeneratorHelperKt;
import com.intellij.database.dialects.mysqlbase.generator.producers.MysqlBaseRoutineProducersKt;
import com.intellij.database.dialects.mysqlbase.model.MysqlBaseRoutine;
import com.intellij.database.model.ElementAlteration;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.meta.BasicMetaField;
import com.intellij.database.model.meta.BasicMetaId;
import com.intellij.database.model.meta.BasicMetaPropertyId;
import com.intellij.database.script.generator.ScriptingCapabilities;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0002J\b\u0010\n\u001a\u00020\tH\u0002J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\rH\u0014J\b\u0010\u0011\u001a\u00020\rH\u0002J\u001d\u0010\u0012\u001a\u0004\u0018\u00010\r2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u0014H\u0014\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u0016\u001a\u00020\tH\u0016J\u001e\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u000f2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001aH\u0016J\b\u0010\u001b\u001a\u00020\rH\u0002\u00a8\u0006\u001c"}, d2={"Lcom/intellij/database/dialects/mysqlbase/generator/producers/MysqlBaseAlterRoutine;", "Lcom/intellij/database/dialects/base/generator/producers/AlterRoutine;", "Lcom/intellij/database/dialects/mysqlbase/model/MysqlBaseRoutine;", "context", "Lcom/intellij/database/dialects/base/generator/ScriptingContext;", "elements", "Lcom/intellij/database/model/ElementAlteration;", "(Lcom/intellij/database/dialects/base/generator/ScriptingContext;Lcom/intellij/database/model/ElementAlteration;)V", "alterSecurity", "", "alterSqlAccess", "canAlter", "Lcom/intellij/database/script/generator/ScriptingCapabilities$VersionedCapability;", "", "prop", "Lcom/intellij/database/model/meta/BasicMetaId;", "checkAlterDefinition", "commentDropped", "computeAlterField", "f", "Lcom/intellij/database/model/meta/BasicMetaField;", "(Lcom/intellij/database/model/meta/BasicMetaField;)Ljava/lang/Boolean;", "produceAlterComment", "produceFlag", "id", "produced", "", "shouldRecreate", "intellij.database.dialects.mysqlbase"})
public final class MysqlBaseAlterRoutine
extends AlterRoutine<MysqlBaseRoutine> {
    public MysqlBaseAlterRoutine(@NotNull ScriptingContext context, @NotNull ElementAlteration<? extends MysqlBaseRoutine> elements2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(elements2, (String)"elements");
        super(context, elements2);
        this.getFlags().add(RoutineProducerKt.getRECREATE_FLAG_ID(), this.shouldRecreate());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldRecreate() {
        if (this.getFlags().get(SourceAwareProducersKt.getDEFINITION_FLAG_ID())) return true;
        Flags flags = this.getFlags();
        BasicMetaPropertyId<String> basicMetaPropertyId = MysqlBaseRoutine.DEFINER;
        Intrinsics.checkNotNullExpressionValue(basicMetaPropertyId, (String)"DEFINER");
        if (flags.get(basicMetaPropertyId)) return true;
        if (this.commentDropped()) return true;
        if (!this.isAnyRename()) return false;
        return true;
    }

    private final boolean commentDropped() {
        Flags flags = this.getFlags();
        BasicMetaPropertyId<String> basicMetaPropertyId = BasicModNamedElement.COMMENT;
        Intrinsics.checkNotNullExpressionValue(basicMetaPropertyId, (String)"COMMENT");
        return flags.get(basicMetaPropertyId) && ((MysqlBaseRoutine)this.getTo()).getComment() == null;
    }

    @Override
    @Nullable
    protected Boolean computeAlterField(@NotNull BasicMetaField<MysqlBaseRoutine> f) {
        Intrinsics.checkNotNullParameter(f, (String)"f");
        return Intrinsics.areEqual((Object)f.getId(), MysqlBaseRoutine.DEFINER) ? Boolean.valueOf(MysqlBaseScriptGeneratorHelperKt.checkAlterDefiner(this, ((MysqlBaseRoutine)this.getElement()).getDefiner(), ((MysqlBaseRoutine)this.getTo()).getDefiner())) : super.computeAlterField(f);
    }

    @Override
    protected boolean checkAlterDefinition() {
        return !this.isAnyRename() && super.checkAlterDefinition();
    }

    @Override
    public void produceFlag(@NotNull BasicMetaId id, @NotNull Set<BasicMetaId> produced) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(produced, (String)"produced");
        BasicMetaId basicMetaId = id;
        if (Intrinsics.areEqual((Object)basicMetaId, MysqlBaseRoutine.SECURITY_DEFINER)) {
            this.alterSecurity();
        } else if (Intrinsics.areEqual((Object)basicMetaId, MysqlBaseRoutine.SQL_ACCESS)) {
            this.alterSqlAccess();
        } else {
            super.produceFlag(id, produced);
        }
    }

    private final void alterSecurity() {
        this.newCoding((Function1<? super ScriptingContext.NewCodingAdapter, Unit>)((Function1)new Function1<ScriptingContext.NewCodingAdapter, Unit>(this){
            final /* synthetic */ MysqlBaseAlterRoutine this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull ScriptingContext.NewCodingAdapter $this$newCoding) {
                Intrinsics.checkNotNullParameter((Object)$this$newCoding, (String)"$this$newCoding");
                $this$newCoding.plus($this$newCoding.plus($this$newCoding.plus($this$newCoding.plus($this$newCoding.unaryPlus("alter"), StringUtil.toLowerCase((String)MysqlBaseRoutineProducersKt.access$routineKindStrict((MysqlBaseRoutine)this.this$0.getTo()).name())), this.this$0.toNameScr()), "security"), ((MysqlBaseRoutine)this.this$0.getTo()).isSecurityDefiner() ? "definer" : "invoker");
            }
        }));
    }

    private final void alterSqlAccess() {
        this.newCoding((Function1<? super ScriptingContext.NewCodingAdapter, Unit>)((Function1)new Function1<ScriptingContext.NewCodingAdapter, Unit>(this){
            final /* synthetic */ MysqlBaseAlterRoutine this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull ScriptingContext.NewCodingAdapter $this$newCoding) {
                Intrinsics.checkNotNullParameter((Object)$this$newCoding, (String)"$this$newCoding");
                $this$newCoding.plus($this$newCoding.plus($this$newCoding.plus($this$newCoding.unaryPlus("alter"), StringUtil.toLowerCase((String)MysqlBaseRoutineProducersKt.access$routineKindStrict((MysqlBaseRoutine)this.this$0.getTo()).name())), this.this$0.toNameScr()), ((MysqlBaseRoutine)this.this$0.getTo()).getSqlAccess().getSql());
            }
        }));
    }

    @Override
    public void produceAlterComment() {
        this.newCoding((Function1<? super ScriptingContext.NewCodingAdapter, Unit>)((Function1)new Function1<ScriptingContext.NewCodingAdapter, Unit>(this){
            final /* synthetic */ MysqlBaseAlterRoutine this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull ScriptingContext.NewCodingAdapter $this$newCoding) {
                Intrinsics.checkNotNullParameter((Object)$this$newCoding, (String)"$this$newCoding");
                ScriptingContext.NewCodingAdapter newCodingAdapter = $this$newCoding.plus($this$newCoding.plus($this$newCoding.plus($this$newCoding.unaryPlus("alter"), StringUtil.toLowerCase((String)MysqlBaseRoutineProducersKt.access$routineKindStrict((MysqlBaseRoutine)this.this$0.getTo()).name())), this.this$0.toNameScr()), "comment");
                String string = ((MysqlBaseRoutine)this.this$0.getTo()).getComment();
                if (string == null) {
                    string = "";
                }
                $this$newCoding.plus(newCodingAdapter, ScriptGeneratorHelperKt.getSqlString(string));
            }
        }));
    }

    @Override
    @NotNull
    public ScriptingCapabilities.VersionedCapability<Boolean> canAlter(@NotNull BasicMetaId prop) {
        Intrinsics.checkNotNullParameter((Object)prop, (String)"prop");
        BasicMetaId basicMetaId = prop;
        return Intrinsics.areEqual((Object)basicMetaId, (Object)MysqlBaseRoutine.ROUTINE_KIND) ? AbstractScriptGeneratorKt.getUNSUPPORTED() : (Intrinsics.areEqual((Object)basicMetaId, (Object)MysqlBaseRoutine.DETERMINISTIC) ? AbstractScriptGeneratorKt.getUNSUPPORTED() : super.canAlter(prop));
    }
}

