/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mysqlbase;

import com.intellij.database.Dbms;
import com.intellij.database.data.types.BaseDomainRegistry;
import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.DomainRegistry;
import com.intellij.database.data.types.domain.BinaryDomain;
import com.intellij.database.data.types.domain.BitDomain;
import com.intellij.database.data.types.domain.BooleanDomain;
import com.intellij.database.data.types.domain.Compatibility;
import com.intellij.database.data.types.domain.CustomSuitabilityDomain;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.Float1Domain;
import com.intellij.database.data.types.domain.FloatDomain;
import com.intellij.database.data.types.domain.FractionDomain;
import com.intellij.database.data.types.domain.IntegerDomain;
import com.intellij.database.data.types.domain.MysqlFloatDomain;
import com.intellij.database.data.types.domain.MysqlNumber2Domain;
import com.intellij.database.data.types.domain.Number2Domain;
import com.intellij.database.data.types.domain.OperationSupport;
import com.intellij.database.data.types.domain.SimpleDomain;
import com.intellij.database.data.types.domain.TextDomain;
import com.intellij.database.util.Version;
import com.intellij.database.util.VersionRange;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public class MysqlBaseDomains
extends BaseDomainRegistry {
    private static final int MIN_MYSQL_MEDIUM_INT = -16777216;
    private static final int MAX_MYSQL_MEDIUM_INT = 0xFFFFFF;
    private static final int MAX_MYSQL_MEDIUM_INT_UNSIGNED = 0xFFFFFF;
    private static final int MAX_PRECISION = 53;
    private static final int MAX_SCALE = 30;
    protected static final int MAX_CHAR = 255;
    protected static final long MAX_LONG = 0xFFFFFFL;
    protected static final int MAX_VARBINARY = 65535;
    protected static final int MAX_VARCHAR = 21844;
    protected static final long INTEGER_UNSIGNED_MAX = 0xFFFFFFFFL;

    public MysqlBaseDomains(@NotNull Dbms dbms) {
        if (dbms == null) {
            MysqlBaseDomains.$$$reportNull$$$0(0);
        }
        this(dbms, true, true);
    }

    public MysqlBaseDomains(@NotNull Dbms dbms, boolean sizedFloats, boolean texts) {
        if (dbms == null) {
            MysqlBaseDomains.$$$reportNull$$$0(1);
        }
        this.add(new CustomSuitabilityDomain.LessOrEqual(new BooleanDomain("bit", ConversionPoint.BOOLEAN), 1));
        this.add(new CustomSuitabilityDomain.Greater(new BitDomain("bit", ConversionPoint.BINARY, 64L, -1L, true, false), 1));
        this.add(new BooleanDomain("bool", ConversionPoint.BOOLEAN));
        this.add(new IntegerDomain("mediumint", ConversionPoint.NUMBER, -1.6777216E7, 1.6777215E7));
        this.add(new IntegerDomain("mediumint unsigned", ConversionPoint.NUMBER, 0.0, 1.6777215E7));
        this.add(new YearDomain());
        this.add(new IntegerDomain("integer", ConversionPoint.NUMBER, -2.147483648E9, 2.147483647E9).withAliases("int"));
        this.add(new IntegerDomain("integer unsigned", ConversionPoint.UNSIGNED_NUMBER, 0.0, 4.294967295E9).withAliases("int unsigned"));
        this.add(new IntegerDomain("smallint", ConversionPoint.NUMBER, -32768.0, 32767.0));
        this.add(new IntegerDomain("smallint unsigned", ConversionPoint.UNSIGNED_NUMBER, 0.0, 65535.0));
        this.add(new IntegerDomain("tinyint", ConversionPoint.NUMBER, -128.0, 127.0));
        this.add(new IntegerDomain("tinyint unsigned", ConversionPoint.UNSIGNED_NUMBER, 0.0, 127.0));
        this.add(new IntegerDomain("bigint", ConversionPoint.NUMBER, -9.223372036854776E18, 9.223372036854776E18));
        this.add(new IntegerDomain("bigint unsigned", ConversionPoint.UNSIGNED_NUMBER, 0.0, DomainRegistry.CommonLimits.BIGINT_UNSIGNED_MAX));
        if (sizedFloats) {
            this.add(new MysqlNumber2Domain(new Number2Domain("double precision", ConversionPoint.DOUBLE_PRECISION, 53, 30, true)).withAliases("double"));
            this.add(new MysqlFloatDomain(new FloatDomain("double precision", ConversionPoint.DOUBLE_PRECISION, -1.7976931348623157E308, Double.MAX_VALUE)).withAliases("double"));
        } else {
            this.add(new FloatDomain("double precision", ConversionPoint.DOUBLE_PRECISION, -1.7976931348623157E308, Double.MAX_VALUE).withAliases("double"));
        }
        this.add(new Number2Domain("decimal", ConversionPoint.BIG_DECIMAL, 53, 30, true).withAliases("dec"));
        this.add(new SimpleDomain("date", ConversionPoint.DATE).withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        this.add(new FractionDomain("time", ConversionPoint.TIME, 6, -1, false).withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        this.add(new FractionDomain("timestamp", ConversionPoint.TIMESTAMP, 6, -1, false).withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        this.add(new FractionDomain("datetime", ConversionPoint.TIMESTAMP, 6, -1, false).withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        if (texts) {
            this.add(new TextDomain("tinytext", ConversionPoint.VARCHAR, 255L));
            this.add(new TextDomain("text", ConversionPoint.TEXT, 65535L));
            this.add(new TextDomain("mediumtext", ConversionPoint.CLOB, 0xFFFFFFL).withOperationSupport(OperationSupport.SUPPORTS_LIKE));
            this.add(new TextDomain("longtext", ConversionPoint.CLOB, 0xFFFFFFFFL).withOperationSupport(OperationSupport.SUPPORTS_LIKE));
            this.add(new TextDomain("char", ConversionPoint.CHAR, 255L, 1L, true, false));
            this.add(new TextDomain("varchar", ConversionPoint.VARCHAR, 21844L, TextDomain.Length.mandatory(4368L, true)));
            this.add(new TextDomain("nvarchar", ConversionPoint.NVARCHAR, 21844L, TextDomain.Length.mandatory(4368L, true)));
        }
        this.add(new BinaryDomain("binary", ConversionPoint.BINARY, 255L, -1L, true, false).withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        this.add(new BinaryDomain("blob", ConversionPoint.BLOB, 65535L).withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        this.add(new BinaryDomain("tinyblob", ConversionPoint.BLOB, 255L).withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        this.add(new BinaryDomain("mediumblob", ConversionPoint.BLOB, 0xFFFFFFL).withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        this.add(new BinaryDomain("longblob", ConversionPoint.BLOB, 0xFFFFFFFFL).withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        this.add(new BinaryDomain("varbinary", ConversionPoint.VARBINARY, 65535L, TextDomain.Length.mandatory(13107L, true)).withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        if (sizedFloats) {
            this.add(new MysqlNumber2Domain(new Number2Domain("float", ConversionPoint.SINGLE_PRECISION, 53, 30, true)));
            this.add(new MysqlNumber2Domain(new Number2Domain("real", ConversionPoint.SINGLE_PRECISION, 53, 30, true)));
            this.add(new MysqlFloatDomain(new Float1Domain("float", ConversionPoint.SINGLE_PRECISION, new DomainRegistry.Limits(new DomainRegistry.Limit(23, Float.valueOf(-3.4028235E38f), Float.valueOf(Float.MAX_VALUE)), new DomainRegistry.Limit(53, -1.7976931348623157E308, Double.MAX_VALUE)))));
            this.add(new MysqlFloatDomain(new FloatDomain("real", ConversionPoint.SINGLE_PRECISION, -3.4028234663852886E38, 3.4028234663852886E38)));
        } else {
            this.add(new FloatDomain("float", ConversionPoint.SINGLE_PRECISION, -3.4028234663852886E38, 3.4028234663852886E38));
            this.add(new FloatDomain("real", ConversionPoint.SINGLE_PRECISION, -3.4028234663852886E38, 3.4028234663852886E38));
        }
        this.add(new SimpleDomain("json", ConversionPoint.JSON).withOperationSupport(OperationSupport.SUPPORTS_LIKE).withVersionRange(dbms.is(Dbms.MYSQL) ? VersionRange.after(Version.of(5, 7, 8)) : (dbms.is(Dbms.MYSQL_AURORA) ? VersionRange.after(Version.of(2)) : VersionRange.before(Version.INFINITY))));
        this.add(new SimpleDomain("enum", ConversionPoint.TEXT){

            @Override
            @NotNull
            public Compatibility getCompatibility(@NotNull Domain domain) {
                if (domain == null) {
                    1.$$$reportNull$$$0(0);
                }
                Compatibility compatibility = domain instanceof SimpleDomain && StringUtil.equals((CharSequence)domain.name(), (CharSequence)this.name()) ? Compatibility.full(this.cardinality(), domain.getLogicType(), this.getLogicType()) : Compatibility.incompatible();
                if (compatibility == null) {
                    1.$$$reportNull$$$0(1);
                }
                return compatibility;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "domain";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/dialects/mysqlbase/MysqlBaseDomains$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/dialects/mysqlbase/MysqlBaseDomains$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getCompatibility";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getCompatibility";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        }.withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        this.add(new SimpleDomain("set", ConversionPoint.TEXT){

            @Override
            @NotNull
            public Compatibility getCompatibility(@NotNull Domain domain) {
                if (domain == null) {
                    2.$$$reportNull$$$0(0);
                }
                Compatibility compatibility = domain instanceof SimpleDomain && StringUtil.equals((CharSequence)domain.name(), (CharSequence)this.name()) ? Compatibility.full(this.cardinality(), domain.getLogicType(), this.getLogicType()) : Compatibility.incompatible();
                if (compatibility == null) {
                    2.$$$reportNull$$$0(1);
                }
                return compatibility;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "domain";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/dialects/mysqlbase/MysqlBaseDomains$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/dialects/mysqlbase/MysqlBaseDomains$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getCompatibility";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getCompatibility";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        }.withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        this.add(new SimpleDomain("geometry", ConversionPoint.GEOMETRY));
        this.add(new SimpleDomain("point", ConversionPoint.GEOMETRY));
        this.add(new SimpleDomain("polygon", ConversionPoint.GEOMETRY));
        this.add(new SimpleDomain("linestring", ConversionPoint.GEOMETRY));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dbms", "com/intellij/database/dialects/mysqlbase/MysqlBaseDomains", "<init>"));
    }

    private static class YearDomain
    extends IntegerDomain {
        public static final int MIN = 1901;
        public static final int MAX = 2155;

        YearDomain() {
            super("year", ConversionPoint.NUMBER, 1901.0, 2155.0);
            this.withOperationSupport(OperationSupport.SUPPORTS_LIKE);
        }

        @Override
        @NotNull
        protected Number trim(@NotNull Number n) {
            long l;
            if (n == null) {
                YearDomain.$$$reportNull$$$0(0);
            }
            Long l2 = (l = YearDomain.convert(n.longValue())) <= 2155L && l >= 1901L ? l : 0L;
            if (l2 == null) {
                YearDomain.$$$reportNull$$$0(1);
            }
            return l2;
        }

        private static long convert(long value2) {
            return value2 <= 69L && value2 >= 1L ? 2000L + value2 : (value2 >= 70L && value2 <= 99L ? 1900L + value2 : value2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "n";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dialects/mysqlbase/MysqlBaseDomains$YearDomain";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dialects/mysqlbase/MysqlBaseDomains$YearDomain";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "trim";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "trim";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

