/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql.ui;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.DataSourceSshTunnelConfiguration;
import com.intellij.database.dataSource.url.DataInterchange;
import com.intellij.database.dataSource.url.ui.CompletionParamEditor;
import com.intellij.database.dialects.mssql.ssrp.SsrpInfo;
import com.intellij.database.dialects.mssql.ssrp.SsrpInfoCache;
import com.intellij.database.dialects.mssql.ui.SsrpHostParamEditor;
import com.intellij.database.util.ErrorHandler;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.impl.EditorMouseHoverPopupControl;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SsrpInstanceParamEditor
extends CompletionParamEditor<SsrpInfo.SsrpInstance> {
    public SsrpInstanceParamEditor(@NlsContexts.Label @NotNull String label2, @NotNull DataInterchange interchange) {
        if (label2 == null) {
            SsrpInstanceParamEditor.$$$reportNull$$$0(0);
        }
        if (interchange == null) {
            SsrpInstanceParamEditor.$$$reportNull$$$0(1);
        }
        super(label2, interchange);
        this.setForceRefresh(DatabaseBundle.message("SsrpInstanceParamEditor.progress.title.refresh", new Object[0]));
        this.setValidateOnDirtyCompletion(true);
        this.addUpdateOnShow();
        this.setReportErrorOnAutoPopup(true);
        this.getInterchange().addUserDataListener(new DataInterchange.UserDataListener(){

            public void userDataChanged(@NotNull Key changed) {
                if (changed == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (changed != SsrpHostParamEditor.SSRP_INFO) {
                    return;
                }
                SsrpInstanceParamEditor.this.updateVariants();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changed", "com/intellij/database/dialects/mssql/ui/SsrpInstanceParamEditor$1", "userDataChanged"));
            }
        }, this);
        this.getInterchange().addPropertyChangeListener("host", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SsrpInstanceParamEditor.this.updateVariants();
            }
        }, this);
        ((CompletionParamEditor.ProgressFieldWithCompletion)this.getEditorComponent()).getField().addSettingsProvider(this::updateHighlighting);
    }

    private void updateVariants() {
        try {
            this.setVariantsAndCompletionVariants((List)ObjectUtils.chooseNotNull(this.getVariants(false), Collections.emptyList()));
        }
        catch (Exception e2) {
            this.setVariantsAndCompletionVariants(Collections.emptyList());
        }
    }

    protected void updateHighlighting(@Nullable Editor editor2) {
        String error2;
        if (editor2 == null) {
            return;
        }
        EditorMouseHoverPopupControl.disablePopups((Editor)editor2);
        boolean unsupportedBrowsing = DataSourceSshTunnelConfiguration.hasTunnel(this.getInterchange().getDataSource());
        editor2.getMarkupModel().removeAllHighlighters();
        SsrpInfo.SsrpServer server = this.getServer();
        SsrpInfo.SsrpInstance inst = server == null ? null : server.getInstance(this.getText());
        String string = error2 = server == null ? null : server.getError();
        if (unsupportedBrowsing || error2 == null && (server == null || inst != null) || StringUtil.isEmptyOrSpaces((String)this.getText())) {
            editor2.getContentComponent().setToolTipText("");
            return;
        }
        TextAttributesKey key2 = CodeInsightColors.WEAK_WARNING_ATTRIBUTES;
        String msg = "UnknownHost".equals(error2) ? DatabaseBundle.message("SsrpInstanceParamEditor.unable.to.contact.browser.service.unknown.host", new Object[0]) : ("NoResponse".equals(error2) ? DatabaseBundle.message("SsrpInstanceParamEditor.unable.to.contact.browser.service.no.response", new Object[0]) : DatabaseBundle.message("SsrpInstanceParamEditor.no.such.instance", new Object[0]));
        editor2.getContentComponent().setToolTipText(msg);
        editor2.getMarkupModel().addRangeHighlighter(key2, 0, editor2.getDocument().getTextLength(), 4000, HighlighterTargetArea.EXACT_RANGE);
    }

    @Override
    @NotNull
    protected List<SsrpInfo.SsrpInstance> getVariantsSync(@NotNull Map<Key<?>, ?> options2, @NotNull ErrorHandler handler2) {
        List<SsrpInfo.SsrpInstance> list;
        if (options2 == null) {
            SsrpInstanceParamEditor.$$$reportNull$$$0(2);
        }
        if (handler2 == null) {
            SsrpInstanceParamEditor.$$$reportNull$$$0(3);
        }
        try {
            List<SsrpInfo.SsrpInstance> res2 = this.getVariants(false);
            if (res2 == null) {
                res2 = this.getVariants(true);
            }
            if (res2 == null) {
                res2 = Collections.emptyList();
            }
            list = res2;
        }
        catch (Exception e2) {
            handler2.addError(null, (Throwable)e2);
            throw new ProcessCanceledException();
        }
        if (list == null) {
            SsrpInstanceParamEditor.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Nullable
    protected List<SsrpInfo.SsrpInstance> getVariants(boolean forced) throws Exception {
        String host = this.getInterchange().getProperty("host");
        if (StringUtil.isEmptyOrSpaces((String)host)) {
            return null;
        }
        SsrpInfo.SsrpServer server = this.getServer();
        if (server == null && forced) {
            SsrpInfoCache.updateHost(false, host);
            server = this.getServer();
        }
        return server == null ? null : new ArrayList<SsrpInfo.SsrpInstance>(server.getInstances());
    }

    @Override
    @Nullable
    protected String getTypeText(@NotNull SsrpInfo.SsrpInstance item) {
        if (item == null) {
            SsrpInstanceParamEditor.$$$reportNull$$$0(5);
        }
        return item.getAttribute("Version");
    }

    @Override
    @NotNull
    protected String getText(@NotNull SsrpInfo.SsrpInstance item) {
        if (item == null) {
            SsrpInstanceParamEditor.$$$reportNull$$$0(6);
        }
        String string = item.getName();
        if (string == null) {
            SsrpInstanceParamEditor.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    private SsrpInfo.SsrpServer getServer() {
        SsrpInfo info2 = (SsrpInfo)SsrpHostParamEditor.SSRP_INFO.get((UserDataHolder)this.getInterchange());
        String host = this.getInterchange().getProperty("host");
        return info2 == null || host == null ? null : info2.getServer(host);
    }

    @Override
    protected void setVariants(@NotNull List<SsrpInfo.SsrpInstance> variants) {
        if (variants == null) {
            SsrpInstanceParamEditor.$$$reportNull$$$0(8);
        }
        super.setVariants(variants);
        this.updateHighlighting(((CompletionParamEditor.ProgressFieldWithCompletion)this.getEditorComponent()).getField().getEditor());
    }

    @Override
    protected void fireChanged() {
        super.fireChanged();
        this.updateHighlighting(((CompletionParamEditor.ProgressFieldWithCompletion)this.getEditorComponent()).getField().getEditor());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interchange";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/mssql/ui/SsrpInstanceParamEditor";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/mssql/ui/SsrpInstanceParamEditor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariantsSync";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getVariantsSync";
                break;
            }
            case 4: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getTypeText";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getText";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setVariants";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 7 -> new IllegalStateException(string);
        };
    }
}

