/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql.types;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.types.DasTypeSystemImpl;
import com.intellij.database.dialects.mssql.types.MsTypeSystemKt;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeCategory;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.SqlDialectImplUtilCore;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J.\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\fH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001c\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u000fH\u0016J\u0010\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u000fH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0014\u00a8\u0006\u001f"}, d2={"Lcom/intellij/database/dialects/mssql/types/MsTypeSystem;", "Lcom/intellij/database/dialects/base/types/DasTypeSystemImpl;", "dbms", "Lcom/intellij/database/Dbms;", "(Lcom/intellij/database/Dbms;)V", "getBuiltinFunctionReturnType", "Lcom/intellij/database/types/DasType;", "prototype", "Lcom/intellij/sql/dialects/BuiltinFunction$Prototype;", "nameElement", "Lcom/intellij/sql/psi/SqlReferenceExpression;", "params", "Lcom/intellij/psi/PsiElement;", "routineElement", "getDefaultTypeName", "", "cat", "Lcom/intellij/database/types/DasTypeCategory;", "getDeprecatedTypes", "", "Lcom/intellij/database/types/DasTypeSystemBase$DeprecatedTypeInfo;", "contextFile", "Lcom/intellij/psi/PsiFile;", "getNormalizedTypeName", "name", "getTypeCategoryByName", "typeName", "supportsAsteriskArgument", "", "definition", "Lcom/intellij/sql/dialects/BuiltinFunction;", "intellij.database.dialects.mssql"})
public final class MsTypeSystem
extends DasTypeSystemImpl {
    public MsTypeSystem(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        super(dbms);
    }

    @Override
    @NotNull
    public String getNormalizedTypeName(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return switch (super.getNormalizedTypeName(name2)) {
            case "integer" -> "int";
            case "dec" -> "decimal";
            case "binary varying" -> "varbinary";
            case "double precision" -> "float";
            case "character" -> "char";
            case "char varying" -> "varchar";
            case "character varying" -> "varchar";
            case "national char" -> "nchar";
            case "national character" -> "nchar";
            case "national char varying" -> "nvarchar";
            case "national character varying" -> "nvarchar";
            case "national text" -> "ntext";
            case "rowversion" -> "timestamp";
            default -> {
                void var2_2;
                yield var2_2;
            }
        };
    }

    @Override
    @Nullable
    public String getDefaultTypeName(@NotNull DasTypeCategory cat) {
        Intrinsics.checkNotNullParameter((Object)((Object)cat), (String)"cat");
        return switch (WhenMappings.$EnumSwitchMapping$0[cat.ordinal()]) {
            case 1 -> "int";
            case 2 -> "numeric";
            case 3 -> "varchar";
            case 4 -> "int";
            case 5 -> "datetime";
            case 6 -> "date";
            case 7 -> "time";
            case 8 -> "timestamp";
            case 9 -> "datetimeoffset";
            case 10 -> "binary";
            default -> null;
        };
    }

    @Override
    @NotNull
    public DasTypeCategory getTypeCategoryByName(@NotNull String typeName) {
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        return switch (typeName) {
            case "money" -> DasTypeCategory.REAL;
            case "smallmoney" -> DasTypeCategory.REAL;
            case "datetimeoffset" -> DasTypeCategory.INTERVAL;
            case "sysname" -> DasTypeCategory.STRING;
            default -> super.getTypeCategoryByName(typeName);
        };
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public Map<String, DasTypeSystemBase.DeprecatedTypeInfo> getDeprecatedTypes(@NotNull PsiFile contextFile) {
        Map map2;
        Intrinsics.checkNotNullParameter((Object)contextFile, (String)"contextFile");
        Version version = SqlImplUtil.getMinDbmsVersion((PsiElement)contextFile);
        if (version != null) {
            int[] nArray = new int[]{13};
            if (version.compareTo(nArray) < 0) {
                map2 = MapsKt.emptyMap();
                return map2;
            }
        }
        map2 = MsTypeSystemKt.access$getDEPRECATED_TYPES$p();
        return map2;
    }

    @Override
    protected boolean supportsAsteriskArgument(@NotNull BuiltinFunction definition2) {
        Intrinsics.checkNotNullParameter((Object)definition2, (String)"definition");
        return StringsKt.equals((String)definition2.getName(), (String)"count_big", (boolean)true) || super.supportsAsteriskArgument(definition2);
    }

    @Override
    @Nullable
    public DasType getBuiltinFunctionReturnType(@NotNull BuiltinFunction.Prototype prototype, @Nullable SqlReferenceExpression nameElement, @Nullable PsiElement params2, @NotNull PsiElement routineElement) {
        Intrinsics.checkNotNullParameter((Object)prototype, (String)"prototype");
        Intrinsics.checkNotNullParameter((Object)routineElement, (String)"routineElement");
        if (!(params2 instanceof SqlExpressionList) || nameElement == null) {
            return null;
        }
        List list = ((SqlExpressionList)params2).getExpressionList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getExpressionList(...)");
        List expressions2 = list;
        if (StringUtil.equalsIgnoreCase((CharSequence)nameElement.getName(), (CharSequence)"CHANGETABLE")) {
            DasTableKey primaryKey;
            ArrayList<SqlImplUtil.Column> columns2 = new ArrayList<SqlImplUtil.Column>();
            String start2 = ((SqlExpressionList)params2).getFirstChild().getText();
            columns2.add(SqlDialectImplUtilCore.col(routineElement, null, "SYS_CHANGE_VERSION", this.getIntType()));
            if (StringUtil.equalsIgnoreCase((CharSequence)start2, (CharSequence)"CHANGES")) {
                columns2.add(SqlDialectImplUtilCore.col(routineElement, null, "SYS_CHANGE_CREATION_VERSION", this.getIntType()));
                columns2.add(SqlDialectImplUtilCore.col(routineElement, null, "SYS_CHANGE_OPERATION", this.getStringType()));
                columns2.add(SqlDialectImplUtilCore.col(routineElement, null, "SYS_CHANGE_COLUMNS", this.getBytesType()));
            }
            columns2.add(SqlDialectImplUtilCore.col(routineElement, null, "SYS_CHANGE_CONTEXT", this.getBytesType()));
            SqlExpression tableRef = (SqlExpression)CollectionsKt.firstOrNull((List)expressions2);
            PsiElement tablePsi = tableRef instanceof SqlReferenceExpression ? ((SqlReferenceExpression)tableRef).resolve() : null;
            DasTableKey dasTableKey = primaryKey = tablePsi instanceof DasTable ? DasUtil.getPrimaryKey((DasTable)tablePsi) : null;
            if (primaryKey != null) {
                Iterable<? extends DasTypedObject> pkColumns = primaryKey.getColumnsRef().resolveObjects();
                for (DasTypedObject dasTypedObject : pkColumns) {
                    columns2.add(SqlDialectImplUtilCore.col(routineElement, null, dasTypedObject.getName(), SqlImplUtil.rebuildDasType(dasTypedObject.getDasType(), this.getSqlDialect(), routineElement)));
                }
            }
            return (DasType)SqlImplUtil.createType((List<? extends SqlImplUtil.Column>)columns2, routineElement);
        }
        return null;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DasTypeCategory.values().length];
            try {
                nArray[DasTypeCategory.INTEGER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.REAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.STRING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.BOOLEAN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.DATE_TIME.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.DATE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.TIME.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.TIMESTAMP.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.INTERVAL.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.BYTES.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

