/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql.testing.tsqlt;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.console.session.DatabaseSessionManager;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.InterruptibleDatabaseConnection;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.DGDepartment;
import com.intellij.database.dataSource.connection.statements.ExecutionMode;
import com.intellij.database.dataSource.connection.statements.NoisyStatement;
import com.intellij.database.dataSource.connection.statements.OutParameter;
import com.intellij.database.dataSource.connection.statements.ResultsProducer;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.connection.statements.StandardExecutionMode;
import com.intellij.database.dataSource.connection.statements.StandardResultsProcessors;
import com.intellij.database.dialects.base.generator.ScriptGeneratorHelperKt;
import com.intellij.database.dialects.mssql.testing.tsqlt.TSqltHandler;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.run.AsyncTaskProcessHandler;
import com.intellij.database.util.AsyncTask;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.testframework.sm.ServiceMessageBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.MultiMap;
import java.lang.invoke.CallSite;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import jetbrains.buildServer.messages.serviceMessages.TestFinished;
import jetbrains.buildServer.messages.serviceMessages.TestIgnored;
import jetbrains.buildServer.messages.serviceMessages.TestStarted;
import jetbrains.buildServer.messages.serviceMessages.TestSuiteFinished;
import jetbrains.buildServer.messages.serviceMessages.TestSuiteStarted;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001f\n\u0002\b\u0004\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t\u00a2\u0006\u0002\u0010\nJ\u001c\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001a\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00072\b\u0010\u0013\u001a\u0004\u0018\u00010\u0007H\u0002J\u001c\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u000eH\u0002J,\u0010\u0017\u001a\u00020\u00152\u001a\u0010\u0018\u001a\u0016\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u00192\u0006\u0010\u0013\u001a\u00020\u0007H\u0002J,\u0010\u001b\u001a\u00020\u00152\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00070\u001d2\u0006\u0010\u0012\u001a\u00020\u00072\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u001eH\u0002J&\u0010\u001f\u001a\u00020\u00152\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00070\u001d2\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0007H\u0002J$\u0010 \u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u000eH\u0002J\u0006\u0010!\u001a\u00020\u0015R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/database/dialects/mssql/testing/tsqlt/TSqltHandler;", "Lcom/intellij/database/run/AsyncTaskProcessHandler;", "project", "Lcom/intellij/openapi/project/Project;", "ds", "Lcom/intellij/database/dataSource/LocalDataSource;", "db", "", "paths", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/dataSource/LocalDataSource;Ljava/lang/String;Ljava/util/List;)V", "expected", "Lkotlin/text/Regex;", "getTests", "Lcom/intellij/util/containers/MultiMap;", "c", "Lcom/intellij/database/dataSource/DatabaseConnection;", "locationHint", "suite", "test", "prepareTree", "", "tests", "processTestResult", "result", "Lkotlin/Triple;", "", "runSuite", "stmt", "Lcom/intellij/database/dataSource/connection/statements/NoisyStatement;", "", "runTest", "runTests", "start", "intellij.database.dialects.mssql.ex"})
@SourceDebugExtension(value={"SMAP\nTSqltHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TSqltHandler.kt\ncom/intellij/database/dialects/mssql/testing/tsqlt/TSqltHandler\n+ 2 StandardResultsProcessors.kt\ncom/intellij/database/dataSource/connection/statements/StandardResultsProcessors\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,148:1\n149#2:149\n1#3:150\n*S KotlinDebug\n*F\n+ 1 TSqltHandler.kt\ncom/intellij/database/dialects/mssql/testing/tsqlt/TSqltHandler\n*L\n87#1:149\n*E\n"})
public final class TSqltHandler
extends AsyncTaskProcessHandler {
    @NotNull
    private final Project project;
    @NotNull
    private final LocalDataSource ds;
    @Nullable
    private final String db;
    @NotNull
    private final List<String> paths;
    @NotNull
    private final Regex expected;

    public TSqltHandler(@NotNull Project project, @NotNull LocalDataSource ds, @Nullable String db2, @NotNull List<String> paths2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)ds, (String)"ds");
        Intrinsics.checkNotNullParameter(paths2, (String)"paths");
        this.project = project;
        this.ds = ds;
        this.db = db2;
        this.paths = paths2;
        this.expected = new Regex("Expected: <(.*)> but was: <(.*)>");
    }

    public final void start() {
        this.start((Function0)new Function0<AsyncTask<?>>(this){
            final /* synthetic */ TSqltHandler this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final AsyncTask<?> invoke() {
                String string = DatabaseBundle.message("progress.title.run.tsqlt.tests", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return AsyncTask.Companion.frame(string).computeAsync(null, () -> start.1.invoke$lambda$1(this.this$0));
            }

            /*
             * WARNING - void declaration
             */
            private static final AsyncTask invoke$lambda$1(TSqltHandler this$0) {
                ObjectPath objectPath;
                Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                Project project = TSqltHandler.access$getProject$p(this$0);
                DatabaseConnectionPoint databaseConnectionPoint = TSqltHandler.access$getDs$p(this$0);
                DatabaseCredentials databaseCredentials = null;
                String string = TSqltHandler.access$getDb$p(this$0);
                if (string != null) {
                    void it2;
                    String string2 = string;
                    DatabaseCredentials databaseCredentials2 = databaseCredentials;
                    DatabaseConnectionPoint databaseConnectionPoint2 = databaseConnectionPoint;
                    Project project2 = project;
                    boolean bl = false;
                    ObjectPath objectPath2 = ObjectPath.create((String)it2, ObjectKind.DATABASE);
                    project = project2;
                    databaseConnectionPoint = databaseConnectionPoint2;
                    databaseCredentials = databaseCredentials2;
                    objectPath = objectPath2;
                } else {
                    objectPath = null;
                }
                return DatabaseSessionManager.getFacade(project, databaseConnectionPoint, databaseCredentials, SearchPath.of(objectPath), false, null, DGDepartment.TEST_RUNNER).runAsync((Function1)new Function1<InterruptibleDatabaseConnection, Unit>(this$0){
                    final /* synthetic */ TSqltHandler this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull InterruptibleDatabaseConnection c2) {
                        Intrinsics.checkNotNullParameter((Object)c2, (String)"c");
                        MultiMap tests = TSqltHandler.access$getTests(this.this$0, c2);
                        TSqltHandler.access$prepareTree(this.this$0, tests);
                        TSqltHandler.access$runTests(this.this$0, c2, tests);
                    }
                });
            }
        });
        this.notifyTextAvailable(ServiceMessageBuilder.testsStarted().toString(), ProcessOutputTypes.STDOUT);
    }

    private final void prepareTree(MultiMap<String, String> tests) {
        for (Map.Entry entry : tests.entrySet()) {
            Intrinsics.checkNotNull((Object)entry);
            String suite = (String)entry.getKey();
            Collection suiteTests = (Collection)entry.getValue();
            ServiceMessageBuilder serviceMessageBuilder = new ServiceMessageBuilder("suiteTreeStarted").addAttribute("name", suite);
            Intrinsics.checkNotNull((Object)suite);
            this.notifyTextAvailable(serviceMessageBuilder.addAttribute("locationHint", this.locationHint(suite, null)).toString(), ProcessOutputTypes.STDOUT);
            for (String test : suiteTests) {
                this.notifyTextAvailable(new ServiceMessageBuilder("suiteTreeNode").addAttribute("name", test).addAttribute("locationHint", this.locationHint(suite, test)).toString(), ProcessOutputTypes.STDOUT);
            }
            this.notifyTextAvailable(new ServiceMessageBuilder("suiteTreeEnded").addAttribute("name", suite).toString(), ProcessOutputTypes.STDOUT);
        }
        this.notifyTextAvailable(new ServiceMessageBuilder("treeEnded").toString(), ProcessOutputTypes.STDOUT);
    }

    private final void runTests(DatabaseConnection c2, MultiMap<String, String> tests) {
        NoisyStatement<String> stmt2 = SmartStatements.Companion.poweredBy(c2).simple().noisy();
        for (Map.Entry entry : tests.entrySet()) {
            Intrinsics.checkNotNull((Object)entry);
            String suite = (String)entry.getKey();
            Collection suiteTests = (Collection)entry.getValue();
            Intrinsics.checkNotNull((Object)suite);
            Intrinsics.checkNotNull((Object)suiteTests);
            this.runSuite(stmt2, suite, suiteTests);
        }
    }

    private final void runSuite(NoisyStatement<String> stmt2, String suite, Collection<String> tests) {
        this.notifyTextAvailable(new TestSuiteStarted(suite).asString(), ProcessOutputTypes.STDOUT);
        for (String test : tests) {
            this.runTest(stmt2, suite, test);
        }
        this.notifyTextAvailable(new TestSuiteFinished(suite).asString(), ProcessOutputTypes.STDOUT);
    }

    private final void runTest(NoisyStatement<String> stmt2, String suite, String test) {
        this.notifyTextAvailable(new TestStarted(test, true, this.locationHint(suite, test)).asString(), ProcessOutputTypes.STDOUT);
        NoisyStatement.execute$default(stmt2, "exec tSQLt.RunWithNullResults " + ScriptGeneratorHelperKt.getSqlString(suite + "." + test), null, 2, null);
        boolean $i$f$first = false;
        Triple result2 = (Triple)stmt2.execute("select Result, Msg, DateDiff(ms, TestStartTime, TestEndTime) Duration from tSQLt.TestResult where Class = " + ScriptGeneratorHelperKt.getSqlString(suite) + " and TestCase = " + ScriptGeneratorHelperKt.getSqlString(test), (ExecutionMode)StandardExecutionMode.QUERY, new ResultsProducer.VoidReadyProcessor<Triple<? extends String, ? extends String, ? extends Integer>>(){

            public Triple<? extends String, ? extends String, ? extends Integer> empty() {
                Object it2 = null;
                boolean bl = false;
                return null;
            }

            public Triple<? extends String, ? extends String, ? extends Integer> results(@NotNull RemoteResultSet resultSet, int subQueryIndex, int resultSetIndex, @Nullable ResultsProducer.ReferenceInfo referenceInfo, @NotNull Function2<? super RemoteResultSet, ? super ResultsProducer.ReferenceInfo, Unit> referenceConsumer) {
                Triple triple;
                Intrinsics.checkNotNullParameter((Object)resultSet, (String)"resultSet");
                Intrinsics.checkNotNullParameter(referenceConsumer, (String)"referenceConsumer");
                RemoteResultSet it2 = resultSet.next() ? resultSet : null;
                boolean bl = false;
                RemoteResultSet remoteResultSet = it2;
                if (remoteResultSet != null) {
                    RemoteResultSet $this$runTest_u24lambda_u241_u24lambda_u240 = remoteResultSet;
                    boolean bl2 = false;
                    triple = new Triple((Object)$this$runTest_u24lambda_u241_u24lambda_u240.getString(1), (Object)$this$runTest_u24lambda_u241_u24lambda_u240.getString(2), (Object)$this$runTest_u24lambda_u241_u24lambda_u240.getInt(3));
                } else {
                    triple = null;
                }
                return triple;
            }

            public Triple<? extends String, ? extends String, ? extends Integer> parameterResults(@NotNull List<? extends OutParameter<?>> parameters2, int subQueryIndex, int resultSetIndex, @NotNull Function1<? super OutParameter<?>, ? extends Object> retriever) {
                Intrinsics.checkNotNullParameter(parameters2, (String)"parameters");
                Intrinsics.checkNotNullParameter(retriever, (String)"retriever");
                Object it2 = null;
                boolean bl = false;
                return null;
            }

            public Triple<? extends String, ? extends String, ? extends Integer> updateCount(int count) {
                Object it2 = null;
                boolean bl = false;
                return null;
            }
        });
        this.processTestResult((Triple<String, String, Integer>)result2, test);
    }

    private final String locationHint(String suite, String test) {
        String string = test;
        return string != null ? "db://" + suite + "." + string : "db://" + suite;
    }

    private final void processTestResult(Triple<String, String, Integer> result2, String test) {
        String resMessage;
        String string;
        String string2;
        Triple<String, String, Integer> triple = result2;
        String string3 = string2 = triple != null ? (String)triple.getFirst() : null;
        if (Intrinsics.areEqual((Object)string2, (Object)"Success")) {
            if (StringUtil.isNotEmpty((String)((String)result2.getSecond()))) {
                this.notifyTextAvailable((String)result2.getSecond(), ProcessOutputTypes.STDOUT);
            }
            string = null;
        } else if (Intrinsics.areEqual((Object)string2, (Object)"Failure")) {
            ServiceMessageBuilder serviceMessageBuilder;
            ServiceMessageBuilder $this$processTestResult_u24lambda_u243 = serviceMessageBuilder = ServiceMessageBuilder.testFailed((String)test);
            boolean bl = false;
            MatchResult m = this.expected.matchEntire((CharSequence)result2.getSecond());
            if (m == null) {
                $this$processTestResult_u24lambda_u243.addAttribute("message", (String)result2.getSecond());
            } else {
                List it2 = m.getGroupValues();
                boolean bl2 = false;
                $this$processTestResult_u24lambda_u243.addAttribute("actual", (String)it2.get(1));
                $this$processTestResult_u24lambda_u243.addAttribute("expected", (String)it2.get(2));
                $this$processTestResult_u24lambda_u243.addAttribute("type", "comparisonFailure");
            }
            string = serviceMessageBuilder.toString();
        } else {
            Object object;
            if (result2 != null) {
                this.notifyTextAvailable("Unknown status " + result2.getFirst(), ProcessOutputTypes.STDERR);
            }
            if ((object = result2) == null || (object = (String)object.getSecond()) == null) {
                object = "Not run by tSQLt";
            }
            string = new TestIgnored(test, object).asString();
        }
        String string4 = resMessage = string;
        if (string4 != null) {
            String it3 = string4;
            boolean bl = false;
            this.notifyTextAvailable(it3, ProcessOutputTypes.STDOUT);
        }
        Triple<String, String, Integer> triple2 = result2;
        this.notifyTextAvailable(new TestFinished(test, triple2 != null ? ((Number)triple2.getThird()).intValue() : 0).asString(), ProcessOutputTypes.STDOUT);
    }

    private final MultiMap<String, String> getTests(DatabaseConnection c2) {
        MultiMap multiMap = MultiMap.createSet();
        Intrinsics.checkNotNullExpressionValue((Object)multiMap, (String)"createSet(...)");
        MultiMap tests = multiMap;
        for (String path : this.paths) {
            int dot = StringsKt.indexOf$default((CharSequence)path, (char)'.', (int)0, (boolean)false, (int)6, null);
            if (dot != -1) {
                String string = path.substring(0, dot);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String string2 = path.substring(dot + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                tests.putValue((Object)string, (Object)string2);
                continue;
            }
            tests.putValues((Object)path, (Collection)SmartStatements.Companion.poweredBy(c2).simple().noisy().execute((CallSite)((Object)("select Name from tSQLt.Tests where TestClassName = " + ScriptGeneratorHelperKt.getSqlString(path))), StandardResultsProcessors.listOfStrings(1)));
        }
        if (this.paths.isEmpty()) {
            SmartStatements.Companion.poweredBy(c2).simple().noisy().execute("select TestClassName, Name from tSQLt.Tests", StandardResultsProcessors.firstResult((ThrowableConsumer<RemoteResultSet, Exception>)((ThrowableConsumer)arg_0 -> TSqltHandler.getTests$lambda$5(tests, arg_0))));
        }
        return tests;
    }

    private static final void getTests$lambda$5(MultiMap $tests, RemoteResultSet it2) {
        Intrinsics.checkNotNullParameter((Object)$tests, (String)"$tests");
        $tests.putValue((Object)it2.getString(1), (Object)it2.getString(2));
    }

    public static final /* synthetic */ Project access$getProject$p(TSqltHandler $this) {
        return $this.project;
    }

    public static final /* synthetic */ LocalDataSource access$getDs$p(TSqltHandler $this) {
        return $this.ds;
    }

    public static final /* synthetic */ String access$getDb$p(TSqltHandler $this) {
        return $this.db;
    }

    public static final /* synthetic */ MultiMap access$getTests(TSqltHandler $this, DatabaseConnection c2) {
        return $this.getTests(c2);
    }

    public static final /* synthetic */ void access$prepareTree(TSqltHandler $this, MultiMap tests) {
        $this.prepareTree((MultiMap<String, String>)tests);
    }

    public static final /* synthetic */ void access$runTests(TSqltHandler $this, DatabaseConnection c2, MultiMap tests) {
        $this.runTests(c2, (MultiMap<String, String>)tests);
    }
}

