/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql.localdb;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DbOptionProvider;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.StatelessJdbcUrlParser;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.ClearableLazyValue;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.WindowsRegistryUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.fields.ExtendableTextField;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LocalDbExecOption
extends DbOptionProvider.DriverOptionProvider<String> {
    private static final Logger LOG = Logger.getInstance(LocalDbExecOption.class);
    private static final String LOCAL_DB_EXECUTABLE = "LOCAL_DB_EXECUTABLE";
    public static final ClearableLazyValue<@NlsSafe String> DEFAULT_LOCALDB_EXEC = ClearableLazyValue.create(() -> {
        try {
            if (SystemInfo.isWindows) {
                String LOCAL_DB_ROOT = "HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Microsoft SQL Server";
                for (String ver : WindowsRegistryUtil.readRegistryBranch((String)"HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Microsoft SQL Server")) {
                    File file;
                    String path = WindowsRegistryUtil.readRegistryValue((String)("HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Microsoft SQL Server\\" + ver + "\\Tools\\ClientSetup"), (String)"Path");
                    if (path == null || !(file = new File(path, "SqlLocalDB.exe")).exists()) continue;
                    return file.getAbsolutePath();
                }
            }
        }
        catch (Throwable th) {
            LOG.warn(th);
        }
        return "";
    });

    @Override
    public boolean isApplicable(@NotNull DatabaseDriver driver2) {
        if (driver2 == null) {
            LocalDbExecOption.$$$reportNull$$$0(0);
        }
        return LocalDbExecOption.isLocalDbDriver(driver2);
    }

    public static boolean isLocalDbDriver(@Nullable DatabaseDriver driver2) {
        if (driver2 == null) {
            return false;
        }
        if (driver2.getId().contains("localdb")) {
            return true;
        }
        for (StatelessJdbcUrlParser parser2 : driver2.getJDBCUrlParsers()) {
            if (parser2.getParameterInfo("localdb_pipe") == null) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nls
    public String getDisplayName() {
        return DatabaseBundle.message("label.localdb.executable", new Object[0]);
    }

    @Override
    @Nls
    public String getDescription() {
        return DatabaseBundle.message("label.localdb.executable", new Object[0]);
    }

    @Override
    public String load(@Nullable DatabaseDriver driver2) {
        return driver2 == null ? null : driver2.getAdditionalProperty(LOCAL_DB_EXECUTABLE);
    }

    @Override
    public void store(@NotNull DatabaseDriver driver2, String value2) {
        if (driver2 == null) {
            LocalDbExecOption.$$$reportNull$$$0(1);
        }
        driver2.setAdditionalProperty(LOCAL_DB_EXECUTABLE, value2);
    }

    @Override
    public DbOptionProvider.EditorDesc<String> getEditor(DatabaseDriver driver2, @NotNull DataContext dataContext) {
        if (dataContext == null) {
            LocalDbExecOption.$$$reportNull$$$0(2);
        }
        ExtendableTextField f = new ExtendableTextField();
        TextFieldWithBrowseButton field = new TextFieldWithBrowseButton((JTextField)f);
        field.addBrowseFolderListener(null, null, null, FileChooserDescriptorFactory.createSingleFileDescriptor((String)"exe"));
        f.getEmptyText().setText(StringUtil.notNullize((String)((String)DEFAULT_LOCALDB_EXEC.getValue())));
        final DbOptionProvider.EditorDesc<String> desc = new DbOptionProvider.EditorDesc<String>((JComponent)field, v2 -> field.setText(StringUtil.notNullize((String)v2)), () -> StringUtil.nullize((String)field.getText()));
        f.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e2) {
                if (e2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                desc.fireChanged();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/dialects/mssql/localdb/LocalDbExecOption$1", "textChanged"));
            }
        });
        return desc;
    }

    @Override
    @NotNull
    public DbOptionProvider.UiLocation getLocation() {
        DbOptionProvider.UiLocation uiLocation = DbOptionProvider.UiLocation.CONNECTION;
        if (uiLocation == null) {
            LocalDbExecOption.$$$reportNull$$$0(3);
        }
        return uiLocation;
    }

    @Nullable
    public static String getLocalDbExecutable(@NotNull LocalDataSource dataSource2) {
        DatabaseDriver driver2;
        String exec;
        if (dataSource2 == null) {
            LocalDbExecOption.$$$reportNull$$$0(4);
        }
        String string = exec = (driver2 = dataSource2.getDatabaseDriver()) == null ? null : (String)DbOptionProvider.getOptionValue(driver2, LocalDbExecOption.class);
        if (StringUtil.isEmpty((String)exec)) {
            exec = (String)DEFAULT_LOCALDB_EXEC.getValue();
        }
        if (StringUtil.isEmpty((String)exec)) {
            exec = dataSource2.getAdditionalProperty(LOCAL_DB_EXECUTABLE);
        }
        return StringUtil.nullize((String)exec);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/mssql/localdb/LocalDbExecOption";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/mssql/localdb/LocalDbExecOption";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "store";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getEditor";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getLocalDbExecutable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

