/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.dataSource.DatabaseAuthProvider;
import com.intellij.database.dataSource.DatabaseConnectionConfig;
import com.intellij.database.dataSource.DatabaseConnectionInterceptor;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.DatabaseCredentialsAuthProvider;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.remote.jdbc.helpers.JdbcSettings;
import com.intellij.openapi.util.SystemInfo;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rH\u0096@\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0004J$\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\rH\u0016J,\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u001e\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0019\u001a\u00020\rH\u0016\u00a8\u0006 "}, d2={"Lcom/intellij/database/dialects/mssql/MsSsoAuthProvider;", "Lcom/intellij/database/dataSource/DatabaseAuthProvider;", "()V", "getApplicability", "Lcom/intellij/database/dataSource/DatabaseAuthProvider$ApplicabilityLevel$Result;", "point", "Lcom/intellij/database/dataSource/DatabaseConnectionPoint;", "level", "Lcom/intellij/database/dataSource/DatabaseAuthProvider$ApplicabilityLevel;", "getDisplayName", "", "getId", "interceptConnection", "", "proto", "Lcom/intellij/database/dataSource/DatabaseConnectionInterceptor$ProtoConnection;", "silent", "(Lcom/intellij/database/dataSource/DatabaseConnectionInterceptor$ProtoConnection;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isMsSso", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "loadAuthConfig", "", "credentials", "Lcom/intellij/database/access/DatabaseCredentials;", "external", "saveAuthConfig", "", "config", "Lcom/intellij/database/dataSource/DatabaseConnectionConfig;", "data", "Companion", "intellij.database.dialects.mssql"})
public final class MsSsoAuthProvider
implements DatabaseAuthProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String ID = "ms-sso";

    @Override
    @Nullable
    public Object interceptConnection(@NotNull DatabaseConnectionInterceptor.ProtoConnection proto2, boolean silent, @NotNull Continuation<? super Boolean> $completion) {
        LocalDataSource localDataSource = proto2.getConnectionPoint().getDataSource();
        Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"getDataSource(...)");
        if (!this.isMsSso(localDataSource)) {
            return Boxing.boxBoolean((boolean)false);
        }
        JdbcSettings.INTEGRATED_SECURITY.put(proto2.getExtraProperties(), (Object)Boxing.boxBoolean((boolean)true));
        DatabaseCredentialsAuthProvider.Companion.applyCredentials(proto2, null, false);
        return Boxing.boxBoolean((boolean)true);
    }

    @Override
    @Nullable
    public Object loadAuthConfig(@NotNull DatabaseConnectionPoint point, @Nullable DatabaseCredentials credentials, boolean external) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        return DatabaseAuthProvider.super.loadAuthConfig(point, credentials, external);
    }

    @Override
    public void saveAuthConfig(@NotNull DatabaseConnectionConfig config, @Nullable DatabaseCredentials credentials, @Nullable Object data, boolean external) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        DatabaseAuthProvider.super.saveAuthConfig(config, credentials, data, external);
    }

    @Override
    @NotNull
    public String getId() {
        return ID;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = DatabaseBundle.message("database.auth.type.windows", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Override
    @NotNull
    public DatabaseAuthProvider.ApplicabilityLevel.Result getApplicability(@NotNull DatabaseConnectionPoint point, @NotNull DatabaseAuthProvider.ApplicabilityLevel level) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        return !SystemInfo.isWindows || !point.getDbms().in(Dbms.MSSQL_LIKE) ? DatabaseAuthProvider.ApplicabilityLevel.Result.NOT_APPLICABLE : DatabaseAuthProvider.ApplicabilityLevel.Result.DEFAULT.clamp(level);
    }

    protected final boolean isMsSso(@NotNull LocalDataSource dataSource2) {
        Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
        return dataSource2.getDbms().isMicrosoft() && Intrinsics.areEqual((Object)ID, (Object)dataSource2.getAuthProviderId());
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/database/dialects/mssql/MsSsoAuthProvider$Companion;", "", "()V", "ID", "", "intellij.database.dialects.mssql"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

