/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql;

import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.connection.throwable.KnownDatabaseException;
import com.intellij.database.connection.throwable.info.ErrorInfo;
import com.intellij.database.connection.throwable.info.SimpleErrorInfo;
import com.intellij.database.dataSource.DatabaseAuthProvider;
import com.intellij.database.dataSource.DatabaseConnectionConfig;
import com.intellij.database.dataSource.DatabaseConnectionInterceptor;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.DatabaseCredentialsAuthProvider;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactList;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactManager;
import com.intellij.database.dialects.DatabaseFixFactory;
import com.intellij.database.dialects.mssql.MsUtils;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.Version;
import com.intellij.openapi.diagnostic.Logger;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b&\u0018\u0000 $2\u00020\u0001:\u0002$%B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J.\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0096@\u00a2\u0006\u0002\u0010\u0016J$\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u000eH\u0016J,\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010 \u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001b\u001a\u00020\u000eH\u0016J\u001a\u0010!\u001a\u00020\u001d2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\"\u001a\u0004\u0018\u00010#H\u0016\u00a8\u0006&"}, d2={"Lcom/intellij/database/dialects/mssql/MsAzureAuthProviderBase;", "Lcom/intellij/database/dataSource/DatabaseAuthProvider;", "()V", "getApplicability", "Lcom/intellij/database/dataSource/DatabaseAuthProvider$ApplicabilityLevel$Result;", "point", "Lcom/intellij/database/dataSource/DatabaseConnectionPoint;", "level", "Lcom/intellij/database/dataSource/DatabaseAuthProvider$ApplicabilityLevel;", "getRequiredArtifact", "Lcom/intellij/database/dialects/mssql/MsAzureAuthProviderBase$RequiredArtifact;", "target", "Lcom/intellij/database/dataSource/LocalDataSource;", "handleConnectionFailure", "", "proto", "Lcom/intellij/database/dataSource/DatabaseConnectionInterceptor$ProtoConnection;", "e", "", "silent", "attempt", "", "(Lcom/intellij/database/dataSource/DatabaseConnectionInterceptor$ProtoConnection;Ljava/lang/Throwable;ZILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "loadAuthConfig", "", "credentials", "Lcom/intellij/database/access/DatabaseCredentials;", "external", "saveAuthConfig", "", "config", "Lcom/intellij/database/dataSource/DatabaseConnectionConfig;", "data", "setNewPassword", "newPass", "", "Companion", "RequiredArtifact", "intellij.database.dialects.mssql"})
public abstract class MsAzureAuthProviderBase
implements DatabaseAuthProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final RequiredArtifact ADAL4J;
    @NotNull
    private static final RequiredArtifact MSAL4J;

    @Override
    @NotNull
    public DatabaseAuthProvider.ApplicabilityLevel.Result getApplicability(@NotNull DatabaseConnectionPoint point, @NotNull DatabaseAuthProvider.ApplicabilityLevel level) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        return !MsUtils.isMs(point.getDatabaseDriver()) ? DatabaseAuthProvider.ApplicabilityLevel.Result.NOT_APPLICABLE : DatabaseAuthProvider.ApplicabilityLevel.Result.DEFAULT.clamp(level);
    }

    @Override
    @Nullable
    public Object loadAuthConfig(@NotNull DatabaseConnectionPoint point, @Nullable DatabaseCredentials credentials, boolean external) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        return DatabaseCredentialsAuthProvider.Companion.loadCredentialsConfig(point, credentials, external);
    }

    @Override
    public void saveAuthConfig(@NotNull DatabaseConnectionConfig config, @Nullable DatabaseCredentials credentials, @Nullable Object data, boolean external) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        DatabaseCredentialsAuthProvider.Companion.saveCredentialsConfig(config, credentials, data instanceof DatabaseCredentialsAuthProvider.UserPassCredentials ? (DatabaseCredentialsAuthProvider.UserPassCredentials)data : null, external);
    }

    @Override
    public void setNewPassword(@NotNull DatabaseConnectionInterceptor.ProtoConnection proto2, @Nullable String newPass) {
        Intrinsics.checkNotNullParameter((Object)proto2, (String)"proto");
        DatabaseCredentialsAuthProvider.Companion.applyNewPassword(proto2, newPass);
    }

    @Override
    @Nullable
    public Object handleConnectionFailure(@NotNull DatabaseConnectionInterceptor.ProtoConnection proto2, @NotNull Throwable e2, boolean silent, int attempt, @NotNull Continuation<? super Boolean> $completion) {
        return MsAzureAuthProviderBase.handleConnectionFailure$suspendImpl(this, proto2, e2, silent, attempt, $completion);
    }

    static /* synthetic */ Object handleConnectionFailure$suspendImpl(MsAzureAuthProviderBase $this, DatabaseConnectionInterceptor.ProtoConnection proto2, Throwable e2, boolean silent, int attempt, Continuation<? super Boolean> $completion) {
        String message2 = e2.getMessage();
        DatabaseDriver driver2 = proto2.getConnectionPoint().getDatabaseDriver();
        if (driver2 != null && message2 != null) {
            RequiredArtifact ra;
            RequiredArtifact requiredArtifact = StringsKt.contains$default((CharSequence)message2, (CharSequence)"Failed to load ADAL4J", (boolean)false, (int)2, null) ? ADAL4J : (ra = StringsKt.contains$default((CharSequence)message2, (CharSequence)"Failed to load MSAL4J", (boolean)false, (int)2, null) ? MSAL4J : null);
            if (ra != null) {
                ErrorInfo info2 = SimpleErrorInfo.create((String)message2, (Throwable)e2, (List)CollectionsKt.listOf((Object)ra.createSetUpFix(driver2, true)));
                throw new KnownDatabaseException(info2);
            }
        }
        return DatabaseAuthProvider.super.handleConnectionFailure(proto2, e2, silent, attempt, $completion);
    }

    @NotNull
    public RequiredArtifact getRequiredArtifact(@NotNull LocalDataSource target2) {
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        return MSAL4J;
    }

    @JvmStatic
    @Nullable
    public static final String setAuthentication(@NotNull DatabaseConnectionInterceptor.ProtoConnection p2, @Nullable String authentication) {
        return Companion.setAuthentication(p2, authentication);
    }

    @JvmStatic
    @NotNull
    public static final RequiredArtifact guessRequired(@NotNull LocalDataSource target2) {
        return Companion.guessRequired(target2);
    }

    static {
        Logger logger2 = Logger.getInstance(MsAzureAuthProviderBase.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        LOG = logger2;
        ADAL4J = new RequiredArtifact(){

            public boolean checkFile(@NotNull String u) {
                Intrinsics.checkNotNullParameter((Object)u, (String)"u");
                return StringsKt.contains$default((CharSequence)u, (CharSequence)"adal4j", (boolean)false, (int)2, null);
            }
        };
        MSAL4J = new RequiredArtifact(){

            public boolean checkFile(@NotNull String u) {
                Intrinsics.checkNotNullParameter((Object)u, (String)"u");
                return StringsKt.contains$default((CharSequence)u, (CharSequence)"msal4j", (boolean)false, (int)2, null);
            }
        };
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u001c\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\rH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/database/dialects/mssql/MsAzureAuthProviderBase$Companion;", "", "()V", "ADAL4J", "Lcom/intellij/database/dialects/mssql/MsAzureAuthProviderBase$RequiredArtifact;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "MSAL4J", "guessRequired", "target", "Lcom/intellij/database/dataSource/LocalDataSource;", "setAuthentication", "", "p", "Lcom/intellij/database/dataSource/DatabaseConnectionInterceptor$ProtoConnection;", "authentication", "intellij.database.dialects.mssql"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final String setAuthentication(@NotNull DatabaseConnectionInterceptor.ProtoConnection p2, @Nullable String authentication) {
            Intrinsics.checkNotNullParameter((Object)p2, (String)"p");
            return DbImplUtilCore.putOrRemove(p2.getConnectionProperties(), "authentication", authentication);
        }

        @JvmStatic
        @NotNull
        public final RequiredArtifact guessRequired(@NotNull LocalDataSource target2) {
            int[] nArray;
            Version version;
            DatabaseDriver.ArtifactRef artifact;
            DatabaseDriver driver2;
            Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
            DatabaseDriver databaseDriver = driver2 = target2.getDatabaseDriver();
            DatabaseDriver.ArtifactRef artifactRef = artifact = databaseDriver == null ? null : RequiredArtifact.Companion.findArtifact(databaseDriver, "SQL Server");
            Version version2 = version = artifactRef == null ? Version.parse(target2.getDriverVersion().version) : artifactRef.getArtifactVersion();
            return version == null || version.isOrGreater(nArray = new int[]{9}) ? MSAL4J : ADAL4J;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H&J\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\bJ\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lcom/intellij/database/dialects/mssql/MsAzureAuthProviderBase$RequiredArtifact;", "", "artifactId", "", "(Ljava/lang/String;)V", "getArtifactId", "()Ljava/lang/String;", "checkFile", "", "u", "createSetUpFix", "Lcom/intellij/database/connection/throwable/info/ErrorInfo$Fix;", "driver", "Lcom/intellij/database/dataSource/DatabaseDriver;", "navigate", "findArtifact", "Lcom/intellij/database/dataSource/artifacts/DatabaseArtifactList$ArtifactVersion;", "Companion", "intellij.database.dialects.mssql"})
    public static abstract class RequiredArtifact {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String artifactId;

        public RequiredArtifact(@NotNull String artifactId) {
            Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
            this.artifactId = artifactId;
        }

        @NotNull
        public final String getArtifactId() {
            return this.artifactId;
        }

        private final DatabaseArtifactList.ArtifactVersion findArtifact() {
            return DatabaseArtifactManager.getArtifacts().resolveVersion(this.artifactId, null, "stable", null);
        }

        public abstract boolean checkFile(@NotNull String var1);

        @Nullable
        public final ErrorInfo.Fix createSetUpFix(@Nullable DatabaseDriver driver2, boolean navigate) {
            DatabaseFixFactory fixFactory;
            DatabaseFixFactory databaseFixFactory = fixFactory = DatabaseFixFactory.getInstance();
            return databaseFixFactory != null ? databaseFixFactory.setUpArtifact(driver2, navigate, () -> RequiredArtifact.createSetUpFix$lambda$0(this)) : null;
        }

        private static final DatabaseArtifactList.ArtifactVersion createSetUpFix$lambda$0(RequiredArtifact this$0) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            DatabaseArtifactList.ArtifactVersion adal = this$0.findArtifact();
            if (adal == null) {
                LOG.error(this$0.artifactId + " artifact not found");
                return null;
            }
            return adal;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lcom/intellij/database/dialects/mssql/MsAzureAuthProviderBase$RequiredArtifact$Companion;", "", "()V", "findArtifact", "Lcom/intellij/database/dataSource/DatabaseDriver$ArtifactRef;", "driver", "Lcom/intellij/database/dataSource/DatabaseDriver;", "artifactId", "", "intellij.database.dialects.mssql"})
        @SourceDebugExtension(value={"SMAP\nMsAzureAuthProviderBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MsAzureAuthProviderBase.kt\ncom/intellij/database/dialects/mssql/MsAzureAuthProviderBase$RequiredArtifact$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,115:1\n1#2:116\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final DatabaseDriver.ArtifactRef findArtifact(@NotNull DatabaseDriver driver2, @NotNull String artifactId) {
                Object v1;
                block1: {
                    Intrinsics.checkNotNullParameter((Object)driver2, (String)"driver");
                    Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
                    List<DatabaseDriver.ArtifactRef> list = driver2.getArtifacts();
                    Intrinsics.checkNotNullExpressionValue(list, (String)"getArtifacts(...)");
                    Iterable iterable = list;
                    for (Object t : iterable) {
                        DatabaseDriver.ArtifactRef it2 = (DatabaseDriver.ArtifactRef)t;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it2.getId(), (Object)artifactId)) continue;
                        v1 = t;
                        break block1;
                    }
                    v1 = null;
                }
                return v1;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

