/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mongo.translator.tree_creator.builder;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dialects.mongo.translator.MongoToDatabaseScriptTranslator;
import com.intellij.database.dialects.mongo.translator.tree.expression.literal.primitive.IMongoLiteral;
import com.intellij.database.dialects.mongo.translator.tree.expression.literal.primitive.MongoBooleanLiteral;
import com.intellij.database.dialects.mongo.translator.tree.expression.literal.primitive.MongoInfinityLiteral;
import com.intellij.database.dialects.mongo.translator.tree.expression.literal.primitive.MongoIntegerLiteral;
import com.intellij.database.dialects.mongo.translator.tree.expression.literal.primitive.MongoNanLiteral;
import com.intellij.database.dialects.mongo.translator.tree.expression.literal.primitive.MongoNullLiteral;
import com.intellij.database.dialects.mongo.translator.tree.expression.literal.primitive.MongoRealLiteral;
import com.intellij.database.dialects.mongo.translator.tree.expression.literal.primitive.MongoStringLiteral;
import com.intellij.database.dialects.mongo.translator.tree_creator.builder.IMongoLiteralBuilder;
import com.intellij.database.types.DasTypeCategory;
import com.intellij.psi.PsiElement;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlLiteralExpression;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\bH\u0016J\u0010\u0010\r\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u000eH\u0016R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/database/dialects/mongo/translator/tree_creator/builder/MongoLiteralBuilder;", "Lcom/intellij/database/dialects/mongo/translator/tree_creator/builder/IMongoLiteralBuilder;", "o", "Lcom/intellij/sql/psi/SqlLiteralExpression;", "root", "Lcom/intellij/sql/psi/SqlElement;", "(Lcom/intellij/sql/psi/SqlLiteralExpression;Lcom/intellij/sql/psi/SqlElement;)V", "category", "Lcom/intellij/database/types/DasTypeCategory;", "getO", "()Lcom/intellij/sql/psi/SqlLiteralExpression;", "getRoot", "()Lcom/intellij/sql/psi/SqlElement;", "text", "", "build", "Lcom/intellij/database/dialects/mongo/translator/tree/expression/literal/primitive/IMongoLiteral;", "v", "intellij.database.dialects.mongo"})
@SourceDebugExtension(value={"SMAP\nMongoLiteralBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MongoLiteralBuilder.kt\ncom/intellij/database/dialects/mongo/translator/tree_creator/builder/MongoLiteralBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,49:1\n1#2:50\n*E\n"})
public final class MongoLiteralBuilder
implements IMongoLiteralBuilder {
    @NotNull
    private final SqlLiteralExpression o;
    @NotNull
    private final SqlElement root;
    @Nullable
    private String text;
    @Nullable
    private DasTypeCategory category;

    public MongoLiteralBuilder(@NotNull SqlLiteralExpression o2, @NotNull SqlElement root2) {
        Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
        Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
        this.o = o2;
        this.root = root2;
    }

    @NotNull
    public final SqlLiteralExpression getO() {
        return this.o;
    }

    @NotNull
    public final SqlElement getRoot() {
        return this.root;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public IMongoLiteral build() {
        IMongoLiteral iMongoLiteral;
        String string = this.text;
        if (string == null) {
            throw MongoToDatabaseScriptTranslator.Companion.createTranslationPSIStructureException((PsiElement)this.o, (PsiElement)this.root);
        }
        String text2 = string;
        String string2 = text2.toUpperCase();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
        String upperText = string2;
        if (this.category == DasTypeCategory.INTEGER && StringsKt.toLongOrNull((String)text2) != null) {
            long l = Long.parseLong(text2);
            String string3 = this.o.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
            iMongoLiteral = new MongoIntegerLiteral(l, string3);
            return iMongoLiteral;
        }
        if (this.category == DasTypeCategory.BOOLEAN) {
            if (!Intrinsics.areEqual((Object)upperText, (Object)"TRUE") && !Intrinsics.areEqual((Object)upperText, (Object)"FALSE")) {
                throw MongoToDatabaseScriptTranslator.Companion.createTranslationPSIStructureException((PsiElement)this.o, (PsiElement)this.root);
            }
            boolean bl = Intrinsics.areEqual((Object)upperText, (Object)"TRUE");
            String string4 = this.o.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getText(...)");
            return new MongoBooleanLiteral(bl, string4);
        }
        if (this.category == DasTypeCategory.STRING) {
            iMongoLiteral = new MongoStringLiteral(text2);
            return iMongoLiteral;
        }
        if (this.category != DasTypeCategory.UNKNOWN) {
            Object[] objectArray = new Object[]{text2};
            String string5 = DatabaseBundle.message("MongoTranslator.errors.incorrect.literal.0", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
            throw MongoToDatabaseScriptTranslator.Companion.createTranslationException(string5, (PsiElement)this.o, (PsiElement)this.root);
        }
        if (Intrinsics.areEqual((Object)upperText, (Object)"NULL")) {
            String string6 = this.o.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getText(...)");
            iMongoLiteral = new MongoNullLiteral(string6);
            return iMongoLiteral;
        }
        if (Intrinsics.areEqual((Object)upperText, (Object)"INFINITY")) {
            String string7 = this.o.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"getText(...)");
            iMongoLiteral = new MongoInfinityLiteral(string7);
            return iMongoLiteral;
        }
        if (Intrinsics.areEqual((Object)upperText, (Object)"NAN")) {
            String string8 = this.o.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"getText(...)");
            iMongoLiteral = new MongoNanLiteral(string8);
            return iMongoLiteral;
        }
        if (StringsKt.toDoubleOrNull((String)text2) != null) {
            double d2 = Double.parseDouble(text2);
            String string9 = this.o.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"getText(...)");
            iMongoLiteral = new MongoRealLiteral(d2, string9);
            return iMongoLiteral;
        }
        Object[] objectArray = new Object[]{text2};
        String string10 = DatabaseBundle.message("MongoTranslator.errors.incorrect.literal.0", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"message(...)");
        throw MongoToDatabaseScriptTranslator.Companion.createTranslationException(string10, (PsiElement)this.o, (PsiElement)this.root);
    }

    @Override
    @NotNull
    public MongoLiteralBuilder text(@NotNull String v2) {
        MongoLiteralBuilder mongoLiteralBuilder;
        Intrinsics.checkNotNullParameter((Object)v2, (String)"v");
        MongoLiteralBuilder $this$text_u24lambda_u240 = mongoLiteralBuilder = this;
        boolean bl = false;
        $this$text_u24lambda_u240.text = v2;
        return mongoLiteralBuilder;
    }

    @Override
    @NotNull
    public MongoLiteralBuilder category(@NotNull DasTypeCategory v2) {
        MongoLiteralBuilder mongoLiteralBuilder;
        Intrinsics.checkNotNullParameter((Object)((Object)v2), (String)"v");
        MongoLiteralBuilder $this$category_u24lambda_u241 = mongoLiteralBuilder = this;
        boolean bl = false;
        $this$category_u24lambda_u241.category = v2;
        return mongoLiteralBuilder;
    }
}

