/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mongo.translator;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dialects.mongo.translator.tree.MongoRoot;
import com.intellij.database.dialects.mongo.translator.tree_aggregator.MongoTreeAggregator;
import com.intellij.database.dialects.mongo.translator.tree_aggregator.MongoTreeAggregatorJS;
import com.intellij.database.dialects.mongo.translator.tree_creator.MongoTreeCreator;
import com.intellij.database.dialects.mongo.translator.tree_creator.MongoTreeCreatorSql;
import com.intellij.database.script.translator.ToDatabaseScriptTranslator;
import com.intellij.database.script.translator.TranslateException;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.sql.psi.SqlElement;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/database/dialects/mongo/translator/MongoToDatabaseScriptTranslator;", "Lcom/intellij/database/script/translator/ToDatabaseScriptTranslator;", "()V", "treeAggregator", "Lcom/intellij/database/dialects/mongo/translator/tree_aggregator/MongoTreeAggregator;", "treeCreator", "Lcom/intellij/database/dialects/mongo/translator/tree_creator/MongoTreeCreator;", "translate", "", "rootPsiElement", "Lcom/intellij/psi/PsiElement;", "Companion", "intellij.database.dialects.mongo"})
public final class MongoToDatabaseScriptTranslator
implements ToDatabaseScriptTranslator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MongoTreeCreator treeCreator = new MongoTreeCreatorSql();
    @NotNull
    private final MongoTreeAggregator treeAggregator = new MongoTreeAggregatorJS();

    @Override
    @NotNull
    public String translate(@NotNull PsiElement rootPsiElement) {
        String string;
        Intrinsics.checkNotNullParameter((Object)rootPsiElement, (String)"rootPsiElement");
        if (rootPsiElement instanceof SqlElement) {
            MongoRoot root2 = this.treeCreator.createTree((SqlElement)rootPsiElement);
            string = this.treeAggregator.aggregateTree(root2);
        } else {
            String string2 = rootPsiElement.getText();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        }
        return string;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00060\u0004j\u0002`\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\tJ\u001a\u0010\u000b\u001a\u00060\u0004j\u0002`\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tJ\u001a\u0010\f\u001a\u00060\u0004j\u0002`\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t\u00a8\u0006\r"}, d2={"Lcom/intellij/database/dialects/mongo/translator/MongoToDatabaseScriptTranslator$Companion;", "", "()V", "createTranslationException", "Ljava/lang/Exception;", "Lkotlin/Exception;", "reason", "", "o", "Lcom/intellij/psi/PsiElement;", "root", "createTranslationPSIStructureException", "createTranslationPSISyntaxException", "intellij.database.dialects.mongo"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Exception createTranslationPSISyntaxException(@NotNull PsiElement o2, @NotNull PsiElement root2) {
            Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
            Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
            String string = DatabaseBundle.message("MongoTranslator.errors.syntax.error", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return this.createTranslationException(string, o2, root2);
        }

        @NotNull
        public final Exception createTranslationPSIStructureException(@NotNull PsiElement o2, @NotNull PsiElement root2) {
            Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
            Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
            String string = DatabaseBundle.message("MongoTranslator.errors.structure.error", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return this.createTranslationException(string, o2, root2);
        }

        @NotNull
        public final Exception createTranslationException(@NotNull String reason, @Nullable PsiElement o2, @NotNull PsiElement root2) {
            int position;
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
            if (o2 != null && PsiTreeUtilKt.isAncestor$default((PsiElement)root2, (PsiElement)o2, (boolean)false, (int)2, null) && (position = o2.getTextRange().getStartOffset() - root2.getTextRange().getStartOffset() + 1) > 0) {
                Object[] objectArray = new Object[]{reason, o2.getText(), position};
                return new TranslateException(DatabaseBundle.message("MongoTranslator.errors.query.cannot.be.translated", objectArray));
            }
            Object[] objectArray = new Object[]{reason};
            return new TranslateException(DatabaseBundle.message("MongoTranslator.errors.query.cannot.be.translated.short", objectArray));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

