/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mongo;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.DatabaseAuthProvider;
import com.intellij.database.dataSource.DatabaseConnectionInterceptor;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dialects.mongo.MongoDatabaseCredentialsAuthProviderKt;
import com.intellij.database.util.DbImplUtilCore;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rH\u0096@\u00a2\u0006\u0002\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/intellij/database/dialects/mongo/MongoX509AuthProvider;", "Lcom/intellij/database/dataSource/DatabaseAuthProvider;", "()V", "getApplicability", "Lcom/intellij/database/dataSource/DatabaseAuthProvider$ApplicabilityLevel$Result;", "point", "Lcom/intellij/database/dataSource/DatabaseConnectionPoint;", "level", "Lcom/intellij/database/dataSource/DatabaseAuthProvider$ApplicabilityLevel;", "getDisplayName", "", "getId", "interceptConnection", "", "proto", "Lcom/intellij/database/dataSource/DatabaseConnectionInterceptor$ProtoConnection;", "silent", "(Lcom/intellij/database/dataSource/DatabaseConnectionInterceptor$ProtoConnection;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.database.dialects.mongo"})
public final class MongoX509AuthProvider
implements DatabaseAuthProvider {
    @Override
    @NotNull
    public String getId() {
        return "MongoDB.MONGODB-X509";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = DatabaseBundle.message("MongoDB.auth.x.509", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Override
    @NotNull
    public DatabaseAuthProvider.ApplicabilityLevel.Result getApplicability(@NotNull DatabaseConnectionPoint point, @NotNull DatabaseAuthProvider.ApplicabilityLevel level) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        return MongoDatabaseCredentialsAuthProviderKt.getMongoApplicability(point, level, "MONGODB-X509");
    }

    @Override
    @Nullable
    public Object interceptConnection(@NotNull DatabaseConnectionInterceptor.ProtoConnection proto2, boolean silent, @NotNull Continuation<? super Boolean> $completion) {
        DbImplUtilCore.putOrRemove(proto2.getConnectionProperties(), "authMechanism", "MONGODB-X509");
        return Boxing.boxBoolean((boolean)true);
    }
}

