/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mongo;

import com.intellij.database.Dbms;
import com.intellij.database.data.types.BaseDomainRegistry;
import com.intellij.database.data.types.ColumnRef;
import com.intellij.database.data.types.ComparePredicateOperation;
import com.intellij.database.data.types.CustomPlaceholder;
import com.intellij.database.data.types.EqualsPredicateOperation;
import com.intellij.database.data.types.FormatTestResult;
import com.intellij.database.data.types.FormatTester;
import com.intellij.database.data.types.GreaterPredicateOperation;
import com.intellij.database.data.types.JdbcPlaceholder;
import com.intellij.database.data.types.LessPredicateOperation;
import com.intellij.database.data.types.LikePredicateOperation;
import com.intellij.database.data.types.LogicalType;
import com.intellij.database.data.types.MultiPredicateValue;
import com.intellij.database.data.types.NotEqualsPredicateOperation;
import com.intellij.database.data.types.NullPredicateValue;
import com.intellij.database.data.types.ObjectPredicateValue;
import com.intellij.database.data.types.Placeholder;
import com.intellij.database.data.types.PredicateOperation;
import com.intellij.database.data.types.PredicateValue;
import com.intellij.database.data.types.PredicatesHelper;
import com.intellij.database.data.types.PredicatesUtilKt;
import com.intellij.database.data.types.StringPredicateValue;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.LikeOpType;
import com.intellij.database.data.types.domain.OperationKt;
import com.intellij.database.dialects.base.BasePredicatesHelper;
import com.intellij.database.dialects.mongo.MongoPredicatesHelper;
import com.intellij.database.dialects.mongo.MongoScriptUtilKt;
import com.intellij.database.extractors.DatabaseObjectFormatterConfig;
import com.intellij.database.extractors.DbObjectFormatter;
import com.intellij.database.extractors.ObjectFormatterMode;
import com.intellij.database.remote.jdbc.helpers.MongoJdbcHelper;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J<\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0014J$\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0014J&\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u001e\u001a\u00020\u00112\b\u0010!\u001a\u0004\u0018\u00010\u001d2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0014JP\u0010\"\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010!\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0014\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00172\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010%\u001a\u00020\u0017H\u0014J\"\u0010&\u001a\u00020\u001b2\u0006\u0010\u0012\u001a\u00020'2\u0006\u0010\u001e\u001a\u00020\u00112\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002J2\u0010(\u001a\u00020 2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001b0*2\u0006\u0010+\u001a\u00020\u00172\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020.0-H\u0002J-\u0010/\u001a\u000200*\u0002012\u0006\u0010\u0014\u001a\u0002022\u0017\u00103\u001a\u0013\u0012\u0004\u0012\u000201\u0012\u0004\u0012\u0002000-\u00a2\u0006\u0002\b4H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/intellij/database/dialects/mongo/MongoPredicatesHelper;", "Lcom/intellij/database/dialects/base/BasePredicatesHelper;", "dbms", "Lcom/intellij/database/Dbms;", "(Lcom/intellij/database/Dbms;)V", "idPattern", "Lkotlin/text/Regex;", "mode", "Lcom/intellij/database/extractors/ObjectFormatterMode;", "getMode", "()Lcom/intellij/database/extractors/ObjectFormatterMode;", "objectFormatter", "Lcom/intellij/database/extractors/DbObjectFormatter;", "uuidPattern", "equalsPredicate", "Lcom/intellij/database/data/types/PredicatesHelper$PredicateProducer;", "column", "Lcom/intellij/database/data/types/ColumnRef;", "value", "Lcom/intellij/database/data/types/PredicateValue;", "op", "Lcom/intellij/database/data/types/ComparePredicateOperation;", "quote", "", "version", "Lcom/intellij/database/util/Version;", "alias", "", "getDomain", "Lcom/intellij/database/data/types/domain/Domain;", "columnRef", "getFormatTester", "Lcom/intellij/database/data/types/FormatTester;", "domain", "likePredicate", "Lcom/intellij/database/data/types/LikePredicateOperation;", "canCastToText", "inUpdate", "literal", "Lcom/intellij/database/data/types/StringPredicateValue;", "typeWithConstructor", "classNames", "", "isQuotedValue", "testUnwrapped", "Lkotlin/Function1;", "Lcom/intellij/database/data/types/FormatTestResult;", "operation", "", "Lcom/intellij/database/util/DdlBuilder;", "Lcom/intellij/database/data/types/PredicateOperation;", "rightOperand", "Lkotlin/ExtensionFunctionType;", "intellij.database.dialects.mongo"})
@SourceDebugExtension(value={"SMAP\nMongoPredicatesHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MongoPredicatesHelper.kt\ncom/intellij/database/dialects/mongo/MongoPredicatesHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,179:1\n1#2:180\n*E\n"})
public final class MongoPredicatesHelper
extends BasePredicatesHelper {
    @NotNull
    private final DbObjectFormatter objectFormatter;
    @NotNull
    private final Regex idPattern;
    @NotNull
    private final Regex uuidPattern;
    @NotNull
    private final ObjectFormatterMode mode;

    public MongoPredicatesHelper(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        super(dbms);
        this.objectFormatter = new DbObjectFormatter(dbms);
        this.idPattern = new Regex("[0-9a-f]{24}", RegexOption.IGNORE_CASE);
        this.uuidPattern = new Regex("[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}", RegexOption.IGNORE_CASE);
        this.mode = ObjectFormatterMode.JS_SCRIPT;
    }

    @Override
    @NotNull
    public ObjectFormatterMode getMode() {
        return this.mode;
    }

    @Override
    @NotNull
    protected PredicatesHelper.PredicateProducer equalsPredicate(@NotNull ColumnRef column2, @NotNull PredicateValue value2, @NotNull ComparePredicateOperation op, boolean quote, @Nullable Version version, @Nullable String alias) {
        Intrinsics.checkNotNullParameter((Object)column2, (String)"column");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        return new PredicatesHelper.PredicateProducer(CollectionsKt.listOf((Object)column2), value2, op, (Function1<? super DdlBuilder, Unit>)((Function1)new Function1<DdlBuilder, Unit>(column2, this, op, value2, quote, version){
            final /* synthetic */ ColumnRef $column;
            final /* synthetic */ MongoPredicatesHelper this$0;
            final /* synthetic */ ComparePredicateOperation $op;
            final /* synthetic */ PredicateValue $value;
            final /* synthetic */ boolean $quote;
            final /* synthetic */ Version $version;
            {
                this.$column = $column;
                this.this$0 = $receiver;
                this.$op = $op;
                this.$value = $value;
                this.$quote = $quote;
                this.$version = $version;
                super(1);
            }

            public final void invoke(@NotNull DdlBuilder builder) {
                Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
                PredicatesUtilKt.identifier(builder, null, this.$column).symbol(":").space();
                MongoPredicatesHelper.access$operation(this.this$0, builder, this.$op, (Function1)new Function1<DdlBuilder, Unit>(this.$value, this.$quote, this.this$0, this.$column, this.$version, builder){
                    final /* synthetic */ PredicateValue $value;
                    final /* synthetic */ boolean $quote;
                    final /* synthetic */ MongoPredicatesHelper this$0;
                    final /* synthetic */ ColumnRef $column;
                    final /* synthetic */ Version $version;
                    final /* synthetic */ DdlBuilder $builder;
                    {
                        this.$value = $value;
                        this.$quote = $quote;
                        this.this$0 = $receiver;
                        this.$column = $column;
                        this.$version = $version;
                        this.$builder = $builder;
                        super(1);
                    }

                    public final void invoke(@NotNull DdlBuilder $this$operation) {
                        Intrinsics.checkNotNullParameter((Object)$this$operation, (String)"$this$operation");
                        PredicateValue predicateValue = this.$value;
                        if (Intrinsics.areEqual((Object)predicateValue, (Object)NullPredicateValue.INSTANCE)) {
                            $this$operation.literal("null");
                        } else if (Intrinsics.areEqual((Object)predicateValue, (Object)JdbcPlaceholder.INSTANCE)) {
                            $this$operation.plain("$placeholder$");
                        } else if (predicateValue instanceof CustomPlaceholder) {
                            $this$operation.plain(((CustomPlaceholder)this.$value).getPlaceholder());
                        } else if (predicateValue instanceof StringPredicateValue) {
                            $this$operation.literal(this.$quote ? MongoPredicatesHelper.access$literal(this.this$0, (StringPredicateValue)this.$value, this.$column, this.$version) : ((StringPredicateValue)this.$value).getStr());
                        } else if (predicateValue instanceof ObjectPredicateValue) {
                            String literal = MongoPredicatesHelper.access$getObjectFormatter$p(this.this$0).objectToString(((ObjectPredicateValue)this.$value).getO(), PredicatesUtilKt.toGridColumn(this.$column), DatabaseObjectFormatterConfig.get((ObjectFormatterMode)ObjectFormatterMode.JS_SCRIPT));
                            if (literal == null) {
                                this.$builder.plain("null");
                            } else if (this.$quote) {
                                this.$builder.plain(DbImplUtilCore.StringLiteralDecorator.PLAIN.decorate(literal, this.this$0.getDbms()));
                            } else {
                                this.$builder.plain(literal);
                            }
                        } else if (predicateValue instanceof MultiPredicateValue) {
                            // empty if block
                        }
                    }
                });
            }
        }));
    }

    private final void operation(DdlBuilder $this$operation, PredicateOperation op, Function1<? super DdlBuilder, Unit> rightOperand) {
        Ref.ObjectRef rightOperand2 = new Ref.ObjectRef();
        rightOperand2.element = rightOperand;
        if (op instanceof EqualsPredicateOperation) {
            ((Function1)rightOperand2.element).invoke((Object)$this$operation);
        } else {
            Object object;
            PredicateOperation predicateOperation = op;
            if (predicateOperation instanceof NotEqualsPredicateOperation) {
                object = "$ne";
            } else if (predicateOperation instanceof LessPredicateOperation) {
                object = "$lt";
            } else if (predicateOperation instanceof GreaterPredicateOperation) {
                object = "$gt";
            } else if (predicateOperation instanceof LikePredicateOperation) {
                if (((LikePredicateOperation)op).isNotLike()) {
                    Function1 operand = (Function1)rightOperand2.element;
                    rightOperand2.element = new Function1<DdlBuilder, Unit>(this, op, (Function1<? super DdlBuilder, Unit>)operand){
                        final /* synthetic */ MongoPredicatesHelper this$0;
                        final /* synthetic */ PredicateOperation $op;
                        final /* synthetic */ Function1<DdlBuilder, Unit> $operand;
                        {
                            this.this$0 = $receiver;
                            this.$op = $op;
                            this.$operand = $operand;
                            super(1);
                        }

                        public final void invoke(@NotNull DdlBuilder $this$null) {
                            Intrinsics.checkNotNullParameter((Object)$this$null, (String)"$this$null");
                            MongoPredicatesHelper.access$operation(this.this$0, $this$null, new LikePredicateOperation(((LikePredicateOperation)this.$op).getLikeType(), ((LikePredicateOperation)this.$op).getMatchCase(), false), this.$operand);
                        }
                    };
                    object = "$ne";
                } else {
                    object = "$regex";
                }
            } else {
                object = "unknown_operation_" + op;
            }
            String operator2 = object;
            MongoScriptUtilKt.inCurly$default($this$operation, false, false, (Function0)new Function0<Unit>((Ref.ObjectRef<Function1<DdlBuilder, Unit>>)rightOperand2, $this$operation, operator2){
                final /* synthetic */ Ref.ObjectRef<Function1<DdlBuilder, Unit>> $rightOperand;
                final /* synthetic */ DdlBuilder $this_operation;
                final /* synthetic */ String $operator;
                {
                    this.$rightOperand = $rightOperand;
                    this.$this_operation = $receiver;
                    this.$operator = $operator;
                    super(0);
                }

                public final void invoke() {
                    Function1 function1 = (Function1)this.$rightOperand.element;
                    DdlBuilder ddlBuilder = this.$this_operation.plain(this.$operator).symbol(":").space();
                    Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"space(...)");
                    function1.invoke((Object)ddlBuilder);
                }
            }, 3, null);
        }
    }

    @Override
    @Nullable
    protected PredicatesHelper.PredicateProducer likePredicate(@NotNull ColumnRef columnRef, @NotNull PredicateValue value2, @Nullable Domain domain, @NotNull LikePredicateOperation op, boolean canCastToText, @Nullable String alias, @Nullable Version version, boolean inUpdate) {
        Intrinsics.checkNotNullParameter((Object)columnRef, (String)"columnRef");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        if (!(value2 instanceof StringPredicateValue) && !(value2 instanceof Placeholder) || op.getLikeType() == LikeOpType.MATCHES) {
            return null;
        }
        Domain domain2 = domain;
        if (!(domain2 != null ? domain2.supports(OperationKt.LIKE_OPERATION) : false)) {
            return null;
        }
        return new PredicatesHelper.PredicateProducer(CollectionsKt.listOf((Object)columnRef), value2, op, (Function1<? super DdlBuilder, Unit>)((Function1)new Function1<DdlBuilder, Unit>(columnRef, this, op, value2){
            final /* synthetic */ ColumnRef $columnRef;
            final /* synthetic */ MongoPredicatesHelper this$0;
            final /* synthetic */ LikePredicateOperation $op;
            final /* synthetic */ PredicateValue $value;
            {
                this.$columnRef = $columnRef;
                this.this$0 = $receiver;
                this.$op = $op;
                this.$value = $value;
                super(1);
            }

            public final void invoke(@NotNull DdlBuilder builder) {
                Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
                PredicatesUtilKt.identifier(builder, null, this.$columnRef).symbol(":").space();
                MongoPredicatesHelper.access$operation(this.this$0, builder, this.$op, (Function1)new Function1<DdlBuilder, Unit>(this.$value, this.$op, this.this$0){
                    final /* synthetic */ PredicateValue $value;
                    final /* synthetic */ LikePredicateOperation $op;
                    final /* synthetic */ MongoPredicatesHelper this$0;
                    {
                        this.$value = $value;
                        this.$op = $op;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull DdlBuilder $this$operation) {
                        Intrinsics.checkNotNullParameter((Object)$this$operation, (String)"$this$operation");
                        PredicateValue predicateValue = this.$value;
                        if (Intrinsics.areEqual((Object)predicateValue, (Object)JdbcPlaceholder.INSTANCE)) {
                            $this$operation.plain("$placeholder$");
                        } else if (predicateValue instanceof CustomPlaceholder) {
                            $this$operation.plain(((CustomPlaceholder)this.$value).getPlaceholder());
                        } else if (predicateValue instanceof StringPredicateValue) {
                            $this$operation.literal(this.$op.getLikeType().getDecorator().decorate(((StringPredicateValue)this.$value).getStr(), this.this$0.getDbms()));
                        }
                    }
                });
            }
        }));
    }

    /*
     * Enabled aggressive block sorting
     */
    private final String literal(StringPredicateValue value2, ColumnRef columnRef, Version version) {
        String string;
        String string2;
        Domain domain;
        String str = value2.getStr();
        Domain domain2 = domain = this.getDomain(columnRef, value2, version);
        String string3 = string2 = domain2 != null ? domain2.simpleName() : null;
        if (string2 != null) {
            int n = -1;
            switch (string2.hashCode()) {
                case -1480407629: {
                    if (!string2.equals("ISODate")) break;
                    n = 1;
                    break;
                }
                case 155139290: {
                    if (!string2.equals("ObjectId")) break;
                    n = 2;
                    break;
                }
                case 1555471665: {
                    if (!string2.equals("BinData")) break;
                    n = 3;
                    break;
                }
                case 9271654: {
                    if (!string2.equals("Decimal128")) break;
                    n = 4;
                    break;
                }
                case 2616251: {
                    if (!string2.equals("UUID")) break;
                    n = 5;
                    break;
                }
                case -1984193210: {
                    if (!string2.equals("decimal128")) break;
                    n = 4;
                    break;
                }
            }
            switch (n) {
                case 2: {
                    string = "new ObjectId(\"" + StringUtil.escapeStringCharacters((String)str) + "\")";
                    return string;
                }
                case 1: {
                    string = "new ISODate(\"" + StringUtil.escapeStringCharacters((String)str) + "\")";
                    return string;
                }
                case 4: {
                    string = "new NumberDecimal(\"" + StringUtil.escapeStringCharacters((String)str) + "\")";
                    return string;
                }
                case 5: {
                    string = "new UUID(\"" + str + "\")";
                    return string;
                }
                case 3: {
                    string = "new BinData(\"" + str + "\")";
                    return string;
                }
            }
        }
        string = "\"" + StringUtil.escapeStringCharacters((String)str) + "\"";
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    protected FormatTester getFormatTester(@NotNull ColumnRef columnRef, @Nullable Domain domain, @Nullable Version version) {
        Intrinsics.checkNotNullParameter((Object)columnRef, (String)"columnRef");
        Domain domain2 = domain;
        if (domain2 == null) return null;
        String string = domain2.simpleName();
        String string2 = string;
        if (string2 == null) return null;
        int n = -1;
        switch (string2.hashCode()) {
            case 63537721: {
                if (string2.equals("Array")) {
                    n = 1;
                }
                break;
            }
            case -1480407629: {
                if (string2.equals("ISODate")) {
                    n = 2;
                }
                break;
            }
            case -1850931927: {
                if (string2.equals("Regexp")) {
                    n = 3;
                }
                break;
            }
            case 70807245: {
                if (string2.equals("Int64")) {
                    n = 4;
                }
                break;
            }
            case 155139290: {
                if (string2.equals("ObjectId")) {
                    n = 5;
                }
                break;
            }
            case 70807150: {
                if (string2.equals("Int32")) {
                    n = 4;
                }
                break;
            }
            case 1555471665: {
                if (string2.equals("BinData")) {
                    n = 6;
                }
                break;
            }
            case -1939501217: {
                if (string2.equals("Object")) {
                    n = 1;
                }
                break;
            }
            case 9271654: {
                if (string2.equals("Decimal128")) {
                    n = 7;
                }
                break;
            }
            case 2616251: {
                if (string2.equals("UUID")) {
                    n = 8;
                }
                break;
            }
            case 1729365000: {
                if (string2.equals("Boolean")) {
                    n = 9;
                }
                break;
            }
            case 2059094262: {
                if (string2.equals("Timestamp")) {
                    n = 10;
                }
                break;
            }
        }
        switch (n) {
            case 3: {
                FormatTester formatTester2 = new FormatTester(false, false, getFormatTester.1.INSTANCE, 2, null);
                return formatTester2;
            }
            case 7: {
                FormatTester formatTester2 = this.typeWithConstructor(CollectionsKt.listOf((Object)"NumberDecimal"), true, (Function1<? super String, ? extends FormatTestResult>)((Function1)getFormatTester.2.INSTANCE));
                return formatTester2;
            }
            case 4: {
                Object[] objectArray = new String[]{"NumberLong", "NumberInt"};
                FormatTester formatTester2 = this.typeWithConstructor(CollectionsKt.listOf((Object[])objectArray), false, (Function1<? super String, ? extends FormatTestResult>)((Function1)getFormatTester.3.INSTANCE));
                return formatTester2;
            }
            case 5: {
                FormatTester formatTester2 = this.typeWithConstructor(CollectionsKt.listOf((Object)"ObjectId"), true, (Function1<? super String, ? extends FormatTestResult>)((Function1)new Function1<String, FormatTestResult>(this){
                    final /* synthetic */ MongoPredicatesHelper this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final FormatTestResult invoke(@NotNull String it2) {
                        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                        return MongoPredicatesHelper.access$getIdPattern$p(this.this$0).matches((CharSequence)it2) ? FormatTestResult.QUOTE : FormatTestResult.NOT_MATCHED;
                    }
                }));
                return formatTester2;
            }
            case 8: {
                FormatTester formatTester2 = this.typeWithConstructor(CollectionsKt.listOf((Object)"UUID"), true, (Function1<? super String, ? extends FormatTestResult>)((Function1)new Function1<String, FormatTestResult>(this){
                    final /* synthetic */ MongoPredicatesHelper this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final FormatTestResult invoke(@NotNull String it2) {
                        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                        return MongoPredicatesHelper.access$getUuidPattern$p(this.this$0).matches((CharSequence)it2) ? FormatTestResult.QUOTE : FormatTestResult.NOT_MATCHED;
                    }
                }));
                return formatTester2;
            }
            case 6: {
                FormatTester formatTester2 = this.typeWithConstructor(CollectionsKt.listOf((Object)"BinData"), true, (Function1<? super String, ? extends FormatTestResult>)((Function1)getFormatTester.6.INSTANCE));
                return formatTester2;
            }
            case 9: {
                FormatTester formatTester2 = new FormatTester(false, false, getFormatTester.7.INSTANCE, 2, null);
                return formatTester2;
            }
            case 1: {
                FormatTester formatTester2 = new FormatTester(false, false, getFormatTester.8.INSTANCE, 2, null);
                return formatTester2;
            }
            case 10: {
                FormatTester formatTester2 = new FormatTester(false, false, getFormatTester.9.INSTANCE, 2, null);
                return formatTester2;
            }
            case 2: {
                List list = CollectionsKt.listOf((Object)"ISODate");
                FormatTester formatTester = PredicatesUtilKt.getFormatTester(columnRef, this.getDbms(), LogicalType.TIMESTAMP);
                Intrinsics.checkNotNull((Object)formatTester);
                FormatTester formatTester2 = this.typeWithConstructor(list, true, formatTester.getTest());
                return formatTester2;
            }
            default: {
                return null;
            }
        }
    }

    private final FormatTester typeWithConstructor(List<String> classNames, boolean isQuotedValue, Function1<? super String, ? extends FormatTestResult> testUnwrapped) {
        return new FormatTester(isQuotedValue, false, (Function1)new Function1<String, FormatTestResult>(classNames, testUnwrapped){
            final /* synthetic */ List<String> $classNames;
            final /* synthetic */ Function1<String, FormatTestResult> $testUnwrapped;
            {
                this.$classNames = $classNames;
                this.$testUnwrapped = $testUnwrapped;
                super(1);
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final FormatTestResult invoke(@NotNull String it2) {
                FormatTestResult formatTestResult;
                Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                if (StringsKt.endsWith$default((String)it2, (String)")", (boolean)false, (int)2, null)) {
                    boolean bl;
                    block5: {
                        Iterable $this$any$iv = this.$classNames;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (T element$iv : $this$any$iv) {
                                String name2 = (String)element$iv;
                                boolean bl2 = false;
                                if (!(StringsKt.startsWith$default((String)it2, (String)(name2 + "("), (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)it2, (String)("new " + name2 + "("), (boolean)false, (int)2, null))) continue;
                                bl = true;
                                break block5;
                            }
                            bl = false;
                        }
                    }
                    if (bl) {
                        formatTestResult = FormatTestResult.NOT_QUOTE;
                        return formatTestResult;
                    }
                }
                formatTestResult = (FormatTestResult)((Object)this.$testUnwrapped.invoke((Object)it2));
                return formatTestResult;
            }
        }, 2, null);
    }

    @Override
    @Nullable
    protected Domain getDomain(@NotNull ColumnRef columnRef, @NotNull PredicateValue value2, @Nullable Version version) {
        Domain domain;
        Intrinsics.checkNotNullParameter((Object)columnRef, (String)"columnRef");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        if (value2 instanceof ObjectPredicateValue) {
            Object v2;
            block3: {
                String string = MongoJdbcHelper.getTypeName((Object)((ObjectPredicateValue)value2).getO());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTypeName(...)");
                String typeName = string;
                Collection<Domain> collection2 = BaseDomainRegistry.get(this.getDbms(), version).getDomains();
                Intrinsics.checkNotNullExpressionValue(collection2, (String)"getDomains(...)");
                Iterable iterable = collection2;
                for (Object t : iterable) {
                    Domain it2 = (Domain)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it2.simpleName(), (Object)typeName)) continue;
                    v2 = t;
                    break block3;
                }
                v2 = null;
            }
            domain = v2;
        } else {
            domain = super.getDomain(columnRef, value2, version);
        }
        return domain;
    }

    public static final /* synthetic */ void access$operation(MongoPredicatesHelper $this, DdlBuilder $receiver, PredicateOperation op, Function1 rightOperand) {
        $this.operation($receiver, op, (Function1<? super DdlBuilder, Unit>)rightOperand);
    }

    public static final /* synthetic */ String access$literal(MongoPredicatesHelper $this, StringPredicateValue value2, ColumnRef columnRef, Version version) {
        return $this.literal(value2, columnRef, version);
    }

    public static final /* synthetic */ DbObjectFormatter access$getObjectFormatter$p(MongoPredicatesHelper $this) {
        return $this.objectFormatter;
    }

    public static final /* synthetic */ Regex access$getIdPattern$p(MongoPredicatesHelper $this) {
        return $this.idPattern;
    }

    public static final /* synthetic */ Regex access$getUuidPattern$p(MongoPredicatesHelper $this) {
        return $this.uuidPattern;
    }
}

