/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mongo;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.dataSource.DatabaseAuthProvider;
import com.intellij.database.dataSource.DatabaseConnectionConfig;
import com.intellij.database.dataSource.DatabaseConnectionInterceptor;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.ui.AuthWidgetBuilder;
import com.intellij.database.dialects.mongo.MongoAWSAuthProviderKt;
import com.intellij.database.dialects.mongo.MongoDatabaseCredentialsAuthProviderKt;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.view.DatabaseCoreUiService;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\u001e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0015H\u0096@\u00a2\u0006\u0002\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lcom/intellij/database/dialects/mongo/MongoKerberosAuthProvider;", "Lcom/intellij/database/dataSource/DatabaseAuthProvider;", "()V", "createWidget", "Lcom/intellij/database/dataSource/DatabaseAuthProvider$AuthWidget;", "project", "Lcom/intellij/openapi/project/Project;", "credentials", "Lcom/intellij/database/access/DatabaseCredentials;", "config", "Lcom/intellij/database/dataSource/DatabaseConnectionConfig;", "getApplicability", "Lcom/intellij/database/dataSource/DatabaseAuthProvider$ApplicabilityLevel$Result;", "point", "Lcom/intellij/database/dataSource/DatabaseConnectionPoint;", "level", "Lcom/intellij/database/dataSource/DatabaseAuthProvider$ApplicabilityLevel;", "getDisplayName", "", "getId", "interceptConnection", "", "proto", "Lcom/intellij/database/dataSource/DatabaseConnectionInterceptor$ProtoConnection;", "silent", "(Lcom/intellij/database/dataSource/DatabaseConnectionInterceptor$ProtoConnection;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.database.dialects.mongo"})
public final class MongoKerberosAuthProvider
implements DatabaseAuthProvider {
    @Override
    @NotNull
    public String getId() {
        return "MongoDB.GSSAPI";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = DatabaseBundle.message("MongoDB.auth.kerberos", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Override
    @NotNull
    public DatabaseAuthProvider.ApplicabilityLevel.Result getApplicability(@NotNull DatabaseConnectionPoint point, @NotNull DatabaseAuthProvider.ApplicabilityLevel level) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        return MongoDatabaseCredentialsAuthProviderKt.getMongoApplicability(point, level, "GSSAPI");
    }

    @Override
    @Nullable
    public Object interceptConnection(@NotNull DatabaseConnectionInterceptor.ProtoConnection proto2, boolean silent, @NotNull Continuation<? super Boolean> $completion) {
        DbImplUtilCore.putOrRemove(proto2.getConnectionProperties(), "authMechanism", "GSSAPI");
        return Boxing.boxBoolean((boolean)true);
    }

    @Override
    @Nullable
    public DatabaseAuthProvider.AuthWidget createWidget(@Nullable Project project, @NotNull DatabaseCredentials credentials, @NotNull DatabaseConnectionConfig config) {
        Intrinsics.checkNotNullParameter((Object)credentials, (String)"credentials");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        AuthWidgetBuilder authWidgetBuilder = DatabaseCoreUiService.getInstance().createAuthWidgetBuilder();
        if (authWidgetBuilder == null) {
            return null;
        }
        AuthWidgetBuilder builder = authWidgetBuilder;
        return builder.addUserField(DatabaseBundle.messagePointer("MongoDB.auth.kerberos.principal", new Object[0])).addTextField(DatabaseBundle.messagePointer("MongoDB.auth.kerberos.service.name", new Object[0]), AuthWidgetBuilder.additionalPropertySerializer("SERVICE_NAME"), MongoAWSAuthProviderKt.mongoUrlAuthPropHandler("SERVICE_NAME")).addTextField(DatabaseBundle.messagePointer("MongoDB.auth.kerberos.service.realm", new Object[0]), AuthWidgetBuilder.additionalPropertySerializer("SERVICE_REALM"), MongoAWSAuthProviderKt.mongoUrlAuthPropHandler("SERVICE_REALM")).addCheckBox(DatabaseBundle.messagePointer("MongoDB.auth.kerberos.canonicalize.host.name", new Object[0]), AuthWidgetBuilder.adapt(AuthWidgetBuilder.additionalPropertySerializer("CANONICALIZE_HOST_NAME"), false), AuthWidgetBuilder.adapt(MongoAWSAuthProviderKt.mongoUrlAuthPropHandler("CANONICALIZE_HOST_NAME"), false)).build(project, credentials, config);
    }
}

