/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.maria.plan;

import com.intellij.database.dialects.base.plan.AbstractPlanModelBuilder;
import com.intellij.database.dialects.maria.plan.MariaJsonPlanData;
import com.intellij.database.plan.PlanModel;
import com.intellij.database.plan.PlanRetrievalException;
import com.intellij.openapi.util.Pair;
import com.intellij.util.ObjectUtils;
import java.math.BigDecimal;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MariaJsonPlanModelBuilder
extends AbstractPlanModelBuilder<MariaJsonPlanData, Pair<String, JSONObject>> {
    public static final Map<String, PlanModel.NodeType> TYPE_MAPPING = new HashMap<String, PlanModel.NodeType>();

    protected MariaJsonPlanModelBuilder() {
        super(EnumSet.of(PlanModel.Feature.TOTAL_COST, PlanModel.Feature.STARTUP_COST));
    }

    @Override
    @NotNull
    public MariaJsonPlanData createData() {
        return new MariaJsonPlanData();
    }

    @Override
    protected void parseData() {
        JSONObject data;
        this.myActual = ((MariaJsonPlanData)this.myData).actual;
        try {
            data = new JSONObject(((MariaJsonPlanData)this.myData).json);
        }
        catch (JSONException e2) {
            throw new PlanRetrievalException("Database returned invalid JSON", e2);
        }
        this.openNode(null);
        this.parseStatement((Pair<String, JSONObject>)Pair.create((Object)"", (Object)data));
        this.closeNode(new PlanModel.GenericNode(PlanModel.NodeType.ROOT, null));
    }

    @Override
    @NotNull
    protected String parseRawDescription(@NotNull Pair<String, JSONObject> object) {
        if (object == null) {
            MariaJsonPlanModelBuilder.$$$reportNull$$$0(0);
        }
        String string = MariaJsonPlanModelBuilder.extractRaw("", object.second, true, new StringBuilder()).toString();
        if (string == null) {
            MariaJsonPlanModelBuilder.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static StringBuilder extractRaw(String key2, @Nullable Object obj2, boolean allowObj, StringBuilder builder) {
        if (obj2 instanceof JSONObject) {
            if (allowObj) {
                JSONObject j = (JSONObject)obj2;
                Iterator it2 = j.keys();
                while (it2.hasNext()) {
                    String k = it2.next().toString();
                    MariaJsonPlanModelBuilder.extractRaw(k, j.opt(k), false, builder);
                }
            }
        } else if (obj2 instanceof JSONArray) {
            JSONArray a = (JSONArray)obj2;
            int e2 = a.length();
            for (int i2 = 0; i2 < e2; ++i2) {
                MariaJsonPlanModelBuilder.extractRaw(key2, a.opt(i2), false, builder);
            }
        } else if (obj2 != null) {
            builder.append(key2).append(" = ").append(obj2.toString()).append("\n");
        }
        return builder;
    }

    @Override
    @Nullable
    protected String parseAccessRelation(@NotNull Pair<String, JSONObject> object) {
        if (object == null) {
            MariaJsonPlanModelBuilder.$$$reportNull$$$0(2);
        }
        return MariaJsonPlanModelBuilder.removeString((JSONObject)object.second, "table_name");
    }

    @Override
    @Nullable
    protected BigDecimal parsePlanNumRows(@NotNull Pair<String, JSONObject> object) {
        String rows;
        if (object == null) {
            MariaJsonPlanModelBuilder.$$$reportNull$$$0(3);
        }
        return (rows = MariaJsonPlanModelBuilder.removeString((JSONObject)object.second, "rows")) == null ? null : new BigDecimal(rows);
    }

    @Override
    @Nullable
    protected BigDecimal parseActualNumRows(@NotNull Pair<String, JSONObject> object) {
        String rows;
        if (object == null) {
            MariaJsonPlanModelBuilder.$$$reportNull$$$0(4);
        }
        return (rows = MariaJsonPlanModelBuilder.removeString((JSONObject)object.second, "r_rows")) == null ? null : new BigDecimal(rows);
    }

    @Override
    @Nullable
    protected Double parseActualTotalTime(@NotNull Pair<String, JSONObject> object) {
        String time;
        if (object == null) {
            MariaJsonPlanModelBuilder.$$$reportNull$$$0(5);
        }
        return (time = MariaJsonPlanModelBuilder.removeString((JSONObject)object.second, "r_total_time_ms")) == null ? null : Double.valueOf(Double.parseDouble(time));
    }

    @Override
    @Nullable
    protected String parseAccessIndex(@NotNull Pair<String, JSONObject> object) {
        if (object == null) {
            MariaJsonPlanModelBuilder.$$$reportNull$$$0(6);
        }
        return MariaJsonPlanModelBuilder.removeString((JSONObject)object.second, "key");
    }

    @Override
    protected void parsePlan(@NotNull Pair<String, JSONObject> object) {
        PlanModel.GenericNode res2;
        if (object == null) {
            MariaJsonPlanModelBuilder.$$$reportNull$$$0(7);
        }
        if (!this.openNode(null)) {
            return;
        }
        String typeStr = (String)object.first;
        JSONObject j = (JSONObject)object.second;
        String extra = null;
        if ("block-nl-join".equals(typeStr)) {
            this.wrapPrevNode();
        } else if ("table".equals(typeStr)) {
            extra = MariaJsonPlanModelBuilder.removeString(j, "access_type");
            if (extra == null) {
                extra = MariaJsonPlanModelBuilder.removeString(j, "message");
            }
        } else if ("query_block".equals(typeStr)) {
            extra = MariaJsonPlanModelBuilder.removeString(j, "operation");
        }
        String key2 = extra == null ? typeStr : typeStr + "." + extra;
        PlanModel.NodeType type2 = MariaJsonPlanModelBuilder.getNodeType(typeStr, key2);
        PlanModel.GenericNode prev = null;
        boolean reusePrev = false;
        if ("materialized".equals(typeStr)) {
            prev = this.removePrevNode();
        }
        this.parseSubPlans(object);
        if ("query_block".equals(typeStr) && extra == null && (prev = this.mergeLastChild()) != null) {
            reusePrev = true;
        }
        PlanModel.GenericNode genericNode = res2 = reusePrev ? prev : this.createNode(object, type2, key2);
        if (prev != null) {
            PlanModel.GenericNode tmp = reusePrev ? this.createNode(object, type2, key2) : prev;
            res2.setActualNumRows((BigDecimal)ObjectUtils.chooseNotNull((Object)res2.getActualNumRows(), (Object)tmp.getActualNumRows()));
            res2.setPlanNumRows((BigDecimal)ObjectUtils.chooseNotNull((Object)res2.getPlanNumRows(), (Object)tmp.getPlanNumRows()));
            res2.setActualTotalTime((Double)ObjectUtils.chooseNotNull((Object)res2.getActualTotalTime(), (Object)tmp.getActualTotalTime()));
            String d1 = res2.getRawDescription();
            String d2 = tmp.getRawDescription();
            res2.setRawDescription((String)(d1.isEmpty() ? d2 : (d2.isEmpty() ? d1 : d1 + "\n" + d2)));
        }
        this.closeNode(res2);
    }

    private static PlanModel.NodeType getNodeType(String typeStr, String key2) {
        PlanModel.NodeType type2 = TYPE_MAPPING.get(key2);
        if (type2 != null) {
            return type2;
        }
        return TYPE_MAPPING.getOrDefault(typeStr, PlanModel.NodeType.UNKNOWN);
    }

    private static String removeString(JSONObject j, String message2) {
        String extra = j.optString(message2, null);
        j.remove(message2);
        return extra;
    }

    @Override
    protected void parseSubPlans(@NotNull Pair<String, JSONObject> object) {
        if (object == null) {
            MariaJsonPlanModelBuilder.$$$reportNull$$$0(8);
        }
        Iterator it2 = ((JSONObject)object.second).keys();
        while (it2.hasNext()) {
            String k = it2.next().toString();
            if (k.equals("r_engine_stats")) continue;
            Object child = ((JSONObject)object.second).opt(k);
            if (child instanceof JSONObject) {
                JSONObject sub = (JSONObject)child;
                Pair state = Pair.create((Object)k, (Object)sub);
                this.parsePlan((Pair<String, JSONObject>)state);
                continue;
            }
            if (!(child instanceof JSONArray)) continue;
            JSONArray subs2 = (JSONArray)child;
            int e2 = subs2.length();
            for (int i2 = 0; i2 < e2; ++i2) {
                JSONObject o2 = subs2.optJSONObject(i2);
                if (o2 == null) continue;
                if ("subqueries".equals(k) || "query_specifications".equals(k)) {
                    this.parseSubPlans((Pair<String, JSONObject>)Pair.create((Object)k, (Object)o2));
                    continue;
                }
                this.parsePlan((Pair<String, JSONObject>)Pair.create((Object)k, (Object)o2));
            }
        }
    }

    @Override
    protected void parseStatement(@NotNull Pair<String, JSONObject> object) {
        if (object == null) {
            MariaJsonPlanModelBuilder.$$$reportNull$$$0(9);
        }
        this.openNode(object);
        this.parseSubPlans(object);
        this.closeNode(new PlanModel.GenericNode(PlanModel.NodeType.SELECT, null));
    }

    @Override
    @Nullable
    protected Double parseTotalCost(@NotNull Pair<String, JSONObject> object) {
        if (object == null) {
            MariaJsonPlanModelBuilder.$$$reportNull$$$0(10);
        }
        return null;
    }

    @Override
    @Nullable
    protected Double parseStartupCost(@NotNull Pair<String, JSONObject> object) {
        if (object == null) {
            MariaJsonPlanModelBuilder.$$$reportNull$$$0(11);
        }
        return null;
    }

    @Override
    protected boolean parseSubqueryCorrelated(@NotNull Pair<String, JSONObject> object) {
        if (object == null) {
            MariaJsonPlanModelBuilder.$$$reportNull$$$0(12);
        }
        JSONObject block = ((JSONObject)object.second).optJSONObject("query_block");
        return block.has("outer_ref_condition");
    }

    @Override
    protected boolean parseSubqueryScalar(@NotNull Pair<String, JSONObject> object) {
        if (object == null) {
            MariaJsonPlanModelBuilder.$$$reportNull$$$0(13);
        }
        return false;
    }

    static {
        TYPE_MAPPING.put("table", PlanModel.NodeType.ACCESS);
        TYPE_MAPPING.put("table.ALL", PlanModel.NodeType.SEQ_SCAN);
        TYPE_MAPPING.put("table.eq_ref", PlanModel.NodeType.UNIQUE_INDEX_SCAN);
        TYPE_MAPPING.put("table.index", PlanModel.NodeType.FULL_INDEX_SCAN);
        TYPE_MAPPING.put("table.system", PlanModel.NodeType.ACCESS);
        TYPE_MAPPING.put("table.const", PlanModel.NodeType.ACCESS);
        TYPE_MAPPING.put("table.No tables used", PlanModel.NodeType.VALUE);
        TYPE_MAPPING.put("query_block.UNION", PlanModel.NodeType.UNION);
        TYPE_MAPPING.put("union_result", PlanModel.NodeType.UNION);
        TYPE_MAPPING.put("block-nl-join", PlanModel.NodeType.NESTED_LOOPS);
        TYPE_MAPPING.put("nested_loop", PlanModel.NodeType.NESTED_LOOPS);
        TYPE_MAPPING.put("materialized", PlanModel.NodeType.TEMPORARY);
        TYPE_MAPPING.put("temporary_table", PlanModel.NodeType.TEMPORARY);
        TYPE_MAPPING.put("read_sorted_file", PlanModel.NodeType.DATA);
        TYPE_MAPPING.put("filesort", PlanModel.NodeType.SORT);
        TYPE_MAPPING.put("recursive_union", PlanModel.NodeType.RECURSION);
        TYPE_MAPPING.put("expression_cache", PlanModel.NodeType.SUBQUERY);
        TYPE_MAPPING.put("query_optimization", PlanModel.NodeType.OPTIMIZE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/maria/plan/MariaJsonPlanModelBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/maria/plan/MariaJsonPlanModelBuilder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "parseRawDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseRawDescription";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parseAccessRelation";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parsePlanNumRows";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parseActualNumRows";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parseActualTotalTime";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parseAccessIndex";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "parsePlan";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "parseSubPlans";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "parseStatement";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "parseTotalCost";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "parseStartupCost";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "parseSubqueryCorrelated";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "parseSubqueryScalar";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

