/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.maria.plan;

import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.connection.statements.ReusableSmartStatement;
import com.intellij.database.dialects.base.plan.RawPlanData;
import com.intellij.database.plan.PlanRetrievalException;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ThrowableConsumer;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;

public class MariaJsonPlanData
extends RawPlanData {
    public String json;
    public boolean actual;

    @Override
    public void load(@NotNull DatabaseConnectionCore connection2, final @NotNull String statement2, final boolean run2) {
        if (connection2 == null) {
            MariaJsonPlanData.$$$reportNull$$$0(0);
        }
        if (statement2 == null) {
            MariaJsonPlanData.$$$reportNull$$$0(1);
        }
        this.json = null;
        this.actual = run2;
        MariaJsonPlanData.useStatementWithPreserved(connection2, (RawPlanData.ResourceUser<? super ReusableSmartStatement<String>>)new RawPlanData.ResourceUser<ReusableSmartStatement<String>>(){

            @Override
            public void use(ReusableSmartStatement<String> s2) throws PlanRetrievalException, SQLException {
                s2.noisy().execute((run2 ? "ANALYZE" : "EXPLAIN") + " FORMAT=JSON " + statement2, MariaJsonPlanData.processing((ThrowableConsumer<? super RemoteResultSet, ? extends Exception>)rs -> {
                    if (!rs.next()) {
                        MariaJsonPlanData.failWithEmptyResultSetError();
                    }
                    if (rs.getMetaData().getColumnCount() != 1) {
                        throw new PlanRetrievalException("Database returned data in unknown format");
                    }
                    String res2 = rs.getString(1);
                    if (res2 == null) {
                        throw new PlanRetrievalException("Database returned null plan");
                    }
                    if (rs.next()) {
                        throw new PlanRetrievalException("Database returned too many data");
                    }
                    MariaJsonPlanData.this.json = res2;
                }));
            }
        }, new RawPlanData.StateSaver[0]);
    }

    @Override
    public void load(@NotNull String dump2) {
        if (dump2 == null) {
            MariaJsonPlanData.$$$reportNull$$$0(2);
        }
        this.actual = !dump2.startsWith("explain");
        this.json = StringUtil.trimLeading((String)StringUtil.trimStart((String)dump2, (String)"explain"));
    }

    @Override
    public String dump() {
        return this.actual ? this.json : "explain\n" + this.json;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "connection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "statement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "dump";
                break;
            }
        }
        objectArray[1] = "com/intellij/database/dialects/maria/plan/MariaJsonPlanData";
        objectArray[2] = "load";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

