/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.hivebase.model;

import com.intellij.database.dialects.hivebase.model.HiveBaseDescriptionService;
import com.intellij.database.dialects.hivebase.model.HiveBaseLikeTable;
import com.intellij.database.dialects.hivebase.model.HiveBaseTable;
import com.intellij.database.dialects.hivebase.model.HiveBaseTableColumn;
import com.intellij.database.dialects.hivebase.model.HiveBaseView;
import com.intellij.database.dialects.hivebase.model.properties.HiveTableColumnSortingOrder;
import com.intellij.database.dialects.hivebase.model.properties.HiveTableColumnType;
import com.intellij.database.model.DescriptionService;
import com.intellij.database.model.NameValue;
import com.intellij.database.model.basic.BasicElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0004J\u0018\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0004J\u0018\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0016\u0010\u0012\u001a\u00020\u00042\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/intellij/database/dialects/hivebase/model/HiveBaseDescriptionService;", "Lcom/intellij/database/model/DescriptionService;", "()V", "appendProperties", "", "e", "Lcom/intellij/database/dialects/hivebase/model/HiveBaseLikeTable;", "desc", "content", "Lcom/intellij/database/model/basic/BasicElement;", "context", "Lcom/intellij/database/model/DescriptionService$Context;", "describeTable", "Lcom/intellij/database/dialects/hivebase/model/HiveBaseTable;", "describeTableColumn", "Lcom/intellij/database/dialects/hivebase/model/HiveBaseTableColumn;", "describeView", "Lcom/intellij/database/dialects/hivebase/model/HiveBaseView;", "joinProperties", "properties", "", "Lcom/intellij/database/model/NameValue;", "intellij.database.dialects.hivebase"})
@SourceDebugExtension(value={"SMAP\nHiveBaseDescriptionService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HiveBaseDescriptionService.kt\ncom/intellij/database/dialects/hivebase/model/HiveBaseDescriptionService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,60:1\n1#2:61\n*E\n"})
public class HiveBaseDescriptionService
extends DescriptionService {
    @Override
    @NotNull
    public String content(@NotNull BasicElement e2, @NotNull DescriptionService.Context context) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        BasicElement basicElement = e2;
        return basicElement instanceof HiveBaseTable ? this.describeTable((HiveBaseTable)e2, context) : (basicElement instanceof HiveBaseTableColumn ? this.describeTableColumn((HiveBaseTableColumn)e2, context) : (basicElement instanceof HiveBaseView ? this.describeView((HiveBaseView)e2, context) : super.content(e2, context)));
    }

    private final String describeView(HiveBaseView e2, DescriptionService.Context context) {
        ((Collection)context.getDescribed()).add(HiveBaseView.PROPERTIES);
        String desc = super.describeView(e2, context);
        return this.appendProperties(e2, desc);
    }

    @NotNull
    protected final String appendProperties(@NotNull HiveBaseLikeTable e2, @NotNull String desc) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
        List<NameValue> list = e2.getProperties();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getProperties(...)");
        List<NameValue> nonIgnoredProperties = list;
        if (!((Collection)nonIgnoredProperties).isEmpty()) {
            return desc + " properties: " + this.joinProperties(nonIgnoredProperties);
        }
        return desc;
    }

    private final String joinProperties(List<? extends NameValue> properties2) {
        return CollectionsKt.joinToString$default((Iterable)properties2, null, null, null, (int)0, null, (Function1)joinProperties.1.INSTANCE, (int)31, null);
    }

    private final String describeTableColumn(HiveBaseTableColumn e2, DescriptionService.Context context) {
        ((Collection)context.getDescribed()).add(HiveBaseTableColumn.TYPE);
        ((Collection)context.getDescribed()).add(HiveBaseTableColumn.SORTING);
        Object desc = super.describeColumn(e2, context, "default");
        if (e2.getType() != HiveTableColumnType.REGULAR) {
            desc = (String)desc + " " + e2.getType();
        }
        if (e2.getSorting() != HiveTableColumnSortingOrder.NONE) {
            desc = (String)desc + " " + e2.getSorting();
        }
        return desc;
    }

    @NotNull
    protected final String describeTable(@NotNull HiveBaseTable e2, @NotNull DescriptionService.Context context) {
        Object desc;
        block6: {
            String it2;
            Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            ((Collection)context.getDescribed()).add(HiveBaseTable.BUCKETS_NUM);
            ((Collection)context.getDescribed()).add(HiveBaseTable.ROW_FORMAT_SERDE);
            ((Collection)context.getDescribed()).add(HiveBaseTable.SERDE_PROPERTIES);
            ((Collection)context.getDescribed()).add(HiveBaseTable.INPUT_FORMAT);
            ((Collection)context.getDescribed()).add(HiveBaseTable.OUTPUT_FORMAT);
            ((Collection)context.getDescribed()).add(HiveBaseTable.INPUT_DRIVER);
            ((Collection)context.getDescribed()).add(HiveBaseTable.OUTPUT_DRIVER);
            ((Collection)context.getDescribed()).add(HiveBaseTable.PROPERTIES);
            desc = null;
            desc = super.describeTable(e2, context);
            if (e2.getBucketsNum() != 0) {
                desc = desc + " buckets: " + e2.getBucketsNum();
            }
            String string = e2.getRowFormatSerde();
            if (string != null) {
                it2 = string;
                boolean bl = false;
                desc = desc + " serde: " + it2;
            }
            List<NameValue> list = e2.getSerdeProperties();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getSerdeProperties(...)");
            if (!((Collection)list).isEmpty()) {
                List<NameValue> list2 = e2.getSerdeProperties();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"getSerdeProperties(...)");
                desc = desc + " serdeproperties: " + this.joinProperties(list2);
            }
            String string2 = e2.getInputFormat();
            if (string2 != null) {
                it2 = string2;
                boolean bl = false;
                desc = desc + " inputformat: " + it2;
            }
            String string3 = e2.getOutputFormat();
            if (string3 != null) {
                it2 = string3;
                boolean bl = false;
                desc = desc + " outputformat: " + it2;
            }
            String string4 = e2.getInputDriver();
            if (string4 != null) {
                it2 = string4;
                boolean bl = false;
                desc = desc + " inputdriver: " + it2;
            }
            String string5 = e2.getOutputDriver();
            if (string5 == null) break block6;
            it2 = string5;
            boolean bl = false;
            desc = desc + " outputdriver: " + it2;
        }
        return this.appendProperties(e2, (String)desc);
    }
}

