/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.hivebase;

import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.base.AbstractDatabaseDialect;
import com.intellij.database.dialects.base.TypeHelper;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.remote.jdbc.RemoteConnection;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.openapi.util.text.StringUtil;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class HiveDialectBase
extends AbstractDatabaseDialect {
    public HiveDialectBase(TypeHelper typeHelper) {
        super(typeHelper);
    }

    @Override
    public boolean supportsEmptyTables() {
        return false;
    }

    @Override
    public boolean supportsCommonTableExpression() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder qualifiedIdentifier(@NotNull DdlBuilder builder, @NotNull String identifier, @Nullable DasObject object, @NotNull DasObject qualifier) {
        if (builder == null) {
            HiveDialectBase.$$$reportNull$$$0(0);
        }
        if (identifier == null) {
            HiveDialectBase.$$$reportNull$$$0(1);
        }
        if (qualifier == null) {
            HiveDialectBase.$$$reportNull$$$0(2);
        }
        DasObject schema2 = DasUtil.getSchemaObject(qualifier);
        DdlBuilder ddlBuilder = builder.qualifiedRef(object, identifier, schema2, DasUtil.getName(schema2), null, null, null, null);
        if (ddlBuilder == null) {
            HiveDialectBase.$$$reportNull$$$0(3);
        }
        return ddlBuilder;
    }

    @Override
    public SearchPath tryToLoadSearchPath(@NotNull DatabaseConnectionCore connection2) throws SQLException {
        if (connection2 == null) {
            HiveDialectBase.$$$reportNull$$$0(4);
        }
        RemoteConnection remoteConnection = connection2.getRemoteConnection();
        String d2 = (String)JdbcNativeUtil.computeRemote(() -> ((RemoteConnection)remoteConnection).getCatalog());
        String s2 = (String)JdbcNativeUtil.computeRemote(() -> ((RemoteConnection)remoteConnection).getSchema());
        return !StringUtil.isEmpty((String)s2) ? SearchPath.of(ObjectPath.create(StringUtil.notNullize((String)d2), ObjectKind.DATABASE).append(s2, ObjectKind.SCHEMA)) : (!StringUtil.isEmpty((String)d2) ? SearchPath.of(ObjectPath.create(d2, ObjectKind.DATABASE)) : null);
    }

    @Override
    public String sqlSetSearchPath(@NotNull SearchPath path) {
        if (path == null) {
            HiveDialectBase.$$$reportNull$$$0(5);
        }
        ObjectPath current = path.getCurrent();
        if (current.kind != ObjectKind.SCHEMA) {
            return null;
        }
        String schema2 = this.getNamingService().catToScript(current.name, current.kind, this.getCodeStyle().getQuotesPriority());
        return String.format("use %s", schema2);
    }

    @Override
    public boolean similarTo(@NotNull DatabaseDialect dialect) {
        if (dialect == null) {
            HiveDialectBase.$$$reportNull$$$0(6);
        }
        return dialect instanceof HiveDialectBase;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/hivebase/HiveDialectBase";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/hivebase/HiveDialectBase";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "qualifiedIdentifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "qualifiedIdentifier";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadSearchPath";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "sqlSetSearchPath";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "similarTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

