/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.h2.introspector.jdbc;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dialects.base.introspector.jdbc.JdbcSourceLoader;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.basic.BasicModSourceAware;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import java.sql.SQLException;
import java.text.MessageFormat;
import org.jetbrains.annotations.NotNull;

public final class H2JdbcSourceLoader
extends JdbcSourceLoader {
    private H2JdbcSourceLoader(@NotNull Dbms dbms) {
        if (dbms == null) {
            H2JdbcSourceLoader.$$$reportNull$$$0(0);
        }
        super(dbms);
    }

    @Override
    protected boolean loadRoutine(@NotNull BasicModSourceAware object, @NotNull DatabaseConnectionCore connection2) throws Exception {
        Version curVersion;
        boolean useNewSchema;
        String templateStr;
        String query;
        if (object == null) {
            H2JdbcSourceLoader.$$$reportNull$$$0(1);
        }
        if (connection2 == null) {
            H2JdbcSourceLoader.$$$reportNull$$$0(2);
        }
        if (!(object instanceof DasRoutine)) {
            return false;
        }
        Dbms dbms = connection2.getDbms();
        StringBuilder res2 = DbImplUtilCore.concatStringResults(connection2, dbms, query = MessageFormat.format(templateStr = (useNewSchema = (curVersion = connection2.getVersion()).isOrGreater(2) && !StringUtil.equalsIgnoreCase((CharSequence)connection2.getConnectionPoint().getConnectionProperties().getProperty("OLD_INFORMATION_SCHEMA"), (CharSequence)"true")) ? "SELECT ROUTINE_DEFINITION FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = ''{0}'' and ROUTINE_SCHEMA = ''{1}'' " : "SELECT SOURCE FROM INFORMATION_SCHEMA.FUNCTION_ALIASES WHERE ALIAS_NAME = ''{0}'' and ALIAS_SCHEMA = ''{1}'' ", object.getName(), DasUtil.getSchema(object)), 0, new StringBuilder(), DbImplUtilCore.ConcatenationProps.NO_CONCAT);
        if (res2.length() == 0) {
            return false;
        }
        H2JdbcSourceLoader.applySourceText(object, res2, false);
        return true;
    }

    @Override
    protected boolean loadView(@NotNull BasicModSourceAware object, @NotNull DatabaseConnectionCore connection2) throws SQLException {
        String templateStr;
        String query;
        if (object == null) {
            H2JdbcSourceLoader.$$$reportNull$$$0(3);
        }
        if (connection2 == null) {
            H2JdbcSourceLoader.$$$reportNull$$$0(4);
        }
        if (!(object instanceof DasTable)) {
            return false;
        }
        Dbms dbms = connection2.getDbms();
        StringBuilder res2 = DbImplUtilCore.concatStringResults(connection2, dbms, 0, query = MessageFormat.format(templateStr = connection2.getVersion().isOrGreater(2) ? "SELECT DB_OBJECT_SQL(''TABLE'', ''{0}'', ''{1}'')" : "SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_SCHEMA = ''{0}'' AND UPPER(TABLE_NAME) = UPPER(''{1}'') ", DasUtil.getSchema(object), object.getName()), new StringBuilder(), DbImplUtilCore.ConcatenationProps.NO_CONCAT);
        if (res2.length() == 0) {
            return false;
        }
        H2JdbcSourceLoader.applySourceText(object, res2, true);
        return true;
    }

    @Override
    public boolean supportsViewDefinition() {
        return true;
    }

    @Override
    public Pair<String, DbImplUtilCore.ConcatenationProps> sqlViewDefinition(@NotNull DasObject element2) {
        if (element2 == null) {
            H2JdbcSourceLoader.$$$reportNull$$$0(5);
        }
        return Pair.create((Object)"", (Object)DbImplUtilCore.ConcatenationProps.NO_CONCAT);
    }

    @Override
    public boolean supportsProcedureDefinition() {
        return true;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtilCore.ConcatenationProps> sqlProcedureDefinition(@NotNull DasRoutine element2) {
        if (element2 == null) {
            H2JdbcSourceLoader.$$$reportNull$$$0(6);
        }
        Pair pair = Pair.create((Object)"", (Object)DbImplUtilCore.ConcatenationProps.NO_CONCAT);
        if (pair == null) {
            H2JdbcSourceLoader.$$$reportNull$$$0(7);
        }
        return pair;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/h2/introspector/jdbc/H2JdbcSourceLoader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/h2/introspector/jdbc/H2JdbcSourceLoader";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlProcedureDefinition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadRoutine";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadView";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "sqlViewDefinition";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "sqlProcedureDefinition";
                break;
            }
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7 -> new IllegalStateException(string);
        };
    }
}

