/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.h2;

import com.intellij.database.connection.throwable.info.ErrorInfo;
import com.intellij.database.dialects.BaseDatabaseErrorHandler;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.h2.H2Lexer;
import com.intellij.sql.psi.SqlTokens;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class H2ErrorHandler
extends BaseDatabaseErrorHandler {
    @Override
    public int getErrorOffset(@NotNull Project project, @NotNull ErrorInfo errorInfo, @NotNull String queryText2) {
        Matcher matcher;
        if (project == null) {
            H2ErrorHandler.$$$reportNull$$$0(0);
        }
        if (errorInfo == null) {
            H2ErrorHandler.$$$reportNull$$$0(1);
        }
        if (queryText2 == null) {
            H2ErrorHandler.$$$reportNull$$$0(2);
        }
        if (!(matcher = Pattern.compile("Syntax error in SQL statement \"([^\"]*)\\[\\*]([^\"]*)\";").matcher(StringUtil.notNullize((String)errorInfo.getMessage()))).find()) {
            return -1;
        }
        H2Lexer lexer = new H2Lexer();
        ArrayList<IElementType> tokens = new ArrayList<IElementType>(5);
        H2ErrorHandler.extractTokens((Lexer)lexer, matcher.group(1), tokens, null);
        int pre = tokens.size();
        H2ErrorHandler.extractTokens((Lexer)lexer, matcher.group(2), tokens, null);
        if (tokens.isEmpty()) {
            return -1;
        }
        ArrayList<IElementType> queryTokens = new ArrayList<IElementType>(30);
        IntArrayList offsets = new IntArrayList();
        H2ErrorHandler.extractTokens((Lexer)lexer, queryText2, queryTokens, (IntList)offsets);
        int size = queryTokens.size() - tokens.size() + 1;
        block0: for (int i2 = 0; i2 < size; ++i2) {
            for (int k = 0; k < tokens.size(); ++k) {
                if (tokens.get(k) != queryTokens.get(i2 + k)) continue block0;
            }
            int errorIndex = i2 + pre;
            return errorIndex < offsets.size() ? offsets.getInt(errorIndex) : queryText2.length();
        }
        return -1;
    }

    private static void extractTokens(@NotNull Lexer lexer, @Nullable String s2, @NotNull List<IElementType> target2, @Nullable IntList offsets) {
        if (lexer == null) {
            H2ErrorHandler.$$$reportNull$$$0(3);
        }
        if (target2 == null) {
            H2ErrorHandler.$$$reportNull$$$0(4);
        }
        if (StringUtil.isEmpty((String)s2)) {
            return;
        }
        lexer.start((CharSequence)s2);
        while (lexer.getTokenType() != null) {
            IElementType tok2 = lexer.getTokenType();
            if (!SqlTokens.WS_OR_COMMENTS.contains(tok2)) {
                target2.add(tok2);
                if (offsets != null) {
                    offsets.add(lexer.getTokenStart());
                }
            }
            lexer.advance();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorInfo";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryText";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lexer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/dialects/h2/H2ErrorHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getErrorOffset";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "extractTokens";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

