/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.generic.introspector.jdbc;

import com.intellij.database.Dbms;
import com.intellij.database.HSet;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.ClosableIt;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.DatabaseMetaDataWrapper;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.ResultSetWrapper;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.TableIt;
import com.intellij.database.dialects.generic.GenericDbms;
import com.intellij.database.remote.jdbc.RemoteDatabaseMetaData;
import com.intellij.openapi.util.text.StringUtil;
import java.rmi.RemoteException;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenericMetadataWrapper
extends DatabaseMetaDataWrapper {
    @NotNull
    private static final HSet BROKEN_ESCAPING = Dbms.asSet(GenericDbms.MONET, GenericDbms.ATHENA);

    public GenericMetadataWrapper(@NotNull DatabaseConnectionCore connection2, @NotNull RemoteDatabaseMetaData data) {
        if (connection2 == null) {
            GenericMetadataWrapper.$$$reportNull$$$0(0);
        }
        if (data == null) {
            GenericMetadataWrapper.$$$reportNull$$$0(1);
        }
        super(connection2, data);
    }

    @Override
    protected boolean isBrokenEscaping() {
        return this.getDbms().in(BROKEN_ESCAPING);
    }

    @Override
    @NotNull
    protected ClosableIt<? extends DatabaseMetaDataWrapper.Table> tablesInner(@NotNull DatabaseMetaDataWrapper.Schema schema2, @Nullable String name2, String @Nullable [] types2) {
        if (schema2 == null) {
            GenericMetadataWrapper.$$$reportNull$$$0(2);
        }
        ClosableIt<? extends DatabaseMetaDataWrapper.Table> closableIt = super.tablesInner(schema2, name2, this.isIris() ? null : types2);
        if (closableIt == null) {
            GenericMetadataWrapper.$$$reportNull$$$0(3);
        }
        return closableIt;
    }

    @Override
    @NotNull
    protected TableIt createTableIt(@NotNull DatabaseMetaDataWrapper.Schema schema2, ResultSetWrapper rs, boolean hasNext) {
        if (schema2 == null) {
            GenericMetadataWrapper.$$$reportNull$$$0(4);
        }
        return new TableIt(rs, hasNext, schema2){

            @Override
            protected boolean fillValue(DatabaseMetaDataWrapper.Table res2) throws SQLException {
                if (!super.fillValue(res2)) {
                    return false;
                }
                if (GenericMetadataWrapper.this.getDbms() == GenericDbms.ATHENA && "VIRTUAL_VIEW".equals(res2.type)) {
                    res2.type = "VIEW";
                }
                return true;
            }
        };
    }

    private boolean isIris() {
        if (this.getDbms() != Dbms.UNKNOWN) {
            return false;
        }
        String dbmsName = "";
        try {
            dbmsName = this.myConnection.getRemoteConnection().getDetectedDbmsName();
        }
        catch (RemoteException e2) {
            dbmsName = "";
        }
        return StringUtil.containsIgnoreCase((String)dbmsName, (String)"iris");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/generic/introspector/jdbc/GenericMetadataWrapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/generic/introspector/jdbc/GenericMetadataWrapper";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "tablesInner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "tablesInner";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createTableIt";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    public static final class Factory
    extends DatabaseMetaDataWrapper.MDFactory {
        @Override
        @NotNull
        public DatabaseMetaDataWrapper create(@NotNull DatabaseConnectionCore connection2, @NotNull RemoteDatabaseMetaData metaData) {
            if (connection2 == null) {
                Factory.$$$reportNull$$$0(0);
            }
            if (metaData == null) {
                Factory.$$$reportNull$$$0(1);
            }
            return new GenericMetadataWrapper(connection2, metaData);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "connection";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "metaData";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/dialects/generic/introspector/jdbc/GenericMetadataWrapper$Factory";
            objectArray[2] = "create";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

