/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.dynamo.introspector;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dialects.base.introspector.BaseIntrospector;
import com.intellij.database.dialects.base.introspector.BaseNativeIntrospector;
import com.intellij.database.dialects.base.introspector.BaseSingleDatabaseIntrospector;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.ClosableIt;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.DatabaseMetaDataWrapper;
import com.intellij.database.dialects.dynamo.DynamoDbms;
import com.intellij.database.dialects.dynamo.introspector.DynamoIntrospectionException;
import com.intellij.database.dialects.dynamo.introspector.DynamoIntrospector;
import com.intellij.database.dialects.dynamo.introspector.DynamoIntrospector$applySchemas$1$invoke$;
import com.intellij.database.dialects.dynamo.model.DynamoIndex;
import com.intellij.database.dialects.dynamo.model.DynamoKey;
import com.intellij.database.dialects.dynamo.model.DynamoRoot;
import com.intellij.database.dialects.dynamo.model.DynamoSchema;
import com.intellij.database.dialects.dynamo.model.DynamoTable;
import com.intellij.database.dialects.dynamo.model.DynamoTableColumn;
import com.intellij.database.dialects.dynamo.model.properties.DynamoIndexProjectionType;
import com.intellij.database.dialects.dynamo.model.properties.DynamoTableClass;
import com.intellij.database.introspection.DBIntrospectionContext;
import com.intellij.database.introspection.DBIntrospector;
import com.intellij.database.layoutedQueries.DBTransaction;
import com.intellij.database.model.BaseModel;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ElementCacheKt;
import com.intellij.database.model.ElementCacheOptimizersKt;
import com.intellij.database.model.ElementChecker;
import com.intellij.database.model.ElementSearchCache;
import com.intellij.database.model.ElementSearcher;
import com.intellij.database.model.ElementSearcherNN;
import com.intellij.database.model.FamilySearcher;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PerObjectVersion;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModMateNamespace;
import com.intellij.database.model.basic.BasicModSchema;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.model.properties.references.BasicNameReference;
import com.intellij.database.remote.jdbc.RemoteConnection;
import com.intellij.database.remote.jdbc.RemoteDatabaseMetaData;
import com.intellij.database.remote.jdbc.RemoteDynamoConnection;
import com.intellij.database.types.DasUnresolvedTypeReference;
import com.intellij.database.util.Version;
import java.io.Closeable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0003 !\"B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J6\u0010\u000e\u001a \u0012\u0006\b\u0001\u0012\u00020\u00020\u000fR\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0002H\u0014J\b\u0010\u0014\u001a\u00020\u0015H\u0002J6\u0010\u0016\u001a \u0012\u0006\b\u0001\u0012\u00020\u00030\u0017R\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0003H\u0014J\u0010\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u0012H\u0014J&\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u00122\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00030\f2\u0006\u0010\u001d\u001a\u00020\u001eH\u0014J\b\u0010\u001f\u001a\u00020\nH\u0016\u00a8\u0006#"}, d2={"Lcom/intellij/database/dialects/dynamo/introspector/DynamoIntrospector;", "Lcom/intellij/database/dialects/base/introspector/BaseSingleDatabaseIntrospector;", "Lcom/intellij/database/dialects/dynamo/model/DynamoRoot;", "Lcom/intellij/database/dialects/dynamo/model/DynamoSchema;", "context", "Lcom/intellij/database/introspection/DBIntrospectionContext;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "(Lcom/intellij/database/introspection/DBIntrospectionContext;Lcom/intellij/database/model/ModelFactory;)V", "applySchemas", "", "newSchemas", "", "", "createDatabaseRetriever", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractDatabaseRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "database", "createMetaData", "Lcom/intellij/database/dialects/base/introspector/jdbc/wrappers/DatabaseMetaDataWrapper;", "createSchemaRetriever", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractSchemaRetriever;", "schema", "introspectNamespacesInTran", "tran", "introspectSchemasAuto", "schemas", "whole", "", "retrieveAndApplySchemas", "DynamoDatabaseRetriever", "DynamoSchemaRetriever", "Factory", "intellij.database.dialects.dynamo"})
public final class DynamoIntrospector
extends BaseSingleDatabaseIntrospector<DynamoRoot, DynamoSchema> {
    public DynamoIntrospector(@NotNull DBIntrospectionContext context, @NotNull ModelFactory modelFactory) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)modelFactory, (String)"modelFactory");
        BaseIntrospector.Nature nature = BaseIntrospector.DefaultNature.INSTANCE;
        Dbms dbms = DynamoDbms.DYNAMO;
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"DYNAMO");
        super(context, nature, dbms, modelFactory);
    }

    private final DatabaseMetaDataWrapper createMetaData() {
        DatabaseConnectionCore connection2;
        DatabaseConnectionCore databaseConnectionCore = connection2 = this.getDbConnection();
        if (databaseConnectionCore != null) {
            DatabaseMetaDataWrapper databaseMetaDataWrapper;
            DatabaseConnectionCore it2 = databaseConnectionCore;
            boolean bl = false;
            try {
                RemoteDatabaseMetaData remoteDatabaseMetaData = connection2.getRemoteMetaData();
                if (remoteDatabaseMetaData == null) {
                    throw new DynamoIntrospectionException("Connection#getMetaData() returns null. No introspection could be performed", null, 2, null);
                }
                RemoteDatabaseMetaData remoteDatabaseMetaData2 = remoteDatabaseMetaData;
                Intrinsics.checkNotNull((Object)remoteDatabaseMetaData2);
                RemoteDatabaseMetaData metaData = remoteDatabaseMetaData2;
                databaseMetaDataWrapper = DatabaseMetaDataWrapper.create(connection2, metaData).withErrorSink(this.getErrorSink());
                Intrinsics.checkNotNull((Object)databaseMetaDataWrapper);
            }
            catch (SQLException e2) {
                throw new DynamoIntrospectionException("Failed to retrieve meta data", e2);
            }
            return databaseMetaDataWrapper;
        }
        throw new DynamoIntrospectionException("Failed to get connection", null, 2, null);
    }

    @Override
    public void retrieveAndApplySchemas() {
        this.inTransactionUnit((Function1<DBTransaction, Unit>)((Function1)new Function1<DBTransaction, Unit>(this){
            final /* synthetic */ DynamoIntrospector this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull DBTransaction it2) {
                Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                this.this$0.introspectNamespacesInTran(it2);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void introspectNamespacesInTran(@NotNull DBTransaction tran) {
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
        Closeable closeable = this.createMetaData().databases();
        Throwable throwable = null;
        try {
            ClosableIt it2 = (ClosableIt)closeable;
            boolean bl = false;
            List list = it2.toList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"toList(...)");
            this.applySchemas(list);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final void applySchemas(List<String> newSchemas) {
        this.inModel((Function1)new Function1<DynamoRoot, Unit>(newSchemas){
            final /* synthetic */ List<String> $newSchemas;
            {
                this.$newSchemas = $newSchemas;
                super(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public final void invoke(@NotNull DynamoRoot root2) {
                void $this$iv$iv$iv;
                void $this$applySchemasNamed$iv$iv;
                void $this$applySchemasNamed$iv;
                Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
                NamingFamily namingFamily = root2.getSchemas();
                Intrinsics.checkNotNullExpressionValue((Object)namingFamily, (String)"getSchemas(...)");
                NamingFamily namingFamily2 = namingFamily;
                List<String> scs$iv = this.$newSchemas;
                boolean $i$f$applySchemasNamed = false;
                void var5_5 = $this$applySchemasNamed$iv;
                ElementSearchCache searchCache$iv$iv = new ElementSearchCache();
                boolean $i$f$applySchemasNamed2 = false;
                FamilySearcher<T, D> familySearcher = ElementCacheOptimizersKt.byName(ElementCacheKt.searchElement(searchCache$iv$iv), (Function1)new Function1<String, String>(){

                    /*
                     * Ignored method signature, as it can't be verified against descriptor
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final String invoke(Object $this$byName) {
                        void var2_2;
                        String it2 = (String)$this$byName;
                        boolean bl = false;
                        return var2_2;
                    }
                }).inFamily((Family)$this$applySchemasNamed$iv$iv);
                Function2 filler$iv$iv$iv = applySchemas$1$invoke$$inlined$applySchemasNamed$2.INSTANCE;
                boolean $i$f$orCreateBulk = false;
                ArrayList<E> items$iv$iv$iv = new ArrayList<E>();
                ElementSearcherNN<T, void> searcher$iv$iv$iv = ElementCacheKt.orCreateElement((ElementSearcher)$this$iv$iv$iv, (Function1)new Function1<D, T>((FamilySearcher)$this$iv$iv$iv, filler$iv$iv$iv, items$iv$iv$iv){
                    final /* synthetic */ FamilySearcher this$0;
                    final /* synthetic */ Function2 $filler;
                    final /* synthetic */ ArrayList $items;
                    {
                        this.this$0 = $receiver;
                        this.$filler = $filler;
                        this.$items = $items;
                        super(1);
                    }

                    @NotNull
                    public final T invoke(D it2) {
                        T t = BasicMetaUtils.getMetaObject(this.this$0.getFamily()).newDataObject();
                        FamilySearcher familySearcher = this.this$0;
                        Function2 function2 = this.$filler;
                        ArrayList arrayList = this.$items;
                        T $this$invoke_u24lambda_u240 = t;
                        boolean bl = false;
                        Intrinsics.checkNotNull($this$invoke_u24lambda_u240);
                        familySearcher.fillImpl($this$invoke_u24lambda_u240, it2, function2);
                        ((Collection)arrayList).add($this$invoke_u24lambda_u240);
                        T t2 = t;
                        Intrinsics.checkNotNullExpressionValue(t2, (String)"apply(...)");
                        return t2;
                    }
                });
                try {
                    ElementSearcherNN<T, void> schemas$iv$iv = searcher$iv$iv$iv;
                    boolean bl = false;
                    void $this$applySchemasImpl$iv$iv$iv = $this$applySchemasNamed$iv$iv;
                    boolean $i$f$applySchemasImpl = false;
                    $this$applySchemasImpl$iv$iv$iv.markChildrenAsSyncPending();
                    Iterable $this$forEach$iv$iv$iv$iv = scs$iv;
                    boolean $i$f$forEach = false;
                    Iterator<T> iterator = $this$forEach$iv$iv$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        void sc$iv$iv;
                        T element$iv$iv$iv$iv;
                        T sc$iv$iv$iv = element$iv$iv$iv$iv = iterator.next();
                        boolean bl2 = false;
                        T t = sc$iv$iv$iv;
                        void $this$applySchemasNamed_u24lambda_u249_u24lambda_u248$iv$iv = $this$applySchemasImpl$iv$iv$iv;
                        boolean bl3 = false;
                        BasicModMateNamespace $this$applySchemasNamed_u24lambda_u249_u24lambda_u248_u24lambda_u247$iv$iv = (BasicModMateNamespace)schemas$iv$iv.find(sc$iv$iv);
                        boolean bl4 = false;
                        String string = (String)sc$iv$iv;
                        DynamoSchema $this$invoke_u24lambda_u241 = (DynamoSchema)$this$applySchemasNamed_u24lambda_u249_u24lambda_u248_u24lambda_u247$iv$iv;
                        boolean bl5 = false;
                    }
                    $this$applySchemasImpl$iv$iv$iv.removeSyncPendingChildren();
                    $this$applySchemasImpl$iv$iv$iv.sort();
                }
                finally {
                    Family<T> family = $this$iv$iv$iv.getFamily();
                    Intrinsics.checkNotNull(family, (String)"null cannot be cast to non-null type com.intellij.database.model.families.Family<T of com.intellij.database.model.FamilySearcher>");
                    BaseModel.createBulk(family, (Iterable)items$iv$iv$iv);
                }
            }
        });
    }

    @Override
    protected void introspectSchemasAuto(@NotNull DBTransaction tran, @NotNull List<? extends DynamoSchema> schemas2, boolean whole) {
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
        Intrinsics.checkNotNullParameter(schemas2, (String)"schemas");
        for (DynamoSchema dynamoSchema : schemas2) {
            this.handleErrors("Introspect schema " + dynamoSchema.getName(), (Function0<Unit>)((Function0)new Function0<Unit>(this, tran, dynamoSchema){
                final /* synthetic */ DynamoIntrospector this$0;
                final /* synthetic */ DBTransaction $tran;
                final /* synthetic */ DynamoSchema $schema;
                {
                    this.this$0 = $receiver;
                    this.$tran = $tran;
                    this.$schema = $schema;
                    super(0);
                }

                public final void invoke() {
                    BaseNativeIntrospector.AbstractSchemaRetriever<? extends DynamoSchema> retriever = this.this$0.createSchemaRetriever(this.$tran, this.$schema);
                    retriever.process();
                }
            }));
        }
    }

    @Override
    @NotNull
    protected BaseNativeIntrospector.AbstractSchemaRetriever<? extends DynamoSchema> createSchemaRetriever(@NotNull DBTransaction transaction, @NotNull DynamoSchema schema2) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)schema2, (String)"schema");
        return new DynamoSchemaRetriever(this, transaction, schema2);
    }

    @Override
    @NotNull
    protected BaseNativeIntrospector.AbstractDatabaseRetriever<? extends DynamoRoot> createDatabaseRetriever(@NotNull DBTransaction transaction, @NotNull DynamoRoot database) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        return new DynamoDatabaseRetriever(transaction);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u0018\u0012\u0004\u0012\u0002H\u00010\u0003R\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00050\u0004B\r\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/dialects/dynamo/introspector/DynamoIntrospector$DynamoDatabaseRetriever;", "R", "Lcom/intellij/database/dialects/dynamo/model/DynamoRoot;", "Lcom/intellij/database/dialects/base/introspector/BaseSingleDatabaseIntrospector$BaseDatabaseRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseSingleDatabaseIntrospector;", "Lcom/intellij/database/dialects/dynamo/model/DynamoSchema;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "(Lcom/intellij/database/dialects/dynamo/introspector/DynamoIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;)V", "process", "", "intellij.database.dialects.dynamo"})
    private final class DynamoDatabaseRetriever<R extends DynamoRoot>
    extends BaseSingleDatabaseIntrospector.BaseDatabaseRetriever<R> {
        public DynamoDatabaseRetriever(DBTransaction transaction) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            super(DynamoIntrospector.this, transaction);
        }

        @Override
        public void process() {
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u001e\u0012\u0004\u0012\u0002H\u00010\u0003R\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\u0004B\u0015\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\tJ:\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2 \u0010\u000e\u001a\u001c\u0012\u0004\u0012\u00020\u0010\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f\u0018\u00010\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001d\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u0016\u001a\u00020\u000bH\u0016J\b\u0010\u0017\u001a\u00020\u000bH\u0002J\u0018\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002\u00a8\u0006\u001e"}, d2={"Lcom/intellij/database/dialects/dynamo/introspector/DynamoIntrospector$DynamoSchemaRetriever;", "S", "Lcom/intellij/database/dialects/dynamo/model/DynamoSchema;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractSchemaRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector;", "Lcom/intellij/database/dialects/dynamo/model/DynamoRoot;", "tran", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "schema", "(Lcom/intellij/database/dialects/dynamo/introspector/DynamoIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/dynamo/model/DynamoSchema;)V", "applyIndices", "", "table", "Lcom/intellij/database/dialects/dynamo/model/DynamoTable;", "indexes", "", "", "", "isGlobal", "", "isPossibleToIntrospectSchemaIncrementally", "(Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/dynamo/model/DynamoSchema;)Z", "process", "retrieveTableData", "connection", "Lcom/intellij/database/remote/jdbc/RemoteDynamoConnection;", "Lcom/intellij/database/model/basic/BasicModElement;", "retrieveTables", "metaData", "Lcom/intellij/database/dialects/base/introspector/jdbc/wrappers/DatabaseMetaDataWrapper;", "intellij.database.dialects.dynamo"})
    @SourceDebugExtension(value={"SMAP\nDynamoIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DynamoIntrospector.kt\ncom/intellij/database/dialects/dynamo/introspector/DynamoIntrospector$DynamoSchemaRetriever\n+ 2 BaseIntrospectionFunctions.kt\ncom/intellij/database/dialects/base/introspector/BaseIntrospectionFunctions\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,234:1\n198#2,13:235\n198#2,13:248\n198#2,7:261\n206#2,5:269\n198#2,13:274\n1#3:268\n*S KotlinDebug\n*F\n+ 1 DynamoIntrospector.kt\ncom/intellij/database/dialects/dynamo/introspector/DynamoIntrospector$DynamoSchemaRetriever\n*L\n124#1:235,13\n150#1:248,13\n162#1:261,7\n162#1:269,5\n174#1:274,13\n*E\n"})
    private static final class DynamoSchemaRetriever<S extends DynamoSchema>
    extends BaseNativeIntrospector.AbstractSchemaRetriever<S> {
        final /* synthetic */ DynamoIntrospector this$0;

        public DynamoSchemaRetriever(@NotNull DBTransaction tran, S schema2) {
            Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
            Intrinsics.checkNotNullParameter(schema2, (String)"schema");
            this.this$0 = this$0;
            super((BaseNativeIntrospector)this$0, tran, (BasicModSchema)schema2);
        }

        @Override
        public boolean isPossibleToIntrospectSchemaIncrementally(@NotNull DBTransaction tran, @NotNull S schema2) {
            Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
            Intrinsics.checkNotNullParameter(schema2, (String)"schema");
            return false;
        }

        @Override
        public void process() {
            DatabaseMetaDataWrapper metaData = this.this$0.createMetaData();
            this.inSchema((Function1)new Function1<S, Unit>(this, metaData){
                final /* synthetic */ DynamoSchemaRetriever<S> this$0;
                final /* synthetic */ DatabaseMetaDataWrapper $metaData;
                {
                    this.this$0 = $receiver;
                    this.$metaData = $metaData;
                    super(1);
                }

                public final void invoke(@NotNull S it2) {
                    Intrinsics.checkNotNullParameter(it2, (String)"it");
                    DynamoSchemaRetriever.access$retrieveTables(this.this$0, this.$metaData);
                }
            });
            this.inSchema((Function1)new Function1<S, Unit>(this){
                final /* synthetic */ DynamoSchemaRetriever<S> this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull S it2) {
                    Intrinsics.checkNotNullParameter(it2, (String)"it");
                    DynamoSchemaRetriever.access$retrieveTableData(this.this$0);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private final void retrieveTables(DatabaseMetaDataWrapper metaData) {
            void families$iv;
            ObjectKind objectKind = ObjectKind.TABLE;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"TABLE");
            this.this$0.reportRetrieving(objectKind);
            ModFamily[] modFamilyArray = new ModFamily[1];
            Intrinsics.checkNotNullExpressionValue(((DynamoSchema)this.getSchema()).getTables(), (String)"getTables(...)");
            boolean inc$iv = true;
            boolean $i$f$modifyFamiliesAndCleanup = false;
            for (void f$iv : families$iv) {
                f$iv.markChildrenAsSyncPending();
            }
            boolean bl = false;
            ElementChecker elementChecker = ElementCacheOptimizersKt.byName(this.searchInSchema(), retrieveTables.1.nameSearcher.1.INSTANCE);
            ModNamingFamily<? extends DynamoTable> modNamingFamily = ((DynamoSchema)this.getSchema()).getTables();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getTables(...)");
            ElementSearcherNN nameSearcher2 = elementChecker.inFamily((Family)modNamingFamily).orCreate(retrieveTables.1.nameSearcher.2.INSTANCE);
            Closeable closeable = metaData.tables(new DatabaseMetaDataWrapper.Schema(((DynamoSchema)this.getSchema()).getName(), null), null, null);
            Throwable throwable = null;
            try {
                ClosableIt retrievedTables = (ClosableIt)closeable;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)retrievedTables);
                ClosableIt closableIt = retrievedTables;
                while (closableIt.hasNext()) {
                    DatabaseMetaDataWrapper.Table table = (DatabaseMetaDataWrapper.Table)closableIt.next();
                    Intrinsics.checkNotNull((Object)table);
                    nameSearcher2.find(table);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            for (void f$iv : families$iv) {
                f$iv.removeSyncPendingChildren();
                f$iv.sort();
            }
        }

        private final void retrieveTableData() {
            RemoteConnection connection2;
            DatabaseConnectionCore databaseConnectionCore = this.this$0.getDbConnection();
            Object object = connection2 = databaseConnectionCore != null ? databaseConnectionCore.getRemoteConnection() : null;
            if (!(connection2 instanceof RemoteDynamoConnection)) {
                return;
            }
            for (DynamoTable dynamoTable : ((DynamoSchema)this.getSchema()).getTables()) {
                RemoteDynamoConnection remoteDynamoConnection = (RemoteDynamoConnection)connection2;
                Intrinsics.checkNotNull((Object)dynamoTable);
                this.retrieveTableData(remoteDynamoConnection, dynamoTable);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveTableData(RemoteDynamoConnection connection2, BasicModElement table) {
            block16: {
                String sortColumn;
                Object types2;
                if (!(table instanceof DynamoTable)) {
                    return;
                }
                Map map2 = connection2.describeTable(((DynamoTable)table).getName());
                if (map2 == null) {
                    map2 = MapsKt.emptyMap();
                }
                Map desc = map2;
                ModFamily[] modFamilyArray = new ModFamily[1];
                Intrinsics.checkNotNullExpressionValue((Object)((DynamoTable)table).getColumns(), (String)"getColumns(...)");
                ModFamily[] families$iv = modFamilyArray;
                boolean inc$iv = true;
                boolean bl = false;
                for (ModFamily f$iv : families$iv) {
                    f$iv.markChildrenAsSyncPending();
                }
                boolean bl2 = false;
                Object v2 = desc.get("ATTRIBUTE_NAMES");
                String[] names2 = v2 instanceof String[] ? (String[])v2 : null;
                Object v3 = desc.get("ATTRIBUTE_TYPES");
                String[] stringArray = types2 = v3 instanceof String[] ? (String[])v3 : null;
                if (names2 != null && types2 != null && names2.length == ((String[])types2).length) {
                    int n = names2.length;
                    for (int i2 = 0; i2 < n; ++i2) {
                        DynamoTableColumn column2 = (DynamoTableColumn)((DynamoTable)table).getColumns().createOrGet(names2[i2]);
                        column2.setPosition((short)(i2 + 1));
                        DataType dataType = DataTypeFactory.of(types2[i2]);
                        Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"of(...)");
                        column2.setStoredType(DasUnresolvedTypeReference.Companion.of(dataType));
                    }
                }
                for (ModFamily f$iv : families$iv) {
                    f$iv.removeSyncPendingChildren();
                    f$iv.sort();
                }
                families$iv = new ModFamily[1];
                Intrinsics.checkNotNullExpressionValue((Object)((DynamoTable)table).getKeys(), (String)"getKeys(...)");
                boolean inc$iv42 = true;
                boolean bl3 = false;
                for (ModFamily f$iv : families$iv) {
                    f$iv.markChildrenAsSyncPending();
                }
                int n = 0;
                types2 = desc.get("HASH_KEY");
                String partitionColumn = types2 instanceof String ? (String)types2 : null;
                Object i2 = desc.get("SORT_KEY");
                String string = sortColumn = i2 instanceof String ? (String)i2 : null;
                if (partitionColumn != null) {
                    BasicNameReference basicNameReference;
                    DynamoKey key2 = (DynamoKey)((DynamoTable)table).getKeys().createOrGet("primary key");
                    key2.setPartitionColumnRef(BasicNameReference.create(partitionColumn));
                    DynamoKey dynamoKey = key2;
                    String string2 = sortColumn;
                    if (string2 != null) {
                        void it2;
                        String string3 = string2;
                        DynamoKey dynamoKey2 = dynamoKey;
                        boolean bl22 = false;
                        basicNameReference = BasicNameReference.create((String)it2);
                        dynamoKey = dynamoKey2;
                    } else {
                        basicNameReference = null;
                    }
                    dynamoKey.setSortColumnRef(basicNameReference);
                }
                for (ModFamily f$iv : families$iv) {
                    f$iv.removeSyncPendingChildren();
                    f$iv.sort();
                }
                Object inc$iv42 = desc.get("LOCAL_INDEXES_KEY");
                Map localIndices2 = inc$iv42 instanceof Map ? (Map)inc$iv42 : null;
                Object v4 = desc.get("GLOBAL_INDEXES_KEY");
                Map globalIndices2 = v4 instanceof Map ? (Map)v4 : null;
                ModFamily[] modFamilyArray2 = new ModFamily[1];
                Intrinsics.checkNotNullExpressionValue((Object)((DynamoTable)table).getIndices(), (String)"getIndices(...)");
                ModFamily[] modFamilyArray3 = modFamilyArray2;
                boolean inc$iv3 = true;
                boolean $i$f$modifyFamiliesAndCleanup3 = false;
                for (ModFamily f$iv : modFamilyArray3) {
                    f$iv.markChildrenAsSyncPending();
                }
                boolean bl32 = false;
                if (localIndices2 != null || globalIndices2 != null) {
                    this.applyIndices((DynamoTable)table, localIndices2, false);
                    this.applyIndices((DynamoTable)table, globalIndices2, true);
                }
                for (ModFamily f$iv : modFamilyArray3) {
                    f$iv.removeSyncPendingChildren();
                    f$iv.sort();
                }
                Object v5 = desc.get("READ_CAPACITY_UNITS");
                Long l = v5 instanceof Long ? (Long)v5 : null;
                if (l != null) {
                    long it3 = ((Number)l).longValue();
                    boolean bl4 = false;
                    ((DynamoTable)table).setReadThroughput(it3);
                }
                v5 = desc.get("WRITE_CAPACITY_UNITS");
                Long l2 = v5 instanceof Long ? (Long)v5 : null;
                if (l2 != null) {
                    long it4 = ((Number)l2).longValue();
                    boolean bl5 = false;
                    ((DynamoTable)table).setWriteThroughput(it4);
                }
                v5 = desc.get("TABLE_CLASS");
                String string4 = v5 instanceof String ? (String)v5 : null;
                if (string4 == null) break block16;
                String it5 = string4;
                boolean bl6 = false;
                ((DynamoTable)table).setTableClass(DynamoTableClass.valueOf(it5));
            }
        }

        /*
         * Unable to fully structure code
         */
        private final void applyIndices(DynamoTable table, Map<String, ? extends Map<String, ? extends Object>> indexes, boolean isGlobal) {
            if (indexes == null) {
                return;
            }
            for (Map.Entry<String, ? extends Map<String, ? extends Object>> var5_5 : indexes.entrySet()) {
                block14: {
                    block12: {
                        block13: {
                            name = var5_5.getKey();
                            indexDesc = var5_5.getValue();
                            var9_9 = indexDesc.get("HASH_KEY");
                            partitionColumn = var9_9 instanceof String != false ? (String)var9_9 : null;
                            var10_10 = indexDesc.get("SORT_KEY");
                            v0 = sortColumn = var10_10 instanceof String != false ? (String)var10_10 : null;
                            if (partitionColumn == null) continue;
                            index = (DynamoIndex)table.getIndices().createOrGet(name);
                            index.setPartitionColumnRef(BasicNameReference.create(partitionColumn));
                            v1 = index;
                            v2 = sortColumn;
                            if (v2 != null) {
                                var12_12 = v2;
                                var14_15 = v1;
                                $i$a$-let-DynamoIntrospector$DynamoSchemaRetriever$applyIndices$1 = false;
                                v3 = BasicNameReference.create((String)it);
                                v1 = var14_15;
                            } else {
                                v3 = null;
                            }
                            v1.setSortColumnRef(v3);
                            var12_12 = indexDesc.get("INDEX_PROJECTION_TYPE");
                            projectionType = var12_12 instanceof String != false ? (String)var12_12 : null;
                            var12_12 = projectionType;
                            if (var12_12 == null) break block12;
                            switch (var12_12.hashCode()) {
                                case 64897: {
                                    if (!var12_12.equals("ALL")) {
                                        ** break;
                                    }
                                    break block13;
                                }
                                case -1634410360: {
                                    if (var12_12.equals("INCLUDE")) break;
                                    ** break;
                                }
                                case 1724531479: {
                                    if (!var12_12.equals("KEYS_ONLY")) ** break;
                                    v4 = DynamoIndexProjectionType.KEYS_ONLY;
                                    break block14;
                                }
                            }
                            v4 = DynamoIndexProjectionType.INCLUDE;
                            break block14;
                        }
                        v4 = DynamoIndexProjectionType.ALL;
                        break block14;
                    }
                    v4 = DynamoIndexProjectionType.KEYS_ONLY;
                }
                index.setProjectionType(v4);
                var13_13 = indexDesc.get("INDEX_PROJECTION_ATTRIBUTES");
                v5 = var13_13 instanceof List != false ? (List)var13_13 : null;
                if (v5 == null) {
                    v5 = CollectionsKt.emptyList();
                }
                index.setProjectedColumnNames(v5);
                index.setGlobal(isGlobal);
                if (isGlobal) {
                    var13_13 = indexDesc.get("READ_CAPACITY_UNITS");
                    v6 = var13_13 instanceof Long != false ? (Long)var13_13 : null;
                    index.setReadThroughput(v6 != null ? v6 : -1L);
                    var13_13 = indexDesc.get("WRITE_CAPACITY_UNITS");
                    v7 = var13_13 instanceof Long != false ? (Long)var13_13 : null;
                    index.setWriteThroughput(v7 != null ? v7 : -1L);
                    continue;
                }
                index.setReadThroughput(0L);
                index.setWriteThroughput(0L);
            }
        }

        public static final /* synthetic */ void access$retrieveTables(DynamoSchemaRetriever $this, DatabaseMetaDataWrapper metaData) {
            $this.retrieveTables(metaData);
        }

        public static final /* synthetic */ void access$retrieveTableData(DynamoSchemaRetriever $this) {
            $this.retrieveTableData();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/database/dialects/dynamo/introspector/DynamoIntrospector$Factory;", "Lcom/intellij/database/introspection/DBIntrospector$Factory;", "()V", "createIntrospector", "Lcom/intellij/database/introspection/DBIntrospector;", "context", "Lcom/intellij/database/introspection/DBIntrospectionContext;", "dbms", "Lcom/intellij/database/Dbms;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "getVersion", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "isOutdatedCheckSupported", "", "e", "Lcom/intellij/database/model/basic/BasicElement;", "isSupported", "version", "Lcom/intellij/database/util/Version;", "VERSION", "intellij.database.dialects.dynamo"})
    public static final class Factory
    implements DBIntrospector.Factory {
        @Override
        public boolean isSupported(@NotNull Version version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            return true;
        }

        @Override
        @NotNull
        public DBIntrospector createIntrospector(@NotNull DBIntrospectionContext context, @NotNull Dbms dbms, @NotNull ModelFactory modelFactory) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
            Intrinsics.checkNotNullParameter((Object)modelFactory, (String)"modelFactory");
            return new DynamoIntrospector(context, modelFactory);
        }

        @Override
        public int getVersion(@NotNull ObjectKind kind) {
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            return VERSION.INSTANCE.get(kind);
        }

        @Override
        public boolean isOutdatedCheckSupported(@Nullable BasicElement e2) {
            return false;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/database/dialects/dynamo/introspector/DynamoIntrospector$Factory$VERSION;", "Lcom/intellij/database/model/PerObjectVersion;", "()V", "intellij.database.dialects.dynamo"})
        public static final class VERSION
        extends PerObjectVersion {
            @NotNull
            public static final VERSION INSTANCE = new VERSION();

            private VERSION() {
            }
        }
    }
}

