/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.derby.plan;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.statements.BarrenStatement;
import com.intellij.database.dataSource.connection.statements.SmartStatementFactoryService;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.dialects.base.plan.AbstractExplainPlanProvider;
import com.intellij.database.dialects.base.plan.AbstractPlanModelBuilder;
import com.intellij.database.plan.ExplainPlanProvider;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.Version;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DerbyExplainPlanProvider
extends AbstractExplainPlanProvider {
    public DerbyExplainPlanProvider() {
        super(Dbms.DERBY);
    }

    @Override
    @Nullable
    public AbstractPlanModelBuilder<?, ?> createBuilder(@NotNull Version version, boolean run2) {
        if (version == null) {
            DerbyExplainPlanProvider.$$$reportNull$$$0(0);
        }
        return null;
    }

    @Override
    public boolean isSupported(@NotNull Version version, boolean run2) {
        if (version == null) {
            DerbyExplainPlanProvider.$$$reportNull$$$0(1);
        }
        return false;
    }

    @Override
    @Nullable
    public ExplainPlanProvider.RawExplainTask createRawExplainTask(@NotNull LocalDataSource dataSource2, final boolean analyze) {
        if (dataSource2 == null) {
            DerbyExplainPlanProvider.$$$reportNull$$$0(2);
        }
        return new ExplainPlanProvider.RawExplainTask(){

            @Override
            public DdlBuilder sqlExplainPlan(@NotNull DdlBuilder builder, @NotNull String statement2) throws UnsupportedOperationException, IllegalArgumentException {
                if (builder == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (statement2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                builder.plain("CALL SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)").newStatement();
                if (!analyze) {
                    builder.plain("CALL SYSCS_UTIL.SYSCS_SET_XPLAIN_MODE(1)").newStatement();
                }
                builder.plain(statement2).newStatement();
                builder.plain("CALL SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(0)").newStatement();
                builder.plain("VALUES SYSCS_UTIL.SYSCS_GET_RUNTIMESTATISTICS()");
                return builder;
            }

            @Override
            @NotNull
            public DataRequest.RawRequest sqlPostExplainPlan(@NotNull DataRequest.OwnerEx owner) throws UnsupportedOperationException, IllegalArgumentException {
                if (owner == null) {
                    1.$$$reportNull$$$0(2);
                }
                return new DataRequest.RawRequest(owner){

                    @Override
                    public void processRaw(DataRequest.Context context, DatabaseConnectionCore connection2) throws Exception {
                        BarrenStatement.QuietBarrenStatement<String> stmt2 = SmartStatementFactoryService.getInstance().poweredBy(connection2).simple().barren().quiet();
                        stmt2.execute("CALL SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(0)");
                        if (!analyze) {
                            stmt2.execute("CALL SYSCS_UTIL.SYSCS_SET_XPLAIN_MODE(0)");
                        }
                    }
                };
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "builder";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "statement";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "owner";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/dialects/derby/plan/DerbyExplainPlanProvider$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "sqlExplainPlan";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "sqlPostExplainPlan";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/dialects/derby/plan/DerbyExplainPlanProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createBuilder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isSupported";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createRawExplainTask";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

