/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.db2.plan;

import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.connection.statements.ReusableNoisyStatement;
import com.intellij.database.dataSource.connection.statements.ReusableSmartStatement;
import com.intellij.database.dataSource.connection.statements.StandardResultsProcessors;
import com.intellij.database.dialects.base.plan.AbstractPlanModelBuilder;
import com.intellij.database.dialects.base.plan.RawPlanData;
import com.intellij.database.dialects.db2.plan.Db2BuilderState;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.plan.PlanRetrievalException;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.script.generator.NamingServices;
import com.intellij.util.Functions;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.JBIterable;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Db2RawPlanData
extends RawPlanData {
    public final Map<Db2BuilderState.NodeId, Db2BuilderState.Stream> streamBySourceId = new HashMap<Db2BuilderState.NodeId, Db2BuilderState.Stream>();
    public final Map<Db2BuilderState.NodeId, List<Db2BuilderState.Stream>> streamsByTargetId = new HashMap<Db2BuilderState.NodeId, List<Db2BuilderState.Stream>>();
    public final Int2ObjectMap<Db2BuilderState.Operator> operatorById = new Int2ObjectOpenHashMap();
    public final Map<Db2BuilderState.ObjectId, Db2BuilderState.Obj> objectById = new HashMap<Db2BuilderState.ObjectId, Db2BuilderState.Obj>();

    @Override
    public void load(final @NotNull DatabaseConnectionCore connection2, final @NotNull String statement2, boolean run2) {
        if (connection2 == null) {
            Db2RawPlanData.$$$reportNull$$$0(0);
        }
        if (statement2 == null) {
            Db2RawPlanData.$$$reportNull$$$0(1);
        }
        Db2RawPlanData.useStatementWithPreserved(connection2, (RawPlanData.ResourceUser<? super ReusableSmartStatement<String>>)new RawPlanData.ResourceUser<ReusableSmartStatement<String>>(){

            @Override
            public void use(ReusableSmartStatement<String> s2) throws PlanRetrievalException, SQLException {
                String uuid = AbstractPlanModelBuilder.randomShorterUUID().substring(0, 20);
                s2.barren().execute((CallSite)((Object)("EXPLAIN PLAN SET QUERYTAG = '" + uuid + "' FOR " + statement2)));
                String schema2 = s2.noisy().execute("select case when 4 = (select count(TABNAME) from SYSCAT.TABLES where TABSCHEMA = current_user and  TABNAME in ('EXPLAIN_STATEMENT', 'EXPLAIN_STREAM', 'EXPLAIN_OPERATOR', 'EXPLAIN_OBJECT')) then current_user else 'SYSTOOLS' end from sysibm.SYSDUMMY1", StandardResultsProcessors.FIRST_STRING);
                NamingService ns = NamingServices.getNamingService(connection2.getDbms());
                this.extractPlan((ReusableNoisyStatement<String>)s2.noisy(), ns.catToScript(schema2, ObjectKind.SCHEMA), uuid);
            }

            private void extractPlan(ReusableNoisyStatement<String> noisy, String schema2, String uuid) throws SQLException {
                noisy.execute("SELECT STREAM_ID, SOURCE_TYPE, SOURCE_ID, TARGET_TYPE, TARGET_ID, OBJECT_SCHEMA, OBJECT_NAME, STREAM_COUNT, PREDICATE_ID\nFROM " + schema2 + ".EXPLAIN_STATEMENT es\n  JOIN " + schema2 + ".EXPLAIN_STREAM ess\n    ON es.STMTNO = ess.STMTNO\n       AND es.SECTNO = ess.SECTNO\n       AND es.EXPLAIN_TIME = ess.EXPLAIN_TIME\n       AND es.EXPLAIN_LEVEL = ess.EXPLAIN_LEVEL\n  WHERE QUERYTAG = '" + uuid + "'", Db2RawPlanData.processing((ThrowableConsumer<? super RemoteResultSet, ? extends Exception>)rs -> Db2RawPlanData.this.extractStreams((RemoteResultSet)rs)));
                noisy.execute("SELECT OPERATOR_ID, OPERATOR_TYPE, eos.TOTAL_COST, IO_COST, CPU_COST, FIRST_ROW_COST\nFROM " + schema2 + ".EXPLAIN_STATEMENT es\n  JOIN " + schema2 + ".EXPLAIN_OPERATOR eos\n    ON es.STMTNO = eos.STMTNO\n       AND es.SECTNO = eos.SECTNO\n       AND es.EXPLAIN_TIME = eos.EXPLAIN_TIME\n       AND es.EXPLAIN_LEVEL = eos.EXPLAIN_LEVEL\n  WHERE QUERYTAG = '" + uuid + "'", Db2RawPlanData.processing((ThrowableConsumer<? super RemoteResultSet, ? extends Exception>)rs -> Db2RawPlanData.this.extractOperators((RemoteResultSet)rs)));
                noisy.execute("SELECT OBJECT_SCHEMA, OBJECT_NAME, OBJECT_TYPE\nFROM " + schema2 + ".EXPLAIN_STATEMENT es\n  JOIN " + schema2 + ".EXPLAIN_OBJECT eo\n    ON es.STMTNO = eo.STMTNO\n       AND es.SECTNO = eo.SECTNO\n       AND es.EXPLAIN_TIME = eo.EXPLAIN_TIME\n       AND es.EXPLAIN_LEVEL = eo.EXPLAIN_LEVEL\n       AND es.SOURCE_NAME = eo.SOURCE_NAME\n  WHERE QUERYTAG = '" + uuid + "'", Db2RawPlanData.processing((ThrowableConsumer<? super RemoteResultSet, ? extends Exception>)rs -> Db2RawPlanData.this.extractObjects((RemoteResultSet)rs)));
            }
        }, new RawPlanData.StateSaver[0]);
    }

    private void extractStreams(@Nullable RemoteResultSet resultSet) throws Exception {
        if (resultSet == null) {
            Db2RawPlanData.unsupportedFormat();
        }
        while (resultSet.next()) {
            Db2BuilderState.NodeId tid;
            Db2BuilderState.NodeId sid;
            int id = resultSet.getInt("STREAM_ID");
            String sourceType = resultSet.getString("SOURCE_TYPE");
            int sourceId = resultSet.getInt("SOURCE_ID");
            String targetType = resultSet.getString("TARGET_TYPE");
            int targetId = resultSet.getInt("TARGET_ID");
            String objectSchema = resultSet.getString("OBJECT_SCHEMA");
            String objectName = resultSet.getString("OBJECT_NAME");
            BigDecimal streamCount = resultSet.getBigDecimal("STREAM_COUNT");
            int predicateId = resultSet.getInt("PREDICATE_ID");
            if (sourceType.equals("O")) {
                if (sourceId == -1) {
                    Db2RawPlanData.unsupportedFormat();
                }
                sid = new Db2BuilderState.NodeId(sourceId);
            } else {
                sid = new Db2BuilderState.NodeId(new Db2BuilderState.ObjectId(objectSchema, objectName));
            }
            if (targetType.equals("O")) {
                if (targetId == -1) {
                    Db2RawPlanData.unsupportedFormat();
                }
                tid = new Db2BuilderState.NodeId(targetId);
            } else {
                if (sourceId == -1) {
                    Db2RawPlanData.unsupportedFormat();
                }
                tid = new Db2BuilderState.NodeId(new Db2BuilderState.ObjectId(objectSchema, objectName));
            }
            Db2BuilderState.Stream stream = new Db2BuilderState.Stream(id, streamCount, predicateId, sid, tid);
            List<Db2BuilderState.Stream> streams = this.streamsByTargetId.get(tid);
            if (streams == null) {
                streams = new ArrayList<Db2BuilderState.Stream>(2);
                this.streamsByTargetId.put(tid, streams);
            }
            streams.add(stream);
            this.streamBySourceId.put(sid, stream);
        }
    }

    private void extractOperators(@Nullable RemoteResultSet resultSet) throws Exception {
        if (resultSet == null) {
            Db2RawPlanData.unsupportedFormat();
        }
        while (resultSet.next()) {
            int id = resultSet.getInt("OPERATOR_ID");
            String operatorType = resultSet.getString("OPERATOR_TYPE").trim();
            double totalCost = resultSet.getDouble("TOTAL_COST");
            double ioCost = resultSet.getDouble("IO_COST");
            double cpuCost = resultSet.getDouble("CPU_COST");
            double firstRowCost = resultSet.getDouble("FIRST_ROW_COST");
            Db2BuilderState.Operator operator2 = new Db2BuilderState.Operator(id, operatorType, totalCost, ioCost, cpuCost, firstRowCost);
            this.operatorById.put(id, (Object)operator2);
        }
    }

    private void extractObjects(@Nullable RemoteResultSet resultSet) throws Exception {
        if (resultSet == null) {
            Db2RawPlanData.unsupportedFormat();
        }
        while (resultSet.next()) {
            String objectSchema = resultSet.getString("OBJECT_SCHEMA");
            String objectName = resultSet.getString("OBJECT_NAME");
            String objectType = resultSet.getString("OBJECT_TYPE");
            Db2BuilderState.Obj obj2 = new Db2BuilderState.Obj(new Db2BuilderState.ObjectId(objectSchema, objectName), objectType);
            this.objectById.put(obj2.id, obj2);
        }
    }

    private static void unsupportedFormat() {
        throw new PlanRetrievalException("Database returned plan in unsupported format");
    }

    @Override
    public void load(@NotNull String dump2) {
        if (dump2 == null) {
            Db2RawPlanData.$$$reportNull$$$0(2);
        }
        try {
            JSONObject json = new JSONObject(dump2);
            this.loadObjects(json.getJSONArray("objects"));
            this.loadOperators(json.getJSONArray("operators"));
            this.loadStreams(json.getJSONArray("streams"));
        }
        catch (JSONException e2) {
            throw new PlanRetrievalException("Load failed", e2);
        }
    }

    private void loadStreams(JSONArray streams) throws JSONException {
        this.streamBySourceId.clear();
        this.streamsByTargetId.clear();
        int e2 = streams.length();
        for (int i2 = 0; i2 < e2; ++i2) {
            Db2BuilderState.Stream s2 = Db2RawPlanData.loadStream(streams.getJSONObject(i2));
            this.streamBySourceId.put(s2.sourceId, s2);
            this.streamsByTargetId.computeIfAbsent(s2.targetId, k -> new ArrayList()).add(s2);
        }
    }

    private static Db2BuilderState.Stream loadStream(JSONObject object) throws JSONException {
        return new Db2BuilderState.Stream(object.getInt("id"), new BigDecimal(object.getString("numRows")), object.getInt("predId"), Db2RawPlanData.loadNodeId(object.getJSONObject("sourceId")), Db2RawPlanData.loadNodeId(object.getJSONObject("targetId")));
    }

    private static Db2BuilderState.NodeId loadNodeId(JSONObject object) throws JSONException {
        JSONObject objectId = object.optJSONObject("objectId");
        if (objectId != null) {
            return new Db2BuilderState.NodeId(Db2RawPlanData.loadObjectId(objectId));
        }
        return new Db2BuilderState.NodeId(object.getInt("operatorId"));
    }

    private void loadOperators(JSONArray operators) throws JSONException {
        this.operatorById.clear();
        int e2 = operators.length();
        for (int i2 = 0; i2 < e2; ++i2) {
            Db2BuilderState.Operator op = Db2RawPlanData.loadOperator(operators.getJSONObject(i2));
            this.operatorById.put(op.id, (Object)op);
        }
    }

    private static Db2BuilderState.Operator loadOperator(JSONObject object) throws JSONException {
        return new Db2BuilderState.Operator(object.getInt("id"), object.getString("type"), object.getDouble("totalCost"), object.getDouble("ioCost"), object.getDouble("cpuCost"), object.getDouble("firstRowCost"));
    }

    private void loadObjects(JSONArray objects2) throws JSONException {
        this.objectById.clear();
        int e2 = objects2.length();
        for (int i2 = 0; i2 < e2; ++i2) {
            Db2BuilderState.Obj obj2 = Db2RawPlanData.loadObject(objects2.getJSONObject(i2));
            this.objectById.put(obj2.id, obj2);
        }
    }

    private static Db2BuilderState.Obj loadObject(JSONObject object) throws JSONException {
        return new Db2BuilderState.Obj(Db2RawPlanData.loadObjectId(object.getJSONObject("id")), object.getString("type"));
    }

    @NotNull
    private static Db2BuilderState.ObjectId loadObjectId(JSONObject object) throws JSONException {
        return new Db2BuilderState.ObjectId(object.getString("schema"), object.getString("name"));
    }

    @Override
    public String dump() {
        try {
            JSONObject res2 = new JSONObject();
            res2.put("objects", this.dumpObjects());
            res2.put("operators", this.dumpOperators());
            res2.put("streams", this.dumpStreams());
            return res2.toString(2);
        }
        catch (JSONException e2) {
            throw new PlanRetrievalException("Dump failed", e2);
        }
    }

    @NotNull
    private JSONArray dumpStreams() throws JSONException {
        JSONArray streams = new JSONArray();
        for (Db2BuilderState.Stream s2 : JBIterable.from(this.streamsByTargetId.values()).flatten(Functions.identity()).append(this.streamBySourceId.values()).unique()) {
            streams.put(Db2RawPlanData.dumpStream(s2));
        }
        JSONArray jSONArray = streams;
        if (jSONArray == null) {
            Db2RawPlanData.$$$reportNull$$$0(3);
        }
        return jSONArray;
    }

    @NotNull
    private static JSONObject dumpStream(Db2BuilderState.Stream s2) throws JSONException {
        JSONObject str = new JSONObject();
        str.put("id", s2.id);
        str.put("numRows", s2.numRows);
        str.put("predId", s2.predId);
        str.put("sourceId", Db2RawPlanData.dumpNodeId(s2.sourceId));
        str.put("targetId", Db2RawPlanData.dumpNodeId(s2.targetId));
        JSONObject jSONObject = str;
        if (jSONObject == null) {
            Db2RawPlanData.$$$reportNull$$$0(4);
        }
        return jSONObject;
    }

    @NotNull
    private JSONArray dumpOperators() throws JSONException {
        JSONArray operators = new JSONArray();
        ObjectIterator it2 = this.operatorById.values().iterator();
        while (it2.hasNext()) {
            operators.put(Db2RawPlanData.dumpOperator((Db2BuilderState.Operator)it2.next()));
        }
        JSONArray jSONArray = operators;
        if (jSONArray == null) {
            Db2RawPlanData.$$$reportNull$$$0(5);
        }
        return jSONArray;
    }

    @NotNull
    private static JSONObject dumpOperator(Db2BuilderState.Operator op) throws JSONException {
        JSONObject oper = new JSONObject();
        oper.put("id", op.id);
        oper.put("type", op.type);
        oper.put("totalCost", op.totalCost);
        oper.put("ioCost", op.ioCost);
        oper.put("cpuCost", op.cpuCost);
        oper.put("firstRowCost", op.firstRowCost);
        JSONObject jSONObject = oper;
        if (jSONObject == null) {
            Db2RawPlanData.$$$reportNull$$$0(6);
        }
        return jSONObject;
    }

    private JSONArray dumpObjects() throws JSONException {
        JSONArray objects2 = new JSONArray();
        for (Db2BuilderState.Obj obj2 : this.objectById.values()) {
            objects2.put(Db2RawPlanData.dumpObject(obj2));
        }
        return objects2;
    }

    @NotNull
    private static JSONObject dumpObject(Db2BuilderState.Obj obj2) throws JSONException {
        JSONObject object = new JSONObject();
        object.put("id", Db2RawPlanData.dumpObjectId(obj2.id));
        object.put("type", obj2.type);
        JSONObject jSONObject = object;
        if (jSONObject == null) {
            Db2RawPlanData.$$$reportNull$$$0(7);
        }
        return jSONObject;
    }

    @NotNull
    private static JSONObject dumpObjectId(Db2BuilderState.ObjectId id) throws JSONException {
        JSONObject object = new JSONObject();
        object.put("schema", id.schema);
        object.put("name", id.name);
        JSONObject jSONObject = object;
        if (jSONObject == null) {
            Db2RawPlanData.$$$reportNull$$$0(8);
        }
        return jSONObject;
    }

    @NotNull
    private static JSONObject dumpNodeId(Db2BuilderState.NodeId id) throws JSONException {
        JSONObject object = new JSONObject();
        if (id.operatorId == null) {
            object.put("objectId", Db2RawPlanData.dumpObjectId(id.objectId));
        } else {
            object.put("operatorId", id.operatorId);
        }
        JSONObject jSONObject = object;
        if (jSONObject == null) {
            Db2RawPlanData.$$$reportNull$$$0(9);
        }
        return jSONObject;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dump";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/db2/plan/Db2RawPlanData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/db2/plan/Db2RawPlanData";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpStreams";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpStream";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpOperators";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpOperator";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpObject";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpObjectId";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpNodeId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 7, 8, 9 -> new IllegalStateException(string);
        };
    }
}

