/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.db2;

import com.intellij.database.data.types.BaseDomainRegistry;
import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.DomainRegistry;
import com.intellij.database.data.types.SizeProvider;
import com.intellij.database.data.types.domain.BinaryDomain;
import com.intellij.database.data.types.domain.Cardinality;
import com.intellij.database.data.types.domain.Compatibility;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.FloatDomain;
import com.intellij.database.data.types.domain.FractionDomain;
import com.intellij.database.data.types.domain.IntegerDomain;
import com.intellij.database.data.types.domain.Number2Domain;
import com.intellij.database.data.types.domain.NumberDomain;
import com.intellij.database.data.types.domain.OperationSupport;
import com.intellij.database.data.types.domain.SimpleDomain;
import com.intellij.database.data.types.domain.TextDomain;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Db2Domains
extends BaseDomainRegistry {
    private static final short MAX_DB2_GRAPHIC = 127;
    private static final short MAX_VARGRAPHIC = 16336;
    private static final short MAX_DECIMAL_PRECISION = 31;
    private static final double MIN_DOUBLE = -7.2E75;
    private static final double MAX_DOUBLE = 7.2E75;
    private static final int DB2_MAX_TS_PRECISION = 12;
    private static final int MAX_VARCHAR_LENGTH = 32672;
    private static final int DBCLOB = 0x3FFFFFFF;

    public Db2Domains() {
        this.add(new BinaryDomain("blob", ConversionPoint.BLOB, Integer.MAX_VALUE));
        this.add(new BinaryDomain("binary", ConversionPoint.BLOB, Integer.MAX_VALUE){

            @Override
            @NotNull
            public Compatibility getCompatibility(@NotNull Domain domain) {
                if (domain == null) {
                    1.$$$reportNull$$$0(0);
                }
                Compatibility compatibility = Compatibility.incompatible();
                if (compatibility == null) {
                    1.$$$reportNull$$$0(1);
                }
                return compatibility;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "domain";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/dialects/db2/Db2Domains$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/dialects/db2/Db2Domains$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getCompatibility";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getCompatibility";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        });
        this.add(new BinaryDomain("char for bit data", ConversionPoint.BLOB, Integer.MAX_VALUE));
        this.add(new BinaryDomain("varchar for bit data", ConversionPoint.BLOB, Integer.MAX_VALUE));
        this.add(new IntegerDomain("integer", ConversionPoint.NUMBER, -2.147483648E9, 2.147483647E9).withAliases("int"));
        this.add(new IntegerDomain("smallint", ConversionPoint.NUMBER, -32768.0, 32767.0));
        this.add(new TextDomain("vargraphic", ConversionPoint.TEXT_GRAPHIC, 16336L, TextDomain.Length.mandatory(16336L, true)).withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        this.add(new TextDomain("graphic", ConversionPoint.TEXT_GRAPHIC, 127L, -1L, true, false).withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        this.add(new Number2Domain("decimal", ConversionPoint.BIG_DECIMAL, 31, 31, true));
        this.add(new Number2Domain("numeric", ConversionPoint.BIG_DECIMAL, 31, 31, true));
        this.add(new IntegerDomain("bigint", ConversionPoint.NUMBER, -9.223372036854776E18, 9.223372036854776E18));
        this.add(new FloatDomain("double", ConversionPoint.DOUBLE_PRECISION, -7.2E75, 7.2E75));
        this.add(new FloatDomain("float", ConversionPoint.SINGLE_PRECISION, -7.2E75, 7.2E75));
        this.add(new FloatDomain("real", ConversionPoint.SINGLE_PRECISION, -7.2E75, 7.2E75));
        this.add(new SimpleDomain("date", ConversionPoint.DATE).withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        this.add(new FractionDomain("time", ConversionPoint.TIME, 0, -1, false));
        this.add(new FractionDomain("timestamp", ConversionPoint.TIMESTAMP, 12, -1, true).withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        this.add(new TextDomain("varchar", ConversionPoint.VARCHAR, 32672L, TextDomain.Length.mandatory(32672L, true)));
        this.add(new TextDomain("clob", ConversionPoint.CLOB, Integer.MAX_VALUE, -1L, true, true).withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        this.add(new TextDomain("dbclob", ConversionPoint.CLOB, 0x3FFFFFFFL, -1L, true, true).withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        this.add(new TextDomain("char", ConversionPoint.CHAR, 127L, 1L, true, false).withAliases("character"));
        this.add(new TextDomain("xml", ConversionPoint.XML, Integer.MAX_VALUE).withOperationSupport(OperationSupport.SUPPORTS_NOTHING));
        this.add(new DecfloatDomain(34));
    }

    private static class DecfloatDomain
    extends NumberDomain {
        private static final int DEFAULT_DIGITS = 16;
        private static final int MAX_DIGITS = 34;
        private static final DomainRegistry.Limits LIMITS = new DomainRegistry.Limits(new DomainRegistry.Limit(16, 384, 384), new DomainRegistry.Limit(34, 6143, 6143));
        private final int myDigits;

        protected DecfloatDomain(int digits) {
            super("decfloat", ConversionPoint.DOUBLE_PRECISION, -1.7976931348623157E308, Double.MAX_VALUE);
            this.myDigits = digits;
        }

        @Override
        @NotNull
        public Cardinality cardinality() {
            return new Cardinality.ScalableCardinality(this.myDigits);
        }

        @Override
        @NotNull
        public Domain narrow(@NotNull Domain domain) {
            if (domain == null) {
                DecfloatDomain.$$$reportNull$$$0(0);
            }
            DecfloatDomain decfloatDomain = domain instanceof Number2Domain ? new DecfloatDomain(LIMITS.minParameterValue(((Number2Domain)domain).getMaxPrecision()).intValue()) : (domain instanceof NumberDomain ? new DecfloatDomain(34) : this);
            if (decfloatDomain == null) {
                DecfloatDomain.$$$reportNull$$$0(1);
            }
            return decfloatDomain;
        }

        @Override
        @NotNull
        public Domain narrow(@NotNull SizeProvider provider) {
            if (provider == null) {
                DecfloatDomain.$$$reportNull$$$0(2);
            }
            return new DecfloatDomain(LIMITS.minParameterValue(provider.getSize()).intValue());
        }

        @Override
        @NotNull
        public Compatibility getCompatibility(@NotNull Domain domain) {
            if (domain == null) {
                DecfloatDomain.$$$reportNull$$$0(3);
            }
            Compatibility compatibility = domain instanceof DecfloatDomain ? Compatibility.full(this.cardinality(), domain.getLogicType(), this.getLogicType()) : (domain instanceof Number2Domain || domain instanceof NumberDomain ? Compatibility.compatibleLossy(this.cardinality(), domain.getLogicType(), this.getLogicType()) : Compatibility.incompatible());
            if (compatibility == null) {
                DecfloatDomain.$$$reportNull$$$0(4);
            }
            return compatibility;
        }

        @Override
        @Nullable
        public Object trim(@NotNull Object o2) {
            if (o2 == null) {
                DecfloatDomain.$$$reportNull$$$0(5);
            }
            return o2;
        }

        @Override
        @NotNull
        public String name() {
            String string = super.name() + (this.myDigits == 16 ? "" : String.format("(%s)", this.myDigits));
            if (string == null) {
                DecfloatDomain.$$$reportNull$$$0(6);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 4, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "domain";
                    break;
                }
                case 1: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dialects/db2/Db2Domains$DecfloatDomain";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dialects/db2/Db2Domains$DecfloatDomain";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "narrow";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCompatibility";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "name";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "narrow";
                    break;
                }
                case 1: 
                case 4: 
                case 6: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getCompatibility";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "trim";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 4, 6 -> new IllegalStateException(string);
            };
        }
    }
}

