/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.db2;

import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.connection.EitherKt;
import com.intellij.database.dataSource.connection.statements.CallableStatementBasis;
import com.intellij.database.dataSource.connection.statements.ExecutionMode;
import com.intellij.database.dataSource.connection.statements.ParameterizedStatementDecoration;
import com.intellij.database.dataSource.connection.statements.ReusableSmartStatement;
import com.intellij.database.dataSource.connection.statements.SmartStatementFactory;
import com.intellij.database.dataSource.connection.statements.SmartStatementFactoryService;
import com.intellij.database.dataSource.connection.statements.StandardExecutionMode;
import com.intellij.database.dataSource.connection.statements.StandardResultsProcessors;
import com.intellij.database.dataSource.connection.statements.StatementParameters;
import com.intellij.database.dialects.AbstractDefinitionProvider;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.QNameUtil;
import com.intellij.util.PairConsumer;
import org.jetbrains.annotations.NotNull;

public final class Db2DefinitionProvider
extends AbstractDefinitionProvider {
    private static final String VIEW_STMT = "SELECT VIEW_DEFINITION FROM SYSIBM.VIEWS WHERE TABLE_SCHEMA = ? AND TABLE_NAME = ?";
    private static final String ROUTINE_STMT = "SELECT ROUTINE_DEFINITION FROM SYSIBM.ROUTINES WHERE ROUTINE_SCHEMA = ? AND ROUTINE_NAME = ?";
    private static final String TABLE_STMT1 = "CALL SYSPROC.DB2LK_GENERATE_DDL('-e -td ; -t ' || ?, ?)";
    private static final String TABLE_STMT2 = "SELECT SQL_STMT FROM SYSTOOLS.DB2LOOK_INFO WHERE OP_TOKEN = ?";

    @Override
    public boolean isSupported(@NotNull DasObject object) {
        ObjectKind kind;
        if (object == null) {
            Db2DefinitionProvider.$$$reportNull$$$0(0);
        }
        return (kind = object.getKind()) == ObjectKind.VIEW || kind == ObjectKind.TABLE || kind == ObjectKind.ROUTINE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void fetchSources(@NotNull Iterable<? extends DasObject> objects2, @NotNull DatabaseConnectionCore connection2, @NotNull PairConsumer<DasObject, Object> consumer2) throws Exception {
        if (objects2 == null) {
            Db2DefinitionProvider.$$$reportNull$$$0(1);
        }
        if (connection2 == null) {
            Db2DefinitionProvider.$$$reportNull$$$0(2);
        }
        if (consumer2 == null) {
            Db2DefinitionProvider.$$$reportNull$$$0(3);
        }
        ReusableSmartStatement<ParameterizedStatementDecoration> routineStmt = null;
        ReusableSmartStatement<ParameterizedStatementDecoration> viewStmt = null;
        ReusableSmartStatement<ParameterizedStatementDecoration> tableCall = null;
        ReusableSmartStatement<ParameterizedStatementDecoration> tableStmt = null;
        CallableStatementBasis basis = new StatementParameters().parameter(2, 4).asCallBasis(TABLE_STMT1);
        SmartStatementFactory statements2 = SmartStatementFactoryService.getInstance().poweredBy(connection2);
        try {
            routineStmt = statements2.parameterized().reuse(ROUTINE_STMT);
            viewStmt = statements2.parameterized().reuse(VIEW_STMT);
            tableCall = statements2.call().reuse(basis);
            tableStmt = statements2.parameterized().reuse(TABLE_STMT2);
            for (DasObject dasObject : objects2) {
                ParameterizedStatementDecoration decoration;
                ReusableSmartStatement<ParameterizedStatementDecoration> statement2;
                ObjectKind kind = dasObject.getKind();
                if (kind == ObjectKind.ROUTINE) {
                    ReusableSmartStatement<ParameterizedStatementDecoration> statement22 = routineStmt;
                } else if (kind == ObjectKind.VIEW) {
                    statement2 = viewStmt;
                } else {
                    if (kind != ObjectKind.TABLE) continue;
                    statement2 = tableStmt;
                }
                if (kind == ObjectKind.TABLE) {
                    ParameterizedStatementDecoration data = new StatementParameters().text(QNameUtil.getQualifiedName(dasObject)).asDecoration();
                    Integer token = (Integer)tableCall.noisy().execute(data, (ExecutionMode)StandardExecutionMode.UPDATE, StandardResultsProcessors.parameterRetriever(2));
                    if (token == null) continue;
                    decoration = new StatementParameters().integer(token).asDecoration();
                } else {
                    decoration = new StatementParameters().text(DasUtil.getSchema(dasObject)).text(dasObject.getName()).asDecoration();
                }
                consumer2.consume((Object)dasObject, EitherKt.any(statement2.execute(decoration, (ExecutionMode)StandardExecutionMode.QUERY, StandardResultsProcessors.FIRST_STRING)));
            }
        }
        finally {
            DbImplUtilCore.closeSafe(routineStmt);
            DbImplUtilCore.closeSafe(viewStmt);
            DbImplUtilCore.closeSafe(tableCall);
            DbImplUtilCore.closeSafe(tableStmt);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/dialects/db2/Db2DefinitionProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isSupported";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "fetchSources";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

