/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.cassandra.types;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.types.DasTypeSystemImpl;
import com.intellij.database.dialects.cassandra.types.CassListType;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeCategory;
import com.intellij.openapi.util.text.StringUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\nH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/database/dialects/cassandra/types/CassTypeSystem;", "Lcom/intellij/database/dialects/base/types/DasTypeSystemImpl;", "dbms", "Lcom/intellij/database/Dbms;", "(Lcom/intellij/database/Dbms;)V", "doCreateArrayType", "Lcom/intellij/database/dialects/cassandra/types/CassListType;", "componentType", "Lcom/intellij/database/types/DasType;", "getDefaultTypeName", "", "cat", "Lcom/intellij/database/types/DasTypeCategory;", "getTypeCategoryByName", "typeName", "intellij.database.dialects.cassandra"})
public final class CassTypeSystem
extends DasTypeSystemImpl {
    public CassTypeSystem(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        super(dbms);
    }

    @Override
    @Nullable
    public String getDefaultTypeName(@NotNull DasTypeCategory cat) {
        Intrinsics.checkNotNullParameter((Object)((Object)cat), (String)"cat");
        return switch (WhenMappings.$EnumSwitchMapping$0[cat.ordinal()]) {
            case 1 -> "int";
            case 2 -> "double";
            case 3 -> "text";
            case 4, 5 -> "date";
            case 6 -> "duration";
            default -> super.getDefaultTypeName(cat);
        };
    }

    @Override
    @NotNull
    public DasTypeCategory getTypeCategoryByName(@NotNull String typeName) {
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        String fixed = StringUtil.toUpperCase((String)typeName);
        Intrinsics.checkNotNull((Object)fixed);
        return StringsKt.contains$default((CharSequence)fixed, (CharSequence)"TIMEUUID", (boolean)false, (int)2, null) ? DasTypeCategory.TIMESTAMP : (StringsKt.contains$default((CharSequence)fixed, (CharSequence)"DURATION", (boolean)false, (int)2, null) ? DasTypeCategory.INTERVAL : (StringsKt.contains$default((CharSequence)fixed, (CharSequence)"BLOB", (boolean)false, (int)2, null) ? DasTypeCategory.BYTES : super.getTypeCategoryByName(typeName)));
    }

    @Override
    @NotNull
    protected CassListType doCreateArrayType(@NotNull DasType componentType) {
        Intrinsics.checkNotNullParameter((Object)componentType, (String)"componentType");
        return new CassListType(componentType);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DasTypeCategory.values().length];
            try {
                nArray[DasTypeCategory.INTEGER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.REAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.STRING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.DATE_TIME.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.DATE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.INTERVAL.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

