/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.cassandra.model;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dialects.cassandra.model.CassDefType;
import com.intellij.database.dialects.cassandra.model.CassDefTypeAttribute;
import com.intellij.database.dialects.cassandra.model.CassFunction;
import com.intellij.database.dialects.cassandra.model.CassRole;
import com.intellij.database.dialects.cassandra.model.CassSchema;
import com.intellij.database.dialects.cassandra.model.defaults.CassSchemaPropertyKind;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelHelper;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModArgument;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.types.DasUnresolvedTypeReference;
import com.intellij.util.containers.JBIterable;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0016J\u001f\u0010\u0012\u001a\t\u0018\u00010\u000b\u00a2\u0006\u0002\b\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\rH\u0016J\u0010\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016\u00a8\u0006\u001a"}, d2={"Lcom/intellij/database/dialects/cassandra/model/CassModelHelper;", "Lcom/intellij/database/model/ModelHelper;", "()V", "fillPropertiesWithExamples", "", "e", "Lcom/intellij/database/model/basic/BasicModElement;", "variant", "Lcom/intellij/database/model/ModelHelper$ObjectKindVariant;", "vars", "", "", "modifyParent", "", "generationVariants", "Lcom/intellij/util/containers/JBIterable;", "meta", "Lcom/intellij/database/model/meta/BasicMetaObject;", "getCustomName", "Lorg/jetbrains/annotations/Nls;", "kind", "Lcom/intellij/database/model/ObjectKind;", "plural", "getVariant", "c", "Lcom/intellij/database/model/DasObject;", "intellij.database.dialects.cassandra"})
@SourceDebugExtension(value={"SMAP\nCassModelHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CassModelHelper.kt\ncom/intellij/database/dialects/cassandra/model/CassModelHelper\n+ 2 BooleanFun.kt\ncom/intellij/database/util/common/BooleanFun\n*L\n1#1,62:1\n18#2:63\n*S KotlinDebug\n*F\n+ 1 CassModelHelper.kt\ncom/intellij/database/dialects/cassandra/model/CassModelHelper\n*L\n23#1:63\n*E\n"})
public final class CassModelHelper
extends ModelHelper {
    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public String getCustomName(@NotNull ObjectKind kind, boolean plural) {
        String string;
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        if (Intrinsics.areEqual((Object)kind, (Object)ObjectKind.SCHEMA)) {
            int _true_$iv;
            void $this$choose$iv;
            Object[] objectArray = new Object[1];
            boolean bl = plural;
            int n = 2;
            int _false_$iv = 1;
            boolean $i$f$choose = false;
            objectArray[0] = $this$choose$iv != false ? _true_$iv : _false_$iv;
            string = DatabaseBundle.message("CustomObjectKind.keyspace", objectArray);
        } else {
            string = null;
        }
        return string;
    }

    @Override
    @NotNull
    public ModelHelper.ObjectKindVariant getVariant(@NotNull DasObject c2) {
        Intrinsics.checkNotNullParameter((Object)c2, (String)"c");
        if (c2 instanceof CassRole && ((CassRole)c2).isCanLogin()) {
            ModelHelper.ObjectKindVariant objectKindVariant = ModelHelper.USER;
            Intrinsics.checkNotNullExpressionValue((Object)objectKindVariant, (String)"USER");
            return objectKindVariant;
        }
        ModelHelper.ObjectKindVariant objectKindVariant = super.getVariant(c2);
        Intrinsics.checkNotNullExpressionValue((Object)objectKindVariant, (String)"getVariant(...)");
        return objectKindVariant;
    }

    @Override
    @NotNull
    public JBIterable<ModelHelper.ObjectKindVariant> generationVariants(@NotNull BasicMetaObject<?> meta) {
        JBIterable jBIterable;
        Intrinsics.checkNotNullParameter(meta, (String)"meta");
        ObjectKind objectKind = meta.kind;
        if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.ROUTINE)) {
            JBIterable jBIterable2 = JBIterable.of((Object)ModelHelper.FUNCTION);
            jBIterable = jBIterable2;
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"of(...)");
        } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.ROLE)) {
            Object[] objectArray = new ModelHelper.ObjectKindVariant[]{ModelHelper.DEFAULT, ModelHelper.USER};
            JBIterable jBIterable3 = JBIterable.of((Object[])objectArray);
            jBIterable = jBIterable3;
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable3, (String)"of(...)");
        } else {
            JBIterable jBIterable4 = super.generationVariants(meta);
            jBIterable = jBIterable4;
            Intrinsics.checkNotNullExpressionValue(jBIterable4, (String)"generationVariants(...)");
        }
        return jBIterable;
    }

    @Override
    public void fillPropertiesWithExamples(@NotNull BasicModElement e2, @NotNull ModelHelper.ObjectKindVariant variant, @NotNull Map<String, String> vars, boolean modifyParent) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        Intrinsics.checkNotNullParameter(vars, (String)"vars");
        super.fillPropertiesWithExamples(e2, variant, vars, modifyParent);
        if (e2 instanceof CassRole) {
            ((CassRole)e2).setCanLogin(Intrinsics.areEqual((Object)variant, (Object)ModelHelper.USER));
        }
        if (e2 instanceof CassSchema) {
            Map properties2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)((Object)CassSchemaPropertyKind.REPLICATION), (Object)"{'class': 'SimpleStrategy', 'replication_factor': 1}"));
            ((CassSchema)e2).setProperties(properties2);
            vars.put("properties", "replication = {'class': 'SimpleStrategy', 'replication_factor': 1}");
        }
        if (e2 instanceof CassFunction) {
            ((CassFunction)e2).setLanguage("java");
            vars.put("language", "java");
            BasicModArgument basicModArgument = ((CassFunction)e2).createOrGetReturnArgument();
            DataType dataType = DataTypeFactory.of("int");
            Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"of(...)");
            basicModArgument.setStoredType(DasUnresolvedTypeReference.Companion.of(dataType));
            vars.put("returns", "int");
        }
        if (e2 instanceof CassDefType) {
            CassDefTypeAttribute attr = (CassDefTypeAttribute)((CassDefType)e2).getAttributes().createNewOne();
            this.setTemplateName(attr, "attr");
            DataType dataType = DataTypeFactory.of("int");
            Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"of(...)");
            attr.setStoredType(DasUnresolvedTypeReference.Companion.of(dataType));
            vars.put("attrs", "attr int");
        }
    }
}

