/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.bigquery.types;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.types.DasTypeSystemImpl;
import com.intellij.database.dialects.bigquery.types.BigQueryArrayType;
import com.intellij.database.types.DasArrayType;
import com.intellij.database.types.DasTableType;
import com.intellij.database.types.DasType;
import com.intellij.psi.PsiElement;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlReferenceExpression;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J.\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/intellij/database/dialects/bigquery/types/BigQueryTypeSystem;", "Lcom/intellij/database/dialects/base/types/DasTypeSystemImpl;", "dbms", "Lcom/intellij/database/Dbms;", "(Lcom/intellij/database/Dbms;)V", "doCreateArrayType", "Lcom/intellij/database/dialects/bigquery/types/BigQueryArrayType;", "componentType", "Lcom/intellij/database/types/DasType;", "getBuiltinFunctionReturnType", "prototype", "Lcom/intellij/sql/dialects/BuiltinFunction$Prototype;", "nameElement", "Lcom/intellij/sql/psi/SqlReferenceExpression;", "params", "Lcom/intellij/psi/PsiElement;", "routineElement", "getTableTypeSpecification", "", "args", "intellij.database.dialects.bigquery"})
public final class BigQueryTypeSystem
extends DasTypeSystemImpl {
    public BigQueryTypeSystem(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        super(dbms);
    }

    @Override
    @NotNull
    public String getTableTypeSpecification(@NotNull String args2) {
        Intrinsics.checkNotNullParameter((Object)args2, (String)"args");
        return "table<" + args2 + ">";
    }

    @Override
    @NotNull
    protected BigQueryArrayType doCreateArrayType(@NotNull DasType componentType) {
        Intrinsics.checkNotNullParameter((Object)componentType, (String)"componentType");
        return new BigQueryArrayType(componentType);
    }

    @Override
    @Nullable
    public DasType getBuiltinFunctionReturnType(@NotNull BuiltinFunction.Prototype prototype, @Nullable SqlReferenceExpression nameElement, @Nullable PsiElement params2, @NotNull PsiElement routineElement) {
        Intrinsics.checkNotNullParameter((Object)prototype, (String)"prototype");
        Intrinsics.checkNotNullParameter((Object)routineElement, (String)"routineElement");
        if (!(params2 instanceof SqlExpressionList) || nameElement == null) {
            return null;
        }
        if (StringsKt.equals((String)nameElement.getName(), (String)"unnest", (boolean)true)) {
            List list = ((SqlExpressionList)params2).getExpressionList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getExpressionList(...)");
            List expressions2 = list;
            if (!((Collection)expressions2).isEmpty()) {
                DasType dasType = ((SqlExpression)expressions2.get(0)).getDasType();
                Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getDasType(...)");
                DasType argType = dasType;
                if (argType instanceof DasArrayType) {
                    DasType dasType2 = ((DasArrayType)argType).getComponentType();
                    Intrinsics.checkNotNullExpressionValue((Object)dasType2, (String)"getComponentType(...)");
                    DasType componentType = dasType2;
                    if (componentType instanceof DasTableType) {
                        return componentType;
                    }
                }
            }
        }
        return super.getBuiltinFunctionReturnType(prototype, nameElement, params2, routineElement);
    }
}

