/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.bigquery.introspector;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dialects.base.introspector.BaseIntrospectionFunctions;
import com.intellij.database.dialects.base.introspector.BaseIntrospector;
import com.intellij.database.dialects.base.introspector.BaseMultiDatabaseIntrospector;
import com.intellij.database.dialects.base.introspector.BaseNativeIntrospector;
import com.intellij.database.dialects.base.introspector.NameCache;
import com.intellij.database.dialects.base.introspector.jdbc.JdbcIntrospectorHelper;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.ClosableIt;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.DatabaseMetaDataWrapper;
import com.intellij.database.dialects.bigquery.introspector.BigQueryIntroQueries;
import com.intellij.database.dialects.bigquery.introspector.BigQueryIntrospectionException;
import com.intellij.database.dialects.bigquery.introspector.BigQueryIntrospector;
import com.intellij.database.dialects.bigquery.introspector.BigQueryIntrospector$BigQuerySchemaRetriever$retrieveTableAndViewColumns$;
import com.intellij.database.dialects.bigquery.introspector.BigQueryIntrospectorKt;
import com.intellij.database.dialects.bigquery.model.BigQueryDatabase;
import com.intellij.database.dialects.bigquery.model.BigQueryLikeColumn;
import com.intellij.database.dialects.bigquery.model.BigQueryLikeTable;
import com.intellij.database.dialects.bigquery.model.BigQueryMatView;
import com.intellij.database.dialects.bigquery.model.BigQueryRoot;
import com.intellij.database.dialects.bigquery.model.BigQueryRoutine;
import com.intellij.database.dialects.bigquery.model.BigQuerySchema;
import com.intellij.database.dialects.bigquery.model.BigQueryTable;
import com.intellij.database.dialects.bigquery.model.BigQueryTableColumn;
import com.intellij.database.dialects.bigquery.model.BigQueryView;
import com.intellij.database.dialects.bigquery.model.properties.BigQueryTableColumnType;
import com.intellij.database.introspection.DBIntrospectionContext;
import com.intellij.database.introspection.DBIntrospector;
import com.intellij.database.layoutedQueries.DBTransaction;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PerObjectVersion;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModArgument;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModMateDatabase;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModSchema;
import com.intellij.database.model.basic.BasicModTableOrViewColumn;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.properties.CompositeText;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.remote.jdba.core.ConnectionInfo;
import com.intellij.database.remote.jdbc.RemoteDatabaseMetaData;
import com.intellij.database.types.DasUnresolvedTypeReference;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.Version;
import com.intellij.util.containers.JBIterable;
import java.io.Closeable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0003\u0016\u0017\u0018B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ&\u0010\n\u001a \u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000bR\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001H\u0014J6\u0010\f\u001a \u0012\u0006\b\u0001\u0012\u00020\u00030\rR\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00012\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0003H\u0014J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u001c\u0010\u0013\u001a\u00060\u0014R\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0004H\u0014\u00a8\u0006\u0019"}, d2={"Lcom/intellij/database/dialects/bigquery/introspector/BigQueryIntrospector;", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector;", "Lcom/intellij/database/dialects/bigquery/model/BigQueryRoot;", "Lcom/intellij/database/dialects/bigquery/model/BigQueryDatabase;", "Lcom/intellij/database/dialects/bigquery/model/BigQuerySchema;", "context", "Lcom/intellij/database/introspection/DBIntrospectionContext;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "(Lcom/intellij/database/introspection/DBIntrospectionContext;Lcom/intellij/database/model/ModelFactory;)V", "createDatabaseLister", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector$DatabaseLister;", "createDatabaseRetriever", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector$BaseDatabaseRetriever;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "database", "createMeta", "Lcom/intellij/database/dialects/base/introspector/jdbc/wrappers/DatabaseMetaDataWrapper;", "createSchemaRetriever", "Lcom/intellij/database/dialects/bigquery/introspector/BigQueryIntrospector$BigQuerySchemaRetriever;", "schema", "BigQueryDatabaseRetriever", "BigQuerySchemaRetriever", "Factory", "intellij.database.dialects.bigquery"})
public class BigQueryIntrospector
extends BaseMultiDatabaseIntrospector<BigQueryRoot, BigQueryDatabase, BigQuerySchema> {
    public BigQueryIntrospector(@NotNull DBIntrospectionContext context, @NotNull ModelFactory modelFactory) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)modelFactory, (String)"modelFactory");
        BaseIntrospector.Nature nature = BaseIntrospector.DefaultNature.INSTANCE;
        Dbms dbms = Dbms.BIGQUERY;
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"BIGQUERY");
        super(context, nature, dbms, modelFactory);
    }

    private final DatabaseMetaDataWrapper createMeta() {
        DatabaseConnectionCore connection2;
        DatabaseConnectionCore databaseConnectionCore = connection2 = this.getDbConnection();
        if (databaseConnectionCore != null) {
            DatabaseMetaDataWrapper databaseMetaDataWrapper;
            DatabaseConnectionCore it2 = databaseConnectionCore;
            boolean bl = false;
            try {
                RemoteDatabaseMetaData remoteDatabaseMetaData = connection2.getRemoteMetaData();
                if (remoteDatabaseMetaData == null) {
                    throw new BigQueryIntrospectionException("Connection#getMetaData() returns null. No introspection could be performed", null, 2, null);
                }
                RemoteDatabaseMetaData remoteDatabaseMetaData2 = remoteDatabaseMetaData;
                Intrinsics.checkNotNull((Object)remoteDatabaseMetaData2);
                RemoteDatabaseMetaData metaData = remoteDatabaseMetaData2;
                databaseMetaDataWrapper = DatabaseMetaDataWrapper.create(connection2, metaData).withErrorSink(this.getErrorSink());
                Intrinsics.checkNotNull((Object)databaseMetaDataWrapper);
            }
            catch (SQLException e2) {
                throw new BigQueryIntrospectionException("Failed to retrieve meta data", e2);
            }
            return databaseMetaDataWrapper;
        }
        throw new BigQueryIntrospectionException("Failed to get connection", null, 2, null);
    }

    @NotNull
    protected BigQuerySchemaRetriever createSchemaRetriever(@NotNull DBTransaction transaction, @NotNull BigQuerySchema schema2) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)schema2, (String)"schema");
        return new BigQuerySchemaRetriever(transaction, schema2);
    }

    @Override
    @NotNull
    protected BaseMultiDatabaseIntrospector.DatabaseLister<?, ?> createDatabaseLister() {
        return new BaseMultiDatabaseIntrospector.DatabaseLister<BigQueryIntroQueries.Database, BigQueryDatabase>(this){
            final /* synthetic */ BigQueryIntrospector this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @NotNull
            protected List<BigQueryIntroQueries.Database> listDatabases(@NotNull DBTransaction tran) {
                List list;
                Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
                Closeable closeable = BigQueryIntrospector.access$createMeta(this.this$0).databases();
                Throwable throwable = null;
                try {
                    ClosableIt it2 = (ClosableIt)closeable;
                    boolean bl = false;
                    List list2 = it2.map(arg_0 -> createDatabaseLister.1.listDatabases$lambda$1$lambda$0(createDatabaseLister.listDatabases.1.1.INSTANCE, arg_0)).toList();
                    list = list2;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"use(...)");
                return list;
            }

            protected boolean isCurrent(int idx, @NotNull BigQueryIntroQueries.Database db2) {
                Intrinsics.checkNotNullParameter((Object)db2, (String)"db");
                return Intrinsics.areEqual((Object)BigQueryIntrospector.access$getDbConnectionInfo((BigQueryIntrospector)this.this$0).databaseName, (Object)db2.name);
            }

            @NotNull
            protected BigQueryDatabase applyDatabase(@NotNull ModNamingFamily<?> databases2, @NotNull BigQueryIntroQueries.Database db2) {
                Intrinsics.checkNotNullParameter(databases2, (String)"databases");
                Intrinsics.checkNotNullParameter((Object)db2, (String)"db");
                return (BigQueryDatabase)this.renew(databases2, db2.name);
            }

            private static final BigQueryIntroQueries.Database listDatabases$lambda$1$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (BigQueryIntroQueries.Database)$tmp0.invoke(p0);
            }
        };
    }

    @Override
    @NotNull
    protected BaseMultiDatabaseIntrospector.BaseDatabaseRetriever<? extends BigQueryDatabase> createDatabaseRetriever(@NotNull DBTransaction transaction, @NotNull BigQueryDatabase database) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        return new BigQueryDatabaseRetriever(transaction, database);
    }

    public static final /* synthetic */ ConnectionInfo access$getDbConnectionInfo(BigQueryIntrospector $this) {
        return $this.getDbConnectionInfo();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0084\u0004\u0018\u00002\u001e\u0012\u0004\u0012\u00020\u00020\u0001R\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00050\u0003B\u0015\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/intellij/database/dialects/bigquery/introspector/BigQueryIntrospector$BigQueryDatabaseRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector$BaseDatabaseRetriever;", "Lcom/intellij/database/dialects/bigquery/model/BigQueryDatabase;", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector;", "Lcom/intellij/database/dialects/bigquery/model/BigQueryRoot;", "Lcom/intellij/database/dialects/bigquery/model/BigQuerySchema;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "database", "(Lcom/intellij/database/dialects/bigquery/introspector/BigQueryIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/bigquery/model/BigQueryDatabase;)V", "retrieveSchemas", "", "retrieveSchemasSafe", "", "Lcom/intellij/database/dialects/base/introspector/jdbc/wrappers/DatabaseMetaDataWrapper$Schema;", "intellij.database.dialects.bigquery"})
    protected final class BigQueryDatabaseRetriever
    extends BaseMultiDatabaseIntrospector.BaseDatabaseRetriever<BigQueryDatabase> {
        public BigQueryDatabaseRetriever(@NotNull DBTransaction transaction, BigQueryDatabase database) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Intrinsics.checkNotNullParameter((Object)database, (String)"database");
            super((BaseMultiDatabaseIntrospector)BigQueryIntrospector.this, transaction, (BasicModMateDatabase)database);
        }

        @Override
        public void retrieveSchemas() {
            this.inDatabase((Function1)new Function1<BigQueryDatabase, Unit>(this, BigQueryIntrospector.this){
                final /* synthetic */ BigQueryDatabaseRetriever this$0;
                final /* synthetic */ BigQueryIntrospector this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull BigQueryDatabase db2) {
                    void scs$iv;
                    void $this$applySchemasImpl$iv;
                    Intrinsics.checkNotNullParameter((Object)db2, (String)"db");
                    NamingFamily namingFamily = db2.getSchemas();
                    Intrinsics.checkNotNullExpressionValue((Object)namingFamily, (String)"getSchemas(...)");
                    NamingFamily namingFamily2 = namingFamily;
                    List list = BigQueryDatabaseRetriever.access$retrieveSchemasSafe(this.this$0);
                    BigQueryIntrospector bigQueryIntrospector = this.this$1;
                    boolean $i$f$applySchemasImpl = false;
                    $this$applySchemasImpl$iv.markChildrenAsSyncPending();
                    Iterable $this$forEach$iv$iv = (Iterable)scs$iv;
                    boolean $i$f$forEach = false;
                    Iterator<T> iterator = $this$forEach$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        void schema2;
                        T element$iv$iv;
                        T sc$iv = element$iv$iv = iterator.next();
                        boolean bl = false;
                        DatabaseMetaDataWrapper.Schema schema3 = (DatabaseMetaDataWrapper.Schema)sc$iv;
                        void $this$invoke_u24lambda_u241 = $this$applySchemasImpl$iv;
                        boolean bl2 = false;
                        E e2 = db2.getSchemas().createOrGet(schema2.schema);
                        BigQuerySchema $this$invoke_u24lambda_u241_u24lambda_u240 = (BigQuerySchema)e2;
                        boolean bl3 = false;
                        $this$invoke_u24lambda_u241_u24lambda_u240.setCurrent(Intrinsics.areEqual((Object)BigQueryIntrospector.access$getDbConnectionInfo((BigQueryIntrospector)bigQueryIntrospector).schemaName, (Object)schema2.schema));
                    }
                    $this$applySchemasImpl$iv.removeSyncPendingChildren();
                    $this$applySchemasImpl$iv.sort();
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final List<DatabaseMetaDataWrapper.Schema> retrieveSchemasSafe() {
            try {
                List list;
                Closeable closeable = BigQueryIntrospector.this.createMeta().schemas((JBIterable<String>)JBIterable.of((Object)((BigQueryDatabase)this.getDatabase()).getName()));
                Throwable throwable = null;
                try {
                    ClosableIt it2 = (ClosableIt)closeable;
                    boolean bl = false;
                    List list2 = it2.filter(arg_0 -> BigQueryDatabaseRetriever.retrieveSchemasSafe$lambda$1$lambda$0((Function1)new Function1<DatabaseMetaDataWrapper.Schema, Boolean>(this){
                        final /* synthetic */ BigQueryDatabaseRetriever this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        @NotNull
                        public final Boolean invoke(DatabaseMetaDataWrapper.Schema schema2) {
                            return Intrinsics.areEqual((Object)schema2.database, (Object)BigQueryDatabaseRetriever.access$getDatabase(this.this$0).getName());
                        }
                    }, arg_0)).toList();
                    list = list2;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"use(...)");
                return list;
            }
            catch (Exception e2) {
                BigQueryIntrospector.this.getErrorSink().consume((Object)("Error while introspecting " + this.getDatabase()), (Object)e2);
                return CollectionsKt.emptyList();
            }
        }

        private static final boolean retrieveSchemasSafe$lambda$1$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Boolean)$tmp0.invoke(p0);
        }

        public static final /* synthetic */ List access$retrieveSchemasSafe(BigQueryDatabaseRetriever $this) {
            return $this.retrieveSchemasSafe();
        }

        public static final /* synthetic */ BigQueryDatabase access$getDatabase(BigQueryDatabaseRetriever $this) {
            return (BigQueryDatabase)$this.getDatabase();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0084\u0004\u0018\u00002\u001e\u0012\u0004\u0012\u00020\u00020\u0001R\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\u0003B\u0017\b\u0000\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J1\u0010\u0011\u001a\u0004\u0018\u0001H\u0012\"\u0004\b\u0000\u0010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u0002H\u00120\u0016H\u0002\u00a2\u0006\u0002\u0010\u0018J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010!\u001a\u00020\u001aH\u0016J\u0018\u0010\"\u001a\u00020#2\u0006\u0010\f\u001a\u00020#2\u0006\u0010$\u001a\u00020\rH\u0002J\u0018\u0010%\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010(\u001a\u00020)2\u0006\u0010\f\u001a\u00020)2\u0006\u0010$\u001a\u00020\rH\u0002J\u0018\u0010*\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020+2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010,\u001a\u00020\u001aH\u0002J\b\u0010-\u001a\u00020\u001aH\u0014J\b\u0010.\u001a\u00020\u001aH\u0002J\b\u0010/\u001a\u00020\u001aH\u0002J\b\u00100\u001a\u00020\u001aH\u0002J\b\u00101\u001a\u00020\u001aH\u0002J\b\u00102\u001a\u00020\u000fH\u0002J\b\u00103\u001a\u00020\u001aH\u0002J\b\u00104\u001a\u00020\u001aH\u0002J\b\u00105\u001a\u00020\u001aH\u0002J\b\u00106\u001a\u00020\u001aH\u0002J\b\u00107\u001a\u00020\u001aH\u0002J\b\u00108\u001a\u00020\u001aH\u0002\u00a8\u00069"}, d2={"Lcom/intellij/database/dialects/bigquery/introspector/BigQueryIntrospector$BigQuerySchemaRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractSchemaRetriever;", "Lcom/intellij/database/dialects/bigquery/model/BigQuerySchema;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector;", "Lcom/intellij/database/dialects/bigquery/model/BigQueryRoot;", "Lcom/intellij/database/dialects/bigquery/model/BigQueryDatabase;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "schema", "(Lcom/intellij/database/dialects/bigquery/introspector/BigQueryIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/bigquery/model/BigQuerySchema;)V", "getColumnType", "Lcom/intellij/database/dialects/bigquery/model/properties/BigQueryTableColumnType;", "column", "Lcom/intellij/database/dialects/bigquery/introspector/BigQueryIntroQueries$ColumnInfo;", "isPossibleToIntrospectSchemaIncrementally", "", "tran", "parseTableOption", "T", "tableOrViewOption", "Lcom/intellij/database/dialects/bigquery/introspector/BigQueryIntroQueries$TableOrViewOption;", "parse", "Lkotlin/Function1;", "", "(Lcom/intellij/database/dialects/bigquery/introspector/BigQueryIntroQueries$TableOrViewOption;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "process", "", "processLikeTableOption", "likeTable", "Lcom/intellij/database/dialects/bigquery/model/BigQueryLikeTable;", "processMatViewOption", "view", "Lcom/intellij/database/dialects/bigquery/model/BigQueryMatView;", "processPreliminaryPhase", "processTableColumn", "Lcom/intellij/database/dialects/bigquery/model/BigQueryTableColumn;", "columnInfo", "processTableOption", "table", "Lcom/intellij/database/dialects/bigquery/model/BigQueryTable;", "processViewColumn", "Lcom/intellij/database/dialects/bigquery/model/BigQueryLikeColumn;", "processViewOption", "Lcom/intellij/database/dialects/bigquery/model/BigQueryView;", "retrieveColumnComments", "retrieveMainContent", "retrieveRoutineArguments", "retrieveRoutineOptions", "retrieveRoutineSources", "retrieveRoutines", "retrieveRoutinesInfo", "retrieveRoutinesInfoFromMetaData", "retrieveTableAndViewColumns", "retrieveTablesAndViews", "retrieveTablesAndViewsInfo", "retrieveTablesAndViewsOptions", "retrieveViewsDefinitions", "intellij.database.dialects.bigquery"})
    @SourceDebugExtension(value={"SMAP\nBigQueryIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BigQueryIntrospector.kt\ncom/intellij/database/dialects/bigquery/introspector/BigQueryIntrospector$BigQuerySchemaRetriever\n+ 2 BaseIntrospectionFunctions.kt\ncom/intellij/database/dialects/base/introspector/BaseIntrospectionFunctions\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,420:1\n198#2,13:421\n239#2:434\n242#2,6:437\n181#2,7:443\n221#2,3:454\n224#2:459\n199#2,12:460\n225#2:472\n1855#3,2:435\n1549#3:450\n1620#3,3:451\n37#4,2:457\n*S KotlinDebug\n*F\n+ 1 BigQueryIntrospector.kt\ncom/intellij/database/dialects/bigquery/introspector/BigQueryIntrospector$BigQuerySchemaRetriever\n*L\n101#1:421,13\n221#1:434\n221#1:437,6\n278#1:443,7\n313#1:454,3\n313#1:459\n313#1:460,12\n313#1:472\n221#1:435,2\n313#1:450\n313#1:451,3\n313#1:457,2\n*E\n"})
    protected final class BigQuerySchemaRetriever
    extends BaseNativeIntrospector.AbstractSchemaRetriever<BigQuerySchema> {
        public BigQuerySchemaRetriever(@NotNull DBTransaction transaction, BigQuerySchema schema2) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Intrinsics.checkNotNullParameter((Object)schema2, (String)"schema");
            super((BaseNativeIntrospector)BigQueryIntrospector.this, transaction, (BasicModSchema)schema2);
        }

        @Override
        public boolean isPossibleToIntrospectSchemaIncrementally(@NotNull DBTransaction tran, @NotNull BigQuerySchema schema2) {
            Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
            Intrinsics.checkNotNullParameter((Object)schema2, (String)"schema");
            return false;
        }

        @Override
        public void processPreliminaryPhase() {
            if (this.getMode().fragment) {
                return;
            }
            if (this.getMode().increment) {
                this.analyzeCurrentContent();
            }
        }

        @Override
        public void process() {
            BaseNativeIntrospector baseNativeIntrospector = BigQueryIntrospector.this;
            String string = ((BigQuerySchema)this.getSchema()).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            BaseNativeIntrospector.reportIntrospectingSchema$default(baseNativeIntrospector, string, null, null, 6, null);
            this.prepareParameters();
            this.processMainPhase();
        }

        @Override
        protected void retrieveMainContent() {
            this.retrieveTablesAndViews();
            this.retrieveTableAndViewColumns();
            this.retrieveColumnComments();
            this.retrieveRoutines();
            this.retrieveRoutineArguments();
            this.retrieveRoutineSources();
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveTablesAndViews() {
            void families$iv;
            BigQueryIntrospector.this.reportRetrieving("tables and views", "introspection.retrieve.tablesViews");
            ModFamily[] modFamilyArray = new ModFamily[3];
            Intrinsics.checkNotNullExpressionValue(((BigQuerySchema)this.getSchema()).getTables(), (String)"getTables(...)");
            Intrinsics.checkNotNullExpressionValue(((BigQuerySchema)this.getSchema()).getViews(), (String)"getViews(...)");
            Intrinsics.checkNotNullExpressionValue(((BigQuerySchema)this.getSchema()).getMatViews(), (String)"getMatViews(...)");
            boolean inc$iv = true;
            boolean $i$f$modifyFamiliesAndCleanup = false;
            for (void f$iv : families$iv) {
                f$iv.markChildrenAsSyncPending();
            }
            boolean bl = false;
            this.retrieveTablesAndViewsInfo();
            for (void f$iv : families$iv) {
                f$iv.removeSyncPendingChildren();
                f$iv.sort();
            }
            this.retrieveTablesAndViewsOptions();
            this.retrieveViewsDefinitions();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void retrieveTablesAndViewsInfo() {
            BigQueryDatabase bigQueryDatabase = ((BigQuerySchema)this.getSchema()).getParent();
            Closeable closeable = BigQueryIntrospector.this.createMeta().tables(new DatabaseMetaDataWrapper.Schema(((BigQuerySchema)this.getSchema()).getName(), bigQueryDatabase != null ? bigQueryDatabase.getName() : null), null, null);
            Throwable throwable = null;
            try {
                ClosableIt it2 = (ClosableIt)closeable;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it2);
                ClosableIt closableIt = it2;
                while (closableIt.hasNext()) {
                    ModNamingFamily tables2;
                    ObjectKind kind;
                    DatabaseMetaDataWrapper.Table t = (DatabaseMetaDataWrapper.Table)closableIt.next();
                    Intrinsics.checkNotNullExpressionValue((Object)JdbcIntrospectorHelper.JdbcTableType.findByName(t.type).getKind(), (String)"getKind(...)");
                    ModFamily modFamily = DbImplUtilCore.familyOf((BasicModElement)this.getSchema(), kind);
                    if ((modFamily instanceof ModNamingFamily ? (ModNamingFamily)modFamily : null) == null) continue;
                    tables2 = tables2;
                    tables2.createOrGet(t.name);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        private final void retrieveViewsDefinitions() {
            BigQueryIntroQueries.INSTANCE.processViewDefinitions(this.getTransaction(), (BigQuerySchema)this.getSchema(), (Function1<? super BigQueryIntroQueries.ViewDefinition, Unit>)((Function1)new Function1<BigQueryIntroQueries.ViewDefinition, Unit>(this){
                final /* synthetic */ BigQuerySchemaRetriever this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull BigQueryIntroQueries.ViewDefinition viewDef) {
                    block0: {
                        BigQueryView bigQueryView;
                        Intrinsics.checkNotNullParameter((Object)viewDef, (String)"viewDef");
                        BigQueryView bigQueryView2 = (BigQueryView)((BigQuerySchema)this.this$0.getSchema()).getViews().get(viewDef.table_name);
                        if (bigQueryView2 == null) break block0;
                        BigQueryView $this$invoke_u24lambda_u241 = bigQueryView = bigQueryView2;
                        boolean bl = false;
                        ((BasicModModel)$this$invoke_u24lambda_u241.getModel()).writeSources(() -> retrieveViewsDefinitions.1.invoke$lambda$1$lambda$0($this$invoke_u24lambda_u241, viewDef));
                    }
                }

                private static final void invoke$lambda$1$lambda$0(BigQueryView $this_apply, BigQueryIntroQueries.ViewDefinition $viewDef) {
                    Intrinsics.checkNotNullParameter((Object)$this_apply, (String)"$this_apply");
                    Intrinsics.checkNotNullParameter((Object)$viewDef, (String)"$viewDef");
                    $this_apply.setSourceText(BaseIntrospectionFunctions.toCompositeText($viewDef.view_definition, CompositeText.Kind.ORIGINAL_TEXT));
                }
            }));
        }

        private final void retrieveTablesAndViewsOptions() {
            BigQueryIntroQueries.INSTANCE.processViewAndTablesOptions(this.getTransaction(), (BigQuerySchema)this.getSchema(), (Function1<? super BigQueryIntroQueries.TableOrViewOption, Unit>)((Function1)new Function1<BigQueryIntroQueries.TableOrViewOption, Unit>(this){
                final /* synthetic */ BigQuerySchemaRetriever this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull BigQueryIntroQueries.TableOrViewOption tableOrViewOption) {
                    Intrinsics.checkNotNullParameter((Object)tableOrViewOption, (String)"tableOrViewOption");
                    ObjectKind objectKind = JdbcIntrospectorHelper.JdbcTableType.findByName(tableOrViewOption.table_type).getKind();
                    Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"getKind(...)");
                    ObjectKind kind = objectKind;
                    if (Intrinsics.areEqual((Object)kind, (Object)ObjectKind.MAT_VIEW)) {
                        BigQueryMatView bigQueryMatView = (BigQueryMatView)((BigQuerySchema)this.this$0.getSchema()).getMatViews().get(tableOrViewOption.table_name);
                        if (bigQueryMatView != null) {
                            BigQueryMatView bigQueryMatView2 = bigQueryMatView;
                            BigQuerySchemaRetriever bigQuerySchemaRetriever = this.this$0;
                            BigQueryMatView $this$invoke_u24lambda_u240 = bigQueryMatView2;
                            boolean bl = false;
                            BigQuerySchemaRetriever.access$processMatViewOption(bigQuerySchemaRetriever, $this$invoke_u24lambda_u240, tableOrViewOption);
                        }
                    } else if (Intrinsics.areEqual((Object)kind, (Object)ObjectKind.VIEW)) {
                        BigQueryView bigQueryView = (BigQueryView)((BigQuerySchema)this.this$0.getSchema()).getViews().get(tableOrViewOption.table_name);
                        if (bigQueryView != null) {
                            BigQueryView bigQueryView2 = bigQueryView;
                            BigQuerySchemaRetriever bigQuerySchemaRetriever = this.this$0;
                            BigQueryView $this$invoke_u24lambda_u241 = bigQueryView2;
                            boolean bl = false;
                            BigQuerySchemaRetriever.access$processViewOption(bigQuerySchemaRetriever, $this$invoke_u24lambda_u241, tableOrViewOption);
                        }
                    } else if (Intrinsics.areEqual((Object)kind, (Object)ObjectKind.TABLE)) {
                        BigQueryTable bigQueryTable = (BigQueryTable)((BigQuerySchema)this.this$0.getSchema()).getTables().get(tableOrViewOption.table_name);
                        if (bigQueryTable != null) {
                            BigQueryTable bigQueryTable2 = bigQueryTable;
                            BigQuerySchemaRetriever bigQuerySchemaRetriever = this.this$0;
                            BigQueryTable $this$invoke_u24lambda_u242 = bigQueryTable2;
                            boolean bl = false;
                            BigQuerySchemaRetriever.access$processTableOption(bigQuerySchemaRetriever, $this$invoke_u24lambda_u242, tableOrViewOption);
                        }
                    } else {
                        this.this$0.log.warn("Incorrect table type: '" + tableOrViewOption.table_type + "'. Detected ObjectKind: '" + kind.name() + "'");
                    }
                }
            }));
        }

        private final void processLikeTableOption(BigQueryLikeTable likeTable, BigQueryIntroQueries.TableOrViewOption tableOrViewOption) {
            block16: {
                String string = tableOrViewOption.name;
                if (string == null) break block16;
                int n = -1;
                switch (string.hashCode()) {
                    case 1451097503: {
                        if (string.equals("friendly_name")) {
                            n = 1;
                        }
                        break;
                    }
                    case -2040455290: {
                        if (string.equals("expiration_timestamp")) {
                            n = 2;
                        }
                        break;
                    }
                    case -1724546052: {
                        if (string.equals("description")) {
                            n = 3;
                        }
                        break;
                    }
                    case -1110417409: {
                        if (string.equals("labels")) {
                            n = 4;
                        }
                        break;
                    }
                }
                switch (n) {
                    case 2: {
                        likeTable.setExpirationTimestamp(tableOrViewOption.value);
                        break;
                    }
                    case 1: {
                        String string2 = tableOrViewOption.value;
                        likeTable.setFriendlyName(string2 != null ? StringsKt.removeSurrounding((String)string2, (CharSequence)"\"") : null);
                        break;
                    }
                    case 3: {
                        String string3 = tableOrViewOption.value;
                        likeTable.setComment(string3 != null ? StringsKt.removeSurrounding((String)string3, (CharSequence)"\"") : null);
                        break;
                    }
                    case 4: {
                        likeTable.setLabels(tableOrViewOption.value);
                    }
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final void processTableOption(BigQueryTable table, BigQueryIntroQueries.TableOrViewOption tableOrViewOption) {
            block6: {
                this.processLikeTableOption(table, tableOrViewOption);
                String string = tableOrViewOption.name;
                if (string == null) return;
                switch (string.hashCode()) {
                    case 749023751: {
                        if (string.equals("require_partition_filter")) break;
                        return;
                    }
                    case 2094986649: {
                        if (!string.equals("kms_key_name")) {
                            return;
                        }
                        break block6;
                    }
                    case -1838282606: {
                        if (!string.equals("partition_expiration_days")) return;
                        Double d2 = (Double)this.parseTableOption(tableOrViewOption, processTableOption.1.INSTANCE);
                        if (d2 == null) return;
                        double it2 = ((Number)d2).doubleValue();
                        boolean bl = false;
                        table.setPartitionExpirationDays(it2);
                        return;
                    }
                }
                Boolean bl = (Boolean)this.parseTableOption(tableOrViewOption, processTableOption.3.INSTANCE);
                if (bl == null) return;
                boolean it3 = bl;
                boolean bl2 = false;
                table.setRequirePartitionFilter(it3);
                return;
            }
            table.setKmsKeyName(tableOrViewOption.value);
        }

        private final void processViewOption(BigQueryView view2, BigQueryIntroQueries.TableOrViewOption tableOrViewOption) {
            this.processLikeTableOption(view2, tableOrViewOption);
        }

        private final void processMatViewOption(BigQueryMatView view2, BigQueryIntroQueries.TableOrViewOption tableOrViewOption) {
            block2: {
                String string;
                block1: {
                    this.processLikeTableOption(view2, tableOrViewOption);
                    string = tableOrViewOption.name;
                    if (!Intrinsics.areEqual((Object)string, (Object)"enable_refresh")) break block1;
                    Boolean bl = (Boolean)this.parseTableOption(tableOrViewOption, processMatViewOption.1.INSTANCE);
                    if (bl == null) break block2;
                    boolean it2 = bl;
                    boolean bl2 = false;
                    view2.setEnableRefresh(it2);
                    break block2;
                }
                if (!Intrinsics.areEqual((Object)string, (Object)"refresh_interval_minutes")) break block2;
                Double d2 = (Double)this.parseTableOption(tableOrViewOption, processMatViewOption.3.INSTANCE);
                if (d2 != null) {
                    double it3 = ((Number)d2).doubleValue();
                    boolean bl = false;
                    view2.setRefreshIntervalMinutes(it3);
                }
            }
        }

        private final <T> T parseTableOption(BigQueryIntroQueries.TableOrViewOption tableOrViewOption, Function1<? super String, ? extends T> parse2) {
            try {
                Object object;
                String optionValue;
                String string = optionValue = tableOrViewOption.value;
                if (string != null) {
                    String it2 = string;
                    boolean bl = false;
                    object = parse2.invoke((Object)optionValue);
                } else {
                    object = null;
                }
                return (T)object;
            }
            catch (Exception e2) {
                this.log.warn("Invalid table option " + tableOrViewOption.name + ": '" + tableOrViewOption.value + "', expected type: " + tableOrViewOption.type);
                return null;
            }
        }

        /*
         * Unable to fully structure code
         */
        private final BigQueryTableColumn processTableColumn(BigQueryTableColumn column, BigQueryIntroQueries.ColumnInfo columnInfo) {
            $this$processTableColumn_u24lambda_u247 = var3_3 = column;
            $i$a$-apply-BigQueryIntrospector$BigQuerySchemaRetriever$processTableColumn$1 = false;
            $this$processTableColumn_u24lambda_u247.setPosition(columnInfo.ordinal_position);
            v0 = DataTypeFactory.of(columnInfo.data_type);
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"of(...)");
            $this$processTableColumn_u24lambda_u247.setStoredType(DasUnresolvedTypeReference.Companion.of(v0));
            if (!Intrinsics.areEqual((Object)columnInfo.is_nullable, (Object)"NO")) ** GOTO lbl-1000
            v1 = columnInfo.data_type.toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"toLowerCase(...)");
            if (!StringsKt.startsWith$default((String)v1, (String)"array", (boolean)false, (int)2, null)) {
                v2 = true;
            } else lbl-1000:
            // 2 sources

            {
                v2 = false;
            }
            $this$processTableColumn_u24lambda_u247.setNotNull(v2);
            $this$processTableColumn_u24lambda_u247.setAutoCreated(Intrinsics.areEqual((Object)columnInfo.is_hidden, (Object)"YES"));
            $this$processTableColumn_u24lambda_u247.setType(this.getColumnType(columnInfo));
            $this$processTableColumn_u24lambda_u247.setClusteringOrdinalPosition(columnInfo.clustering_ordinal_position);
            return var3_3;
        }

        private final BigQueryTableColumnType getColumnType(BigQueryIntroQueries.ColumnInfo column2) {
            return Intrinsics.areEqual((Object)column2.is_partitioning, (Object)"YES") ? BigQueryTableColumnType.PARTITIONING : (column2.clustering_ordinal_position != 0 ? BigQueryTableColumnType.CLUSTERING : BigQueryTableColumnType.REGULAR);
        }

        private final void retrieveTableAndViewColumns() {
            boolean bl;
            boolean bl2;
            boolean bl3;
            BigQueryLikeTable t;
            ObjectKind objectKind = ObjectKind.COLUMN;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"COLUMN");
            BigQueryIntrospector.this.reportRetrieving(objectKind);
            boolean $i$f$modifyFamiliesAndCleanup = false;
            Function1 it2 = BigQuerySchemaRetriever$retrieveTableAndViewColumns$$inlined$modifyFamiliesAndCleanup$1.INSTANCE;
            boolean bl4 = false;
            ModNamingFamily<? extends BigQueryTable> modNamingFamily = ((BigQuerySchema)this.getSchema()).getTables();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getTables(...)");
            Iterable $this$forEach$iv = modNamingFamily;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                t = (BigQueryTable)element$iv;
                bl3 = false;
                PositioningNamingFamily positioningNamingFamily = t.getColumns();
                Intrinsics.checkNotNullExpressionValue((Object)positioningNamingFamily, (String)"getColumns(...)");
                it2.invoke((Object)positioningNamingFamily);
            }
            ModNamingFamily<? extends BigQueryView> modNamingFamily2 = ((BigQuerySchema)this.getSchema()).getViews();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily2, (String)"getViews(...)");
            $this$forEach$iv = modNamingFamily2;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                t = (BigQueryView)element$iv;
                bl2 = false;
                PositioningNamingFamily positioningNamingFamily = t.getColumns();
                Intrinsics.checkNotNullExpressionValue((Object)positioningNamingFamily, (String)"getColumns(...)");
                it2.invoke((Object)positioningNamingFamily);
            }
            ModNamingFamily<? extends BigQueryMatView> modNamingFamily3 = ((BigQuerySchema)this.getSchema()).getMatViews();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily3, (String)"getMatViews(...)");
            $this$forEach$iv = modNamingFamily3;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                t = (BigQueryMatView)element$iv;
                bl = false;
                PositioningNamingFamily positioningNamingFamily = t.getColumns();
                Intrinsics.checkNotNullExpressionValue((Object)positioningNamingFamily, (String)"getColumns(...)");
                it2.invoke((Object)positioningNamingFamily);
            }
            boolean bl5 = false;
            List colsWithoutPosition = new ArrayList();
            NameCache<BigQueryLikeTable> tableCache2 = new NameCache<BigQueryLikeTable>();
            Ref.IntRef counter = new Ref.IntRef();
            BigQueryIntroQueries.INSTANCE.processColumns(this.getTransaction(), (BigQuerySchema)this.getSchema(), (Function1<? super BigQueryIntroQueries.ColumnInfo, Unit>)((Function1)new Function1<BigQueryIntroQueries.ColumnInfo, Unit>(tableCache2, this, (List<BigQueryLikeColumn>)colsWithoutPosition, counter){
                final /* synthetic */ NameCache<BigQueryLikeTable> $tableCache;
                final /* synthetic */ BigQuerySchemaRetriever this$0;
                final /* synthetic */ List<BigQueryLikeColumn> $colsWithoutPosition;
                final /* synthetic */ Ref.IntRef $counter;
                {
                    this.$tableCache = $tableCache;
                    this.this$0 = $receiver;
                    this.$colsWithoutPosition = $colsWithoutPosition;
                    this.$counter = $counter;
                    super(1);
                }

                /*
                 * Unable to fully structure code
                 */
                public final void invoke(@NotNull BigQueryIntroQueries.ColumnInfo columnInfo) {
                    Intrinsics.checkNotNullParameter((Object)columnInfo, (String)"columnInfo");
                    var3_2 = this.$tableCache;
                    var4_3 = columnInfo.table_name;
                    var5_5 = this.this$0;
                    var6_6 = this.$colsWithoutPosition;
                    var7_7 = this.$counter;
                    $i$f$get = false;
                    var9_9 = this_$iv;
                    create$iv$iv = false;
                    $i$f$get = false;
                    if (this_$iv$iv.getV() == null) ** GOTO lbl-1000
                    v0 = this_$iv$iv.getV();
                    Intrinsics.checkNotNull(v0);
                    if (Intrinsics.areEqual((Object)v0.getName(), (Object)name$iv)) {
                        v1 = this_$iv$iv.getV();
                    } else lbl-1000:
                    // 2 sources

                    {
                        var12_12 = (Function1)new Function1<ModNamingFamily<? extends T>, T>(create$iv$iv, (String)name$iv){
                            final /* synthetic */ boolean $create;
                            final /* synthetic */ String $name;
                            {
                                this.$create = $create;
                                this.$name = $name;
                                super(1);
                            }

                            @Nullable
                            public final T invoke(@NotNull ModNamingFamily<? extends T> $this$invoke) {
                                Intrinsics.checkNotNullParameter($this$invoke, (String)"$this$invoke");
                                return (T)(this.$create ? $this$invoke.createOrGet(this.$name) : (BasicModNamedElement)$this$invoke.get(this.$name));
                            }
                        };
                        var13_13 = this_$iv$iv;
                        var15_14 = this_$iv$iv;
                        $i$a$-get-BigQueryIntrospector$BigQuerySchemaRetriever$retrieveTableAndViewColumns$2$1$table$1 = false;
                        BigQuerySchemaRetriever.access$retrieveTableAndViewColumns$lambda$12$tableChanged(var6_6, var7_7);
                        v2 = ((BigQuerySchema)var5_5.getSchema()).getTables();
                        Intrinsics.checkNotNullExpressionValue(v2, (String)"getTables(...)");
                        v3 = (BigQueryLikeTable)it.invoke(v2);
                        if (v3 == null) {
                            v4 = ((BigQuerySchema)var5_5.getSchema()).getViews();
                            Intrinsics.checkNotNullExpressionValue(v4, (String)"getViews(...)");
                            v3 = (BigQueryLikeTable)it.invoke(v4);
                            if (v3 == null) {
                                v5 = ((BigQuerySchema)var5_5.getSchema()).getMatViews();
                                Intrinsics.checkNotNullExpressionValue(v5, (String)"getMatViews(...)");
                                v3 = (BigQueryLikeTable)it.invoke(v5);
                            }
                        }
                        var15_14.setV((BasicModNamedElement)v3);
                        v1 = this_$iv$iv.getV();
                    }
                    table = (BigQueryLikeTable)v1;
                    var4_3 = table;
                    if (var4_3 instanceof BigQueryView != false ? true : var4_3 instanceof BigQueryMatView) {
                        v6 = table.getColumns().createOrGet(columnInfo.name);
                        Intrinsics.checkNotNull(v6, (String)"null cannot be cast to non-null type com.intellij.database.dialects.bigquery.model.BigQueryLikeColumn");
                        v7 = BigQuerySchemaRetriever.access$processViewColumn(this.this$0, (BigQueryLikeColumn)v6, columnInfo);
                    } else if (var4_3 instanceof BigQueryTable) {
                        v8 = ((BigQueryTable)table).getColumns().createOrGet(columnInfo.name);
                        Intrinsics.checkNotNullExpressionValue(v8, (String)"createOrGet(...)");
                        v7 = BigQuerySchemaRetriever.access$processTableColumn(this.this$0, (BigQueryTableColumn)v8, columnInfo);
                    } else {
                        v7 = column = null;
                    }
                    if (column != null) {
                        if (column.getPosition() == 0) {
                            this.$colsWithoutPosition.add((BigQueryLikeColumn)column);
                        } else {
                            var4_4 = this.$counter.element;
                            this.$counter.element = var4_4 + 1;
                        }
                    }
                }
            }));
            BigQuerySchemaRetriever.retrieveTableAndViewColumns$lambda$12$tableChanged(colsWithoutPosition, counter);
            it = BigQuerySchemaRetriever$retrieveTableAndViewColumns$$inlined$modifyFamiliesAndCleanup$2.INSTANCE;
            $i$a$-modifyFamiliesAndCleanup-BigQueryIntrospector$BigQuerySchemaRetriever$retrieveTableAndViewColumns$1 = false;
            ModNamingFamily<? extends BigQueryTable> modNamingFamily4 = ((BigQuerySchema)this.getSchema()).getTables();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily4, (String)"getTables(...)");
            $this$forEach$iv = modNamingFamily4;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                t = (BigQueryTable)element$iv;
                bl3 = false;
                PositioningNamingFamily positioningNamingFamily = t.getColumns();
                Intrinsics.checkNotNullExpressionValue((Object)positioningNamingFamily, (String)"getColumns(...)");
                it.invoke((Object)positioningNamingFamily);
            }
            ModNamingFamily<? extends BigQueryView> modNamingFamily5 = ((BigQuerySchema)this.getSchema()).getViews();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily5, (String)"getViews(...)");
            $this$forEach$iv = modNamingFamily5;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                t = (BigQueryView)element$iv;
                bl2 = false;
                PositioningNamingFamily positioningNamingFamily = t.getColumns();
                Intrinsics.checkNotNullExpressionValue((Object)positioningNamingFamily, (String)"getColumns(...)");
                it.invoke((Object)positioningNamingFamily);
            }
            ModNamingFamily<? extends BigQueryMatView> modNamingFamily6 = ((BigQuerySchema)this.getSchema()).getMatViews();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily6, (String)"getMatViews(...)");
            $this$forEach$iv = modNamingFamily6;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                t = (BigQueryMatView)element$iv;
                bl = false;
                PositioningNamingFamily positioningNamingFamily = t.getColumns();
                Intrinsics.checkNotNullExpressionValue((Object)positioningNamingFamily, (String)"getColumns(...)");
                it.invoke((Object)positioningNamingFamily);
            }
        }

        /*
         * Unable to fully structure code
         */
        private final BigQueryLikeColumn processViewColumn(BigQueryLikeColumn column, BigQueryIntroQueries.ColumnInfo columnInfo) {
            $this$processViewColumn_u24lambda_u2413 = var3_3 = column;
            $i$a$-apply-BigQueryIntrospector$BigQuerySchemaRetriever$processViewColumn$1 = false;
            $this$processViewColumn_u24lambda_u2413.setPosition(columnInfo.ordinal_position);
            $this$processViewColumn_u24lambda_u2413.setName(columnInfo.name);
            v0 = DataTypeFactory.of(columnInfo.data_type);
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"of(...)");
            $this$processViewColumn_u24lambda_u2413.setStoredType(DasUnresolvedTypeReference.Companion.of(v0));
            if (!Intrinsics.areEqual((Object)columnInfo.is_nullable, (Object)"NO")) ** GOTO lbl-1000
            v1 = columnInfo.data_type.toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"toLowerCase(...)");
            if (!StringsKt.startsWith$default((String)v1, (String)"array", (boolean)false, (int)2, null)) {
                v2 = true;
            } else lbl-1000:
            // 2 sources

            {
                v2 = false;
            }
            $this$processViewColumn_u24lambda_u2413.setNotNull(v2);
            $this$processViewColumn_u24lambda_u2413.setAutoCreated(Intrinsics.areEqual((Object)columnInfo.is_hidden, (Object)"YES"));
            return var3_3;
        }

        private final void retrieveColumnComments() {
            ObjectKind objectKind = ObjectKind.COLUMN;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"COLUMN");
            BigQueryIntrospector.this.reportRetrieving(objectKind);
            BigQueryIntroQueries.INSTANCE.processColumnComments(this.getTransaction(), (BigQuerySchema)this.getSchema(), (Function1<? super BigQueryIntroQueries.ColumnComment, Unit>)((Function1)new Function1<BigQueryIntroQueries.ColumnComment, Unit>(this){
                final /* synthetic */ BigQuerySchemaRetriever this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull BigQueryIntroQueries.ColumnComment c2) {
                    block2: {
                        BasicNode basicNode;
                        BigQueryLikeTable table;
                        BasicNode basicNode2;
                        BigQueryLikeTable bigQueryLikeTable;
                        Intrinsics.checkNotNullParameter((Object)c2, (String)"c");
                        BigQueryTable bigQueryTable = (BigQueryTable)((BigQuerySchema)this.this$0.getSchema()).getTables().get(c2.table_name);
                        if (bigQueryTable != null) {
                            bigQueryLikeTable = bigQueryTable;
                        } else {
                            BigQueryView bigQueryView = (BigQueryView)((BigQuerySchema)this.this$0.getSchema()).getViews().get(c2.table_name);
                            bigQueryLikeTable = bigQueryView != null ? (BigQueryLikeTable)bigQueryView : (BigQueryLikeTable)((BigQuerySchema)this.this$0.getSchema()).getMatViews().get(c2.table_name);
                        }
                        if ((basicNode2 = (table = bigQueryLikeTable)) == null || (basicNode2 = basicNode2.getColumns()) == null || (basicNode2 = (BasicModTableOrViewColumn)basicNode2.get(c2.name)) == null) break block2;
                        BasicNode $this$invoke_u24lambda_u240 = basicNode = basicNode2;
                        boolean bl = false;
                        $this$invoke_u24lambda_u240.setComment(c2.description);
                    }
                }
            }));
        }

        private final void retrieveRoutines() {
            BigQueryIntrospector.this.reportRetrieving("Routines", "introspection.retrieve.routinesList");
            boolean accessDenied = false;
            ModFamily $this$modifyAndCleanup_u24default$iv = ((BigQuerySchema)this.getSchema()).getRoutines();
            boolean inc$iv = true;
            boolean $i$f$modifyAndCleanup = false;
            $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
            ModNamingFamily it2 = (ModNamingFamily)$this$modifyAndCleanup_u24default$iv;
            boolean bl = false;
            boolean bl2 = accessDenied = !this.retrieveRoutinesInfo();
            if (accessDenied) {
                this.retrieveRoutinesInfoFromMetaData();
            }
            $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
            $this$modifyAndCleanup_u24default$iv.sort();
            if (!accessDenied) {
                this.retrieveRoutineOptions();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void retrieveRoutinesInfoFromMetaData() {
            BigQueryDatabase bigQueryDatabase = ((BigQuerySchema)this.getSchema()).getParent();
            Closeable closeable = BigQueryIntrospector.this.createMeta().routines(new DatabaseMetaDataWrapper.Schema(((BigQuerySchema)this.getSchema()).getName(), bigQueryDatabase != null ? bigQueryDatabase.getName() : null), null, null);
            Throwable throwable = null;
            try {
                ClosableIt it2 = (ClosableIt)closeable;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it2);
                ClosableIt closableIt = it2;
                while (closableIt.hasNext()) {
                    BigQueryRoutine bigQueryRoutine;
                    DatabaseMetaDataWrapper.Routine routine2 = (DatabaseMetaDataWrapper.Routine)closableIt.next();
                    BigQueryRoutine $this$retrieveRoutinesInfoFromMetaData_u24lambda_u2416_u24lambda_u2415 = bigQueryRoutine = ((BigQuerySchema)this.getSchema()).getRoutines().createOrGet(routine2.name);
                    boolean bl2 = false;
                    $this$retrieveRoutinesInfoFromMetaData_u24lambda_u2416_u24lambda_u2415.setName(routine2.name);
                    $this$retrieveRoutinesInfoFromMetaData_u24lambda_u2416_u24lambda_u2415.setRoutineKind(routine2.kind);
                    $this$retrieveRoutinesInfoFromMetaData_u24lambda_u2416_u24lambda_u2415.setComment(routine2.comment);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        private final boolean retrieveRoutinesInfo() {
            BigQueryIntrospector.this.reportRetrieving("routine sources", "introspection.retrieve.routine.sources");
            return BigQueryIntroQueries.INSTANCE.processRoutines(this.getTransaction(), (BigQuerySchema)this.getSchema(), (Function1<? super BigQueryIntroQueries.RoutineInfo, Unit>)((Function1)new Function1<BigQueryIntroQueries.RoutineInfo, Unit>(this){
                final /* synthetic */ BigQuerySchemaRetriever this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull BigQueryIntroQueries.RoutineInfo routine2) {
                    BigQueryRoutine bigQueryRoutine;
                    Intrinsics.checkNotNullParameter((Object)routine2, (String)"routine");
                    BigQueryRoutine $this$invoke_u24lambda_u240 = bigQueryRoutine = ((BigQuerySchema)this.this$0.getSchema()).getRoutines().createOrGet(routine2.name);
                    boolean bl = false;
                    $this$invoke_u24lambda_u240.setName(routine2.name);
                    $this$invoke_u24lambda_u240.setRoutineKind(BigQueryIntrospectorKt.access$getRoutineKind(routine2.routine_kind));
                    $this$invoke_u24lambda_u240.setLanguage(routine2.language);
                    $this$invoke_u24lambda_u240.setDeterministic(Intrinsics.areEqual((Object)routine2.is_deterministic, (Object)"YES"));
                }
            }));
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveRoutineArguments() {
            void $this$mapTo$iv$iv;
            ObjectKind objectKind = ObjectKind.ARGUMENT;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"ARGUMENT");
            BigQueryIntrospector.this.reportRetrieving(objectKind);
            ModNamingFamily<? extends BigQueryRoutine> modNamingFamily = ((BigQuerySchema)this.getSchema()).getRoutines();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getRoutines(...)");
            Iterable $this$map$iv = modNamingFamily;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                BigQueryRoutine bigQueryRoutine = (BigQueryRoutine)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(it2.getArguments());
            }
            Collection families$iv = (List)destination$iv$iv;
            boolean inc$iv = true;
            boolean $i$f$modifyFamiliesAndCleanup = false;
            Collection $this$toTypedArray$iv$iv = families$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv$iv = $this$toTypedArray$iv$iv;
            ModFamily[] fs$iv = thisCollection$iv$iv.toArray(new ModPositioningNamingFamily[0]);
            ModFamily[] families$iv$iv = Arrays.copyOf(fs$iv, fs$iv.length);
            boolean $i$f$modifyFamiliesAndCleanup2 = false;
            for (ModFamily f$iv$iv : families$iv$iv) {
                f$iv$iv.markChildrenAsSyncPending();
            }
            boolean bl = false;
            BigQueryIntroQueries.INSTANCE.processRoutineArguments(this.getTransaction(), (BigQuerySchema)this.getSchema(), (Function1<? super BigQueryIntroQueries.RoutineArgumentInfo, Unit>)((Function1)new Function1<BigQueryIntroQueries.RoutineArgumentInfo, Unit>(this){
                final /* synthetic */ BigQuerySchemaRetriever this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull BigQueryIntroQueries.RoutineArgumentInfo argInfo) {
                    block2: {
                        String it2;
                        BasicModArgument element2;
                        BasicModArgument basicModArgument;
                        Intrinsics.checkNotNullParameter((Object)argInfo, (String)"argInfo");
                        String string = argInfo.routine_name;
                        if (string == null) break block2;
                        String string2 = string;
                        BigQuerySchemaRetriever bigQuerySchemaRetriever = this.this$0;
                        String routine_name = string2;
                        boolean bl = false;
                        BigQueryRoutine routine2 = ((BigQuerySchema)bigQuerySchemaRetriever.getSchema()).getRoutines().createOrGet(routine_name);
                        BasicModArgument $this$invoke_u24lambda_u243_u24lambda_u242 = basicModArgument = (element2 = Intrinsics.areEqual((Object)argInfo.is_result, (Object)"YES") ? routine2.createOrGetReturnArgument() : (BasicModArgument)routine2.getArguments().createOrGetAt(argInfo.ordinal_position));
                        boolean bl2 = false;
                        String string3 = argInfo.name;
                        if (string3 != null) {
                            it2 = string3;
                            boolean bl3 = false;
                            $this$invoke_u24lambda_u243_u24lambda_u242.setName(it2);
                        }
                        String string4 = argInfo.data_type;
                        if (string4 != null) {
                            it2 = string4;
                            boolean bl4 = false;
                            DataType dataType = DataTypeFactory.of(it2);
                            Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"of(...)");
                            $this$invoke_u24lambda_u243_u24lambda_u242.setStoredType(DasUnresolvedTypeReference.Companion.of(dataType));
                        }
                        $this$invoke_u24lambda_u243_u24lambda_u242.setArgumentDirection(BigQueryIntrospectorKt.access$getDirection(argInfo));
                    }
                }
            }));
            for (ModFamily f$iv$iv : families$iv$iv) {
                f$iv$iv.removeSyncPendingChildren();
                f$iv$iv.sort();
            }
        }

        private final void retrieveRoutineSources() {
            BigQueryIntrospector.this.reportRetrieving("routine sources", "introspection.retrieve.routine.sources");
            BigQueryIntroQueries.INSTANCE.processRoutineSources(this.getTransaction(), (BigQuerySchema)this.getSchema(), (Function1<? super BigQueryIntroQueries.RoutineDefinition, Unit>)((Function1)new Function1<BigQueryIntroQueries.RoutineDefinition, Unit>(this){
                final /* synthetic */ BigQuerySchemaRetriever this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull BigQueryIntroQueries.RoutineDefinition routine2) {
                    BigQueryRoutine bigQueryRoutine;
                    Intrinsics.checkNotNullParameter((Object)routine2, (String)"routine");
                    BigQueryRoutine $this$invoke_u24lambda_u241 = bigQueryRoutine = ((BigQuerySchema)this.this$0.getSchema()).getRoutines().createOrGet(routine2.name);
                    boolean bl = false;
                    ((BasicModModel)$this$invoke_u24lambda_u241.getModel()).writeSources(() -> retrieveRoutineSources.1.invoke$lambda$1$lambda$0($this$invoke_u24lambda_u241, routine2));
                }

                private static final void invoke$lambda$1$lambda$0(BigQueryRoutine $this_apply, BigQueryIntroQueries.RoutineDefinition $routine) {
                    Intrinsics.checkNotNullParameter((Object)$routine, (String)"$routine");
                    $this_apply.setSourceText(BaseIntrospectionFunctions.toCompositeText(((Object)StringsKt.trim((CharSequence)$routine.routine_definition)).toString(), CompositeText.Kind.ORIGINAL_TEXT));
                }
            }));
        }

        private final void retrieveRoutineOptions() {
            BigQueryIntrospector.this.reportRetrieving("routine sources", "introspection.retrieve.routine.options");
            BigQueryIntroQueries.INSTANCE.processRoutineOptions(this.getTransaction(), (BigQuerySchema)this.getSchema(), (Function1<? super BigQueryIntroQueries.RoutineOption, Unit>)((Function1)new Function1<BigQueryIntroQueries.RoutineOption, Unit>(this){
                final /* synthetic */ BigQuerySchemaRetriever this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull BigQueryIntroQueries.RoutineOption routineOption) {
                    block0: {
                        String string;
                        BigQueryRoutine $this$invoke_u24lambda_u240;
                        block1: {
                            BigQueryRoutine bigQueryRoutine;
                            Intrinsics.checkNotNullParameter((Object)routineOption, (String)"routineOption");
                            BigQueryRoutine bigQueryRoutine2 = (BigQueryRoutine)((BigQuerySchema)this.this$0.getSchema()).getRoutines().get(routineOption.routine_name);
                            if (bigQueryRoutine2 == null) break block0;
                            $this$invoke_u24lambda_u240 = bigQueryRoutine = bigQueryRoutine2;
                            boolean bl = false;
                            string = routineOption.name;
                            if (!Intrinsics.areEqual((Object)string, (Object)"description")) break block1;
                            String string2 = routineOption.value;
                            $this$invoke_u24lambda_u240.setComment(string2 != null ? StringsKt.removeSurrounding((String)string2, (CharSequence)"\"") : null);
                            break block0;
                        }
                        if (!Intrinsics.areEqual((Object)string, (Object)"library")) break block0;
                        String string3 = routineOption.value;
                        $this$invoke_u24lambda_u240.setLibrary(string3 != null ? StringsKt.removeSurrounding((String)string3, (CharSequence)"\"") : null);
                    }
                }
            }));
        }

        private static final void retrieveTableAndViewColumns$lambda$12$tableChanged(List<BigQueryLikeColumn> colsWithoutPosition, Ref.IntRef counter) {
            Iterator<BigQueryLikeColumn> iterator = colsWithoutPosition.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                int index2 = n++;
                BigQueryLikeColumn col = iterator.next();
                col.setPosition((short)(counter.element + index2 + 1));
            }
            colsWithoutPosition.clear();
            counter.element = 0;
        }

        public static final /* synthetic */ void access$processMatViewOption(BigQuerySchemaRetriever $this, BigQueryMatView view2, BigQueryIntroQueries.TableOrViewOption tableOrViewOption) {
            $this.processMatViewOption(view2, tableOrViewOption);
        }

        public static final /* synthetic */ void access$processViewOption(BigQuerySchemaRetriever $this, BigQueryView view2, BigQueryIntroQueries.TableOrViewOption tableOrViewOption) {
            $this.processViewOption(view2, tableOrViewOption);
        }

        public static final /* synthetic */ void access$processTableOption(BigQuerySchemaRetriever $this, BigQueryTable table, BigQueryIntroQueries.TableOrViewOption tableOrViewOption) {
            $this.processTableOption(table, tableOrViewOption);
        }

        public static final /* synthetic */ BigQueryLikeColumn access$processViewColumn(BigQuerySchemaRetriever $this, BigQueryLikeColumn column2, BigQueryIntroQueries.ColumnInfo columnInfo) {
            return $this.processViewColumn(column2, columnInfo);
        }

        public static final /* synthetic */ BigQueryTableColumn access$processTableColumn(BigQuerySchemaRetriever $this, BigQueryTableColumn column2, BigQueryIntroQueries.ColumnInfo columnInfo) {
            return $this.processTableColumn(column2, columnInfo);
        }

        public static final /* synthetic */ void access$retrieveTableAndViewColumns$lambda$12$tableChanged(List colsWithoutPosition, Ref.IntRef counter) {
            BigQuerySchemaRetriever.retrieveTableAndViewColumns$lambda$12$tableChanged(colsWithoutPosition, counter);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/database/dialects/bigquery/introspector/BigQueryIntrospector$Factory;", "Lcom/intellij/database/introspection/DBIntrospector$Factory;", "()V", "createIntrospector", "Lcom/intellij/database/introspection/DBIntrospector;", "context", "Lcom/intellij/database/introspection/DBIntrospectionContext;", "dbms", "Lcom/intellij/database/Dbms;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "getVersion", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "isOutdatedCheckSupported", "", "e", "Lcom/intellij/database/model/basic/BasicElement;", "isSupported", "version", "Lcom/intellij/database/util/Version;", "VERSION", "intellij.database.dialects.bigquery"})
    public static final class Factory
    implements DBIntrospector.Factory {
        @Override
        public boolean isSupported(@NotNull Version version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            int[] nArray = new int[]{1, 0};
            return version.isOrGreater(nArray);
        }

        @Override
        @NotNull
        public DBIntrospector createIntrospector(@NotNull DBIntrospectionContext context, @NotNull Dbms dbms, @NotNull ModelFactory modelFactory) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
            Intrinsics.checkNotNullParameter((Object)modelFactory, (String)"modelFactory");
            return new BigQueryIntrospector(context, modelFactory);
        }

        @Override
        public int getVersion(@NotNull ObjectKind kind) {
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            return VERSION.INSTANCE.get(kind);
        }

        @Override
        public boolean isOutdatedCheckSupported(@Nullable BasicElement e2) {
            return false;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/database/dialects/bigquery/introspector/BigQueryIntrospector$Factory$VERSION;", "Lcom/intellij/database/model/PerObjectVersion;", "()V", "intellij.database.dialects.bigquery"})
        public static final class VERSION
        extends PerObjectVersion {
            @NotNull
            public static final VERSION INSTANCE = new VERSION();

            private VERSION() {
            }
        }
    }
}

