/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.bigquery.generator;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.generator.ScriptGeneratorHelper;
import com.intellij.database.dialects.base.generator.ScriptingContext;
import com.intellij.database.dialects.base.generator.producers.AlterProducerBase;
import com.intellij.database.dialects.base.generator.producers.BaseProducersKt;
import com.intellij.database.dialects.base.generator.producers.CreateProducer;
import com.intellij.database.dialects.base.generator.producers.DropProducer;
import com.intellij.database.dialects.base.generator.producers.TruncateProducer;
import com.intellij.database.dialects.bigquery.generator.producers.BigQueryAlterArgument;
import com.intellij.database.dialects.bigquery.generator.producers.BigQueryAlterDatabase;
import com.intellij.database.dialects.bigquery.generator.producers.BigQueryAlterLikeView;
import com.intellij.database.dialects.bigquery.generator.producers.BigQueryAlterMatView;
import com.intellij.database.dialects.bigquery.generator.producers.BigQueryAlterMatViewColumn;
import com.intellij.database.dialects.bigquery.generator.producers.BigQueryAlterRoutine;
import com.intellij.database.dialects.bigquery.generator.producers.BigQueryAlterSchema;
import com.intellij.database.dialects.bigquery.generator.producers.BigQueryAlterTable;
import com.intellij.database.dialects.bigquery.generator.producers.BigQueryAlterTableColumn;
import com.intellij.database.dialects.bigquery.generator.producers.BigQueryAlterViewColumn;
import com.intellij.database.dialects.bigquery.generator.producers.BigQueryCreateLikeView;
import com.intellij.database.dialects.bigquery.generator.producers.BigQueryCreateMatView;
import com.intellij.database.dialects.bigquery.generator.producers.BigQueryCreateMatViewColumn;
import com.intellij.database.dialects.bigquery.generator.producers.BigQueryCreateRoutine;
import com.intellij.database.dialects.bigquery.generator.producers.BigQueryCreateTable;
import com.intellij.database.dialects.bigquery.generator.producers.BigQueryCreateTableColumn;
import com.intellij.database.dialects.bigquery.generator.producers.BigQueryCreateViewColumn;
import com.intellij.database.dialects.bigquery.generator.producers.BigQueryDropMatView;
import com.intellij.database.dialects.bigquery.generator.producers.BigQueryDropRoutine;
import com.intellij.database.dialects.bigquery.generator.producers.BigQueryDropTable;
import com.intellij.database.dialects.bigquery.generator.producers.BigQueryDropTableColumn;
import com.intellij.database.dialects.bigquery.generator.producers.BigQueryDropView;
import com.intellij.database.dialects.bigquery.generator.producers.BigQueryTruncateTable;
import com.intellij.database.dialects.bigquery.model.BigQueryArgument;
import com.intellij.database.dialects.bigquery.model.BigQueryDatabase;
import com.intellij.database.dialects.bigquery.model.BigQueryLikeTable;
import com.intellij.database.dialects.bigquery.model.BigQueryLikeView;
import com.intellij.database.dialects.bigquery.model.BigQueryMatView;
import com.intellij.database.dialects.bigquery.model.BigQueryMatViewColumn;
import com.intellij.database.dialects.bigquery.model.BigQueryRoutine;
import com.intellij.database.dialects.bigquery.model.BigQuerySchema;
import com.intellij.database.dialects.bigquery.model.BigQueryTable;
import com.intellij.database.dialects.bigquery.model.BigQueryTableColumn;
import com.intellij.database.dialects.bigquery.model.BigQueryView;
import com.intellij.database.dialects.bigquery.model.BigQueryViewColumn;
import com.intellij.database.model.ElementAlteration;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicLikeTable;
import com.intellij.database.script.generator.ScriptingOption;
import com.intellij.database.script.generator.ScriptingOptionStatic;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rH\u0016J\u001c\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001c\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001c\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00152\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0012\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\u0014\u0010\u001a\u001a\u00020\u001b2\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u001dH\u0016R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001e"}, d2={"Lcom/intellij/database/dialects/bigquery/generator/BigQueryScriptGeneratorHelper;", "Lcom/intellij/database/dialects/base/generator/ScriptGeneratorHelper;", "()V", "supportsCreateIfNotExists", "", "Lcom/intellij/database/model/ObjectKind;", "getSupportsCreateIfNotExists", "()Ljava/util/Set;", "createAlterProducerImpl", "Lcom/intellij/database/dialects/base/generator/producers/AlterProducerBase;", "context", "Lcom/intellij/database/dialects/base/generator/ScriptingContext;", "elements", "Lcom/intellij/database/model/ElementAlteration;", "createDropProducerImpl", "Lcom/intellij/database/dialects/base/generator/producers/DropProducer;", "element", "Lcom/intellij/database/model/basic/BasicElement;", "createProducerImpl", "Lcom/intellij/database/dialects/base/generator/producers/CreateProducer;", "createTruncateProducer", "Lcom/intellij/database/dialects/base/generator/producers/TruncateProducer;", "getTableTerm", "", "table", "Lcom/intellij/database/model/basic/BasicLikeTable;", "isOptionSupported", "", "option", "Lcom/intellij/database/script/generator/ScriptingOption;", "intellij.database.dialects.bigquery"})
public final class BigQueryScriptGeneratorHelper
extends ScriptGeneratorHelper {
    @NotNull
    public static final BigQueryScriptGeneratorHelper INSTANCE = new BigQueryScriptGeneratorHelper();

    private BigQueryScriptGeneratorHelper() {
        Dbms dbms = Dbms.BIGQUERY;
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"BIGQUERY");
        super(dbms);
    }

    @Override
    @NotNull
    protected Set<ObjectKind> getSupportsCreateIfNotExists() {
        Object[] objectArray = new ObjectKind[]{ObjectKind.DATABASE, ObjectKind.TABLE, ObjectKind.VIEW, ObjectKind.MAT_VIEW};
        return SetsKt.setOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public CreateProducer<?> createProducerImpl(@NotNull ScriptingContext context, @NotNull BasicElement element2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        BasicElement basicElement = element2;
        return basicElement instanceof BigQueryTable ? (CreateProducer)new BigQueryCreateTable(context, (BigQueryTable)element2) : (basicElement instanceof BigQueryView ? (CreateProducer)new BigQueryCreateLikeView<BigQueryLikeView>(context, (BigQueryLikeView)element2) : (basicElement instanceof BigQueryMatView ? (CreateProducer)new BigQueryCreateMatView(context, (BigQueryMatView)element2) : (basicElement instanceof BigQueryTableColumn ? (CreateProducer)new BigQueryCreateTableColumn(context, (BigQueryTableColumn)element2) : (basicElement instanceof BigQueryViewColumn ? (CreateProducer)new BigQueryCreateViewColumn(context, (BigQueryViewColumn)element2) : (basicElement instanceof BigQueryMatViewColumn ? (CreateProducer)new BigQueryCreateMatViewColumn(context, (BigQueryMatViewColumn)element2) : (basicElement instanceof BigQueryRoutine ? (CreateProducer)new BigQueryCreateRoutine(context, (BigQueryRoutine)element2) : super.createProducerImpl(context, element2)))))));
    }

    @Override
    @NotNull
    public DropProducer<?> createDropProducerImpl(@NotNull ScriptingContext context, @NotNull BasicElement element2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        BasicElement basicElement = element2;
        return basicElement instanceof BigQueryTable ? (DropProducer)new BigQueryDropTable(context, (BigQueryTable)element2) : (basicElement instanceof BigQueryView ? (DropProducer)new BigQueryDropView(context, (BigQueryView)element2) : (basicElement instanceof BigQueryMatView ? (DropProducer)new BigQueryDropMatView(context, (BigQueryMatView)element2) : (basicElement instanceof BigQueryTableColumn ? (DropProducer)new BigQueryDropTableColumn(context, (BigQueryTableColumn)element2) : (basicElement instanceof BigQueryRoutine ? (DropProducer)new BigQueryDropRoutine(context, (BigQueryRoutine)element2) : super.createDropProducerImpl(context, element2)))));
    }

    @Override
    @NotNull
    public AlterProducerBase<?> createAlterProducerImpl(@NotNull ScriptingContext context, @NotNull ElementAlteration<?> elements2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(elements2, (String)"elements");
        Object it2 = elements2.getSourceElement();
        boolean bl = false;
        Object obj2 = it2;
        return obj2 instanceof BigQueryTable ? (AlterProducerBase)new BigQueryAlterTable(context, (ElementAlteration<? extends BigQueryTable>)BaseProducersKt.cast(elements2, it2)) : (obj2 instanceof BigQueryView ? (AlterProducerBase)new BigQueryAlterLikeView(context, BaseProducersKt.cast(elements2, it2), null, 4, null) : (obj2 instanceof BigQueryMatView ? (AlterProducerBase)new BigQueryAlterMatView(context, (ElementAlteration<? extends BigQueryMatView>)BaseProducersKt.cast(elements2, it2)) : (obj2 instanceof BigQueryTableColumn ? (AlterProducerBase)new BigQueryAlterTableColumn(context, (ElementAlteration<? extends BigQueryTableColumn>)BaseProducersKt.cast(elements2, it2)) : (obj2 instanceof BigQueryViewColumn ? (AlterProducerBase)new BigQueryAlterViewColumn(context, (ElementAlteration<? extends BigQueryViewColumn>)BaseProducersKt.cast(elements2, it2)) : (obj2 instanceof BigQueryMatViewColumn ? (AlterProducerBase)new BigQueryAlterMatViewColumn(context, (ElementAlteration<? extends BigQueryMatViewColumn>)BaseProducersKt.cast(elements2, it2)) : (obj2 instanceof BigQueryDatabase ? (AlterProducerBase)new BigQueryAlterDatabase(context, (ElementAlteration<? extends BigQueryDatabase>)BaseProducersKt.cast(elements2, it2)) : (obj2 instanceof BigQuerySchema ? (AlterProducerBase)new BigQueryAlterSchema(context, (ElementAlteration<? extends BigQuerySchema>)BaseProducersKt.cast(elements2, it2)) : (obj2 instanceof BigQueryArgument ? (AlterProducerBase)new BigQueryAlterArgument(context, (ElementAlteration<? extends BigQueryArgument>)BaseProducersKt.cast(elements2, it2)) : (obj2 instanceof BigQueryRoutine ? (AlterProducerBase)new BigQueryAlterRoutine(context, (ElementAlteration<? extends BigQueryRoutine>)BaseProducersKt.cast(elements2, it2)) : super.createAlterProducerImpl(context, elements2))))))))));
    }

    @Override
    @NotNull
    public String getTableTerm(@Nullable BasicLikeTable table) {
        ObjectKind objectKind;
        BasicLikeTable basicLikeTable = table;
        ObjectKind objectKind2 = objectKind = basicLikeTable != null ? basicLikeTable.getKind() : null;
        return Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.VIEW) ? "view" : (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.MAT_VIEW) ? "materialized view" : "table");
    }

    @Override
    @NotNull
    public TruncateProducer<?> createTruncateProducer(@NotNull ScriptingContext context, @NotNull BasicElement element2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        return element2 instanceof BigQueryLikeTable ? (TruncateProducer)new BigQueryTruncateTable(context, (BigQueryLikeTable)element2) : super.createTruncateProducer(context, element2);
    }

    @Override
    public boolean isOptionSupported(@NotNull ScriptingOption<?> option) {
        Intrinsics.checkNotNullParameter(option, (String)"option");
        ScriptingOption<?> scriptingOption = option;
        return Intrinsics.areEqual(scriptingOption, ScriptingOptionStatic.IF_EXISTS) ? true : (Intrinsics.areEqual(scriptingOption, ScriptingOptionStatic.DROP_CASCADE) ? false : super.isOptionSupported(option));
    }
}

