/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.bigquery.generator;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.generator.AbstractNamingService;
import com.intellij.database.dialects.bigquery.generator.BigQueryNamingServiceKt;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.util.Casing;
import com.intellij.sql.psi.SqlDbElementType;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/dialects/bigquery/generator/BigQueryNamingService;", "Lcom/intellij/database/dialects/base/generator/AbstractNamingService;", "()V", "closingQuotes", "", "getClosingQuotes", "()Ljava/lang/String;", "openingQuotes", "getOpeningQuotes", "getCasing", "Lcom/intellij/database/util/Casing;", "kind", "Lcom/intellij/database/model/ObjectKind;", "context", "Lcom/intellij/database/model/DasObject;", "Provider", "intellij.database.dialects.bigquery"})
public final class BigQueryNamingService
extends AbstractNamingService {
    @NotNull
    public static final BigQueryNamingService INSTANCE = new BigQueryNamingService();

    private BigQueryNamingService() {
        Dbms dbms = Dbms.BIGQUERY;
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"BIGQUERY");
        Pattern pattern2 = BigQueryNamingServiceKt.access$pattern("a-zA-Z}");
        Intrinsics.checkNotNullExpressionValue((Object)pattern2, (String)"access$pattern(...)");
        Casing casing = CasingProvider.EXACT_CASING;
        Intrinsics.checkNotNullExpressionValue((Object)casing, (String)"EXACT_CASING");
        super(dbms, pattern2, casing);
    }

    @Override
    @NotNull
    public String getClosingQuotes() {
        return "`";
    }

    @Override
    @NotNull
    public String getOpeningQuotes() {
        return "`";
    }

    @Override
    @NotNull
    public Casing getCasing(@NotNull ObjectKind kind, @Nullable DasObject context) {
        Casing casing;
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        ObjectKind objectKind = kind;
        if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.COLUMN) ? true : Intrinsics.areEqual((Object)objectKind, (Object)SqlDbElementType.LOCAL_ALIAS)) {
            Casing casing2 = CasingProvider.MIXED_CASING;
            casing = casing2;
            Intrinsics.checkNotNullExpressionValue((Object)casing2, (String)"MIXED_CASING");
        } else {
            casing = super.getCasing(kind, context);
        }
        return casing;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/database/dialects/bigquery/generator/BigQueryNamingService$Provider;", "Lcom/intellij/database/script/generator/NamingService$Provider;", "()V", "getNamingService", "Lcom/intellij/database/script/generator/NamingService;", "model", "Lcom/intellij/database/model/basic/BasicModel;", "database", "Lcom/intellij/database/model/basic/BasicDatabase;", "intellij.database.dialects.bigquery"})
    public static final class Provider
    implements NamingService.Provider {
        @Override
        @NotNull
        public NamingService getNamingService(@Nullable BasicModel model2, @Nullable BasicDatabase database) {
            return INSTANCE;
        }
    }
}

