/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.introspector.jdbc;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DBConnectionAccessibilityMatcher;
import com.intellij.database.dataSource.DataSourceSchemaMapping;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dialects.base.introspector.BaseIntrospector;
import com.intellij.database.dialects.base.introspector.BaseMultiDatabaseIntrospectorKt;
import com.intellij.database.dialects.base.introspector.BaseSingleDatabaseIntrospectorKt;
import com.intellij.database.dialects.base.introspector.jdbc.JdbcIntrospectorHelper;
import com.intellij.database.dialects.base.introspector.jdbc.JdbcIntrospectorLegacyModelUtils;
import com.intellij.database.dialects.base.introspector.jdbc.JdbcSourceLoader;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.ClosableIt;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.DatabaseMetaDataWrapper;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.MetaDataUtil;
import com.intellij.database.introspection.CheckUptodatenessIntrospectionTask;
import com.intellij.database.introspection.DBIntrospectionContext;
import com.intellij.database.introspection.DBIntrospectionException;
import com.intellij.database.introspection.DBIntrospectionOptions;
import com.intellij.database.introspection.DBIntrospector;
import com.intellij.database.introspection.DatabaseIntrospectionTask;
import com.intellij.database.introspection.DatabaseObjectsIntrospectionTask;
import com.intellij.database.introspection.DefiniteIntrospectionTask;
import com.intellij.database.introspection.IntrospectionTask;
import com.intellij.database.introspection.IntrospectionTaskHelperFun;
import com.intellij.database.introspection.IntrospectionTasks;
import com.intellij.database.introspection.ListSchemasTask;
import com.intellij.database.introspection.RegularIntrospectionTask;
import com.intellij.database.introspection.SchemasIntrospectionTask;
import com.intellij.database.introspection.ServerObjectsIntrospectionTask;
import com.intellij.database.layoutedQueries.DBTransaction;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PerObjectVersion;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModDatabase;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModMateDatabase;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModMultiDatabaseRoot;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModNamespace;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.basic.BasicModRoutine;
import com.intellij.database.model.basic.BasicModSchema;
import com.intellij.database.model.basic.BasicModSourceAware;
import com.intellij.database.model.basic.BasicModTableOrView;
import com.intellij.database.model.basic.BasicMultiDatabaseRoot;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicSingleDatabaseRoot;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.remote.jdba.core.ConnectionInfo;
import com.intellij.database.remote.jdbc.RemoteDatabaseMetaData;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.Version;
import com.intellij.database.util.common.CalendarFun;
import com.intellij.openapi.util.Conditions;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.MultiMap;
import java.sql.SQLException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JdbcIntrospector
extends BaseIntrospector<BasicModRoot> {
    private String database;
    private String[] myTableTypes;
    private Set<ObjectKind> myTableKinds;
    private JdbcIntrospectorHelper myHelper;
    private ConnectionInfo myInfo;
    @Nullable
    private JdbcSourceLoader mySrcLoader;
    private TreePattern introspectionScope;
    private boolean namespacesAreIntrospected;
    private boolean introspectAutoFinished;

    @Override
    @Nullable
    public String collectDiagnosticInfo(@NotNull Iterable<? extends BasicElement> elements2) {
        if (elements2 == null) {
            JdbcIntrospector.$$$reportNull$$$0(0);
        }
        return "JDBC introspector";
    }

    public JdbcIntrospector(@NotNull DBIntrospectionContext context, @NotNull BaseIntrospector.Nature nature, @NotNull Dbms dbms, @NotNull ModelFactory modelFactory) {
        if (context == null) {
            JdbcIntrospector.$$$reportNull$$$0(1);
        }
        if (nature == null) {
            JdbcIntrospector.$$$reportNull$$$0(2);
        }
        if (dbms == null) {
            JdbcIntrospector.$$$reportNull$$$0(3);
        }
        if (modelFactory == null) {
            JdbcIntrospector.$$$reportNull$$$0(4);
        }
        super(context, nature, dbms, modelFactory);
        this.mySrcLoader = null;
        this.introspectionScope = null;
        this.namespacesAreIntrospected = false;
        this.introspectAutoFinished = false;
    }

    @Override
    @NotNull
    public BasicModModel init(@Nullable BasicModModel model2, @NotNull LocalDataSource dataSource2, @Nullable TreePattern introspectionScope) {
        if (dataSource2 == null) {
            JdbcIntrospector.$$$reportNull$$$0(5);
        }
        BasicModModel newModel = super.init(model2, dataSource2, introspectionScope);
        if (this.myHelper != null) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " already initialized");
        }
        this.myHelper = new JdbcIntrospectorHelper(newModel, this.dbms);
        this.introspectionScope = dataSource2.getIntrospectionScope();
        BasicModModel basicModModel = newModel;
        if (basicModModel == null) {
            JdbcIntrospector.$$$reportNull$$$0(6);
        }
        return basicModModel;
    }

    @Override
    @Nullable
    public String getCurrentDatabase() {
        return this.myInfo != null ? this.myInfo.databaseName : null;
    }

    @Override
    public void attachToDB(@NotNull DatabaseConnectionCore connection2) {
        if (connection2 == null) {
            JdbcIntrospector.$$$reportNull$$$0(7);
        }
        super.attachToDB(connection2);
        this.myInfo = this.getDbConnectionInfo();
        if (this.dbms.isDb2()) {
            this.myInfo = new ConnectionInfo(this.myInfo.dbmsName, this.myInfo.databaseName, this.myInfo.schemaName == null ? null : this.myInfo.schemaName.trim(), this.myInfo.userName, this.myInfo.serverVersion, this.myInfo.driverVersion);
        }
        this.myHelper.setCatalogIsSchema(connection2.getConnectionPoint().getDataSource().getInfo().isJdbcCatalogIsSchema());
        this.ensureHaveSourceLoader();
    }

    public void ensureHaveSourceLoader() {
        boolean withSources = this.getOptions().getSources() != DBIntrospectionOptions.SourceLoading.NO_SOURCES;
        if (withSources == (this.mySrcLoader != null)) {
            return;
        }
        this.mySrcLoader = withSources ? JdbcSourceLoader.EP.forDbms(this.dbms) : null;
    }

    @Override
    @NotNull
    public Map<BasicElement, Boolean> checkElementsUptodate(@NotNull Iterable<? extends BasicElement> elements2) {
        if (elements2 == null) {
            JdbcIntrospector.$$$reportNull$$$0(8);
        }
        Map<BasicElement, Boolean> map2 = Collections.emptyMap();
        if (map2 == null) {
            JdbcIntrospector.$$$reportNull$$$0(9);
        }
        return map2;
    }

    @Override
    public void detachFromDB() {
        super.detachFromDB();
        this.myInfo = null;
        this.mySrcLoader = null;
    }

    @Override
    protected void optionsAreSet(@NotNull DBIntrospectionOptions newOptions) {
        if (newOptions == null) {
            JdbcIntrospector.$$$reportNull$$$0(10);
        }
        super.optionsAreSet(newOptions);
        this.ensureHaveSourceLoader();
    }

    @Override
    @NotNull
    public TreePattern getDefaultScope() {
        TreePattern treePattern = ModelFun.isMultiDatabase(this.dbms) ? BaseMultiDatabaseIntrospectorKt.getMULTI_DB_SCOPE() : BaseSingleDatabaseIntrospectorKt.getSINGLE_DB_SCOPE();
        if (treePattern == null) {
            JdbcIntrospector.$$$reportNull$$$0(11);
        }
        return treePattern;
    }

    @Override
    @Nullable
    protected BasicDatabase reifyDatabase(@NotNull DBTransaction transaction, @NotNull String databaseName) {
        BasicDatabase database;
        if (transaction == null) {
            JdbcIntrospector.$$$reportNull$$$0(12);
        }
        if (databaseName == null) {
            JdbcIntrospector.$$$reportNull$$$0(13);
        }
        if ((database = this.findDatabase(databaseName)) == null) {
            this.retrieveDatabases();
            database = this.findDatabase(databaseName);
        }
        return database;
    }

    @Override
    @Nullable
    protected BasicDatabase findDatabase(@NotNull String databaseName) {
        if (databaseName == null) {
            JdbcIntrospector.$$$reportNull$$$0(14);
        }
        BasicModModel model2 = this.getMyModel();
        BasicRoot root2 = model2.getRoot();
        if (databaseName.equals("@") || databaseName.isEmpty()) {
            return root2.getCurrentDatabase();
        }
        if (root2 instanceof BasicSingleDatabaseRoot) {
            BasicSingleDatabaseRoot single = (BasicSingleDatabaseRoot)root2;
            if (single.getName().equals(databaseName)) {
                return single;
            }
        } else if (root2 instanceof BasicMultiDatabaseRoot) {
            BasicMultiDatabaseRoot multi = (BasicMultiDatabaseRoot)root2;
            return multi.getDatabases().get(databaseName);
        }
        return null;
    }

    @Override
    protected void introspectNamespaces(@NotNull DBTransaction transaction, @NotNull IntrospectionTask task) {
        BasicDatabase theOnlyDatabase;
        if (transaction == null) {
            JdbcIntrospector.$$$reportNull$$$0(15);
        }
        if (task == null) {
            JdbcIntrospector.$$$reportNull$$$0(16);
        }
        if ((theOnlyDatabase = this.taskHelper.specifiedDatabaseOf(task)) != null) {
            this.retrieveSchemasOfDatabase(theOnlyDatabase);
        } else {
            if (this.isMetadataAccessDependsOnConnection()) {
                this.retrieveDatabases();
                BasicModModel model2 = this.getModel();
                List databasesToProcess = JBIterable.from(model2.getRoot().getAllDatabases()).filter(db2 -> this.inIntrospectionScope((BasicNamespace)db2)).toList();
                for (BasicDatabase db3 : databasesToProcess) {
                    if (this.canAccessDatabaseInThisConnection(db3)) {
                        this.retrieveSchemasOfDatabase(db3);
                        continue;
                    }
                    ListSchemasTask additionalTask = new ListSchemasTask(db3.getName());
                    this.deferTask(additionalTask);
                }
            } else {
                this.introspectNamespaces();
            }
            this.namespacesAreIntrospected = true;
        }
    }

    @Override
    protected void introspectGeneral(@NotNull DBTransaction transaction) {
        if (transaction == null) {
            JdbcIntrospector.$$$reportNull$$$0(17);
        }
        this.introspectAllAutomatically();
    }

    @Override
    protected void introspectDatabase(@NotNull DBTransaction transaction, @NotNull DatabaseIntrospectionTask task) {
        Object root2;
        if (transaction == null) {
            JdbcIntrospector.$$$reportNull$$$0(18);
        }
        if (task == null) {
            JdbcIntrospector.$$$reportNull$$$0(19);
        }
        if ((root2 = this.getRoot()) instanceof BasicSingleDatabaseRoot) {
            this.introspectAutoInTran(transaction, null);
        } else if (root2 instanceof BasicMultiDatabaseRoot) {
            BasicDatabase database = this.getDatabaseOrSole(task);
            if (database == null) {
                throw new IllegalArgumentException("Cannot perform the database introspection task when the database is not properly specified in the task: " + task);
            }
            this.retrieveSchemasOfDatabase(database);
            this.introspectAutoInTran(transaction, Collections.singleton(database));
        }
    }

    @Override
    protected void introspectSchemas(@NotNull DBTransaction transaction, @NotNull SchemasIntrospectionTask task) {
        BasicDatabase database;
        if (transaction == null) {
            JdbcIntrospector.$$$reportNull$$$0(20);
        }
        if (task == null) {
            JdbcIntrospector.$$$reportNull$$$0(21);
        }
        if ((database = this.getDatabaseOrSole(task)) == null) {
            throw new IllegalArgumentException("Cannot perform schemas introspection task because the related database is not properly specified: " + task);
        }
        List<@NotNull ? extends BasicSchema> schemas2 = ModelFun.elementsByNames(database.getSchemas(), task.getSchemaNames());
        this.introspectAutoInTran(transaction, schemas2);
    }

    @Nullable
    private BasicDatabase getDatabaseOrSole(@NotNull IntrospectionTask task) {
        BasicDatabase database;
        if (task == null) {
            JdbcIntrospector.$$$reportNull$$$0(22);
        }
        if ((database = this.taskHelper.specifiedDatabaseOf(task)) == null) {
            database = this.getCurrentOrSole(this.getModel().getRoot().getAllDatabases());
        }
        return database;
    }

    @Override
    protected void introspectRegularElements(@NotNull DBTransaction transaction, @NotNull RegularIntrospectionTask task) {
        Collection<BasicSchema> schemasToIntrospect2;
        BasicDatabase taskDatabase;
        if (transaction == null) {
            JdbcIntrospector.$$$reportNull$$$0(23);
        }
        if (task == null) {
            JdbcIntrospector.$$$reportNull$$$0(24);
        }
        if ((taskDatabase = this.getDatabaseOrSole(task)) != null && task.getContainsDatabaseItself()) {
            this.retrieveSchemasOfDatabase(taskDatabase);
            schemasToIntrospect2 = this.getDatabaseSchemasInScope(taskDatabase);
        } else {
            schemasToIntrospect2 = IntrospectionTaskHelperFun.schemasOf(this.taskHelper, task.getElementsToRefresh());
        }
        this.introspectSchemasInThisConnection(schemasToIntrospect2);
    }

    @Override
    protected void introspectServerElements(@NotNull DBTransaction transaction, @NotNull ServerObjectsIntrospectionTask task) {
        if (transaction == null) {
            JdbcIntrospector.$$$reportNull$$$0(25);
        }
        if (task == null) {
            JdbcIntrospector.$$$reportNull$$$0(26);
        }
        if (this.nature.getSupportServerObjects()) {
            this.introspectAllAutomatically();
        }
    }

    @Override
    protected void introspectDatabaseObjects(@NotNull DBTransaction transaction, @NotNull DatabaseObjectsIntrospectionTask task) {
        if (transaction == null) {
            JdbcIntrospector.$$$reportNull$$$0(27);
        }
        if (task == null) {
            JdbcIntrospector.$$$reportNull$$$0(28);
        }
    }

    @Override
    protected void introspectAutoInTran(@NotNull DBTransaction tran, @Nullable Collection<? extends BasicNamespace> namespaces2) {
        if (tran == null) {
            JdbcIntrospector.$$$reportNull$$$0(29);
        }
        if (namespaces2 != null && !namespaces2.isEmpty()) {
            this.introspectSpecifiedAreasAutomatically((BasicNamespace[])namespaces2.toArray(BasicNamespace[]::new));
        } else {
            this.introspectAllAutomatically();
        }
    }

    @Override
    protected void checkUptodate(@NotNull DBTransaction transaction, @NotNull CheckUptodatenessIntrospectionTask task) {
        if (transaction == null) {
            JdbcIntrospector.$$$reportNull$$$0(30);
        }
        if (task == null) {
            JdbcIntrospector.$$$reportNull$$$0(31);
        }
        this.logWarn("JdbcIntrospector doesn't support outdated objects checking");
    }

    @Override
    public void introspectAuto() {
        if (this.getDbConnection() == null) {
            throw new AssertionError((Object)"Not connected to database");
        }
        this.introspectAllAutomatically();
    }

    @Override
    public void introspectAuto(@NotNull @NotNull BasicNamespace @NotNull [] namespaces2) {
        if (namespaces2 == null) {
            JdbcIntrospector.$$$reportNull$$$0(32);
        }
        if (this.getDbConnection() == null) {
            throw new AssertionError((Object)"Not connected to database");
        }
        if (namespaces2.length > 0) {
            this.introspectSpecifiedAreasAutomatically(namespaces2);
        } else {
            this.introspectAllAutomatically();
        }
    }

    private void introspectAllAutomatically() {
        this.introspectNamespaces();
        if (this.introspectAutoFinished) {
            return;
        }
        BasicModModel model2 = this.getModel();
        BasicRoot root2 = model2.getRoot();
        if (this.isMetadataAccessDependsOnConnection()) {
            Iterable<? extends BasicDatabase> databases2 = root2.getAllDatabases();
            for (BasicDatabase basicDatabase : databases2) {
                if (!this.inIntrospectionScope(basicDatabase)) continue;
                if (this.canAccessDatabaseInThisConnection(basicDatabase)) {
                    List<@NotNull BasicSchema> schemasToIntrospect2 = this.getDatabaseSchemasInScope(basicDatabase);
                    this.introspectSchemasInThisConnection(schemasToIntrospect2);
                    continue;
                }
                DefiniteIntrospectionTask additionalTask = IntrospectionTasks.prepareDatabaseTask(basicDatabase);
                this.deferTask(additionalTask);
            }
        } else {
            List<BasicSchema> schemasToIntrospect3 = JdbcIntrospector.listAllSchemasToIntrospect(root2, this.introspectionScope);
            this.introspectSchemasInThisConnection(schemasToIntrospect3);
        }
        this.introspectAutoFinished = true;
    }

    @NotNull
    private @NotNull List<@NotNull BasicSchema> getDatabaseSchemasInScope(@NotNull BasicDatabase db2) {
        List schemasToIntrospect2;
        if (db2 == null) {
            JdbcIntrospector.$$$reportNull$$$0(33);
        }
        List list = schemasToIntrospect2 = db2.getSchemas().jbi().filter(x$0 -> this.inIntrospectionScope((BasicNamespace)x$0)).filter(BasicSchema.class).toList();
        if (list == null) {
            JdbcIntrospector.$$$reportNull$$$0(34);
        }
        return list;
    }

    @Override
    @NotNull
    protected BaseIntrospector.ConnectionApplicability checkConnectionApplicable(@NotNull IntrospectionTask task) {
        BasicDatabase taskDatabase;
        if (task == null) {
            JdbcIntrospector.$$$reportNull$$$0(35);
        }
        if ((taskDatabase = this.getDatabaseOrSole(task)) == null) {
            BaseIntrospector.ConnectionApplicability connectionApplicability = this.isMetadataAccessDependsOnConnection() ? BaseIntrospector.ConnectionApplicability.connApplicablePartial : BaseIntrospector.ConnectionApplicability.connApplicableFull;
            if (connectionApplicability == null) {
                JdbcIntrospector.$$$reportNull$$$0(36);
            }
            return connectionApplicability;
        }
        BaseIntrospector.ConnectionApplicability connectionApplicability = this.canAccessDatabaseInThisConnection(taskDatabase) ? BaseIntrospector.ConnectionApplicability.connApplicableFull : BaseIntrospector.ConnectionApplicability.connInapplicable;
        if (connectionApplicability == null) {
            JdbcIntrospector.$$$reportNull$$$0(37);
        }
        return connectionApplicability;
    }

    private boolean canAccessDatabaseInThisConnection(@NotNull BasicDatabase database) {
        DatabaseConnectionCore connection2;
        if (database == null) {
            JdbcIntrospector.$$$reportNull$$$0(38);
        }
        if ((connection2 = this.getDbConnection()) == null) {
            return false;
        }
        DBConnectionAccessibilityMatcher accessibilityMatcher = this.getAccessibilityMatcher();
        if (accessibilityMatcher == null) {
            return true;
        }
        return accessibilityMatcher.isDatabaseAccessible(connection2.getConnectionPoint(), database);
    }

    private static List<BasicSchema> listAllSchemasToIntrospect(@NotNull BasicRoot root2, @Nullable TreePattern scope) {
        if (root2 == null) {
            JdbcIntrospector.$$$reportNull$$$0(39);
        }
        ArrayList<BasicSchema> schemasToIntrospect2 = new ArrayList<BasicSchema>();
        if (root2 instanceof BasicMultiDatabaseRoot) {
            for (BasicDatabase basicDatabase : ((BasicMultiDatabaseRoot)root2).getDatabases()) {
                boolean ok2 = JdbcIntrospector.inScope(basicDatabase, scope);
                if (!ok2) continue;
                JdbcIntrospector.listDatabaseSchemasToIntrospect(basicDatabase, scope, schemasToIntrospect2);
            }
        } else if (root2 instanceof BasicSingleDatabaseRoot) {
            JdbcIntrospector.listDatabaseSchemasToIntrospect((BasicDatabase)((Object)root2), scope, schemasToIntrospect2);
        }
        return schemasToIntrospect2;
    }

    public static void listDatabaseSchemasToIntrospect(@NotNull BasicDatabase database, @Nullable TreePattern scope, @NotNull Collection<BasicSchema> container) {
        if (database == null) {
            JdbcIntrospector.$$$reportNull$$$0(40);
        }
        if (container == null) {
            JdbcIntrospector.$$$reportNull$$$0(41);
        }
        for (BasicSchema basicSchema : database.getSchemas()) {
            boolean ok2 = JdbcIntrospector.inScope(basicSchema, scope);
            if (!ok2) continue;
            container.add(basicSchema);
        }
    }

    private static boolean inScope(@NotNull BasicNamespace namespace, @Nullable TreePattern scope) {
        if (namespace == null) {
            JdbcIntrospector.$$$reportNull$$$0(42);
        }
        return scope != null ? DataSourceSchemaMapping.matches(scope, namespace) : namespace.isCurrent();
    }

    private void introspectSpecifiedAreasAutomatically(@NotNull @NotNull BasicNamespace @NotNull [] namespaces2) {
        if (namespaces2 == null) {
            JdbcIntrospector.$$$reportNull$$$0(43);
        }
        assert (namespaces2.length > 0);
        this.introspectSchemasInThisConnection(this.schemas(namespaces2));
    }

    private void introspectSchemasInThisConnection(@NotNull @NotNull Collection<@NotNull BasicSchema> schemas2) {
        if (schemas2 == null) {
            JdbcIntrospector.$$$reportNull$$$0(44);
        }
        BasicModModel model2 = this.getModel();
        model2.modify(BasicModRoot.class, root2 -> {
            DatabaseMetaDataWrapper meta = this.createMetaAndUpdateHelper();
            @NotNull JBIterable schemasIterable = JBIterable.from((Iterable)schemas2);
            this.introspectSchemas(meta, (JBIterable<BasicModSchema>)schemasIterable.filter(BasicModSchema.class));
        });
    }

    @Override
    public void introspectNamespaces() {
        if (this.getDbConnection() == null) {
            throw new AssertionError((Object)"Not connected to database");
        }
        if (this.namespacesAreIntrospected) {
            return;
        }
        BasicModModel model2 = this.getModel();
        model2.modify(BasicModRoot.class, root2 -> {
            DatabaseMetaDataWrapper meta = this.createMetaAndUpdateHelper();
            this.introspectDatabaseList(meta);
            if (root2 instanceof BasicModMultiDatabaseRoot) {
                JBIterable databases2 = ((BasicModMultiDatabaseRoot)root2).getDatabases().jbi().filter(db2 -> JdbcIntrospector.inScope(db2, this.introspectionScope));
                this.introspectSchemaList(meta, (JBIterable<? extends BasicModDatabase>)databases2);
            }
        });
        this.namespacesAreIntrospected = true;
    }

    private void retrieveDatabases() {
        this.getModel().modify(BasicModRoot.class, root2 -> {
            DatabaseMetaDataWrapper meta = this.createMetaAndUpdateHelper();
            this.introspectDatabaseList(meta);
        });
    }

    @NotNull
    private DatabaseMetaDataWrapper createMetaAndUpdateHelper() {
        DatabaseMetaDataWrapper meta = this.createMeta();
        this.myHelper.setCasing(meta.getCasing());
        DatabaseMetaDataWrapper databaseMetaDataWrapper = meta;
        if (databaseMetaDataWrapper == null) {
            JdbcIntrospector.$$$reportNull$$$0(45);
        }
        return databaseMetaDataWrapper;
    }

    @Override
    protected void retrieveSchemasOfDatabase(@NotNull DBTransaction transaction, @NotNull BasicDatabase database) {
        if (transaction == null) {
            JdbcIntrospector.$$$reportNull$$$0(46);
        }
        if (database == null) {
            JdbcIntrospector.$$$reportNull$$$0(47);
        }
        this.retrieveSchemasOfDatabase(database);
    }

    protected void retrieveSchemasOfDatabase(@NotNull BasicDatabase database) {
        if (database == null) {
            JdbcIntrospector.$$$reportNull$$$0(48);
        }
        this.getModel().modify(database, BasicModDatabase.class, db2 -> {
            DatabaseMetaDataWrapper meta = this.createMetaAndUpdateHelper();
            this.introspectSchemaList(meta, (JBIterable<? extends BasicModDatabase>)JBIterable.of((Object)db2));
        });
    }

    @Override
    public void introspectDatabaseSchemas(BasicDatabase ... databases2) {
        if (databases2 == null) {
            JdbcIntrospector.$$$reportNull$$$0(49);
        }
        if (this.getDbConnection() == null) {
            throw new AssertionError((Object)"Not connected to database");
        }
        this.getModel().modify(BasicModRoot.class, root2 -> {
            DatabaseMetaDataWrapper meta = this.createMetaAndUpdateHelper();
            this.introspectSchemaList(meta, (JBIterable<? extends BasicModDatabase>)JBIterable.of((Object[])databases2).filter(BasicModDatabase.class));
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void introspectSchemas(@NotNull DatabaseMetaDataWrapper meta, @NotNull JBIterable<BasicModSchema> schemas2) {
        if (meta == null) {
            JdbcIntrospector.$$$reportNull$$$0(50);
        }
        if (schemas2 == null) {
            JdbcIntrospector.$$$reportNull$$$0(51);
        }
        try {
            this.myTableTypes = meta.getAllTableTypes();
        }
        catch (SQLException e2) {
            this.getErrorSink().consume((Object)"Failed to retrieve table types", (Object)e2);
            this.myTableTypes = null;
        }
        this.myTableKinds = ArrayUtil.isEmpty((Object[])this.myTableTypes) ? null : JBIterable.of((Object[])this.myTableTypes).transform(x -> JdbcIntrospectorHelper.JdbcTableType.findByName(x).getKind()).toSet();
        MultiMap byCatalog = MultiMap.create();
        for (BasicModSchema schema2 : schemas2) {
            byCatalog.putValue((Object)this.myHelper.getDatabase(schema2), (Object)schema2);
        }
        String catalog = null;
        try {
            catalog = (String)JdbcNativeUtil.computeRemote(() -> meta.getConnection().getRemoteConnection().getCatalog());
            this.introspectSchemasByCatalogs(meta, (MultiMap<BasicModNamespace, BasicModSchema>)byCatalog);
        }
        catch (SQLException e3) {
            this.getErrorSink().consume((Object)"Failed to get current catalog", (Object)e3);
        }
        finally {
            if (catalog != null) {
                String finalCatalog = catalog;
                JdbcNativeUtil.performSafe(() -> meta.getConnection().getRemoteConnection().setCatalog(finalCatalog));
            }
        }
    }

    private void introspectSchemasByCatalogs(@NotNull DatabaseMetaDataWrapper meta, @NotNull MultiMap<BasicModNamespace, BasicModSchema> byCatalog) {
        DatabaseConnectionCore connection2;
        if (meta == null) {
            JdbcIntrospector.$$$reportNull$$$0(52);
        }
        if (byCatalog == null) {
            JdbcIntrospector.$$$reportNull$$$0(53);
        }
        if ((connection2 = this.getDbConnection()) == null) {
            this.logWarn("Cannot introspectSchemasByCatalogs \u2014 the connection is null");
            return;
        }
        Instant beginTimestamp = CalendarFun.currentInstantTruncatedToSeconds();
        JdbcIntrospector.forEachSchemaInCatalog(meta, byCatalog, s2 -> {
            this.introspectTablesInSchema(meta, (BasicModSchema)s2);
            this.introspectRoutinesInSchema(meta, (BasicModSchema)s2);
            this.introspectTypesInSchema(meta, (BasicModSchema)s2);
        });
        JdbcIntrospector.forEachSchemaInCatalog(meta, byCatalog, s2 -> {
            this.introspectColumnsInSchema(meta, (BasicModSchema)s2);
            this.introspectPrototypesInSchema(meta, (BasicModSchema)s2);
            this.introspectTypeAttributesInSchema(meta, (BasicModSchema)s2);
        });
        JdbcIntrospector.forEachSchemaInCatalog(meta, byCatalog, s2 -> {
            ModNamingFamily<BasicModNamedElement> tables2 = JdbcIntrospectorLegacyModelUtils.familyOf(s2, ObjectKind.TABLE);
            if (tables2 != null) {
                tables2.forEach(t -> this.introspectTableKeys(meta, (BasicModTableOrView)t, false));
                tables2.forEach(t -> this.introspectTableForeignKeys(meta, (BasicModTableOrView)t));
                tables2.forEach(t -> this.introspectTableIndices(meta, (BasicModTableOrView)t));
                tables2.forEach(t -> JdbcIntrospector.cleanupFamily(t.familyOf(ObjectKind.KEY)));
            }
        });
        if (this.mySrcLoader != null) {
            this.getModel().writeSources(() -> JdbcIntrospector.forEachSchemaInCatalog(meta, byCatalog, s2 -> {
                this.checkProgressCanceled();
                this.setProgressIndicatorText(DatabaseBundle.message("progress.text.sources.in", MetaDataUtil.qName(s2)), false);
                this.mySrcLoader.loadSources((Iterable<BasicModSourceAware>)((JBTreeTraverser)DasUtil.dasTraverser().withRoot(s2)).filter(BasicModSourceAware.class), connection2);
            }));
        }
        JdbcIntrospector.forEachSchemaInCatalog(meta, byCatalog, s2 -> s2.setLastIntrospectionLocalTimestamp(beginTimestamp));
    }

    private static void forEachCatalog(@NotNull DatabaseMetaDataWrapper meta, @NotNull MultiMap<BasicModNamespace, BasicModSchema> grouped, @NotNull Consumer<Iterable<BasicModSchema>> process2) {
        if (meta == null) {
            JdbcIntrospector.$$$reportNull$$$0(54);
        }
        if (grouped == null) {
            JdbcIntrospector.$$$reportNull$$$0(55);
        }
        if (process2 == null) {
            JdbcIntrospector.$$$reportNull$$$0(56);
        }
        for (Map.Entry entry : grouped.entrySet()) {
            String catalog;
            String string = catalog = entry.getKey() == null ? null : ((BasicModNamespace)entry.getKey()).getName();
            if (catalog != null) {
                JdbcNativeUtil.performSafe(() -> meta.getConnection().getRemoteConnection().setCatalog(catalog));
            }
            process2.accept((Iterable)entry.getValue());
        }
    }

    private static void forEachSchemaInCatalog(@NotNull DatabaseMetaDataWrapper meta, @NotNull MultiMap<BasicModNamespace, BasicModSchema> grouped, @NotNull Consumer<BasicModSchema> process2) {
        if (meta == null) {
            JdbcIntrospector.$$$reportNull$$$0(57);
        }
        if (grouped == null) {
            JdbcIntrospector.$$$reportNull$$$0(58);
        }
        if (process2 == null) {
            JdbcIntrospector.$$$reportNull$$$0(59);
        }
        JdbcIntrospector.forEachCatalog(meta, grouped, ss2 -> ss2.forEach(process2));
    }

    public void introspectTablesInSchema(@NotNull DatabaseMetaDataWrapper meta, @NotNull BasicModSchema schema2) {
        if (meta == null) {
            JdbcIntrospector.$$$reportNull$$$0(60);
        }
        if (schema2 == null) {
            JdbcIntrospector.$$$reportNull$$$0(61);
        }
        this.setProgressIndicatorText(DatabaseBundle.message("progress.text.table.list.in", MetaDataUtil.qName(schema2)), true);
        JBIterable<ModFamily<? extends BasicModTableOrView>> families = this.getTableFamilies(schema2);
        families.forEach(ModFamily::markChildrenAsSyncPending);
        try (ClosableIt<? extends DatabaseMetaDataWrapper.Table> tableIt = meta.tables(this.asSchema(schema2), null, this.myTableTypes);){
            for (DatabaseMetaDataWrapper.Table table : JBIterable.once(tableIt)) {
                this.checkProgressCanceled();
                this.myHelper.createTable(schema2, table);
            }
        }
        catch (SQLException e2) {
            this.getErrorSink().consume((Object)("Failed to retrieve tables in " + MetaDataUtil.qName(schema2)), (Object)e2);
        }
        families.forEach(JdbcIntrospector::cleanupFamily);
    }

    @NotNull
    private JBIterable<ModFamily<? extends BasicModTableOrView>> getTableFamilies(@NotNull BasicModSchema schema2) {
        if (schema2 == null) {
            JdbcIntrospector.$$$reportNull$$$0(62);
        }
        JBIterable kinds = JBIterable.from(ModelConsts.TABLE_OR_VIEW_KINDS).append((Object)ObjectKind.SEQUENCE).append((Object)ObjectKind.SYNONYM);
        if (this.myTableKinds != null) {
            kinds = kinds.filter(this.myTableKinds::contains);
        }
        JBIterable jBIterable = kinds.transform(k -> JdbcIntrospectorLegacyModelUtils.familyOf(schema2, k)).filter(Conditions.notNull());
        if (jBIterable == null) {
            JdbcIntrospector.$$$reportNull$$$0(63);
        }
        return jBIterable;
    }

    public void introspectTableKeys(@NotNull DatabaseMetaDataWrapper meta, @NotNull BasicModTableOrView table, boolean cleanup) {
        if (meta == null) {
            JdbcIntrospector.$$$reportNull$$$0(64);
        }
        if (table == null) {
            JdbcIntrospector.$$$reportNull$$$0(65);
        }
        Family keys2 = table.familyOf(ObjectKind.KEY);
        if (table.getKind() != ObjectKind.TABLE || keys2 == null) {
            return;
        }
        this.setProgressIndicatorText(DatabaseBundle.message("progress.text.keys.in", MetaDataUtil.qName(table)), true);
        keys2.markChildrenAsSyncPending();
        try (ClosableIt.GroupingIt<DatabaseMetaDataWrapper.TableKey, DatabaseMetaDataWrapper.TableKeyColumn> keyIt = meta.tableKeys(this.myHelper.asTable(table));){
            this.myHelper.createKeys(table, keyIt);
        }
        catch (Exception ex) {
            this.getErrorSink().consume((Object)MetaDataUtil.qName(table), (Object)ex);
        }
        if (cleanup) {
            JdbcIntrospector.cleanupFamily(keys2);
        }
    }

    public void introspectTableForeignKeys(@NotNull DatabaseMetaDataWrapper meta, @NotNull BasicModTableOrView table) {
        if (meta == null) {
            JdbcIntrospector.$$$reportNull$$$0(66);
        }
        if (table == null) {
            JdbcIntrospector.$$$reportNull$$$0(67);
        }
        Family fKeys = table.familyOf(ObjectKind.FOREIGN_KEY);
        if (table.getKind() != ObjectKind.TABLE || fKeys == null) {
            return;
        }
        this.setProgressIndicatorText(DatabaseBundle.message("progress.text.foreign.keys.in", MetaDataUtil.qName(table)), true);
        fKeys.markChildrenAsSyncPending();
        try (ClosableIt.GroupingIt<DatabaseMetaDataWrapper.TableFKey, DatabaseMetaDataWrapper.TableFKeyColumn> fkColumnIt = meta.tableFKeyColumns(this.myHelper.asTable(table));){
            this.myHelper.createForeignKeys(table, fkColumnIt);
        }
        catch (Exception ex) {
            this.getErrorSink().consume((Object)MetaDataUtil.qName(table), (Object)ex);
        }
        JdbcIntrospector.cleanupFamily(fKeys);
    }

    private void introspectTableIndices(@NotNull DatabaseMetaDataWrapper meta, @NotNull BasicModTableOrView table) {
        if (meta == null) {
            JdbcIntrospector.$$$reportNull$$$0(68);
        }
        if (table == null) {
            JdbcIntrospector.$$$reportNull$$$0(69);
        }
        Family indices = table.familyOf(ObjectKind.INDEX);
        if (table.getKind() != ObjectKind.TABLE || indices == null) {
            return;
        }
        this.setProgressIndicatorText(DatabaseBundle.message("progress.text.indices.in", MetaDataUtil.qName(table)), true);
        indices.markChildrenAsSyncPending();
        try (ClosableIt.GroupingIt<DatabaseMetaDataWrapper.TableIndex, DatabaseMetaDataWrapper.TableIndexColumn> indexColumnIt = meta.tableIndexColumns(this.myHelper.asTable(table));){
            this.myHelper.createIndices(table, indexColumnIt);
        }
        catch (Exception ex) {
            this.getErrorSink().consume((Object)MetaDataUtil.qName(table), (Object)ex);
        }
        JdbcIntrospector.cleanupFamily(indices);
    }

    public void introspectColumnsInSchema(@NotNull DatabaseMetaDataWrapper meta, @NotNull BasicModSchema schema2) {
        if (meta == null) {
            JdbcIntrospector.$$$reportNull$$$0(70);
        }
        if (schema2 == null) {
            JdbcIntrospector.$$$reportNull$$$0(71);
        }
        this.setProgressIndicatorText(DatabaseBundle.message("progress.text.table.columns.in", MetaDataUtil.qName(schema2)), true);
        JBIterable tables2 = this.getTableFamilies(schema2).flatten(s2 -> s2).filter(BasicModTableOrView.class);
        HashMap<String, BasicModTableOrView> name2Table = new HashMap<String, BasicModTableOrView>();
        for (Object table : tables2) {
            JdbcIntrospector.markChildrenAsSyncPending(JdbcIntrospectorLegacyModelUtils.familyOf((BasicModElement)table, ObjectKind.COLUMN));
            name2Table.put(table.getName(), (BasicModTableOrView)table);
        }
        try (ClosableIt.GroupingIt<DatabaseMetaDataWrapper.Table, DatabaseMetaDataWrapper.TableColumn> columnIt = meta.tableColumns(this.asSchema(schema2), null, name2Table.keySet());){
            for (DatabaseMetaDataWrapper.Table table : JBIterable.once(columnIt)) {
                this.checkProgressCanceled();
                this.myHelper.createColumns((BasicModTableOrView)name2Table.get(table.name), (Iterator<DatabaseMetaDataWrapper.TableColumn>)columnIt.groupIt());
            }
        }
        catch (SQLException e2) {
            this.getErrorSink().consume((Object)MetaDataUtil.qName(schema2), (Object)e2);
        }
        for (Object table : tables2) {
            JdbcIntrospector.cleanupFamily(table.familyOf(ObjectKind.COLUMN));
        }
    }

    private void introspectTypeAttributesInSchema(@NotNull DatabaseMetaDataWrapper meta, @NotNull BasicModSchema schema2) {
        if (meta == null) {
            JdbcIntrospector.$$$reportNull$$$0(72);
        }
        if (schema2 == null) {
            JdbcIntrospector.$$$reportNull$$$0(73);
        }
        this.checkProgressCanceled();
        ModNamingFamily<Object> types2 = JdbcIntrospectorLegacyModelUtils.familyOf(schema2, ObjectKind.OBJECT_TYPE);
        if (types2 == null || types2.isEmpty()) {
            return;
        }
        this.setProgressIndicatorText(DatabaseBundle.message("progress.text.type.attributes.in", MetaDataUtil.qName(schema2)), false);
        HashMap<String, BasicModElement> name2Type = new HashMap<String, BasicModElement>();
        for (Object type2 : types2) {
            JdbcIntrospector.markChildrenAsSyncPending(JdbcIntrospectorLegacyModelUtils.familyOf((BasicModElement)type2, ObjectKind.OBJECT_ATTRIBUTE));
            name2Type.put(type2.getName(), (BasicModElement)type2);
        }
        try (ClosableIt.GroupingIt<DatabaseMetaDataWrapper.UserDefinedType, DatabaseMetaDataWrapper.UserDefinedTypeAttribute> attrIt = meta.userDefinedTypeAttributes(this.asSchema(schema2), null, name2Type.keySet());){
            for (DatabaseMetaDataWrapper.UserDefinedType type3 : JBIterable.once(attrIt)) {
                this.checkProgressCanceled();
                this.myHelper.createUserDefinedTypeAttributes((BasicModElement)name2Type.get(type3.name), (Iterator<DatabaseMetaDataWrapper.UserDefinedTypeAttribute>)attrIt.groupIt());
            }
        }
        catch (SQLException e2) {
            this.getErrorSink().consume((Object)MetaDataUtil.qName(schema2), (Object)e2);
        }
        for (BasicModElement type2 : types2) {
            JdbcIntrospector.cleanupFamily(type2.familyOf(ObjectKind.OBJECT_ATTRIBUTE));
        }
    }

    @NotNull
    private DatabaseMetaDataWrapper.Schema asSchema(@NotNull BasicModSchema schema2) {
        if (schema2 == null) {
            JdbcIntrospector.$$$reportNull$$$0(74);
        }
        DatabaseMetaDataWrapper.Schema s2 = this.myHelper.asSchema(schema2);
        if (s2.database == null) {
            s2.database = this.database;
        }
        DatabaseMetaDataWrapper.Schema schema3 = s2;
        if (schema3 == null) {
            JdbcIntrospector.$$$reportNull$$$0(75);
        }
        return schema3;
    }

    private void introspectPrototypesInSchema(@NotNull DatabaseMetaDataWrapper meta, @NotNull BasicModSchema schema2) {
        if (meta == null) {
            JdbcIntrospector.$$$reportNull$$$0(76);
        }
        if (schema2 == null) {
            JdbcIntrospector.$$$reportNull$$$0(77);
        }
        this.setProgressIndicatorText(DatabaseBundle.message("progress.text.prototypes.in", MetaDataUtil.qName(schema2)), true);
        JBIterable<ModFamily<?>> routineFamilies = this.getRoutineFamilies(schema2);
        JBIterable routines = routineFamilies.flatten(r -> r).filter(BasicModRoutine.class);
        JdbcIntrospectorHelper.RoutineMap map2 = this.myHelper.createRoutineMap();
        for (Object routine2 : routines) {
            JdbcIntrospector.markChildrenAsSyncPending(JdbcIntrospectorLegacyModelUtils.familyOf((BasicModElement)routine2, ObjectKind.ARGUMENT));
            map2.put((BasicModRoutine)routine2);
        }
        try (ClosableIt.GroupingIt<DatabaseMetaDataWrapper.Routine, DatabaseMetaDataWrapper.RoutineArgument> argumentIt = meta.routineArguments(this.asSchema(schema2), null, (Function<DatabaseMetaDataWrapper.Routine, DasRoutine.Kind>)((Function)map2::guessType));){
            for (DatabaseMetaDataWrapper.Routine routine3 : JBIterable.once(argumentIt)) {
                this.checkProgressCanceled();
                this.myHelper.createArguments(map2.get(routine3), (Iterator<DatabaseMetaDataWrapper.RoutineArgument>)argumentIt.groupIt());
            }
        }
        catch (SQLException e2) {
            this.getErrorSink().consume((Object)MetaDataUtil.qName(schema2), (Object)e2);
        }
        for (Object routine2 : routines) {
            JdbcIntrospector.cleanupFamily(routine2.familyOf(ObjectKind.ARGUMENT));
        }
        routineFamilies.forEach(ModFamily::sort);
    }

    private void introspectRoutinesInSchema(@NotNull DatabaseMetaDataWrapper meta, @NotNull BasicModSchema schema2) {
        if (meta == null) {
            JdbcIntrospector.$$$reportNull$$$0(78);
        }
        if (schema2 == null) {
            JdbcIntrospector.$$$reportNull$$$0(79);
        }
        this.setProgressIndicatorText(DatabaseBundle.message("progress.text.routine.list.in", MetaDataUtil.qName(schema2)), true);
        JBIterable<ModFamily<?>> routineFamilies = this.getRoutineFamilies(schema2);
        routineFamilies.forEach(ModFamily::markChildrenAsSyncPending);
        try (ClosableIt<DatabaseMetaDataWrapper.Routine> routineIt = meta.routines(this.asSchema(schema2), null, null);){
            for (DatabaseMetaDataWrapper.Routine routine2 : JBIterable.once(routineIt)) {
                this.checkProgressCanceled();
                this.myHelper.createRoutine(schema2, routine2);
            }
        }
        catch (SQLException e2) {
            this.getErrorSink().consume((Object)("Failed to retrieve routines in " + MetaDataUtil.qName(schema2)), (Object)e2);
        }
        routineFamilies.forEach(JdbcIntrospector::cleanupFamily);
    }

    private void introspectAdditionalTypes(@NotNull DatabaseMetaDataWrapper meta, @NotNull BasicModSchema schema2) {
        if (meta == null) {
            JdbcIntrospector.$$$reportNull$$$0(80);
        }
        if (schema2 == null) {
            JdbcIntrospector.$$$reportNull$$$0(81);
        }
        ObjectKind target2 = null;
        String scName = schema2.getName();
        if (this.myHelper.getDbms().isSybase() && "dbo".equalsIgnoreCase(scName)) {
            target2 = ObjectKind.ALIAS_TYPE;
        }
        if (target2 != null) {
            try (ClosableIt<? extends DatabaseMetaDataWrapper.Type> typesIt = meta.types();){
                for (DatabaseMetaDataWrapper.Type type2 : JBIterable.once(typesIt)) {
                    this.checkProgressCanceled();
                    this.myHelper.createType(schema2, type2, target2);
                }
            }
            catch (SQLException e2) {
                this.getErrorSink().consume((Object)("Failed to retrieve types in " + MetaDataUtil.qName(schema2)), (Object)e2);
            }
        }
    }

    private void introspectTypesInSchema(@NotNull DatabaseMetaDataWrapper meta, @NotNull BasicModSchema schema2) {
        if (meta == null) {
            JdbcIntrospector.$$$reportNull$$$0(82);
        }
        if (schema2 == null) {
            JdbcIntrospector.$$$reportNull$$$0(83);
        }
        this.setProgressIndicatorText(DatabaseBundle.message("progress.text.types.list.in", MetaDataUtil.qName(schema2)), true);
        JBIterable<ModFamily<?>> userDefinedTypeFamilies = this.getUserDefinedTypeFamilies(schema2);
        if (userDefinedTypeFamilies.isEmpty()) {
            return;
        }
        userDefinedTypeFamilies.forEach(ModFamily::markChildrenAsSyncPending);
        try (ClosableIt<? extends DatabaseMetaDataWrapper.UserDefinedType> userDefinedTypesIt = meta.userDefinedTypes(this.asSchema(schema2), null);){
            for (DatabaseMetaDataWrapper.UserDefinedType userDefinedType : JBIterable.once(userDefinedTypesIt)) {
                this.checkProgressCanceled();
                this.myHelper.createUserDefinedType(schema2, userDefinedType);
            }
        }
        catch (SQLException e2) {
            this.getErrorSink().consume((Object)("Failed to retrieve user types in " + MetaDataUtil.qName(schema2)), (Object)e2);
        }
        this.introspectAdditionalTypes(meta, schema2);
        userDefinedTypeFamilies.forEach(JdbcIntrospector::cleanupFamily);
    }

    private void introspectDatabaseList(@NotNull DatabaseMetaDataWrapper meta) {
        ModNamingFamily databases2;
        if (meta == null) {
            JdbcIntrospector.$$$reportNull$$$0(84);
        }
        if ((databases2 = JdbcIntrospectorLegacyModelUtils.familyOf((BasicModElement)((Object)this.getModel().getRoot()), ObjectKind.DATABASE)) != null && !this.myHelper.isSchemaDbMode()) {
            this.introspectDatabaseListImpl(meta);
        } else {
            JdbcIntrospector.markChildrenAsSyncPending(databases2);
            this.introspectSchemaList(meta, (JBIterable<? extends BasicModDatabase>)JBIterable.empty());
            JdbcIntrospector.cleanupFamily(databases2);
            this.updateDatabaseFlags(databases2);
        }
    }

    private void introspectDatabaseListImpl(@NotNull DatabaseMetaDataWrapper meta) {
        boolean haveDb;
        ModNamingFamily databases2;
        if (meta == null) {
            JdbcIntrospector.$$$reportNull$$$0(85);
        }
        if ((databases2 = JdbcIntrospectorLegacyModelUtils.familyOf((BasicModElement)((Object)this.getModel().getRoot()), ObjectKind.DATABASE)) == null) {
            return;
        }
        databases2.markChildrenAsSyncPending();
        try (ClosableIt<String> dbIt = meta.databases();){
            haveDb = this.fillDatabases((Iterator<String>)((Object)dbIt));
        }
        catch (SQLException e2) {
            throw new GenericIntrospectionException("Failed to retrieve databases", e2);
        }
        if (haveDb) {
            JdbcIntrospector.cleanupFamily(databases2);
            this.updateDatabaseFlags(databases2);
            this.introspectSchemaList(meta, (JBIterable<? extends BasicModDatabase>)JBIterable.from(databases2).filter(BasicModDatabase.class).filter(db2 -> db2.isCurrent()));
        } else {
            this.introspectSchemaList(meta, (JBIterable<? extends BasicModDatabase>)JBIterable.empty());
            this.updateDatabaseFlags(databases2);
        }
    }

    private void introspectSchemaList(@NotNull DatabaseMetaDataWrapper meta, @NotNull JBIterable<? extends BasicModDatabase> databases2) {
        if (meta == null) {
            JdbcIntrospector.$$$reportNull$$$0(86);
        }
        if (databases2 == null) {
            JdbcIntrospector.$$$reportNull$$$0(87);
        }
        for (BasicModDatabase db3 : databases2) {
            db3.getSchemas().markChildrenAsSyncPending();
        }
        if (this.myHelper.isSchemaDbMode()) {
            try (ClosableIt<String> dbIt = meta.databases();){
                this.fillSchemas((Iterator<DatabaseMetaDataWrapper.Schema>)dbIt.map(db2 -> new DatabaseMetaDataWrapper.Schema("", (String)db2)));
            }
            catch (SQLException e2) {
                throw new GenericIntrospectionException("Failed to retrieve schemas", e2);
            }
            return;
        }
        try (ClosableIt<DatabaseMetaDataWrapper.Schema> schemaIt = meta.schemas((JBIterable<String>)databases2.filter(Conditions.notInstanceOf(BasicRoot.class)).transform(DasUtil.TO_NAME));){
            this.fillSchemas((Iterator<DatabaseMetaDataWrapper.Schema>)((Object)schemaIt));
        }
        catch (SQLException e3) {
            throw new GenericIntrospectionException("Failed to retrieve schemas", e3);
        }
        for (BasicModDatabase db3 : databases2) {
            JdbcIntrospector.cleanupFamily(db3.getSchemas());
        }
    }

    @Nullable
    private <T extends BasicNamespace> T getCurrentOrSole(@NotNull Iterable<? extends T> namespaces2) {
        JBIterable nsp;
        BasicNamespace current;
        if (namespaces2 == null) {
            JdbcIntrospector.$$$reportNull$$$0(88);
        }
        if ((current = (BasicNamespace)(nsp = JBIterable.from(namespaces2)).filter(this::isCurrent).first()) != null) {
            return (T)current;
        }
        if (nsp.size() == 1) {
            return (T)((BasicNamespace)nsp.first());
        }
        return null;
    }

    private void fillSchemas(Iterator<DatabaseMetaDataWrapper.Schema> schemaIt) {
        LinkedHashSet schemaFamilies = new LinkedHashSet();
        ModNamingFamily root2 = JdbcIntrospectorLegacyModelUtils.familyOf((BasicModElement)((Object)this.getModel().getRoot()), ObjectKind.SCHEMA);
        if (root2 != null) {
            root2.markChildrenAsSyncPending();
            schemaFamilies.add(root2);
        }
        for (DatabaseMetaDataWrapper.Schema schema2 : JBIterable.once(schemaIt)) {
            if (root2 == null) {
                ModNamingFamily schemas3;
                BasicModDatabase database = this.myHelper.createDatabaseFor(schema2);
                ModNamingFamily modNamingFamily = schemas3 = database == null ? null : JdbcIntrospectorLegacyModelUtils.familyOf(database, ObjectKind.SCHEMA);
                if (schemas3 != null && schemaFamilies.add(schemas3)) {
                    schemas3.markChildrenAsSyncPending();
                }
            } else if (this.database == null) {
                this.database = schema2.database;
            }
            this.myHelper.createSchema(schema2);
        }
        schemaFamilies.forEach(schemas2 -> {
            JdbcIntrospector.cleanupFamily(schemas2);
            this.updateSchemaFlags((ModNamingFamily<? extends BasicModSchema>)schemas2);
        });
    }

    private void updateSchemaFlags(ModNamingFamily<? extends BasicModSchema> schemas2) {
        BasicModSchema curSc = this.getCurrentOrSole(schemas2);
        if (curSc != null) {
            schemas2.forEach(s2 -> s2.setCurrent(s2 == curSc));
            curSc.setCurrent(true);
        }
    }

    private boolean fillDatabases(Iterator<String> dbIt) {
        boolean empty2 = true;
        for (String db2 : JBIterable.once(dbIt)) {
            empty2 = false;
            this.myHelper.createDatabase(db2);
        }
        return !empty2;
    }

    private void updateDatabaseFlags(@Nullable ModNamingFamily<?> root2) {
        JBIterable databases2 = JBIterable.from(root2).filter(BasicModMateDatabase.class);
        BasicModMateDatabase curDb = (BasicModMateDatabase)this.getCurrentOrSole((Iterable)databases2);
        Iterator iterator = databases2.iterator();
        while (iterator.hasNext()) {
            BasicModMateDatabase database;
            database.setCurrent((database = (BasicModMateDatabase)iterator.next()) == curDb);
        }
        if (curDb != null) {
            curDb.setCurrent(true);
        }
    }

    private boolean isCurrent(@Nullable BasicNamespace nsp) {
        if (nsp instanceof BasicDatabase) {
            return this.isCurrent((BasicDatabase)nsp);
        }
        if (nsp instanceof BasicSchema) {
            return this.isCurrent((BasicSchema)nsp);
        }
        return false;
    }

    private boolean isCurrent(@Nullable BasicDatabase db2) {
        if (db2 == null || this.myInfo == null) {
            return false;
        }
        return db2.getName().equals(this.myInfo.databaseName);
    }

    private boolean isCurrent(@Nullable BasicSchema sc2) {
        if (sc2 == null || this.myInfo == null) {
            return false;
        }
        return this.myHelper.isSchemaDbMode() ? sc2.getName().equals(this.myInfo.databaseName) : sc2.getName().equals(this.myInfo.schemaName) || this.myInfo.schemaName == null && sc2.getName().equals(this.myInfo.userName);
    }

    @NotNull
    private DatabaseMetaDataWrapper createMeta() {
        DatabaseMetaDataWrapper databaseMetaDataWrapper;
        if (this.getDbConnection() == null) {
            throw new GenericIntrospectionException("Failed to get connection", null);
        }
        try {
            RemoteDatabaseMetaData metaData = this.getDbConnection().getRemoteMetaData();
            if (metaData == null) {
                throw new GenericIntrospectionException("Connection#getMetaData() returns null. No introspection could be performed", null);
            }
            databaseMetaDataWrapper = DatabaseMetaDataWrapper.create(this.getDbConnection(), metaData).withErrorSink(this.getErrorSink());
        }
        catch (SQLException e2) {
            throw new GenericIntrospectionException("Failed to retrieve meta data", e2);
        }
        if (databaseMetaDataWrapper == null) {
            JdbcIntrospector.$$$reportNull$$$0(89);
        }
        return databaseMetaDataWrapper;
    }

    @NotNull
    private @NotNull Collection<@NotNull BasicSchema> schemas(BasicNamespace ... namespaces2) {
        JBTreeTraverser traverser2 = this.getModel().traverser();
        if (namespaces2 != null && namespaces2.length != 0) {
            traverser2 = (JBTreeTraverser)traverser2.withRoots((Iterable)JBIterable.of((Object[])namespaces2));
        }
        List list = ((JBTreeTraverser)traverser2.expand(Conditions.instanceOf(BasicDatabase.class))).filter(BasicSchema.class).filter(s2 -> this.inIntrospectionScope((BasicNamespace)s2) || namespaces2 != null && ArrayUtil.indexOf((Object[])namespaces2, (Object)s2) != -1).toList();
        if (list == null) {
            JdbcIntrospector.$$$reportNull$$$0(90);
        }
        return list;
    }

    @NotNull
    public JBIterable<ModFamily<?>> getRoutineFamilies(@NotNull BasicModSchema schema2) {
        if (schema2 == null) {
            JdbcIntrospector.$$$reportNull$$$0(91);
        }
        JBIterable routineFamilies = JBIterable.of((Object)schema2.familyOf(ObjectKind.ROUTINE));
        Family packages = schema2.familyOf(ObjectKind.PACKAGE);
        if (packages != null) {
            JBIterable pkg = JBIterable.of((Object)packages);
            routineFamilies = routineFamilies.append((Iterable)pkg).append((Iterable)pkg.flatten(p2 -> p2).transform(f -> f.familyOf(ObjectKind.ROUTINE)).filter(Conditions.notNull()));
        }
        JBIterable jBIterable = routineFamilies;
        if (jBIterable == null) {
            JdbcIntrospector.$$$reportNull$$$0(92);
        }
        return jBIterable;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    public JBIterable<ModFamily<?>> getUserDefinedTypeFamilies(@NotNull BasicModSchema schema2) {
        if (schema2 == null) {
            JdbcIntrospector.$$$reportNull$$$0(93);
        }
        @NotNull JBIterable transform = JBIterable.of((Object[])new ObjectKind[]{ObjectKind.ALIAS_TYPE, ObjectKind.COLLECTION_TYPE, ObjectKind.OBJECT_TYPE, ObjectKind.TABLE_TYPE}).transform(schema2::familyOf);
        JBIterable jBIterable = transform.filter(Conditions.notNull());
        if (jBIterable == null) {
            JdbcIntrospector.$$$reportNull$$$0(94);
        }
        return jBIterable;
    }

    private static void markChildrenAsSyncPending(@Nullable ModFamily<?> f) {
        if (f == null) {
            return;
        }
        f.markChildrenAsSyncPending();
    }

    private static void cleanupFamily(@Nullable ModFamily<?> f) {
        if (f == null) {
            return;
        }
        f.removeSyncPendingChildren();
        f.sort();
    }

    @Override
    public void introspectSessionState() {
        DatabaseConnectionCore connection2 = this.getDbConnection();
        if (connection2 == null) {
            this.logWarn("Cannot introspectSchemasByCatalogs \u2014 the connection is null");
            return;
        }
        Version version = connection2.getVersion();
        this.getModel().modify(BasicModRoot.class, root2 -> root2.setServerVersion(version));
    }

    @Override
    @NotNull
    public Map<BasicElement, String[]> introspectNativeDefinitions(@NotNull Iterable<? extends BasicElement> elements2, boolean withNestedElements) {
        if (elements2 == null) {
            JdbcIntrospector.$$$reportNull$$$0(95);
        }
        Map<BasicElement, String[]> map2 = Collections.emptyMap();
        if (map2 == null) {
            JdbcIntrospector.$$$reportNull$$$0(96);
        }
        return map2;
    }

    @Override
    public void introspectServerObjects() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 9, 11, 34, 36, 37, 45, 63, 75, 89, 90, 92, 94, 96 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nature";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelFactory";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 6: 
            case 9: 
            case 11: 
            case 34: 
            case 36: 
            case 37: 
            case 45: 
            case 63: 
            case 75: 
            case 89: 
            case 90: 
            case 92: 
            case 94: 
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/base/introspector/jdbc/JdbcIntrospector";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newOptions";
                break;
            }
            case 12: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 23: 
            case 25: 
            case 27: 
            case 30: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transaction";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "databaseName";
                break;
            }
            case 16: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 31: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tran";
                break;
            }
            case 32: 
            case 43: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespaces";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "db";
                break;
            }
            case 38: 
            case 40: 
            case 47: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "database";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 44: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemas";
                break;
            }
            case 49: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "databases";
                break;
            }
            case 50: 
            case 52: 
            case 54: 
            case 57: 
            case 60: 
            case 64: 
            case 66: 
            case 68: 
            case 70: 
            case 72: 
            case 76: 
            case 78: 
            case 80: 
            case 82: 
            case 84: 
            case 85: 
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "meta";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "byCatalog";
                break;
            }
            case 55: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grouped";
                break;
            }
            case 56: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 61: 
            case 62: 
            case 71: 
            case 73: 
            case 74: 
            case 77: 
            case 79: 
            case 81: 
            case 83: 
            case 91: 
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
            case 65: 
            case 67: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/base/introspector/jdbc/JdbcIntrospector";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "init";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "checkElementsUptodate";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultScope";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getDatabaseSchemasInScope";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "checkConnectionApplicable";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "createMetaAndUpdateHelper";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableFamilies";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "asSchema";
                break;
            }
            case 89: {
                objectArray = objectArray2;
                objectArray2[1] = "createMeta";
                break;
            }
            case 90: {
                objectArray = objectArray2;
                objectArray2[1] = "schemas";
                break;
            }
            case 92: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoutineFamilies";
                break;
            }
            case 94: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserDefinedTypeFamilies";
                break;
            }
            case 96: {
                objectArray = objectArray2;
                objectArray2[1] = "introspectNativeDefinitions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectDiagnosticInfo";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 6: 
            case 9: 
            case 11: 
            case 34: 
            case 36: 
            case 37: 
            case 45: 
            case 63: 
            case 75: 
            case 89: 
            case 90: 
            case 92: 
            case 94: 
            case 96: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "attachToDB";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkElementsUptodate";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "optionsAreSet";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "reifyDatabase";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findDatabase";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "introspectNamespaces";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "introspectGeneral";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "introspectDatabase";
                break;
            }
            case 20: 
            case 21: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "introspectSchemas";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getDatabaseOrSole";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "introspectRegularElements";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "introspectServerElements";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "introspectDatabaseObjects";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "introspectAutoInTran";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "checkUptodate";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "introspectAuto";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getDatabaseSchemasInScope";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "checkConnectionApplicable";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "canAccessDatabaseInThisConnection";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "listAllSchemasToIntrospect";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "listDatabaseSchemasToIntrospect";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "inScope";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "introspectSpecifiedAreasAutomatically";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "introspectSchemasInThisConnection";
                break;
            }
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "retrieveSchemasOfDatabase";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "introspectDatabaseSchemas";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "introspectSchemasByCatalogs";
                break;
            }
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "forEachCatalog";
                break;
            }
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "forEachSchemaInCatalog";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "introspectTablesInSchema";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "getTableFamilies";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "introspectTableKeys";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "introspectTableForeignKeys";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "introspectTableIndices";
                break;
            }
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "introspectColumnsInSchema";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "introspectTypeAttributesInSchema";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "asSchema";
                break;
            }
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "introspectPrototypesInSchema";
                break;
            }
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "introspectRoutinesInSchema";
                break;
            }
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "introspectAdditionalTypes";
                break;
            }
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "introspectTypesInSchema";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "introspectDatabaseList";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "introspectDatabaseListImpl";
                break;
            }
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "introspectSchemaList";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentOrSole";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "getRoutineFamilies";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "getUserDefinedTypeFamilies";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "introspectNativeDefinitions";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 9, 11, 34, 36, 37, 45, 63, 75, 89, 90, 92, 94, 96 -> new IllegalStateException(string);
        };
    }

    private static class GenericIntrospectionException
    extends DBIntrospectionException {
        GenericIntrospectionException(String message2, Throwable cause) {
            super(message2, cause);
        }
    }

    public static final class Factory
    implements DBIntrospector.Factory {
        private static final Map<Dbms, PerObjectVersion> VERSIONS = FactoryMap.create(key2 -> PerObjectVersion.DEFAULT.INSTANCE);
        private final Dbms myDbms;
        @NotNull
        public static final JdbcNature ourNature = new JdbcNature();

        public Factory(@NotNull Dbms dbms) {
            if (dbms == null) {
                Factory.$$$reportNull$$$0(0);
            }
            this.myDbms = dbms;
        }

        @Override
        @NotNull
        public DBIntrospector createIntrospector(@NotNull DBIntrospectionContext context, @NotNull Dbms dbms, @NotNull ModelFactory modelFactory) {
            if (context == null) {
                Factory.$$$reportNull$$$0(1);
            }
            if (dbms == null) {
                Factory.$$$reportNull$$$0(2);
            }
            if (modelFactory == null) {
                Factory.$$$reportNull$$$0(3);
            }
            return new JdbcIntrospector(context, ourNature, dbms, modelFactory);
        }

        @Override
        public boolean isSupported(@NotNull Version version) {
            if (version == null) {
                Factory.$$$reportNull$$$0(4);
            }
            return true;
        }

        @Override
        public boolean isNative() {
            return false;
        }

        @Override
        public boolean isIncremental() {
            return false;
        }

        @Override
        public int getVersion(@NotNull ObjectKind kind) {
            if (kind == null) {
                Factory.$$$reportNull$$$0(5);
            }
            return VERSIONS.get(this.myDbms).get(kind);
        }

        @Override
        public boolean isOutdatedCheckSupported(@Nullable BasicElement e2) {
            return false;
        }

        @Override
        public boolean supportsMultilevelIntrospection() {
            return false;
        }

        @Override
        public boolean supportsFragmentIntrospection() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dbms";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modelFactory";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "version";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dialects/base/introspector/jdbc/JdbcIntrospector$Factory";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createIntrospector";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSupported";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getVersion";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class JdbcNature
    implements BaseIntrospector.Nature {
        @Override
        public boolean getSupportServerObjects() {
            return false;
        }

        @Override
        public boolean getSupportFragmentIntrospection() {
            return false;
        }

        @Override
        @NotNull
        public Set<ObjectKind> getSupportFragmentKinds() {
            Set<ObjectKind> set = Collections.emptySet();
            if (set == null) {
                JdbcNature.$$$reportNull$$$0(0);
            }
            return set;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/base/introspector/jdbc/JdbcIntrospector$JdbcNature", "getSupportFragmentKinds"));
        }
    }
}

