/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.introspector;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DBConnectionAccessibilityMatcher;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dialects.base.introspector.BaseIntrospectionFunctions;
import com.intellij.database.dialects.base.introspector.BaseIntrospector;
import com.intellij.database.dialects.base.introspector.BaseMultiDatabaseIntrospector;
import com.intellij.database.dialects.base.introspector.BaseMultiDatabaseIntrospectorKt;
import com.intellij.database.dialects.base.introspector.BaseNativeIntrospector;
import com.intellij.database.introspection.BriefIntrospectionTask;
import com.intellij.database.introspection.DBIntrospectionContext;
import com.intellij.database.introspection.DatabaseIntrospectionTask;
import com.intellij.database.introspection.DatabaseObjectsIntrospectionTask;
import com.intellij.database.introspection.DefiniteIntrospectionTask;
import com.intellij.database.introspection.IndefiniteIntrospectionTask;
import com.intellij.database.introspection.IntrospectionMode;
import com.intellij.database.introspection.IntrospectionTask;
import com.intellij.database.introspection.IntrospectionTaskHelperFun;
import com.intellij.database.introspection.IntrospectionTasks;
import com.intellij.database.introspection.ListSchemasTask;
import com.intellij.database.introspection.SchemasIntrospectionTask;
import com.intellij.database.layoutedQueries.DBTransaction;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.basic.BasicAuxiliaryElement;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIdentifiedElement;
import com.intellij.database.model.basic.BasicMajorObject;
import com.intellij.database.model.basic.BasicMateDatabase;
import com.intellij.database.model.basic.BasicMateNamespace;
import com.intellij.database.model.basic.BasicMinorObject;
import com.intellij.database.model.basic.BasicModDatabase;
import com.intellij.database.model.basic.BasicModMateDatabase;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModMultiDatabaseRoot;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModSchema;
import com.intellij.database.model.basic.BasicMultiDatabaseRoot;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicNamespaceOwner;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.IdentifyingFamily;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.common.StringFun;
import com.intellij.ide.PlatformIdeService;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.UtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00f0\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u001f\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u0004*\b\b\u0002\u0010\u0005*\u00020\u00062\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u00050\u0007:\u0003lmnB'\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u0010\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001fH\u0014J&\u0010 \u001a \u0012\u0002\b\u0003\u0012\u0002\b\u00030!R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0000H$J;\u0010\"\u001a \u0012\u0006\b\u0001\u0012\u00028\u00010#R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00002\u0006\u0010$\u001a\u00020%2\u0006\u0010\u001e\u001a\u00028\u0001H$\u00a2\u0006\u0002\u0010&J9\u0010'\u001a\u001e\u0012\u0004\u0012\u00028\u00010(R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00072\u0006\u0010$\u001a\u00020%2\u0006\u0010\u001e\u001a\u00028\u0001H\u0014\u00a2\u0006\u0002\u0010)J;\u0010*\u001a \u0012\u0006\b\u0001\u0012\u00028\u00020+R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00072\u0006\u0010$\u001a\u00020%2\u0006\u0010,\u001a\u00028\u0002H$\u00a2\u0006\u0002\u0010-J\u0012\u0010.\u001a\u0004\u0018\u00010/2\u0006\u00100\u001a\u000201H\u0016J\u001c\u00102\u001a\b\u0012\u0004\u0012\u00020/032\f\u00104\u001a\b\u0012\u0004\u0012\u00020105H\u0016J\u0012\u00106\u001a\u0004\u0018\u00010\u001f2\u0006\u00107\u001a\u00020\u0012H\u0014J&\u00108\u001a\b\u0012\u0004\u0012\u00028\u0001092\u0006\u0010:\u001a\u00020%2\u000e\u0010;\u001a\n\u0012\u0004\u0012\u00020<\u0018\u000103H\u0014J\b\u0010=\u001a\u00020>H\u0016J\u0016\u0010?\u001a\b\u0012\u0004\u0012\u00020A0@2\u0006\u0010\u001e\u001a\u00020\u0004H\u0002J \u0010B\u001a\u00020C2\u0006\u0010:\u001a\u00020%2\u000e\u0010;\u001a\n\u0012\u0004\u0012\u00020<\u0018\u000103H\u0014J\u0018\u0010D\u001a\u00020C2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u001b\u001a\u00020EH\u0014J\u0018\u0010F\u001a\u00020C2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u001b\u001a\u00020GH\u0014J!\u0010H\u001a\u00020C2\u0012\u0010I\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001f0J\"\u00020\u001fH\u0016\u00a2\u0006\u0002\u0010KJ\u001e\u0010L\u001a\u00020C2\u0006\u0010:\u001a\u00020%2\f\u0010M\u001a\b\u0012\u0004\u0012\u00020\u001f09H\u0002J\u001e\u0010N\u001a\u00020C2\u0006\u0010:\u001a\u00020%2\f\u0010O\u001a\b\u0012\u0004\u0012\u00020/03H\u0002J\u0010\u0010P\u001a\u00020C2\u0006\u0010$\u001a\u00020%H\u0014J\u0010\u0010Q\u001a\u00020C2\u0006\u0010$\u001a\u00020%H\u0002J\u0018\u0010R\u001a\u00020C2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u0010\u0010S\u001a\u00020C2\u0006\u0010:\u001a\u00020%H\u0014J(\u0010S\u001a\u00020C\"\b\b\u0003\u0010T*\u00020\u001f2\u0006\u0010:\u001a\u00020%2\f\u0010I\u001a\b\u0012\u0004\u0012\u0002HT0UH\u0004J8\u0010V\u001a\u00020C2\f\u00104\u001a\b\u0012\u0004\u0012\u000201092\u0006\u0010W\u001a\u00020\u00182\u0018\u0010X\u001a\u0014\u0012\u0004\u0012\u000201\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120J0YH\u0016J\u0010\u0010Z\u001a\u00020C2\u0006\u0010:\u001a\u00020%H\u0014J\u0018\u0010[\u001a\u00020C2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u001b\u001a\u00020\\H\u0014J\u001e\u0010[\u001a\u00020C2\u0006\u0010:\u001a\u00020%2\f\u0010]\u001a\b\u0012\u0004\u0012\u00020A03H\u0002J\u0010\u0010^\u001a\u00020C2\u0006\u0010:\u001a\u00020%H\u0004J\b\u0010_\u001a\u00020CH\u0014J\u0018\u0010`\u001a\u00020C2\u0006\u0010a\u001a\u00020b2\u0006\u0010c\u001a\u00020\u001fH\u0002J\u001d\u0010d\u001a\u00020C2\u0006\u0010:\u001a\u00020%2\u0006\u0010\u001e\u001a\u00028\u0001H\u0014\u00a2\u0006\u0002\u0010eJ\u001a\u0010f\u001a\u0004\u0018\u00010\u001f2\u0006\u0010$\u001a\u00020%2\u0006\u00107\u001a\u00020\u0012H\u0014J\u001c\u0010g\u001a\b\u0012\u0004\u0012\u00020\u001c0@2\f\u0010h\u001a\b\u0012\u0004\u0012\u00020\u001c03H\u0014J\u0018\u0010i\u001a\u00020C2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u001e\u001a\u00020\u001fH\u0014J\u000e\u0010j\u001a\u0004\u0018\u00010\u001f*\u00020\u001fH\u0002J\u000e\u0010k\u001a\u0004\u0018\u00010A*\u00020AH\u0002R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006o"}, d2={"Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector;", "MR", "Lcom/intellij/database/model/basic/BasicModMultiDatabaseRoot;", "D", "Lcom/intellij/database/model/basic/BasicModMateDatabase;", "S", "Lcom/intellij/database/model/basic/BasicModSchema;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector;", "context", "Lcom/intellij/database/introspection/DBIntrospectionContext;", "nature", "Lcom/intellij/database/dialects/base/introspector/BaseIntrospector$Nature;", "dbms", "Lcom/intellij/database/Dbms;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "(Lcom/intellij/database/introspection/DBIntrospectionContext;Lcom/intellij/database/dialects/base/introspector/BaseIntrospector$Nature;Lcom/intellij/database/Dbms;Lcom/intellij/database/model/ModelFactory;)V", "connectionCurrentDatabaseName", "", "getConnectionCurrentDatabaseName", "()Ljava/lang/String;", "setConnectionCurrentDatabaseName", "(Ljava/lang/String;)V", "databasesAreListed", "", "checkConnectionApplicable", "Lcom/intellij/database/dialects/base/introspector/BaseIntrospector$ConnectionApplicability;", "task", "Lcom/intellij/database/introspection/IntrospectionTask;", "checkDatabaseIsAccessibleInCurrentConnection", "database", "Lcom/intellij/database/model/basic/BasicDatabase;", "createDatabaseLister", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector$DatabaseLister;", "createDatabaseRetriever", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector$BaseDatabaseRetriever;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "(Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/model/basic/BasicModMateDatabase;)Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector$BaseDatabaseRetriever;", "createNativeRetriever", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractNativeRetriever;", "(Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/model/basic/BasicModMateDatabase;)Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractNativeRetriever;", "createSchemaRetriever", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractSchemaRetriever;", "schema", "(Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/model/basic/BasicModSchema;)Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractSchemaRetriever;", "extractFragmentToIntrospect", "Lcom/intellij/database/model/basic/BasicMajorObject;", "element", "Lcom/intellij/database/model/basic/BasicElement;", "extractFragmentsToIntrospect", "", "elements", "", "findDatabase", "databaseName", "getDatabasesToIntrospect", "", "tran", "namespaces", "Lcom/intellij/database/model/basic/BasicNamespace;", "getDefaultScope", "Lcom/intellij/database/util/TreePattern;", "getSchemasToIntrospect", "", "Lcom/intellij/database/model/basic/BasicSchema;", "introspectAutoInTran", "", "introspectDatabase", "Lcom/intellij/database/introspection/DatabaseIntrospectionTask;", "introspectDatabaseObjects", "Lcom/intellij/database/introspection/DatabaseObjectsIntrospectionTask;", "introspectDatabaseSchemas", "databases", "", "([Lcom/intellij/database/model/basic/BasicDatabase;)V", "introspectDatabases", "databasesToIntrospect", "introspectFragments", "fragmentToIntrospect", "introspectGeneral", "introspectGeneralWithDistributionByDatabases", "introspectNamespaces", "introspectNamespacesInTran", "T", "Lcom/intellij/util/containers/JBIterable;", "introspectNativeDefinitions", "withNestedElements", "result", "", "introspectPreDatabaseObjects", "introspectSchemas", "Lcom/intellij/database/introspection/SchemasIntrospectionTask;", "schemasToIntrospect", "listAndApplyDatabasesIfNotYet", "logModelInfo", "notifyCannotSwitchDatabase", "root", "Lcom/intellij/database/model/basic/BasicMultiDatabaseRoot;", "db", "postProcessDatabase", "(Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/model/basic/BasicModMateDatabase;)V", "reifyDatabase", "reorderTasks", "originalTasks", "retrieveSchemasOfDatabase", "adjustDatabaseInstance", "adjustSchemaInstance", "BaseDatabaseRetriever", "BaseNativeRetriever", "DatabaseLister", "intellij.database.dialects.base"})
@SourceDebugExtension(value={"SMAP\nBaseMultiDatabaseIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseMultiDatabaseIntrospector.kt\ncom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector\n+ 2 BaseIntrospector.kt\ncom/intellij/database/dialects/base/introspector/BaseIntrospector\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 6 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,626:1\n968#2,2:627\n981#2:644\n968#2,2:645\n982#2:647\n981#2:648\n968#2,2:649\n982#2:651\n1002#3,2:629\n1002#3,2:631\n1002#3,2:633\n766#3:635\n857#3,2:636\n766#3:639\n857#3,2:640\n288#3,2:642\n1477#3:666\n1502#3,3:667\n1505#3,3:677\n1#4:638\n988#5:652\n1017#5,3:653\n1020#5,3:663\n372#6,7:656\n372#6,7:670\n*S KotlinDebug\n*F\n+ 1 BaseMultiDatabaseIntrospector.kt\ncom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector\n*L\n91#1:627,2\n384#1:644\n384#1:645,2\n384#1:647\n414#1:648\n414#1:649,2\n414#1:651\n133#1:629,2\n134#1:631,2\n135#1:633,2\n158#1:635\n158#1:636,2\n246#1:639\n246#1:640,2\n265#1:642,2\n605#1:666\n605#1:667,3\n605#1:677,3\n540#1:652\n540#1:653,3\n540#1:663,3\n540#1:656,7\n605#1:670,7\n*E\n"})
public abstract class BaseMultiDatabaseIntrospector<MR extends BasicModMultiDatabaseRoot, D extends BasicModMateDatabase, S extends BasicModSchema>
extends BaseNativeIntrospector<MR, D, S> {
    @Nullable
    private String connectionCurrentDatabaseName;
    private boolean databasesAreListed;

    @Nullable
    protected final String getConnectionCurrentDatabaseName() {
        return this.connectionCurrentDatabaseName;
    }

    protected final void setConnectionCurrentDatabaseName(@Nullable String string) {
        this.connectionCurrentDatabaseName = string;
    }

    public BaseMultiDatabaseIntrospector(@NotNull DBIntrospectionContext context, @NotNull BaseIntrospector.Nature nature, @NotNull Dbms dbms, @NotNull ModelFactory modelFactory) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)nature, (String)"nature");
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        Intrinsics.checkNotNullParameter((Object)modelFactory, (String)"modelFactory");
        super(context, nature, dbms, modelFactory);
    }

    protected boolean checkDatabaseIsAccessibleInCurrentConnection(@NotNull BasicDatabase database) {
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        Object object = this.getDbConnection();
        if (object == null || (object = object.getConnectionPoint()) == null) {
            return false;
        }
        Object connectionPoint = object;
        DBConnectionAccessibilityMatcher dBConnectionAccessibilityMatcher = this.getAccessibilityMatcher();
        if (dBConnectionAccessibilityMatcher == null) {
            return true;
        }
        DBConnectionAccessibilityMatcher accessibilityMatcher = dBConnectionAccessibilityMatcher;
        return accessibilityMatcher.isDatabaseAccessible((DatabaseConnectionPoint)connectionPoint, database);
    }

    @Override
    @NotNull
    protected BaseIntrospector.ConnectionApplicability checkConnectionApplicable(@NotNull IntrospectionTask task) {
        boolean ok2;
        BasicDatabase db2;
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        BaseIntrospector.ConnectionApplicability connectionApplicability = this.getDbConnection() == null ? BaseIntrospector.ConnectionApplicability.connNone : (this.isMetadataAccessDependsOnConnection() ? ((db2 = this.getDatabase(task)) != null ? ((ok2 = this.checkDatabaseIsAccessibleInCurrentConnection(db2)) ? BaseIntrospector.ConnectionApplicability.connApplicableFull : BaseIntrospector.ConnectionApplicability.connInapplicable) : BaseIntrospector.ConnectionApplicability.connApplicablePartial) : BaseIntrospector.ConnectionApplicability.connApplicableFull);
        return connectionApplicability;
    }

    @Override
    protected void logModelInfo() {
        super.logModelInfo();
        BasicModModel basicModModel = this.getMyModel();
        if (basicModModel == null) {
            this.logWarn("The model is not initialized yet");
            return;
        }
        BasicModModel model2 = basicModModel;
        BaseIntrospector this_$iv = this;
        boolean $i$f$getTracing = false;
        Logger logger2 = BaseIntrospector.access$getDbLogger(this_$iv);
        Level level$iv = logger2 != null ? BaseIntrospector.Companion.access$getEffectiveLevel(BaseIntrospector.Companion, logger2) : null;
        if (!(level$iv != null && level$iv.intValue() <= BaseIntrospector.access$getTRACE_LEVEL_VALUE$cp())) {
            return;
        }
        StringBuilder b2 = new StringBuilder();
        BasicRoot basicRoot = model2.getRoot();
        Intrinsics.checkNotNull((Object)basicRoot, (String)"null cannot be cast to non-null type com.intellij.database.model.basic.BasicMultiDatabaseRoot");
        BasicMultiDatabaseRoot root2 = (BasicMultiDatabaseRoot)basicRoot;
        Iterable<? extends BasicMateDatabase> iterable = root2.getNamespaces();
        Intrinsics.checkNotNullExpressionValue(iterable, (String)"getNamespaces(...)");
        int n12 = SequencesKt.count((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence(iterable), (Function1)logModelInfo.n1.1.INSTANCE));
        StringBuilder stringBuilder = b2;
        Iterable<? extends BasicMateDatabase> iterable2 = root2.getNamespaces();
        Intrinsics.checkNotNullExpressionValue(iterable2, (String)"getNamespaces(...)");
        StringBuilder stringBuilder2 = stringBuilder.append("The model contains " + CollectionsKt.count(iterable2) + " databases, " + n12 + " of them are with schemas");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
        BasicMateDatabase currDatabase = root2.getCurrentDatabase();
        if (currDatabase != null) {
            BasicSchema currSchema;
            StringBuilder stringBuilder3 = b2.append("Current database: " + currDatabase.getName());
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append(...)");
            Iterable<? extends BasicMateNamespace> iterable3 = currDatabase.getNamespaces();
            Intrinsics.checkNotNullExpressionValue(iterable3, (String)"getNamespaces(...)");
            int n22 = SequencesKt.count((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence(iterable3), (Function1)logModelInfo.n2.1.INSTANCE));
            StringBuilder stringBuilder4 = b2;
            Iterable<? extends BasicMateNamespace> iterable4 = currDatabase.getNamespaces();
            Intrinsics.checkNotNullExpressionValue(iterable4, (String)"getNamespaces(...)");
            StringBuilder stringBuilder5 = stringBuilder4.append("The current database has " + CollectionsKt.count(iterable4) + " schemas, " + n22 + " of them have inner objects");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append('\n'), (String)"append(...)");
            BasicSchema basicSchema = currSchema = ModelFun.getCurrentSchema(currDatabase);
            if (basicSchema != null) {
                StringBuilder stringBuilder6 = b2.append("Current schema: " + basicSchema.getName());
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6.append('\n'), (String)"append(...)");
            } else {
                StringBuilder stringBuilder7 = b2.append("No current schema in this database");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7.append('\n'), (String)"append(...)");
            }
        } else {
            StringBuilder stringBuilder8 = b2.append("No current database.");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8.append('\n'), (String)"append(...)");
        }
        String string = b2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        this.trace(string);
    }

    @Override
    @NotNull
    protected List<IntrospectionTask> reorderTasks(@NotNull Collection<? extends IntrospectionTask> originalTasks) {
        Intrinsics.checkNotNullParameter(originalTasks, (String)"originalTasks");
        ArrayList tasks0 = new ArrayList(0);
        ArrayList tasks1 = new ArrayList(0);
        ArrayList tasks2 = new ArrayList(0);
        BasicModMateDatabase basicModMateDatabase = (BasicModMateDatabase)((BasicModMultiDatabaseRoot)this.getRoot()).getCurrentDatabase();
        String currentDatabaseName = basicModMateDatabase != null ? basicModMateDatabase.getName() : null;
        for (IntrospectionTask introspectionTask : originalTasks) {
            IntrospectionTask introspectionTask2 = introspectionTask;
            if (introspectionTask2 instanceof IndefiniteIntrospectionTask) {
                ((Collection)tasks0).add(introspectionTask);
                continue;
            }
            if (!(introspectionTask2 instanceof DefiniteIntrospectionTask)) continue;
            String name2 = ((DefiniteIntrospectionTask)introspectionTask).getDatabaseName();
            if (Intrinsics.areEqual((Object)name2, (Object)currentDatabaseName) || Intrinsics.areEqual((Object)name2, (Object)"@") || ((CharSequence)name2).length() == 0) {
                ((Collection)tasks1).add(introspectionTask);
                continue;
            }
            ((Collection)tasks2).add(introspectionTask);
        }
        List $this$sortBy$iv = tasks0;
        boolean bl = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b2) {
                    IntrospectionTask it2 = (IntrospectionTask)a;
                    boolean bl = false;
                    Comparable comparable = Byte.valueOf(it2.getTaskTypeOrder());
                    it2 = (IntrospectionTask)b2;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Byte.valueOf(it2.getTaskTypeOrder()));
                }
            });
        }
        $this$sortBy$iv = tasks1;
        boolean bl2 = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b2) {
                    IntrospectionTask it2 = (IntrospectionTask)a;
                    boolean bl = false;
                    Comparable comparable = Byte.valueOf(it2.getTaskTypeOrder());
                    it2 = (IntrospectionTask)b2;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Byte.valueOf(it2.getTaskTypeOrder()));
                }
            });
        }
        $this$sortBy$iv = tasks2;
        boolean bl3 = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b2) {
                    IntrospectionTask it2 = (IntrospectionTask)a;
                    boolean bl = false;
                    Comparable comparable = Byte.valueOf(it2.getTaskTypeOrder());
                    it2 = (IntrospectionTask)b2;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Byte.valueOf(it2.getTaskTypeOrder()));
                }
            });
        }
        ArrayList tasks = new ArrayList(originalTasks.size());
        tasks.addAll(tasks0);
        tasks.addAll(tasks1);
        tasks.addAll(tasks2);
        return tasks;
    }

    @Override
    protected void introspectGeneral(@NotNull DBTransaction transaction) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        this.introspectServerAndSessionInfo();
        this.listAndApplyDatabasesIfNotYet(transaction);
        if (this.isMetadataAccessDependsOnConnection()) {
            this.introspectGeneralWithDistributionByDatabases(transaction);
        } else {
            super.introspectGeneral(transaction);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void introspectGeneralWithDistributionByDatabases(DBTransaction transaction) {
        void $this$filterTo$iv$iv;
        Iterable<? extends BasicMateDatabase> iterable = ((BasicModMultiDatabaseRoot)this.getRoot()).getNamespaces();
        Intrinsics.checkNotNullExpressionValue(iterable, (String)"getNamespaces(...)");
        Iterable<? extends BasicMateDatabase> $this$filter$iv = iterable;
        boolean $i$f$filter = false;
        Iterable<? extends BasicMateDatabase> iterable2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            BasicNamespace p0 = (BasicNamespace)element$iv$iv;
            boolean bl = false;
            if (!this.inIntrospectionScope(p0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List databasesToIntrospect = (List)destination$iv$iv;
        ArrayList applicableTasks = new ArrayList();
        DBConnectionAccessibilityMatcher accessibilityMatcher = this.getAccessibilityMatcher();
        boolean canSwitchDatabase = accessibilityMatcher != null && accessibilityMatcher.canSwitchDatabase();
        for (BasicModMateDatabase db2 : databasesToIntrospect) {
            DefiniteIntrospectionTask additionalTask = IntrospectionTasks.prepareDatabaseTask(db2);
            if (this.checkDatabaseIsAccessibleInCurrentConnection(db2)) {
                ((Collection)applicableTasks).add(additionalTask);
                continue;
            }
            if (canSwitchDatabase) {
                this.deferTask(additionalTask);
                continue;
            }
            this.notifyCannotSwitchDatabase((BasicMultiDatabaseRoot)this.getRoot(), db2);
        }
        if (!((Collection)applicableTasks).isEmpty()) {
            this.introspectPreDatabaseObjects(transaction);
            for (IntrospectionTask applicableTask : applicableTasks) {
                Intrinsics.checkNotNull((Object)applicableTask);
                this.introspectInTran(transaction, applicableTask);
            }
        }
        this.introspectServerObjectsInTran(transaction);
    }

    private final void notifyCannotSwitchDatabase(BasicMultiDatabaseRoot root2, BasicDatabase db2) {
        Object[] accessibleDatabase = (Object[])root2.getCurrentDatabase();
        Object[] objectArray = accessibleDatabase;
        if (objectArray == null || (objectArray = objectArray.getDisplayName()) == null) {
            objectArray = "not detected";
        }
        Object[] accessibleDatabaseString = objectArray;
        this.logWarn("Cannot perform introspection task with non-accessible database (" + db2.getDisplayName() + ") because switching database is not possible in this configuration; the only accessible database is " + (String)accessibleDatabaseString);
        Object[] objectArray2 = accessibleDatabase;
        if (objectArray2 == null || (objectArray2 = objectArray2.getDisplayName()) == null) {
            objectArray2 = DatabaseBundle.message("base.introspector.switching.database.singleDatabaseMode.currentDatabaseIsNotDetected", new Object[0]);
        }
        Object[] objectArray3 = objectArray2;
        Intrinsics.checkNotNull((Object)objectArray3);
        Object[] accessibleDatabaseI18nString = objectArray3;
        objectArray3 = new Object[]{accessibleDatabaseI18nString, db2.getDisplayName()};
        PlatformIdeService.getInstance().notification("Switching database in introspection", PlatformIdeService.NotificationType.WARNING, DatabaseBundle.message("base.introspector.switching.database.singleDatabaseMode.title", new Object[0]), DatabaseBundle.message("base.introspector.switching.database.singleDatabaseMode.subtitle", new Object[0]), DatabaseBundle.message("base.introspector.switching.database.singleDatabaseMode.description", objectArray3), this.getProject(), "base.introspector.switching.database.singleDatabaseMode");
    }

    @NotNull
    public Collection<BasicMajorObject> extractFragmentsToIntrospect(@NotNull Collection<BasicElement> elements2) {
        Intrinsics.checkNotNullParameter(elements2, (String)"elements");
        LinkedHashSet fragments2 = new LinkedHashSet(elements2.size());
        BaseIntrospectionFunctions.extractTo(elements2, fragments2, (Function1)new Function1<BasicElement, BasicMajorObject>((Object)this){

            @Nullable
            public final BasicMajorObject invoke(@NotNull BasicElement p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((BaseMultiDatabaseIntrospector)this.receiver).extractFragmentToIntrospect(p0);
            }
        });
        return fragments2;
    }

    @Nullable
    public BasicMajorObject extractFragmentToIntrospect(@NotNull BasicElement element2) {
        BasicMajorObject basicMajorObject;
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        BasicElement basicElement = element2;
        if (basicElement instanceof BasicMajorObject) {
            basicMajorObject = (BasicMajorObject)element2;
        } else if (basicElement instanceof BasicMinorObject) {
            basicMajorObject = ((BasicMinorObject)element2).getMajorObject();
        } else if (basicElement instanceof BasicNamespace ? true : basicElement instanceof BasicNamespaceOwner) {
            basicMajorObject = null;
        } else if (basicElement instanceof BasicAuxiliaryElement) {
            basicMajorObject = null;
        } else {
            BasicElement basicElement2 = element2.getParent();
            if (basicElement2 != null) {
                BasicElement parent2 = basicElement2;
                boolean bl = false;
                basicMajorObject = this.extractFragmentToIntrospect(parent2);
            } else {
                basicMajorObject = null;
            }
        }
        return basicMajorObject;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void introspectNamespaces(@NotNull DBTransaction transaction, @NotNull IntrospectionTask task) {
        boolean needsToListDatabases;
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Iterable<? extends BasicMateDatabase> iterable = ((BasicModMultiDatabaseRoot)this.getRoot()).getNamespaces();
        Intrinsics.checkNotNullExpressionValue(iterable, (String)"getNamespaces(...)");
        boolean bl = needsToListDatabases = IntrospectionTaskHelperFun.isEmpty(iterable) || task instanceof IndefiniteIntrospectionTask || task instanceof DefiniteIntrospectionTask && this.getDatabaseIsKnown((DefiniteIntrospectionTask)task);
        if (needsToListDatabases) {
            this.listAndApplyDatabasesIfNotYet(transaction);
        }
        boolean allApplicable = !this.isMetadataAccessDependsOnConnection();
        IntrospectionTask introspectionTask = task;
        if (introspectionTask instanceof DefiniteIntrospectionTask) {
            boolean applicableRightNow;
            BasicDatabase basicDatabase = this.getDatabase(task);
            if (basicDatabase == null) {
                return;
            }
            BasicDatabase theDatabase = basicDatabase;
            boolean bl2 = applicableRightNow = allApplicable || this.checkDatabaseIsAccessibleInCurrentConnection(theDatabase);
            if (applicableRightNow) {
                this.retrieveSchemasOfDatabase(transaction, theDatabase);
            } else {
                ListSchemasTask listSchemasTask;
                if (task instanceof ListSchemasTask) {
                    listSchemasTask = (ListSchemasTask)task;
                } else {
                    String string = theDatabase.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    listSchemasTask = new ListSchemasTask(string);
                }
                ListSchemasTask taskToDefer = listSchemasTask;
                this.deferTask(taskToDefer);
            }
        } else if (introspectionTask instanceof IndefiniteIntrospectionTask) {
            List list;
            if (task instanceof BriefIntrospectionTask && ((BriefIntrospectionTask)task).getVisitEveryDatabase()) {
                Iterable<? extends BasicMateDatabase> iterable2 = ((BasicModMultiDatabaseRoot)this.getRoot()).getNamespaces();
                Intrinsics.checkNotNullExpressionValue(iterable2, (String)"getNamespaces(...)");
                list = CollectionsKt.toList(iterable2);
            } else {
                void $this$filterTo$iv$iv;
                Iterable<? extends BasicMateDatabase> iterable3 = ((BasicModMultiDatabaseRoot)this.getRoot()).getNamespaces();
                Intrinsics.checkNotNullExpressionValue(iterable3, (String)"getNamespaces(...)");
                Iterable<? extends BasicMateDatabase> $this$filter$iv = iterable3;
                boolean $i$f$filter = false;
                Iterable<? extends BasicMateDatabase> iterable4 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    BasicNamespace p0 = (BasicNamespace)element$iv$iv;
                    boolean bl3 = false;
                    if (!this.inIntrospectionScope(p0)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list = (List)destination$iv$iv;
            }
            List databases2 = list;
            for (BasicModMateDatabase db2 : databases2) {
                boolean applicableRightNow;
                boolean bl4 = applicableRightNow = allApplicable || this.checkDatabaseIsAccessibleInCurrentConnection(db2);
                if (applicableRightNow) {
                    this.retrieveSchemasOfDatabase(transaction, db2);
                    continue;
                }
                String string = db2.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                ListSchemasTask additionalTask = new ListSchemasTask(string);
                this.deferTask(additionalTask);
            }
        }
    }

    @Override
    protected void introspectNamespacesInTran(@NotNull DBTransaction tran) {
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
        this.listAndApplyDatabasesIfNotYet(tran);
        BasicDatabase firstDatabase = ((BasicModMultiDatabaseRoot)this.getRoot()).getCurrentDatabase();
        if (firstDatabase == null && this.dbms.isSnowflake()) {
            BasicMateDatabase basicMateDatabase;
            block3: {
                Iterable<? extends BasicMateDatabase> iterable = ((BasicModMultiDatabaseRoot)this.getRoot()).getNamespaces();
                Intrinsics.checkNotNullExpressionValue(iterable, (String)"getNamespaces(...)");
                Iterable<? extends BasicMateDatabase> $this$firstOrNull$iv = iterable;
                boolean $i$f$firstOrNull = false;
                for (BasicMateDatabase basicMateDatabase2 : $this$firstOrNull$iv) {
                    BasicModMateDatabase it2 = (BasicModMateDatabase)basicMateDatabase2;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it2);
                    if (!this.inIntrospectionScope(it2)) continue;
                    basicMateDatabase = basicMateDatabase2;
                    break block3;
                }
                basicMateDatabase = null;
            }
            firstDatabase = basicMateDatabase;
        }
        if (firstDatabase != null) {
            JBIterable jBIterable = JBIterable.of((Object)firstDatabase);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"of(...)");
            this.introspectNamespacesInTran(tran, jBIterable);
        }
    }

    protected final <T extends BasicDatabase> void introspectNamespacesInTran(@NotNull DBTransaction tran, @NotNull JBIterable<T> databases2) {
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
        Intrinsics.checkNotNullParameter(databases2, (String)"databases");
        for (BasicDatabase database : databases2) {
            Intrinsics.checkNotNull((Object)database);
            this.retrieveSchemasOfDatabase(tran, database);
        }
    }

    protected final void listAndApplyDatabasesIfNotYet(@NotNull DBTransaction tran) {
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
        Iterable<? extends BasicMateDatabase> iterable = ((BasicModMultiDatabaseRoot)this.getRoot()).getNamespaces();
        Intrinsics.checkNotNullExpressionValue(iterable, (String)"getNamespaces(...)");
        if (IntrospectionTaskHelperFun.isEmpty(iterable) || !this.databasesAreListed) {
            this.trace("Listing databases\u2026");
            DatabaseLister<?, ?> databaseLister = this.createDatabaseLister();
            databaseLister.listAndApplyDatabases$intellij_database_dialects_base(tran);
            Iterable<? extends BasicMateDatabase> iterable2 = ((BasicModMultiDatabaseRoot)this.getRoot()).getNamespaces();
            Intrinsics.checkNotNullExpressionValue(iterable2, (String)"getNamespaces(...)");
            this.databasesAreListed = IntrospectionTaskHelperFun.isNotEmpty(iterable2);
        }
    }

    @Override
    @Nullable
    protected BasicDatabase reifyDatabase(@NotNull DBTransaction transaction, @NotNull String databaseName) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)databaseName, (String)"databaseName");
        BasicDatabase database = this.findDatabase(databaseName);
        if (database == null && !this.databasesAreListed) {
            this.listAndApplyDatabasesIfNotYet(transaction);
            database = this.findDatabase(databaseName);
        }
        return database;
    }

    @Override
    @Nullable
    protected BasicDatabase findDatabase(@NotNull String databaseName) {
        Intrinsics.checkNotNullParameter((Object)databaseName, (String)"databaseName");
        return Intrinsics.areEqual((Object)databaseName, (Object)"@") ? (BasicDatabase)((BasicModMultiDatabaseRoot)this.getRoot()).getCurrentDatabase() : (BasicDatabase)((BasicModMultiDatabaseRoot)this.getRoot()).findDatabaseByName(databaseName);
    }

    @Override
    protected void introspectDatabase(@NotNull DBTransaction transaction, @NotNull DatabaseIntrospectionTask task) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        BasicDatabase basicDatabase = this.getDatabase(task);
        if (basicDatabase == null) {
            this.logWarn("Cannot find database with name '" + task.getDatabaseName() + "'.");
            return;
        }
        BasicDatabase database = basicDatabase;
        this.introspectAutoInTran(transaction, SetsKt.setOf((Object)database));
    }

    @Override
    protected void introspectSchemas(@NotNull DBTransaction transaction, @NotNull SchemasIntrospectionTask task) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        BasicDatabase basicDatabase = this.getDatabase(task);
        if (basicDatabase == null) {
            this.logWarn("Cannot find database with name '" + task.getDatabaseName() + "'.");
            return;
        }
        BasicDatabase database = basicDatabase;
        NamingFamily<? extends BasicSchema> namingFamily = database.getSchemas();
        Intrinsics.checkNotNullExpressionValue(namingFamily, (String)"getSchemas(...)");
        List schemas2 = ModelFun.elementsByNames(namingFamily, task.getSchemaNames());
        this.introspectAutoInTran(transaction, schemas2);
    }

    @Override
    protected void introspectDatabaseObjects(@NotNull DBTransaction transaction, @NotNull DatabaseObjectsIntrospectionTask task) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        BasicDatabase basicDatabase = this.getDatabase(task);
        if (basicDatabase == null) {
            this.logWarn("Cannot find database with name '" + task.getDatabaseName() + "'.");
            return;
        }
        BasicDatabase database = basicDatabase;
        BaseDatabaseRetriever<BasicModMateDatabase> databaseRetriever = this.createDatabaseRetriever(transaction, (BasicModMateDatabase)database);
        databaseRetriever.retrieveServerAndDatabaseObjects();
    }

    @Override
    @NotNull
    public TreePattern getDefaultScope() {
        return BaseMultiDatabaseIntrospectorKt.getMULTI_DB_SCOPE();
    }

    @NotNull
    protected abstract DatabaseLister<?, ?> createDatabaseLister();

    @Override
    public void introspectDatabaseSchemas(BasicDatabase ... databases2) {
        Intrinsics.checkNotNullParameter((Object)databases2, (String)"databases");
        if (!(databases2.length == 0)) {
            BaseIntrospector this_$iv = this;
            boolean $i$f$trace = false;
            BaseIntrospector this_$iv$iv = this_$iv;
            boolean $i$f$getTracing = false;
            Logger logger2 = BaseIntrospector.access$getDbLogger(this_$iv$iv);
            Level level$iv$iv = logger2 != null ? BaseIntrospector.Companion.access$getEffectiveLevel(BaseIntrospector.Companion, logger2) : null;
            if (level$iv$iv != null && level$iv$iv.intValue() <= BaseIntrospector.access$getTRACE_LEVEL_VALUE$cp()) {
                BaseIntrospector baseIntrospector = this_$iv;
                boolean bl = false;
                String dbs2 = ArraysKt.joinToString$default((Object[])databases2, (CharSequence)"", null, null, (int)0, null, (Function1)introspectDatabaseSchemas.1.dbs.1.INSTANCE, (int)30, null);
                BaseIntrospector.access$trace(baseIntrospector, "Introspecting database schemas brief info for the following databases: " + dbs2);
            }
            this.inTransactionUnit((Function1<DBTransaction, Unit>)((Function1)new Function1<DBTransaction, Unit>(databases2, this){
                final /* synthetic */ BasicDatabase[] $databases;
                final /* synthetic */ BaseMultiDatabaseIntrospector<MR, D, S> this$0;
                {
                    this.$databases = $databases;
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull DBTransaction it2) {
                    Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                    for (BasicDatabase database : this.$databases) {
                        this.this$0.retrieveSchemasOfDatabase(it2, database);
                    }
                }
            }));
        } else {
            BasicModMateDatabase basicModMateDatabase = (BasicModMateDatabase)((BasicModMultiDatabaseRoot)this.getRoot()).getCurrentDatabase();
            if (basicModMateDatabase == null) {
                return;
            }
            BasicModMateDatabase currentDatabase = basicModMateDatabase;
            this.trace("Introspecting database schemas for the current database " + currentDatabase.getDisplayName());
            this.inTransactionUnit((Function1<DBTransaction, Unit>)((Function1)new Function1<DBTransaction, Unit>(this, currentDatabase){
                final /* synthetic */ BaseMultiDatabaseIntrospector<MR, D, S> this$0;
                final /* synthetic */ BasicModMateDatabase $currentDatabase;
                {
                    this.this$0 = $receiver;
                    this.$currentDatabase = $currentDatabase;
                    super(1);
                }

                public final void invoke(@NotNull DBTransaction it2) {
                    Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                    this.this$0.retrieveSchemasOfDatabase(it2, this.$currentDatabase);
                }
            }));
        }
    }

    @Override
    protected void retrieveSchemasOfDatabase(@NotNull DBTransaction transaction, @NotNull BasicDatabase database) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        boolean bl = this.getModel().contains(database);
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string = "Alien database.";
            throw new AssertionError((Object)string);
        }
        BaseDatabaseRetriever<BasicModMateDatabase> databaseRetriever = this.createDatabaseRetriever(transaction, (BasicModMateDatabase)database);
        databaseRetriever.retrieveSchemas();
    }

    @Override
    protected void introspectAutoInTran(@NotNull DBTransaction tran, @Nullable Collection<? extends BasicNamespace> namespaces2) {
        JBIterable jBIterable;
        block8: {
            block7: {
                Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
                this.introspectPreDatabaseObjects(tran);
                if (namespaces2 == null) break block7;
                Iterable<? extends BasicMateDatabase> iterable = ((BasicModMultiDatabaseRoot)this.getRoot()).getNamespaces();
                Intrinsics.checkNotNullExpressionValue(iterable, (String)"getNamespaces(...)");
                if (!IntrospectionTaskHelperFun.isEmpty(iterable)) break block8;
            }
            this.listAndApplyDatabasesIfNotYet(tran);
        }
        List databasesToIntrospect = CollectionsKt.toList(this.getDatabasesToIntrospect(tran, namespaces2));
        BaseIntrospector this_$iv = this;
        boolean $i$f$trace = false;
        BaseIntrospector this_$iv$iv = this_$iv;
        boolean $i$f$getTracing = false;
        Logger logger2 = BaseIntrospector.access$getDbLogger(this_$iv$iv);
        Level level$iv$iv = logger2 != null ? BaseIntrospector.Companion.access$getEffectiveLevel(BaseIntrospector.Companion, logger2) : null;
        if (level$iv$iv != null && level$iv$iv.intValue() <= BaseIntrospector.access$getTRACE_LEVEL_VALUE$cp()) {
            BaseIntrospector baseIntrospector = this_$iv;
            boolean bl = false;
            BaseIntrospector.access$trace(baseIntrospector, "IntrospectAutoInTran: getting the following " + databasesToIntrospect.size() + " databases:" + CollectionsKt.joinToString$default((Iterable)databasesToIntrospect, null, null, null, (int)0, null, (Function1)introspectAutoInTran.1.1.INSTANCE, (int)31, null));
        }
        this.introspectDatabases(tran, databasesToIntrospect);
        if (namespaces2 != null && !namespaces2.isEmpty()) {
            $i$f$trace = JBIterable.from((Iterable)namespaces2).flatMap(arg_0 -> BaseMultiDatabaseIntrospector.introspectAutoInTran$lambda$9((Function1)new Function1<BasicNamespace, Iterable<? extends BasicSchema>>(this){
                final /* synthetic */ BaseMultiDatabaseIntrospector<MR, D, S> this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final Iterable<BasicSchema> invoke(BasicNamespace ns) {
                    JBIterable jBIterable;
                    BasicNamespace basicNamespace = ns;
                    if (basicNamespace instanceof BasicModMateDatabase) {
                        Intrinsics.checkNotNull((Object)ns);
                        JBIterable jBIterable2 = UtilKt.asJBIterable((Iterable)BaseMultiDatabaseIntrospector.access$getSchemasToIntrospect(this.this$0, (BasicModMateDatabase)ns)).filter(arg_0 -> introspectAutoInTran.schemasToIntrospect.1.invoke$lambda$0((Function1)new Function1<BasicNamespace, Boolean>(this.this$0){

                            @NotNull
                            public final Boolean invoke(@NotNull BasicNamespace p0) {
                                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                                return ((BaseMultiDatabaseIntrospector)this.receiver).inIntrospectionScope(p0);
                            }
                        }, arg_0));
                        jBIterable = jBIterable2;
                        Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"filter(...)");
                    } else if (basicNamespace instanceof BasicModSchema) {
                        Intrinsics.checkNotNull((Object)ns);
                        jBIterable = BaseIntrospectionFunctions.asSingleOrEmptyJBIterable(BaseMultiDatabaseIntrospector.access$adjustSchemaInstance(this.this$0, (BasicSchema)ns));
                    } else {
                        JBIterable jBIterable3 = JBIterable.empty();
                        jBIterable = jBIterable3;
                        Intrinsics.checkNotNullExpressionValue((Object)jBIterable3, (String)"empty(...)");
                    }
                    return (Iterable)jBIterable;
                }

                private static final boolean invoke$lambda$0(Function1 $tmp0, Object p0) {
                    Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                    return (Boolean)$tmp0.invoke(p0);
                }
            }, arg_0));
            Intrinsics.checkNotNull((Object)$i$f$trace);
            jBIterable = $i$f$trace;
        } else {
            $i$f$trace = JBIterable.from((Iterable)databasesToIntrospect).flatMap(arg_0 -> BaseMultiDatabaseIntrospector.introspectAutoInTran$lambda$10((Function1)new Function1<D, Iterable<? extends BasicSchema>>(this){
                final /* synthetic */ BaseMultiDatabaseIntrospector<MR, D, S> this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final Iterable<BasicSchema> invoke(D it2) {
                    Intrinsics.checkNotNull(it2);
                    return BaseMultiDatabaseIntrospector.access$getSchemasToIntrospect(this.this$0, it2);
                }
            }, arg_0)).filter(arg_0 -> BaseMultiDatabaseIntrospector.introspectAutoInTran$lambda$11((Function1)new Function1<BasicNamespace, Boolean>((Object)this){

                @NotNull
                public final Boolean invoke(@NotNull BasicNamespace p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((BaseMultiDatabaseIntrospector)this.receiver).inIntrospectionScope(p0);
                }
            }, arg_0));
            Intrinsics.checkNotNull((Object)$i$f$trace);
            jBIterable = $i$f$trace;
        }
        JBIterable schemasToIntrospect2 = jBIterable;
        List list = schemasToIntrospect2.filterMap(arg_0 -> BaseMultiDatabaseIntrospector.introspectAutoInTran$lambda$12(introspectAutoInTran.schemasWillBeIntrospected.1.INSTANCE, arg_0)).toList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"toList(...)");
        List schemasWillBeIntrospected2 = list;
        this.introspectSchemas(tran, schemasWillBeIntrospected2);
        for (BasicModMateDatabase d2 : databasesToIntrospect) {
            this.postProcessDatabase(tran, d2);
        }
    }

    private final BasicSchema adjustSchemaInstance(BasicSchema $this$adjustSchemaInstance) {
        if ($this$adjustSchemaInstance instanceof BasicModSchema && ((BasicModSchema)$this$adjustSchemaInstance).isDropped()) {
            Object e2;
            BasicDatabase basicDatabase = ((BasicModSchema)$this$adjustSchemaInstance).getDatabase();
            if (basicDatabase == null || (basicDatabase = this.adjustDatabaseInstance(basicDatabase)) == null) {
                return null;
            }
            BasicDatabase database = basicDatabase;
            BasicSchema replacement = null;
            Family<? extends BasicElement> schemas2 = database.familyOf(((BasicModSchema)$this$adjustSchemaInstance).getKind());
            if ($this$adjustSchemaInstance instanceof BasicIdentifiedElement && ((BasicIdentifiedElement)((Object)$this$adjustSchemaInstance)).getObjectId() != Long.MIN_VALUE && schemas2 instanceof IdentifyingFamily) {
                e2 = ((IdentifyingFamily)schemas2).getByObjectId(((BasicIdentifiedElement)((Object)$this$adjustSchemaInstance)).getObjectId());
                BasicSchema basicSchema = replacement = e2 instanceof BasicSchema ? (BasicSchema)e2 : null;
            }
            if (replacement == null && schemas2 instanceof NamingFamily) {
                e2 = ((NamingFamily)schemas2).get(((BasicModSchema)$this$adjustSchemaInstance).getName());
                replacement = e2 instanceof BasicSchema ? (BasicSchema)e2 : null;
            }
            return replacement;
        }
        return $this$adjustSchemaInstance;
    }

    private final BasicDatabase adjustDatabaseInstance(BasicDatabase $this$adjustDatabaseInstance) {
        if ($this$adjustDatabaseInstance instanceof BasicModDatabase && ((BasicModDatabase)$this$adjustDatabaseInstance).isDropped()) {
            Object e2;
            BasicDatabase replacement = null;
            ModFamily databases2 = (ModFamily)((BasicModMultiDatabaseRoot)this.getRoot()).familyOf(((BasicModDatabase)$this$adjustDatabaseInstance).getKind());
            if ($this$adjustDatabaseInstance instanceof BasicIdentifiedElement && ((BasicIdentifiedElement)((Object)$this$adjustDatabaseInstance)).getObjectId() != Long.MIN_VALUE && databases2 instanceof IdentifyingFamily) {
                e2 = ((IdentifyingFamily)((Object)databases2)).getByObjectId(((BasicIdentifiedElement)((Object)$this$adjustDatabaseInstance)).getObjectId());
                BasicDatabase basicDatabase = replacement = e2 instanceof BasicDatabase ? (BasicDatabase)e2 : null;
            }
            if (replacement == null && databases2 instanceof NamingFamily) {
                e2 = ((NamingFamily)((Object)databases2)).get(((BasicModDatabase)$this$adjustDatabaseInstance).getName());
                replacement = e2 instanceof BasicDatabase ? (BasicDatabase)e2 : null;
            }
            return replacement;
        }
        return $this$adjustDatabaseInstance;
    }

    protected void introspectPreDatabaseObjects(@NotNull DBTransaction tran) {
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
    }

    @NotNull
    protected Iterable<D> getDatabasesToIntrospect(@NotNull DBTransaction tran, @Nullable Collection<? extends BasicNamespace> namespaces2) {
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
        if (namespaces2 != null && !namespaces2.isEmpty()) {
            JBIterable jBIterable = JBIterable.from((Iterable)namespaces2).filterMap(arg_0 -> BaseMultiDatabaseIntrospector.getDatabasesToIntrospect$lambda$13(getDatabasesToIntrospect.1.INSTANCE, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filterMap(...)");
            return (Iterable)jBIterable;
        }
        this.introspectNamespacesInTran(tran);
        JBIterable jBIterable = UtilKt.asJBIterable(((BasicModMultiDatabaseRoot)this.getRoot()).getNamespaces()).filter(arg_0 -> BaseMultiDatabaseIntrospector.getDatabasesToIntrospect$lambda$14((Function1)new Function1<BasicNamespace, Boolean>((Object)this){

            @NotNull
            public final Boolean invoke(@NotNull BasicNamespace p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((BaseMultiDatabaseIntrospector)this.receiver).inIntrospectionScope(p0);
            }
        }, arg_0)).map(arg_0 -> BaseMultiDatabaseIntrospector.getDatabasesToIntrospect$lambda$15(getDatabasesToIntrospect.3.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"map(...)");
        return (Iterable)jBIterable;
    }

    private final List<BasicSchema> getSchemasToIntrospect(BasicModMateDatabase database) {
        Iterable<? extends BasicMateNamespace> iterable = database.getNamespaces();
        Intrinsics.checkNotNullExpressionValue(iterable, (String)"getNamespaces(...)");
        return CollectionsKt.toList(iterable);
    }

    private final void introspectDatabases(DBTransaction tran, Iterable<? extends BasicDatabase> databasesToIntrospect) {
        for (BasicDatabase basicDatabase : databasesToIntrospect) {
            this.handleErrors("Introspect database " + basicDatabase.getName(), (Function0<Unit>)((Function0)new Function0<Unit>(basicDatabase, this, tran){
                final /* synthetic */ BasicDatabase $database;
                final /* synthetic */ BaseMultiDatabaseIntrospector<MR, D, S> this$0;
                final /* synthetic */ DBTransaction $tran;
                {
                    this.$database = $database;
                    this.this$0 = $receiver;
                    this.$tran = $tran;
                    super(0);
                }

                public final void invoke() {
                    BasicDatabase basicDatabase = this.$database;
                    Intrinsics.checkNotNull((Object)basicDatabase, (String)"null cannot be cast to non-null type D of com.intellij.database.dialects.base.introspector.BaseMultiDatabaseIntrospector");
                    BasicModMateDatabase db2 = (BasicModMateDatabase)basicDatabase;
                    BaseDatabaseRetriever<BasicModMateDatabase> databaseRetriever = this.this$0.createDatabaseRetriever(this.$tran, db2);
                    databaseRetriever.process();
                }
            }));
        }
    }

    private final void introspectSchemas(DBTransaction tran, Collection<? extends BasicSchema> schemasToIntrospect2) {
        ArrayList retrievers = new ArrayList(schemasToIntrospect2.size());
        for (BasicSchema basicSchema : schemasToIntrospect2) {
            BasicDatabase basicDatabase = basicSchema.getDatabase();
            this.handleErrors("Initialize retriever for database " + (basicDatabase != null ? basicDatabase.getName() : null) + " schema " + basicSchema.getName(), (Function0<Unit>)((Function0)new Function0<Unit>(basicSchema, this, tran, retrievers){
                final /* synthetic */ BasicSchema $schema;
                final /* synthetic */ BaseMultiDatabaseIntrospector<MR, D, S> this$0;
                final /* synthetic */ DBTransaction $tran;
                final /* synthetic */ ArrayList<BaseNativeIntrospector.AbstractSchemaRetriever<?>> $retrievers;
                {
                    this.$schema = $schema;
                    this.this$0 = $receiver;
                    this.$tran = $tran;
                    this.$retrievers = $retrievers;
                    super(0);
                }

                public final void invoke() {
                    BasicSchema basicSchema = this.$schema;
                    Intrinsics.checkNotNull((Object)basicSchema, (String)"null cannot be cast to non-null type S of com.intellij.database.dialects.base.introspector.BaseMultiDatabaseIntrospector");
                    BasicModSchema s2 = (BasicModSchema)basicSchema;
                    BaseNativeIntrospector.AbstractSchemaRetriever<BasicModSchema> retriever = this.this$0.createSchemaRetriever(this.$tran, s2);
                    this.$retrievers.add(retriever);
                }
            }));
        }
        for (BaseNativeIntrospector.AbstractSchemaRetriever abstractSchemaRetriever : retrievers) {
            BasicDatabase basicDatabase = abstractSchemaRetriever.getSchema().getDatabase();
            this.handleErrors("Introspect database " + (basicDatabase != null ? basicDatabase.getName() : null) + " schema " + abstractSchemaRetriever.getSchema().getName() + " (names)", (Function0<Unit>)((Function0)new Function0<Unit>(abstractSchemaRetriever){
                final /* synthetic */ BaseNativeIntrospector.AbstractSchemaRetriever<?> $retriever;
                {
                    this.$retriever = $retriever;
                    super(0);
                }

                public final void invoke() {
                    this.$retriever.prepareParameters();
                    this.$retriever.processPreliminaryPhase();
                }
            }));
        }
        for (BaseNativeIntrospector.AbstractSchemaRetriever abstractSchemaRetriever : retrievers) {
            BasicDatabase basicDatabase = abstractSchemaRetriever.getSchema().getDatabase();
            this.handleErrors("Introspect database " + (basicDatabase != null ? basicDatabase.getName() : null) + " schema " + abstractSchemaRetriever.getSchema().getName() + " (details)", (Function0<Unit>)((Function0)new Function0<Unit>(abstractSchemaRetriever){
                final /* synthetic */ BaseNativeIntrospector.AbstractSchemaRetriever<?> $retriever;
                {
                    this.$retriever = $retriever;
                    super(0);
                }

                public final void invoke() {
                    this.$retriever.processMainPhase();
                }
            }));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void introspectFragments(DBTransaction tran, Collection<? extends BasicMajorObject> fragmentToIntrospect) {
        void $this$groupByTo$iv$iv;
        void $this$groupBy$iv;
        Sequence sequence = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)fragmentToIntrospect), (Function1)introspectFragments.schemaFragments.1.INSTANCE);
        boolean bl = false;
        void var6_6 = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            BasicSchema key$iv$iv;
            BasicMajorObject it2 = (BasicMajorObject)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it2.getSchema());
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl22 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map schemaFragments2 = destination$iv$iv;
        for (Map.Entry entry : schemaFragments2.entrySet()) {
            BasicSchema schema2 = (BasicSchema)entry.getKey();
            List fragments2 = (List)entry.getValue();
            BasicDatabase basicDatabase = schema2.getDatabase();
            this.handleErrors("Introspect database " + (basicDatabase != null ? basicDatabase.getName() : null) + " schema " + schema2.getName() + " (" + fragments2.size() + " fragments)", (Function0<Unit>)((Function0)new Function0<Unit>(schema2, this, tran, (List<? extends BasicMajorObject>)fragments2){
                final /* synthetic */ BasicSchema $schema;
                final /* synthetic */ BaseMultiDatabaseIntrospector<MR, D, S> this$0;
                final /* synthetic */ DBTransaction $tran;
                final /* synthetic */ List<BasicMajorObject> $fragments;
                {
                    this.$schema = $schema;
                    this.this$0 = $receiver;
                    this.$tran = $tran;
                    this.$fragments = $fragments;
                    super(0);
                }

                public final void invoke() {
                    BasicSchema basicSchema = this.$schema;
                    Intrinsics.checkNotNull((Object)basicSchema, (String)"null cannot be cast to non-null type S of com.intellij.database.dialects.base.introspector.BaseMultiDatabaseIntrospector");
                    BasicModSchema s2 = (BasicModSchema)basicSchema;
                    BaseNativeIntrospector.AbstractSchemaRetriever<BasicModSchema> retriever = this.this$0.createSchemaRetriever(this.$tran, s2);
                    retriever.setMode(IntrospectionMode.FRAGMENT);
                    retriever.retrieveSpecificFragments((Collection<BasicMajorObject>)this.$fragments);
                }
            }));
        }
    }

    @Override
    @NotNull
    protected BaseNativeIntrospector.AbstractNativeRetriever<D> createNativeRetriever(@NotNull DBTransaction transaction, @NotNull D database) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter(database, (String)"database");
        return new BaseNativeIntrospector.AbstractNativeRetriever<D>(this, transaction, database){};
    }

    @Override
    @NotNull
    protected abstract BaseDatabaseRetriever<? extends D> createDatabaseRetriever(@NotNull DBTransaction var1, @NotNull D var2);

    @Override
    @NotNull
    protected abstract BaseNativeIntrospector.AbstractSchemaRetriever<? extends S> createSchemaRetriever(@NotNull DBTransaction var1, @NotNull S var2);

    protected void postProcessDatabase(@NotNull DBTransaction tran, @NotNull D database) {
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
        Intrinsics.checkNotNullParameter(database, (String)"database");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void introspectNativeDefinitions(@NotNull Iterable<? extends BasicElement> elements2, boolean withNestedElements, @NotNull Map<BasicElement, String[]> result2) {
        void $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter(elements2, (String)"elements");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        JBIterable jBIterable = JBIterable.from(elements2);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"from(...)");
        Iterable $this$groupBy$iv = (Iterable)jBIterable;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            BasicElement it2 = (BasicElement)element$iv$iv;
            boolean bl = false;
            BasicDatabase key$iv$iv = it2.getDatabase();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map groups2 = destination$iv$iv;
        for (Map.Entry entry : groups2.entrySet()) {
            BasicDatabase db2 = (BasicDatabase)entry.getKey();
            List dbElements = (List)entry.getValue();
            if (db2 == null) continue;
            if (!this.getModel().contains(db2)) {
                throw new IllegalArgumentException("The database " + db2 + " is from another model");
            }
            BasicModMateDatabase database = (BasicModMateDatabase)db2;
            this.inTransactionUnit((Function1<DBTransaction, Unit>)((Function1)new Function1<DBTransaction, Unit>(this, database, (List<? extends BasicElement>)dbElements, withNestedElements, result2){
                final /* synthetic */ BaseMultiDatabaseIntrospector<MR, D, S> this$0;
                final /* synthetic */ D $database;
                final /* synthetic */ List<BasicElement> $dbElements;
                final /* synthetic */ boolean $withNestedElements;
                final /* synthetic */ Map<BasicElement, String[]> $result;
                {
                    this.this$0 = $receiver;
                    this.$database = $database;
                    this.$dbElements = $dbElements;
                    this.$withNestedElements = $withNestedElements;
                    this.$result = $result;
                    super(1);
                }

                public final void invoke(@NotNull DBTransaction transaction) {
                    Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
                    BaseNativeIntrospector.AbstractNativeRetriever<D> retriever = this.this$0.createNativeRetriever(transaction, this.$database);
                    retriever.retrieveNativeDefinitions((Iterable<BasicElement>)this.$dbElements, this.$withNestedElements, this.$result);
                }
            }));
        }
    }

    private static final Iterable introspectAutoInTran$lambda$9(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Iterable)$tmp0.invoke(p0);
    }

    private static final Iterable introspectAutoInTran$lambda$10(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Iterable)$tmp0.invoke(p0);
    }

    private static final boolean introspectAutoInTran$lambda$11(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final BasicModSchema introspectAutoInTran$lambda$12(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (BasicModSchema)$tmp0.invoke(p0);
    }

    private static final BasicModMateDatabase getDatabasesToIntrospect$lambda$13(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (BasicModMateDatabase)$tmp0.invoke(p0);
    }

    private static final boolean getDatabasesToIntrospect$lambda$14(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final BasicModMateDatabase getDatabasesToIntrospect$lambda$15(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (BasicModMateDatabase)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ List access$getSchemasToIntrospect(BaseMultiDatabaseIntrospector $this, BasicModMateDatabase database) {
        return $this.getSchemasToIntrospect(database);
    }

    public static final /* synthetic */ BasicSchema access$adjustSchemaInstance(BaseMultiDatabaseIntrospector $this, BasicSchema $receiver) {
        return $this.adjustSchemaInstance($receiver);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u00a4\u0004\u0018\u0000*\b\b\u0003\u0010\u0001*\u00020\u00022\u001e\u0012\u0004\u0012\u0002H\u00010\u0003R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0004B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00028\u0003\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0014J\b\u0010\u000b\u001a\u00020\nH\u0014J\b\u0010\f\u001a\u00020\nH\u0016J\b\u0010\r\u001a\u00020\nH\u0016J\b\u0010\u000e\u001a\u00020\nH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector$BaseDatabaseRetriever;", "D", "Lcom/intellij/database/model/basic/BasicModMateDatabase;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractDatabaseRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "database", "(Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/model/basic/BasicModMateDatabase;)V", "beforeSchemasRetrieval", "", "beforeServerAndDatabaseObjectsRetrieval", "process", "retrieveSchemas", "retrieveServerAndDatabaseObjects", "intellij.database.dialects.base"})
    protected static abstract class BaseDatabaseRetriever<D extends BasicModMateDatabase>
    extends BaseNativeIntrospector.AbstractDatabaseRetriever<D> {
        final /* synthetic */ BaseMultiDatabaseIntrospector<MR, D, S> this$0;

        public BaseDatabaseRetriever(@NotNull DBTransaction transaction, D database) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Intrinsics.checkNotNullParameter(database, (String)"database");
            this.this$0 = this$0;
            super((BaseNativeIntrospector)this$0, transaction, (BasicModDatabase)database);
        }

        @Override
        public void process() {
            String isCurrentStr = ((BasicModMateDatabase)this.getDatabase()).isCurrent() ? "(current) " : "";
            String string = ((BasicModMateDatabase)this.getDatabase()).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String databaseName = string;
            String introspectionLogMessage = StringFun.centerAndPadAsTitle("INTROSPECTING DATABASE " + databaseName + " " + isCurrentStr, 140, '=');
            Object[] objectArray = new Object[]{databaseName};
            this.this$0.reportIntrospecting(introspectionLogMessage, "introspection.report.database.plain", objectArray);
            this.retrieveSchemas();
            this.retrieveServerAndDatabaseObjects();
        }

        @Override
        public void retrieveSchemas() {
            this.beforeSchemasRetrieval();
        }

        @Override
        public void retrieveServerAndDatabaseObjects() {
            this.beforeServerAndDatabaseObjectsRetrieval();
        }

        protected void beforeServerAndDatabaseObjectsRetrieval() {
        }

        protected void beforeSchemasRetrieval() {
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00a4\u0004\u0018\u0000*\b\b\u0003\u0010\u0001*\u00020\u00022\u001e\u0012\u0004\u0012\u0002H\u00010\u0003R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0004B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00028\u0003\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector$BaseNativeRetriever;", "D", "Lcom/intellij/database/model/basic/BasicModMateDatabase;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractNativeRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "database", "(Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/model/basic/BasicModMateDatabase;)V", "intellij.database.dialects.base"})
    protected static abstract class BaseNativeRetriever<D extends BasicModMateDatabase>
    extends BaseNativeIntrospector.AbstractNativeRetriever<D> {
        final /* synthetic */ BaseMultiDatabaseIntrospector<MR, D, S> this$0;

        public BaseNativeRetriever(@NotNull DBTransaction transaction, D database) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Intrinsics.checkNotNullParameter(database, (String)"database");
            this.this$0 = this$0;
            super((BaseNativeIntrospector)this$0, transaction, (BasicModDatabase)database);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00a4\u0004\u0018\u0000*\u0004\b\u0003\u0010\u0001*\b\b\u0004\u0010\u0002*\u00020\u00032\u00020\u0004B\u0005\u00a2\u0006\u0002\u0010\u0005J!\u0010\u0006\u001a\u00028\u00042\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\t\u001a\u00028\u0003H$\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00030\u000eH\u0002J\u001d\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00028\u0003H\u0014\u00a2\u0006\u0002\u0010\u0013J\u0015\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b\u0017J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00030\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H$J\b\u0010\u0019\u001a\u00020\fH\u0014J+\u0010\u001a\u001a\u00028\u00042\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0004\u00a2\u0006\u0002\u0010\u001fJ#\u0010\u001a\u001a\u00028\u00042\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0004\u00a2\u0006\u0002\u0010 J\u0010\u0010!\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\u0014\u0010\"\u001a\u00020\u00102\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030#H\u0014J\u0016\u0010$\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00030\u000eH\u0014J\u0012\u0010%\u001a\u00028\u0004*\u00020&H\u0082\b\u00a2\u0006\u0002\u0010'\u00a8\u0006("}, d2={"Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector$DatabaseLister;", "T", "MD", "Lcom/intellij/database/model/basic/BasicModMateDatabase;", "", "(Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector;)V", "applyDatabase", "databases", "Lcom/intellij/database/model/families/ModNamingFamily;", "db", "(Lcom/intellij/database/model/families/ModNamingFamily;Ljava/lang/Object;)Lcom/intellij/database/model/basic/BasicModMateDatabase;", "applyDatabases", "", "dbs", "", "isCurrent", "", "idx", "", "(ILjava/lang/Object;)Z", "listAndApplyDatabases", "tran", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "listAndApplyDatabases$intellij_database_dialects_base", "listDatabases", "prepareParameters", "renew", "id", "", "name", "", "(Lcom/intellij/database/model/families/ModNamingFamily;JLjava/lang/String;)Lcom/intellij/database/model/basic/BasicModMateDatabase;", "(Lcom/intellij/database/model/families/ModNamingFamily;Ljava/lang/String;)Lcom/intellij/database/model/basic/BasicModMateDatabase;", "retrieveExternalDatabases", "shouldUpdateCurrent", "", "traceDatabases", "asMD", "Lcom/intellij/database/model/basic/BasicModNamedElement;", "(Lcom/intellij/database/model/basic/BasicModNamedElement;)Lcom/intellij/database/model/basic/BasicModMateDatabase;", "intellij.database.dialects.base"})
    @SourceDebugExtension(value={"SMAP\nBaseMultiDatabaseIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseMultiDatabaseIntrospector.kt\ncom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector$DatabaseLister\n*L\n1#1,626:1\n375#1:627\n375#1:628\n*S KotlinDebug\n*F\n+ 1 BaseMultiDatabaseIntrospector.kt\ncom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector$DatabaseLister\n*L\n370#1:627\n372#1:628\n*E\n"})
    protected abstract class DatabaseLister<T, MD extends BasicModMateDatabase> {
        public final void listAndApplyDatabases$intellij_database_dialects_base(@NotNull DBTransaction tran) {
            Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
            this.prepareParameters();
            List<T> dbs2 = this.listDatabases(tran);
            this.traceDatabases(dbs2);
            this.applyDatabases(dbs2);
            this.retrieveExternalDatabases(tran);
        }

        protected void prepareParameters() {
        }

        @NotNull
        protected abstract List<T> listDatabases(@NotNull DBTransaction var1);

        protected void traceDatabases(@NotNull List<? extends T> dbs2) {
            Intrinsics.checkNotNullParameter(dbs2, (String)"dbs");
            BaseMultiDatabaseIntrospector.this.trace("Listed " + dbs2.size() + " databases");
        }

        private final void applyDatabases(List<? extends T> dbs2) {
            BaseMultiDatabaseIntrospector.this.inModel((Function1)new Function1<MR, Unit>(this, dbs2){
                final /* synthetic */ DatabaseLister<T, MD> this$0;
                final /* synthetic */ List<T> $dbs;
                {
                    this.this$0 = $receiver;
                    this.$dbs = $dbs;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull MR root2) {
                    void $this$modifyAndCleanup_u24default$iv;
                    Intrinsics.checkNotNullParameter(root2, (String)"root");
                    NamingFamily namingFamily = root2.getDatabases();
                    Intrinsics.checkNotNullExpressionValue((Object)namingFamily, (String)"getDatabases(...)");
                    NamingFamily databases2 = namingFamily;
                    boolean updateCurrent = this.this$0.shouldUpdateCurrent(databases2);
                    ModFamily modFamily = (ModFamily)((Object)databases2);
                    List<T> list = this.$dbs;
                    DatabaseLister<void, MD> databaseLister = this.this$0;
                    boolean inc$iv = true;
                    boolean $i$f$modifyAndCleanup = false;
                    $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
                    ModNamingFamily it2 = (ModNamingFamily)$this$modifyAndCleanup_u24default$iv;
                    boolean bl = false;
                    Iterable $this$forEachIndexed$iv = list;
                    boolean $i$f$forEachIndexed = false;
                    int index$iv = 0;
                    for (T item$iv : $this$forEachIndexed$iv) {
                        void db2;
                        int n;
                        if ((n = index$iv++) < 0) {
                            CollectionsKt.throwIndexOverflow();
                        }
                        T t = item$iv;
                        int idx = n;
                        boolean bl2 = false;
                        MD database = databaseLister.applyDatabase(it2, db2);
                        boolean current = databaseLister.isCurrent(idx, db2);
                        if (!updateCurrent) continue;
                        database.setCurrent(current);
                    }
                    $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
                    $this$modifyAndCleanup_u24default$iv.sort();
                }
            });
        }

        protected boolean shouldUpdateCurrent(@NotNull Iterable<?> databases2) {
            Intrinsics.checkNotNullParameter(databases2, (String)"databases");
            return true;
        }

        protected boolean isCurrent(int idx, T db2) {
            return idx == 0;
        }

        @NotNull
        protected abstract MD applyDatabase(@NotNull ModNamingFamily<?> var1, T var2);

        /*
         * WARNING - void declaration
         */
        @NotNull
        protected final MD renew(@NotNull ModNamingFamily<?> databases2, long id, @Nullable String name2) {
            void $this$asMD$iv;
            Intrinsics.checkNotNullParameter(databases2, (String)"databases");
            DatabaseLister databaseLister = this;
            Object e2 = ((ModNamingIdentifyingFamily)databases2).renew(id, name2);
            Intrinsics.checkNotNullExpressionValue(e2, (String)"renew(...)");
            Object e3 = e2;
            boolean $i$f$asMD = false;
            return (MD)((BasicModMateDatabase)$this$asMD$iv);
        }

        @NotNull
        protected final MD renew(@NotNull ModNamingFamily<?> databases2, @Nullable String name2) {
            Intrinsics.checkNotNullParameter(databases2, (String)"databases");
            DatabaseLister databaseLister = this;
            String string = name2;
            if (string == null) {
                string = "";
            }
            Object obj2 = databases2.createOrGet(string);
            Intrinsics.checkNotNullExpressionValue(obj2, (String)"createOrGet(...)");
            Object $this$asMD$iv = obj2;
            boolean $i$f$asMD = false;
            return (MD)((BasicModMateDatabase)$this$asMD$iv);
        }

        private final MD asMD(BasicModNamedElement $this$asMD) {
            boolean $i$f$asMD = false;
            Intrinsics.checkNotNull((Object)$this$asMD, (String)"null cannot be cast to non-null type MD of com.intellij.database.dialects.base.introspector.BaseMultiDatabaseIntrospector.DatabaseLister");
            return (MD)((BasicModMateDatabase)$this$asMD);
        }

        protected void retrieveExternalDatabases(@NotNull DBTransaction tran) {
            Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
        }
    }
}

