/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.introspector;

import com.intellij.database.dialects.base.introspector.AffectedObjectAnalyzer;
import com.intellij.database.dialects.base.introspector.BaseAffectedObjectAnalyzer;
import com.intellij.database.introspection.AffectedObjectMention;
import com.intellij.database.introspection.AffectedObjectScriptedMention;
import com.intellij.database.introspection.BelongingAreaKind;
import com.intellij.database.introspection.ObjectAffectionType;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicAuxiliaryDetail;
import com.intellij.database.model.basic.BasicAuxiliaryObject;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicMajorObject;
import com.intellij.database.model.basic.BasicMateDatabase;
import com.intellij.database.model.basic.BasicMinorObject;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicMultiDatabaseRoot;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicSchemaObject;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.model.meta.BasicMetaFunKt;
import com.intellij.database.model.meta.BasicMetaModel;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.util.Casing;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\b\u0016\u0018\u00002\u00020\u0001:\u000278B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J4\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\t2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\"H\u0014J\u0012\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020&H\u0016J\u001c\u0010#\u001a\b\u0012\u0004\u0012\u00020$0'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020&0'H\u0016J4\u0010)\u001a\u0004\u0018\u00010 2\u0006\u0010*\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\t2\b\u0010+\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\"H\u0014J\u001a\u0010,\u001a\u0004\u0018\u00010 2\u0006\u0010*\u001a\u00020\u001b2\u0006\u0010-\u001a\u00020\tH\u0004J\u0013\u0010.\u001a\u0004\u0018\u00010/2\u0006\u00100\u001a\u00020/H\u0082\u0010J\u0018\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\t2\u0006\u00104\u001a\u00020\tH\u0004J\u0010\u00105\u001a\u00020\u001b2\u0006\u00106\u001a\u00020&H\u0014R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000bR\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000b\u00a8\u00069\u00b2\u0006\u0010\u0010:\u001a\b\u0012\u0004\u0012\u00020<0;X\u008a\u0084\u0002"}, d2={"Lcom/intellij/database/dialects/base/introspector/BaseAffectedObjectAnalyzer;", "Lcom/intellij/database/dialects/base/introspector/AffectedObjectAnalyzer;", "model", "Lcom/intellij/database/model/basic/BasicModel;", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "(Lcom/intellij/database/model/basic/BasicModel;Lcom/intellij/openapi/diagnostic/Logger;)V", "databaseAuxiliaryDetailKinds", "", "Lcom/intellij/database/model/ObjectKind;", "getDatabaseAuxiliaryDetailKinds", "()Ljava/util/Set;", "getLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "getModel", "()Lcom/intellij/database/model/basic/BasicModel;", "root", "Lcom/intellij/database/model/basic/BasicRoot;", "getRoot", "()Lcom/intellij/database/model/basic/BasicRoot;", "schemaMinor", "getSchemaMinor", "serverAuxiliaryDetailKinds", "getServerAuxiliaryDetailKinds", "adjustObject", "Lcom/intellij/database/dialects/base/introspector/BaseAffectedObjectAnalyzer$ObjectAdjustment;", "namespaces", "Lcom/intellij/database/dialects/base/introspector/BaseAffectedObjectAnalyzer$Namespaces;", "objectName", "", "objectKind", "affectionAreaKind", "Lcom/intellij/database/introspection/BelongingAreaKind;", "affectionType", "Lcom/intellij/database/introspection/ObjectAffectionType;", "analyze", "Lcom/intellij/database/introspection/AffectedObjectMention;", "scriptedMention", "Lcom/intellij/database/introspection/AffectedObjectScriptedMention;", "", "scriptedMentions", "determineAffectionArea", "ns", "givenArea", "determineAreaOfKind", "theKind", "getEnclosingFragmentObject", "Lcom/intellij/database/model/basic/BasicElement;", "element", "parentCanHaveChild", "", "parentKind", "childKind", "resolveNamespaces", "sm", "Namespaces", "ObjectAdjustment", "intellij.database.dialects.base", "indexedObjects", "Lcom/intellij/util/containers/JBIterable;", "Lcom/intellij/database/model/DasObject;"})
public class BaseAffectedObjectAnalyzer
implements AffectedObjectAnalyzer {
    @NotNull
    private final BasicModel model;
    @Nullable
    private final Logger log;
    @NotNull
    private final BasicRoot root;
    @NotNull
    private final Set<ObjectKind> schemaMinor;
    @NotNull
    private final Set<ObjectKind> databaseAuxiliaryDetailKinds;
    @NotNull
    private final Set<ObjectKind> serverAuxiliaryDetailKinds;

    public BaseAffectedObjectAnalyzer(@NotNull BasicModel model2, @Nullable Logger log) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        this.model = model2;
        this.log = log;
        BasicRoot basicRoot = this.model.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)basicRoot, (String)"getRoot(...)");
        this.root = basicRoot;
        Object[] objectArray = new ObjectKind[]{ObjectKind.COLUMN, ObjectKind.KEY, ObjectKind.FOREIGN_KEY, ObjectKind.CHECK, ObjectKind.RULE, ObjectKind.TRIGGER};
        this.schemaMinor = SetsKt.setOf((Object[])objectArray);
        this.databaseAuxiliaryDetailKinds = SetsKt.emptySet();
        this.serverAuxiliaryDetailKinds = SetsKt.emptySet();
    }

    public /* synthetic */ BaseAffectedObjectAnalyzer(BasicModel basicModel, Logger logger2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            logger2 = null;
        }
        this(basicModel, logger2);
    }

    @NotNull
    public final BasicModel getModel() {
        return this.model;
    }

    @Nullable
    public final Logger getLog() {
        return this.log;
    }

    @NotNull
    protected final BasicRoot getRoot() {
        return this.root;
    }

    @NotNull
    protected Set<ObjectKind> getSchemaMinor() {
        return this.schemaMinor;
    }

    @NotNull
    protected Set<ObjectKind> getDatabaseAuxiliaryDetailKinds() {
        return this.databaseAuxiliaryDetailKinds;
    }

    @NotNull
    protected Set<ObjectKind> getServerAuxiliaryDetailKinds() {
        return this.serverAuxiliaryDetailKinds;
    }

    @Override
    @NotNull
    public Collection<AffectedObjectMention> analyze(@NotNull Collection<AffectedObjectScriptedMention> scriptedMentions) {
        Intrinsics.checkNotNullParameter(scriptedMentions, (String)"scriptedMentions");
        ArrayList mentions = new ArrayList(scriptedMentions.size());
        for (AffectedObjectScriptedMention scriptedMention : scriptedMentions) {
            AffectedObjectMention mention = this.analyze(scriptedMention);
            if (mention == null) continue;
            ((Collection)mentions).add(mention);
        }
        return mentions;
    }

    @Override
    @Nullable
    public AffectedObjectMention analyze(@NotNull AffectedObjectScriptedMention scriptedMention) {
        block6: {
            Intrinsics.checkNotNullParameter((Object)scriptedMention, (String)"scriptedMention");
            ObjectKind originalObjectKind = scriptedMention.objectKind;
            Namespaces namespaces2 = this.resolveNamespaces(scriptedMention);
            if (namespaces2.database == null && !Intrinsics.areEqual((Object)originalObjectKind, (Object)ObjectKind.DATABASE)) {
                return null;
            }
            if (namespaces2.schema == null && !Intrinsics.areEqual((Object)originalObjectKind, (Object)ObjectKind.SCHEMA)) {
                return null;
            }
            CasingProvider casingProvider = namespaces2.schema;
            if (casingProvider == null && (casingProvider = namespaces2.database) == null) {
                casingProvider = this.root;
            }
            BasicSchema objectCasingProvider = casingProvider;
            Casing casing = ((CasingProvider)objectCasingProvider).getCasing(originalObjectKind, objectCasingProvider);
            Intrinsics.checkNotNullExpressionValue((Object)casing, (String)"getCasing(...)");
            Casing objectCasing = casing;
            String objectName = objectCasing.choose(!scriptedMention.objectNameIsQuoted).apply(scriptedMention.objectName);
            ObjectKind objectKind = originalObjectKind;
            BelongingAreaKind affectionArea = scriptedMention.belongingAreaKind;
            String string = objectName;
            Intrinsics.checkNotNull((Object)string);
            ObjectAdjustment adjustment = this.adjustObject(namespaces2, string, objectKind, affectionArea, scriptedMention.affectionType);
            if (adjustment != null) {
                objectName = adjustment.name;
                objectKind = adjustment.kind;
                affectionArea = adjustment.area;
            }
            if (affectionArea == null) {
                string = objectName;
                Intrinsics.checkNotNull((Object)string);
                affectionArea = this.determineAffectionArea(namespaces2, string, objectKind, scriptedMention.belongingAreaKind, scriptedMention.affectionType);
            }
            if (affectionArea != null) {
                String string2 = namespaces2.databaseName;
                BasicDatabase basicDatabase = namespaces2.database;
                String string3 = namespaces2.schemaName;
                BasicSchema basicSchema = namespaces2.schema;
                string = objectName;
                Intrinsics.checkNotNull((Object)string);
                return new AffectedObjectMention(string2, basicDatabase, string3, basicSchema, string, objectKind, affectionArea, scriptedMention.affectionType);
            }
            Logger logger2 = this.log;
            if (logger2 == null) break block6;
            logger2.debug("We cannot find the area for an affected objects with the following info: namespaces=(" + namespaces2 + "), object=(" + objectKind + ":" + objectName + "), affectionType=" + scriptedMention.affectionType.getCode());
        }
        return null;
    }

    @NotNull
    protected Namespaces resolveNamespaces(@NotNull AffectedObjectScriptedMention sm) {
        Intrinsics.checkNotNullParameter((Object)sm, (String)"sm");
        String databaseName = null;
        BasicDatabase database = null;
        String schemaName = null;
        BasicSchema schema2 = null;
        Casing casing = this.root.getCasing(ObjectKind.DATABASE, this.root);
        Intrinsics.checkNotNullExpressionValue((Object)casing, (String)"getCasing(...)");
        Casing rootCasing = casing;
        BasicRoot basicRoot = this.root;
        if (basicRoot instanceof BasicMultiDatabaseRoot) {
            BasicDatabase basicDatabase;
            if (Intrinsics.areEqual((Object)sm.databaseName, (Object)"") || Intrinsics.areEqual((Object)sm.databaseName, (Object)"@")) {
                basicDatabase = ((BasicMultiDatabaseRoot)this.root).getCurrentDatabase();
            } else {
                NamingFamily<? extends BasicMateDatabase> namingFamily = ((BasicMultiDatabaseRoot)this.root).getDatabases();
                Intrinsics.checkNotNullExpressionValue(namingFamily, (String)"getDatabases(...)");
                basicDatabase = (BasicDatabase)ModelFun.findByScriptName(namingFamily, sm.databaseName, sm.databaseNameIsQuoted);
            }
            database = basicDatabase;
            BasicMateDatabase basicMateDatabase = (BasicMateDatabase)database;
            String string = basicMateDatabase != null ? basicMateDatabase.getName() : null;
            if (string == null) {
                String string2 = rootCasing.choose(!sm.databaseNameIsQuoted).apply(sm.databaseName);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"apply(...)");
            }
            databaseName = string;
        } else if (basicRoot instanceof BasicDatabase) {
            database = (BasicDatabase)((Object)this.root);
            databaseName = "@";
        } else {
            database = null;
            String string = rootCasing.choose(!sm.databaseNameIsQuoted).apply(sm.databaseName);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"apply(...)");
            databaseName = string;
        }
        if (database != null) {
            BasicSchema basicSchema;
            if (Intrinsics.areEqual((Object)sm.schemaName, (Object)"") || Intrinsics.areEqual((Object)sm.schemaName, (Object)"@")) {
                basicSchema = ModelFun.getCurrentSchema(database);
            } else {
                NamingFamily<? extends BasicSchema> namingFamily = database.getSchemas();
                Intrinsics.checkNotNullExpressionValue(namingFamily, (String)"getSchemas(...)");
                basicSchema = (BasicSchema)ModelFun.findByScriptName(namingFamily, sm.schemaName, sm.schemaNameIsQuoted);
            }
            BasicSchema basicSchema2 = schema2 = basicSchema;
            String string = basicSchema2 != null ? basicSchema2.getName() : null;
            if (string == null) {
                String string3 = database.getCasing(ObjectKind.SCHEMA, database).choose(!sm.schemaNameIsQuoted).apply(sm.schemaName);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"apply(...)");
            }
            schemaName = string;
        } else {
            schema2 = null;
            String string = this.root.getCasing(ObjectKind.SCHEMA, this.root).choose(!sm.schemaNameIsQuoted).apply(sm.schemaName);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"apply(...)");
            schemaName = string;
        }
        return new Namespaces(databaseName, database, schemaName, schema2);
    }

    @Nullable
    protected ObjectAdjustment adjustObject(@NotNull Namespaces namespaces2, @NotNull String objectName, @NotNull ObjectKind objectKind, @Nullable BelongingAreaKind affectionAreaKind, @NotNull ObjectAffectionType affectionType) {
        BasicElement candidate2;
        BasicElement candidate3;
        Intrinsics.checkNotNullParameter((Object)namespaces2, (String)"namespaces");
        Intrinsics.checkNotNullParameter((Object)objectName, (String)"objectName");
        Intrinsics.checkNotNullParameter((Object)objectKind, (String)"objectKind");
        Intrinsics.checkNotNullParameter((Object)((Object)affectionType), (String)"affectionType");
        if (affectionType == ObjectAffectionType.WAS_CREATED) {
            return null;
        }
        Ref.ObjectRef kind = new Ref.ObjectRef();
        kind.element = objectKind;
        BelongingAreaKind areaKind = affectionAreaKind;
        Lazy indexedObjects$delegate = LazyKt.lazy((Function0)((Function0)new Function0<JBIterable<DasObject>>(this, objectName){
            final /* synthetic */ BaseAffectedObjectAnalyzer this$0;
            final /* synthetic */ String $objectName;
            {
                this.this$0 = $receiver;
                this.$objectName = $objectName;
                super(0);
            }

            @NotNull
            public final JBIterable<DasObject> invoke() {
                return this.this$0.getModel().getNameIndex().getObjectsByNameInsensitive(this.$objectName);
            }
        }));
        if (Intrinsics.areEqual((Object)kind.element, (Object)ObjectKind.SCHEMA_OBJECT) && (candidate3 = (BasicElement)BaseAffectedObjectAnalyzer.adjustObject$lambda$0((Lazy<? extends JBIterable<DasObject>>)indexedObjects$delegate).filter(BasicElement.class).filter(arg_0 -> BaseAffectedObjectAnalyzer.adjustObject$lambda$1((Function1)new Function1<BasicElement, Boolean>(namespaces2){
            final /* synthetic */ Namespaces $namespaces;
            {
                this.$namespaces = $namespaces;
                super(1);
            }

            @NotNull
            public final Boolean invoke(BasicElement it2) {
                return Intrinsics.areEqual((Object)it2.getSchema(), (Object)this.$namespaces.schema);
            }
        }, arg_0)).sort((arg_0, arg_1) -> BaseAffectedObjectAnalyzer.adjustObject$lambda$2(adjustObject.candidate.2.INSTANCE, arg_0, arg_1)).first()) != null) {
            ObjectKind objectKind2 = candidate3.getKind();
            Intrinsics.checkNotNullExpressionValue((Object)objectKind2, (String)"getKind(...)");
            kind.element = objectKind2;
            areaKind = this.determineAreaOfKind(namespaces2, (ObjectKind)kind.element);
        }
        BasicSchema schema2 = namespaces2.schema;
        if (this.getSchemaMinor().contains(kind.element) && schema2 != null && (candidate2 = (BasicElement)BaseAffectedObjectAnalyzer.adjustObject$lambda$0((Lazy<? extends JBIterable<DasObject>>)indexedObjects$delegate).filter(BasicElement.class).filter(arg_0 -> BaseAffectedObjectAnalyzer.adjustObject$lambda$3((Function1)new Function1<BasicElement, Boolean>((Ref.ObjectRef<ObjectKind>)kind){
            final /* synthetic */ Ref.ObjectRef<ObjectKind> $kind;
            {
                this.$kind = $kind;
                super(1);
            }

            @NotNull
            public final Boolean invoke(BasicElement it2) {
                return Intrinsics.areEqual((Object)it2.getKind(), (Object)this.$kind.element);
            }
        }, arg_0)).filterMap(arg_0 -> BaseAffectedObjectAnalyzer.adjustObject$lambda$4((Function1)new Function1<BasicElement, BasicElement>((Object)this){

            @Nullable
            public final BasicElement invoke(@NotNull BasicElement p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return BaseAffectedObjectAnalyzer.access$getEnclosingFragmentObject((BaseAffectedObjectAnalyzer)this.receiver, p0);
            }
        }, arg_0)).filter(arg_0 -> BaseAffectedObjectAnalyzer.adjustObject$lambda$5((Function1)new Function1<BasicElement, Boolean>(schema2){
            final /* synthetic */ BasicSchema $schema;
            {
                this.$schema = $schema;
                super(1);
            }

            @NotNull
            public final Boolean invoke(BasicElement it2) {
                BasicElement basicElement = it2;
                Intrinsics.checkNotNull((Object)basicElement);
                return Intrinsics.areEqual((Object)basicElement.getParent(), (Object)this.$schema);
            }
        }, arg_0)).first()) != null) {
            String string = candidate2.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            ObjectKind objectKind3 = candidate2.getKind();
            Intrinsics.checkNotNullExpressionValue((Object)objectKind3, (String)"getKind(...)");
            return new ObjectAdjustment(string, objectKind3, BelongingAreaKind.A_SCHEMA);
        }
        if (!this.getDatabaseAuxiliaryDetailKinds().contains(kind.element) || namespaces2.database != null) {
            // empty if block
        }
        if (this.getServerAuxiliaryDetailKinds().contains(kind.element) && (candidate2 = (BasicElement)BaseAffectedObjectAnalyzer.adjustObject$lambda$0((Lazy<? extends JBIterable<DasObject>>)indexedObjects$delegate).filter(BasicElement.class).filter(arg_0 -> BaseAffectedObjectAnalyzer.adjustObject$lambda$6((Function1)new Function1<BasicElement, Boolean>((Ref.ObjectRef<ObjectKind>)kind){
            final /* synthetic */ Ref.ObjectRef<ObjectKind> $kind;
            {
                this.$kind = $kind;
                super(1);
            }

            @NotNull
            public final Boolean invoke(BasicElement it2) {
                return Intrinsics.areEqual((Object)it2.getKind(), (Object)this.$kind.element);
            }
        }, arg_0)).filterMap(arg_0 -> BaseAffectedObjectAnalyzer.adjustObject$lambda$7((Function1)new Function1<BasicElement, BasicElement>((Object)this){

            @Nullable
            public final BasicElement invoke(@NotNull BasicElement p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return BaseAffectedObjectAnalyzer.access$getEnclosingFragmentObject((BaseAffectedObjectAnalyzer)this.receiver, p0);
            }
        }, arg_0)).filter(arg_0 -> BaseAffectedObjectAnalyzer.adjustObject$lambda$8((Function1)new Function1<BasicElement, Boolean>(this){
            final /* synthetic */ BaseAffectedObjectAnalyzer this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(BasicElement it2) {
                BasicElement basicElement = it2;
                Intrinsics.checkNotNull((Object)basicElement);
                return Intrinsics.areEqual((Object)basicElement.getParent(), (Object)this.this$0.getRoot());
            }
        }, arg_0)).first()) != null) {
            String string = candidate2.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            ObjectKind objectKind4 = candidate2.getKind();
            Intrinsics.checkNotNullExpressionValue((Object)objectKind4, (String)"getKind(...)");
            return new ObjectAdjustment(string, objectKind4, BelongingAreaKind.A_ROOT);
        }
        if (!Intrinsics.areEqual((Object)kind.element, (Object)objectKind) || areaKind != affectionAreaKind) {
            BelongingAreaKind belongingAreaKind = areaKind;
            if (belongingAreaKind == null && (belongingAreaKind = this.determineAreaOfKind(namespaces2, (ObjectKind)kind.element)) == null) {
                return null;
            }
            areaKind = belongingAreaKind;
            return new ObjectAdjustment(objectName, (ObjectKind)kind.element, areaKind);
        }
        return null;
    }

    private final BasicElement getEnclosingFragmentObject(BasicElement element2) {
        BasicElement basicElement;
        block5: {
            block6: {
                while (true) {
                    BasicElement basicElement2;
                    Object object;
                    BasicElement basicElement3;
                    if ((basicElement3 = element2) instanceof BasicMajorObject) {
                        basicElement = element2;
                        break block5;
                    }
                    if (basicElement3 instanceof BasicMinorObject) {
                        basicElement = ((BasicMinorObject)element2).getMajorObject();
                        break block5;
                    }
                    if (basicElement3 instanceof BasicSchemaObject) {
                        object = ((BasicSchemaObject)element2).getParent();
                        basicElement = object instanceof BasicMajorObject ? (BasicMajorObject)object : null;
                        break block5;
                    }
                    if (basicElement3 instanceof BasicAuxiliaryObject) {
                        basicElement = element2;
                        break block5;
                    }
                    if (!(basicElement3 instanceof BasicAuxiliaryDetail)) break block6;
                    if (((BasicAuxiliaryDetail)element2).getParent() == null) break;
                    object = this_;
                    Intrinsics.checkNotNull((Object)((BasicAuxiliaryDetail)element2).getParent());
                    Object this_ = object;
                    element2 = basicElement2;
                }
                basicElement = null;
                break block5;
            }
            basicElement = null;
        }
        return basicElement;
    }

    @Nullable
    protected BelongingAreaKind determineAffectionArea(@NotNull Namespaces ns, @NotNull String objectName, @NotNull ObjectKind objectKind, @Nullable BelongingAreaKind givenArea, @NotNull ObjectAffectionType affectionType) {
        Intrinsics.checkNotNullParameter((Object)ns, (String)"ns");
        Intrinsics.checkNotNullParameter((Object)objectName, (String)"objectName");
        Intrinsics.checkNotNullParameter((Object)objectKind, (String)"objectKind");
        Intrinsics.checkNotNullParameter((Object)((Object)affectionType), (String)"affectionType");
        BelongingAreaKind area = this.determineAreaOfKind(ns, objectKind);
        return area;
    }

    @Nullable
    protected final BelongingAreaKind determineAreaOfKind(@NotNull Namespaces ns, @NotNull ObjectKind theKind) {
        Intrinsics.checkNotNullParameter((Object)ns, (String)"ns");
        Intrinsics.checkNotNullParameter((Object)theKind, (String)"theKind");
        BelongingAreaKind area = null;
        ObjectKind objectKind = theKind;
        if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.SCHEMA) ? true : Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.SCHEMA_OBJECT)) {
            area = BelongingAreaKind.A_SCHEMA;
        } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.DATABASE)) {
            area = BelongingAreaKind.A_DATABASE;
        }
        if (area == null) {
            BasicSchema schema2 = ns.schema;
            if (schema2 != null) {
                if (schema2.familyOf(theKind) != null) {
                    area = BelongingAreaKind.A_SCHEMA;
                }
            } else {
                ObjectKind objectKind2 = ObjectKind.SCHEMA;
                Intrinsics.checkNotNullExpressionValue((Object)objectKind2, (String)"SCHEMA");
                if (this.parentCanHaveChild(objectKind2, theKind)) {
                    area = BelongingAreaKind.A_SCHEMA;
                }
            }
        }
        if (area == null && this.root instanceof BasicMultiDatabaseRoot) {
            BasicDatabase database = ns.database;
            if (database != null) {
                if (database.familyOf(theKind) != null) {
                    area = BelongingAreaKind.A_DATABASE;
                }
            } else {
                ObjectKind objectKind3 = ObjectKind.DATABASE;
                Intrinsics.checkNotNullExpressionValue((Object)objectKind3, (String)"DATABASE");
                if (this.parentCanHaveChild(objectKind3, theKind)) {
                    area = BelongingAreaKind.A_DATABASE;
                }
            }
        }
        if (area == null && this.root.familyOf(theKind) != null) {
            area = BelongingAreaKind.A_ROOT;
        }
        return area;
    }

    protected final boolean parentCanHaveChild(@NotNull ObjectKind parentKind, @NotNull ObjectKind childKind) {
        Intrinsics.checkNotNullParameter((Object)parentKind, (String)"parentKind");
        Intrinsics.checkNotNullParameter((Object)childKind, (String)"childKind");
        BasicMetaObject basicMetaObject = (BasicMetaObject)((BasicMetaModel)this.model.getMetaModel()).findMetaObjects(parentKind).first();
        if (basicMetaObject == null) {
            return false;
        }
        BasicMetaObject metaObject = basicMetaObject;
        return BasicMetaFunKt.findChild(metaObject, childKind) != null;
    }

    private static final JBIterable<DasObject> adjustObject$lambda$0(Lazy<? extends JBIterable<DasObject>> $indexedObjects$delegate) {
        Lazy<? extends JBIterable<DasObject>> lazy = $indexedObjects$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (JBIterable)object;
    }

    private static final boolean adjustObject$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final int adjustObject$lambda$2(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    private static final boolean adjustObject$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final BasicElement adjustObject$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (BasicElement)$tmp0.invoke(p0);
    }

    private static final boolean adjustObject$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean adjustObject$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final BasicElement adjustObject$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (BasicElement)$tmp0.invoke(p0);
    }

    private static final boolean adjustObject$lambda$8(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ BasicElement access$getEnclosingFragmentObject(BaseAffectedObjectAnalyzer $this, BasicElement element2) {
        return $this.getEnclosingFragmentObject(element2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0084\b\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u000b\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\bH\u00c6\u0003J5\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00032\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bH\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\b\u0010\u0014\u001a\u00020\u0003H\u0016R\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/database/dialects/base/introspector/BaseAffectedObjectAnalyzer$Namespaces;", "", "databaseName", "", "database", "Lcom/intellij/database/model/basic/BasicDatabase;", "schemaName", "schema", "Lcom/intellij/database/model/basic/BasicSchema;", "(Ljava/lang/String;Lcom/intellij/database/model/basic/BasicDatabase;Ljava/lang/String;Lcom/intellij/database/model/basic/BasicSchema;)V", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.database.dialects.base"})
    protected static final class Namespaces {
        @JvmField
        @NotNull
        public final String databaseName;
        @JvmField
        @Nullable
        public final BasicDatabase database;
        @JvmField
        @NotNull
        public final String schemaName;
        @JvmField
        @Nullable
        public final BasicSchema schema;

        public Namespaces(@NotNull String databaseName, @Nullable BasicDatabase database, @NotNull String schemaName, @Nullable BasicSchema schema2) {
            Intrinsics.checkNotNullParameter((Object)databaseName, (String)"databaseName");
            Intrinsics.checkNotNullParameter((Object)schemaName, (String)"schemaName");
            this.databaseName = databaseName;
            this.database = database;
            this.schemaName = schemaName;
            this.schema = schema2;
        }

        @NotNull
        public String toString() {
            StringBuilder stringBuilder;
            StringBuilder $this$toString_u24lambda_u240 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$toString_u24lambda_u240.append(this.databaseName);
            $this$toString_u24lambda_u240.append(this.database != null ? (char)'!' : '?');
            $this$toString_u24lambda_u240.append('/');
            $this$toString_u24lambda_u240.append(this.schemaName);
            $this$toString_u24lambda_u240.append(this.schema != null ? (char)'!' : '?');
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        @NotNull
        public final String component1() {
            return this.databaseName;
        }

        @Nullable
        public final BasicDatabase component2() {
            return this.database;
        }

        @NotNull
        public final String component3() {
            return this.schemaName;
        }

        @Nullable
        public final BasicSchema component4() {
            return this.schema;
        }

        @NotNull
        public final Namespaces copy(@NotNull String databaseName, @Nullable BasicDatabase database, @NotNull String schemaName, @Nullable BasicSchema schema2) {
            Intrinsics.checkNotNullParameter((Object)databaseName, (String)"databaseName");
            Intrinsics.checkNotNullParameter((Object)schemaName, (String)"schemaName");
            return new Namespaces(databaseName, database, schemaName, schema2);
        }

        public static /* synthetic */ Namespaces copy$default(Namespaces namespaces2, String string, BasicDatabase basicDatabase, String string2, BasicSchema basicSchema, int n, Object object) {
            if ((n & 1) != 0) {
                string = namespaces2.databaseName;
            }
            if ((n & 2) != 0) {
                basicDatabase = namespaces2.database;
            }
            if ((n & 4) != 0) {
                string2 = namespaces2.schemaName;
            }
            if ((n & 8) != 0) {
                basicSchema = namespaces2.schema;
            }
            return namespaces2.copy(string, basicDatabase, string2, basicSchema);
        }

        public int hashCode() {
            int result2 = this.databaseName.hashCode();
            result2 = result2 * 31 + (this.database == null ? 0 : this.database.hashCode());
            result2 = result2 * 31 + this.schemaName.hashCode();
            result2 = result2 * 31 + (this.schema == null ? 0 : this.schema.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Namespaces)) {
                return false;
            }
            Namespaces namespaces2 = (Namespaces)other;
            if (!Intrinsics.areEqual((Object)this.databaseName, (Object)namespaces2.databaseName)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.database, (Object)namespaces2.database)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.schemaName, (Object)namespaces2.schemaName)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.schema, (Object)namespaces2.schema);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0084\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0007H\u00c6\u0003J'\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/database/dialects/base/introspector/BaseAffectedObjectAnalyzer$ObjectAdjustment;", "", "name", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "area", "Lcom/intellij/database/introspection/BelongingAreaKind;", "(Ljava/lang/String;Lcom/intellij/database/model/ObjectKind;Lcom/intellij/database/introspection/BelongingAreaKind;)V", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.database.dialects.base"})
    protected static final class ObjectAdjustment {
        @JvmField
        @NotNull
        public final String name;
        @JvmField
        @NotNull
        public final ObjectKind kind;
        @JvmField
        @NotNull
        public final BelongingAreaKind area;

        public ObjectAdjustment(@NotNull String name2, @NotNull ObjectKind kind, @NotNull BelongingAreaKind area) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            Intrinsics.checkNotNullParameter((Object)((Object)area), (String)"area");
            this.name = name2;
            this.kind = kind;
            this.area = area;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final ObjectKind component2() {
            return this.kind;
        }

        @NotNull
        public final BelongingAreaKind component3() {
            return this.area;
        }

        @NotNull
        public final ObjectAdjustment copy(@NotNull String name2, @NotNull ObjectKind kind, @NotNull BelongingAreaKind area) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            Intrinsics.checkNotNullParameter((Object)((Object)area), (String)"area");
            return new ObjectAdjustment(name2, kind, area);
        }

        public static /* synthetic */ ObjectAdjustment copy$default(ObjectAdjustment objectAdjustment, String string, ObjectKind objectKind, BelongingAreaKind belongingAreaKind, int n, Object object) {
            if ((n & 1) != 0) {
                string = objectAdjustment.name;
            }
            if ((n & 2) != 0) {
                objectKind = objectAdjustment.kind;
            }
            if ((n & 4) != 0) {
                belongingAreaKind = objectAdjustment.area;
            }
            return objectAdjustment.copy(string, objectKind, belongingAreaKind);
        }

        @NotNull
        public String toString() {
            return "ObjectAdjustment(name=" + this.name + ", kind=" + this.kind + ", area=" + this.area + ")";
        }

        public int hashCode() {
            int result2 = this.name.hashCode();
            result2 = result2 * 31 + this.kind.hashCode();
            result2 = result2 * 31 + this.area.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ObjectAdjustment)) {
                return false;
            }
            ObjectAdjustment objectAdjustment = (ObjectAdjustment)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)objectAdjustment.name)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.kind, (Object)objectAdjustment.kind)) {
                return false;
            }
            return this.area == objectAdjustment.area;
        }
    }
}

