/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.introspector;

import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.connection.DGDepartment;
import com.intellij.database.dataSource.connection.DatabaseDepartment;
import com.intellij.database.dataSource.connection.audit.AdvancedAuditService;
import com.intellij.database.dataSource.connection.statements.SmartStatementMark;
import com.intellij.database.dataSource.connection.statements.SmartStatementSource;
import com.intellij.database.dataSource.connection.statements.StatementParameters;
import com.intellij.database.dialects.base.introspector.AuditFacade;
import com.intellij.database.remote.jdba.RemoteCursor;
import com.intellij.database.remote.jdba.RemoteFacade;
import com.intellij.database.remote.jdba.RemoteSeance;
import com.intellij.database.remote.jdba.RemoteSession;
import com.intellij.database.remote.jdba.core.ConnectionInfo;
import com.intellij.database.remote.jdba.core.ParameterDef;
import com.intellij.database.remote.jdba.core.ResultLayout;
import com.intellij.database.remote.jdba.intermediate.PrimeIntermediateCursor;
import com.intellij.database.remote.jdba.intermediate.PrimeIntermediateFacade;
import com.intellij.database.remote.jdba.intermediate.PrimeIntermediateSeance;
import com.intellij.database.remote.jdba.intermediate.PrimeIntermediateSession;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.remote.jdbc.RemoteStatement;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 !2\u00020\u0001:\u0005!\"#$%B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\b\u0010\u0010\u001a\u00020\u000eH\u0016J\b\u0010\u0011\u001a\u00020\u000eH\u0016J\u0010\u0010\u0012\u001a\n \u0014*\u0004\u0018\u00010\u00130\u0013H\u0016J+\u0010\u0015\u001a\u0004\u0018\u0001H\u0016\"\u0004\b\u0000\u0010\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00160\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016\u00a2\u0006\u0002\u0010\u001bJ\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u000eH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00020\u000b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/database/dialects/base/introspector/AuditFacade;", "Lcom/intellij/database/remote/jdba/intermediate/PrimeIntermediateFacade;", "remoteFacade", "Lcom/intellij/database/remote/jdba/RemoteFacade;", "connection", "Lcom/intellij/database/dataSource/DatabaseConnectionCore;", "(Lcom/intellij/database/remote/jdba/RemoteFacade;Lcom/intellij/database/dataSource/DatabaseConnectionCore;)V", "getConnection", "()Lcom/intellij/database/dataSource/DatabaseConnectionCore;", "openedSessions", "Ljava/util/ArrayList;", "Lcom/intellij/database/dialects/base/introspector/AuditFacade$Session;", "Lkotlin/collections/ArrayList;", "closeOpenedSessions", "", "connect", "detachFromDB", "disconnect", "getConnectionInfo", "Lcom/intellij/database/remote/jdba/core/ConnectionInfo;", "kotlin.jvm.PlatformType", "getSpecificService", "I", "serviceClass", "Ljava/lang/Class;", "serviceName", "", "(Ljava/lang/Class;Ljava/lang/String;)Ljava/lang/Object;", "isConnected", "", "openSession", "Lcom/intellij/database/remote/jdba/intermediate/PrimeIntermediateSession;", "reconnect", "Companion", "Cursor", "OneTimeInvocation", "Seance", "Session", "intellij.database.dialects.base"})
public final class AuditFacade
implements PrimeIntermediateFacade {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RemoteFacade remoteFacade;
    @NotNull
    private final DatabaseConnectionCore connection;
    @NotNull
    private final ArrayList<Session> openedSessions;

    public AuditFacade(@NotNull RemoteFacade remoteFacade, @NotNull DatabaseConnectionCore connection2) {
        Intrinsics.checkNotNullParameter((Object)remoteFacade, (String)"remoteFacade");
        Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
        this.remoteFacade = remoteFacade;
        this.connection = connection2;
        this.openedSessions = new ArrayList();
    }

    @NotNull
    public final DatabaseConnectionCore getConnection() {
        return this.connection;
    }

    @NotNull
    public PrimeIntermediateSession openSession() {
        RemoteSession remoteSession = this.remoteFacade.openSession();
        Intrinsics.checkNotNullExpressionValue((Object)remoteSession, (String)"openSession(...)");
        Session opened2 = new Session(remoteSession, this.connection, (Function1<? super Session, Unit>)((Function1)new Function1<Session, Unit>(this){
            final /* synthetic */ AuditFacade this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Session it2) {
                Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                ((Collection)AuditFacade.access$getOpenedSessions$p(this.this$0)).remove(it2);
            }
        }));
        ((Collection)this.openedSessions).add(opened2);
        return opened2;
    }

    public ConnectionInfo getConnectionInfo() {
        return this.remoteFacade.getConnectionInfo();
    }

    public void reconnect() {
        this.remoteFacade.reconnect();
    }

    public void detachFromDB() {
        this.closeOpenedSessions();
        this.remoteFacade.detachFromDB();
    }

    public void disconnect() {
        this.closeOpenedSessions();
        this.remoteFacade.disconnect();
    }

    private final void closeOpenedSessions() {
        for (Session openedSession : this.openedSessions) {
            openedSession.disconnect();
        }
        this.openedSessions.clear();
    }

    public void connect() {
        this.remoteFacade.connect();
    }

    public boolean isConnected() {
        return this.remoteFacade.isConnected();
    }

    @Nullable
    public <I> I getSpecificService(@NotNull Class<I> serviceClass, @NotNull String serviceName) {
        Intrinsics.checkNotNullParameter(serviceClass, (String)"serviceClass");
        Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
        String string = "not implemented yet";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    public static final /* synthetic */ ArrayList access$getOpenedSessions$p(AuditFacade $this) {
        return $this.openedSessions;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J-\u0010\u0003\u001a\u0004\u0018\u0001H\u0004\"\u0004\b\u0000\u0010\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00040\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0001H\u0007\u00a2\u0006\u0002\u0010\bJ1\u0010\t\u001a\u0002H\n\"\u0004\b\u0000\u0010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\n0\u0010H\u0002\u00a2\u0006\u0002\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/intellij/database/dialects/base/introspector/AuditFacade$Companion;", "", "()V", "castTo", "C", "clazz", "Ljava/lang/Class;", "obj", "(Ljava/lang/Class;Ljava/lang/Object;)Ljava/lang/Object;", "runReporting", "T", "connection", "Lcom/intellij/database/dataSource/DatabaseConnectionCore;", "mark", "Lcom/intellij/database/dataSource/connection/statements/SmartStatementMark;", "runnable", "Lkotlin/Function0;", "(Lcom/intellij/database/dataSource/DatabaseConnectionCore;Lcom/intellij/database/dataSource/connection/statements/SmartStatementMark;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "intellij.database.dialects.base"})
    public static final class Companion {
        private Companion() {
        }

        private final <T> T runReporting(DatabaseConnectionCore connection2, SmartStatementMark mark2, Function0<? extends T> runnable) {
            try {
                return (T)runnable.invoke();
            }
            catch (Throwable t) {
                connection2.getAuditService().error(t, mark2);
                throw t;
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        @Contract(value="_,!null->!null; _,null->null")
        @Nullable
        public final <C> C castTo(@NotNull Class<C> clazz, @Nullable Object obj2) throws ClassCastException {
            Object object;
            Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
            if (obj2 == null) {
                object = null;
                return (C)object;
            }
            Class<?> objectClass = obj2.getClass();
            if (clazz.isAssignableFrom(objectClass)) {
                object = obj2;
                return (C)object;
            }
            String kind = clazz.isInterface() ? "interface" : "class";
            String string = "cannot cast object of class %s to %s %s.";
            Object[] objectArray = new Object[]{objectClass.getName(), kind, clazz.getName()};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            String msg = string2;
            throw new ClassCastException(msg);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002BG\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0018\u0010\u000b\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0000\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u000f\u001a\u00020\rH\u0016J\u0006\u0010\u0010\u001a\u00020\rJ\r\u0010\u0011\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0012J\u0015\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u0014H\u0016\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R \u0010\u000b\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0000\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/database/dialects/base/introspector/AuditFacade$Cursor;", "T", "Lcom/intellij/database/remote/jdba/intermediate/PrimeIntermediateCursor;", "remoteCursor", "Lcom/intellij/database/remote/jdba/RemoteCursor;", "resultsClosingInvocation", "Lcom/intellij/database/dialects/base/introspector/AuditFacade$OneTimeInvocation;", "session", "Lcom/intellij/database/dialects/base/introspector/AuditFacade$Session;", "mark", "Lcom/intellij/database/dataSource/connection/statements/SmartStatementMark;", "disposalCallback", "Lkotlin/Function1;", "", "(Lcom/intellij/database/remote/jdba/RemoteCursor;Lcom/intellij/database/dialects/base/introspector/AuditFacade$OneTimeInvocation;Lcom/intellij/database/dialects/base/introspector/AuditFacade$Session;Lcom/intellij/database/dataSource/connection/statements/SmartStatementMark;Lkotlin/jvm/functions/Function1;)V", "close", "disconnect", "fetch", "()Ljava/lang/Object;", "getColumnNames", "", "", "()[Ljava/lang/String;", "hasRows", "", "setCollectLimit", "limit", "", "intellij.database.dialects.base"})
    private static final class Cursor<T>
    implements PrimeIntermediateCursor<T> {
        @NotNull
        private final RemoteCursor<T> remoteCursor;
        @Nullable
        private final OneTimeInvocation resultsClosingInvocation;
        @NotNull
        private final Session session;
        @NotNull
        private final SmartStatementMark mark;
        @NotNull
        private final Function1<Cursor<T>, Unit> disposalCallback;

        public Cursor(@NotNull RemoteCursor<T> remoteCursor, @Nullable OneTimeInvocation resultsClosingInvocation, @NotNull Session session2, @NotNull SmartStatementMark mark2, @NotNull Function1<? super Cursor<T>, Unit> disposalCallback) {
            Intrinsics.checkNotNullParameter(remoteCursor, (String)"remoteCursor");
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            Intrinsics.checkNotNullParameter((Object)mark2, (String)"mark");
            Intrinsics.checkNotNullParameter(disposalCallback, (String)"disposalCallback");
            this.remoteCursor = remoteCursor;
            this.resultsClosingInvocation = resultsClosingInvocation;
            this.session = session2;
            this.mark = mark2;
            this.disposalCallback = disposalCallback;
        }

        public T fetch() {
            return (T)Companion.runReporting(this.session.getConnection(), this.mark, new Function0<T>(this){
                final /* synthetic */ Cursor<T> this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final T invoke() {
                    Object result2 = Cursor.access$getRemoteCursor$p(this.this$0).fetch();
                    return (T)result2;
                }
            });
        }

        public boolean hasRows() {
            return this.remoteCursor.hasRows();
        }

        @NotNull
        public String[] getColumnNames() {
            String[] stringArray = this.remoteCursor.getColumnNames();
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getColumnNames(...)");
            return stringArray;
        }

        public void setCollectLimit(int limit) {
            this.remoteCursor.setCollectLimit(limit);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            try {
                this.disposalCallback.invoke((Object)this);
                this.disconnect();
            }
            finally {
                this.remoteCursor.close();
            }
        }

        public final void disconnect() {
            block1: {
                if (this.session.isClosed()) break block1;
                OneTimeInvocation oneTimeInvocation = this.resultsClosingInvocation;
                if (oneTimeInvocation != null) {
                    oneTimeInvocation.run();
                }
            }
        }

        public static final /* synthetic */ RemoteCursor access$getRemoteCursor$p(Cursor $this) {
            return $this.remoteCursor;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\b\u001a\u00020\u0004R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/database/dialects/base/introspector/AuditFacade$OneTimeInvocation;", "", "invoker", "Lkotlin/Function0;", "", "(Lkotlin/jvm/functions/Function0;)V", "invoked", "", "run", "intellij.database.dialects.base"})
    private static final class OneTimeInvocation {
        @NotNull
        private final Function0<Unit> invoker;
        private boolean invoked;

        public OneTimeInvocation(@NotNull Function0<Unit> invoker) {
            Intrinsics.checkNotNullParameter(invoker, (String)"invoker");
            this.invoker = invoker;
        }

        public final void run() {
            if (this.invoked) {
                return;
            }
            this.invoked = true;
            this.invoker.invoke();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u007f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005*\u0001\r\b\u0002\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u001e\u001a\u00020\nH\u0002J\b\u0010\u001f\u001a\u00020\nH\u0002J\b\u0010 \u001a\u00020\nH\u0016J\u0006\u0010!\u001a\u00020\nJ\b\u0010\"\u001a\u00020\nH\u0016J\b\u0010#\u001a\u00020$H\u0016J+\u0010%\u001a\u0004\u0018\u0001H&\"\u0004\b\u0000\u0010&2\f\u0010'\u001a\b\u0012\u0004\u0012\u0002H&0(2\u0006\u0010)\u001a\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010*J*\u0010+\u001a\b\u0012\u0004\u0012\u0002H-0,\"\u0004\b\u0000\u0010-2\u0006\u0010.\u001a\u00020$2\f\u0010/\u001a\b\u0012\u0004\u0012\u0002H-00H\u0016J\u001d\u00101\u001a\u00020\n2\u000e\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00180\u0017H\u0016\u00a2\u0006\u0002\u00102J\u0010\u00103\u001a\u00020\n2\u0006\u00104\u001a\u00020$H\u0016R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\u0012\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140\u0013j\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0014`\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0018\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0019R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/intellij/database/dialects/base/introspector/AuditFacade$Seance;", "Lcom/intellij/database/remote/jdba/intermediate/PrimeIntermediateSeance;", "remoteSeance", "Lcom/intellij/database/remote/jdba/RemoteSeance;", "session", "Lcom/intellij/database/dialects/base/introspector/AuditFacade$Session;", "sql", "", "disposalCallback", "Lkotlin/Function1;", "", "(Lcom/intellij/database/remote/jdba/RemoteSeance;Lcom/intellij/database/dialects/base/introspector/AuditFacade$Session;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "mark", "com/intellij/database/dialects/base/introspector/AuditFacade$Seance$mark$1", "Lcom/intellij/database/dialects/base/introspector/AuditFacade$Seance$mark$1;", "myResultSetInvocation", "Lcom/intellij/database/dialects/base/introspector/AuditFacade$OneTimeInvocation;", "myStatementInvocation", "openedCursors", "Ljava/util/ArrayList;", "Lcom/intellij/database/dialects/base/introspector/AuditFacade$Cursor;", "Lkotlin/collections/ArrayList;", "parameters", "", "", "[Ljava/lang/Object;", "resultSet", "Lcom/intellij/database/remote/jdbc/RemoteResultSet;", "statement", "Lcom/intellij/database/remote/jdbc/RemoteStatement;", "before", "beforePrepared", "close", "disconnect", "execute", "getAffectedRowsCount", "", "getSpecificService", "I", "serviceClass", "Ljava/lang/Class;", "serviceName", "(Ljava/lang/Class;Ljava/lang/String;)Ljava/lang/Object;", "openCursor", "Lcom/intellij/database/remote/jdba/intermediate/PrimeIntermediateCursor;", "R", "parameterPosition", "layout", "Lcom/intellij/database/remote/jdba/core/ResultLayout;", "setInParameters", "([Ljava/lang/Object;)V", "setPackLimit", "packLimit", "intellij.database.dialects.base"})
    @SourceDebugExtension(value={"SMAP\nAuditFacade.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AuditFacade.kt\ncom/intellij/database/dialects/base/introspector/AuditFacade$Seance\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,322:1\n1#2:323\n*E\n"})
    private static final class Seance
    implements PrimeIntermediateSeance {
        @NotNull
        private final RemoteSeance remoteSeance;
        @NotNull
        private final Session session;
        @NotNull
        private final String sql;
        @NotNull
        private final Function1<Seance, Unit> disposalCallback;
        @Nullable
        private Object[] parameters;
        @Nullable
        private RemoteResultSet resultSet;
        @Nullable
        private RemoteStatement statement;
        @Nullable
        private OneTimeInvocation myResultSetInvocation;
        @Nullable
        private OneTimeInvocation myStatementInvocation;
        @NotNull
        private final mark.1 mark;
        @NotNull
        private final ArrayList<Cursor<?>> openedCursors;

        public Seance(@NotNull RemoteSeance remoteSeance, @NotNull Session session2, @NotNull String sql, @NotNull Function1<? super Seance, Unit> disposalCallback) {
            RemoteStatement x;
            Intrinsics.checkNotNullParameter((Object)remoteSeance, (String)"remoteSeance");
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
            Intrinsics.checkNotNullParameter(disposalCallback, (String)"disposalCallback");
            this.remoteSeance = remoteSeance;
            this.session = session2;
            this.sql = sql;
            this.disposalCallback = disposalCallback;
            this.mark = new SmartStatementMark.RunnableMark(this){
                final /* synthetic */ Seance this$0;
                {
                    this.this$0 = $receiver;
                }

                @NotNull
                public DatabaseDepartment getDepartment() {
                    return DGDepartment.INTROSPECTION;
                }

                @NotNull
                public SmartStatementSource getSource() {
                    return SmartStatementSource.SYSTEM;
                }

                public boolean cancel() {
                    if (Seance.access$getStatement$p(this.this$0) == null) {
                        return true;
                    }
                    return JdbcNativeUtil.getBooleanSafe(() -> mark.1.cancel$lambda$0(this.this$0));
                }

                private static final Boolean cancel$lambda$0(Seance this$0) {
                    Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                    RemoteStatement remoteStatement = Seance.access$getStatement$p(this$0);
                    Intrinsics.checkNotNull((Object)remoteStatement);
                    remoteStatement.cancel();
                    return true;
                }
            };
            this.openedCursors = new ArrayList();
            RemoteStatement remoteStatement = this.statement = (x = this.remoteSeance.getStatement());
            if (remoteStatement != null) {
                RemoteStatement it2 = remoteStatement;
                boolean bl = false;
                this.myStatementInvocation = new OneTimeInvocation((Function0<Unit>)((Function0)new Function0<Unit>(this, it2){
                    final /* synthetic */ Seance this$0;
                    final /* synthetic */ RemoteStatement $it;
                    {
                        this.this$0 = $receiver;
                        this.$it = $it;
                        super(0);
                    }

                    public final void invoke() {
                        Seance.access$getSession$p(this.this$0).getConnection().getAuditService().beforeStatementClosing(this.$it, Seance.access$getMark$p(this.this$0));
                    }
                }));
            }
            if (this.statement != null) {
                AdvancedAuditService advancedAuditService = this.session.getConnection().getAuditService();
                RemoteStatement remoteStatement2 = this.statement;
                Intrinsics.checkNotNull((Object)remoteStatement2);
                advancedAuditService.statementOpened(remoteStatement2, this.mark);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public <R> PrimeIntermediateCursor<R> openCursor(int parameterPosition, @NotNull ResultLayout<R> layout) {
            Intrinsics.checkNotNullParameter(layout, (String)"layout");
            try {
                RemoteCursor remoteCursor = this.remoteSeance.openCursor(parameterPosition, layout);
                Intrinsics.checkNotNullExpressionValue((Object)remoteCursor, (String)"openCursor(...)");
                Cursor cursor2 = new Cursor(remoteCursor, this.myResultSetInvocation, this.session, this.mark, (Function1)new Function1<Cursor<R>, Unit>(this){
                    final /* synthetic */ Seance this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Cursor<R> it2) {
                        Intrinsics.checkNotNullParameter(it2, (String)"it");
                        ((Collection)Seance.access$getOpenedCursors$p(this.this$0)).remove(it2);
                    }
                });
                ((Collection)this.openedCursors).add(cursor2);
                PrimeIntermediateCursor primeIntermediateCursor = cursor2;
                return primeIntermediateCursor;
            }
            finally {
                if (this.resultSet != null) {
                    AdvancedAuditService advancedAuditService = this.session.getConnection().getAuditService();
                    RemoteResultSet remoteResultSet = this.resultSet;
                    Intrinsics.checkNotNull((Object)remoteResultSet);
                    advancedAuditService.resultsOpened(remoteResultSet, this.mark);
                }
            }
        }

        public int getAffectedRowsCount() {
            return this.remoteSeance.getAffectedRowsCount();
        }

        public void setInParameters(@NotNull Object[] parameters2) {
            Intrinsics.checkNotNullParameter((Object)parameters2, (String)"parameters");
            this.remoteSeance.setInParameters(parameters2);
            this.parameters = parameters2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            try {
                this.disposalCallback.invoke((Object)this);
                this.disconnect();
            }
            finally {
                this.remoteSeance.close();
            }
        }

        public void setPackLimit(int packLimit) {
            this.remoteSeance.setPackLimit(packLimit);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute() {
            try {
                Companion.runReporting(this.session.getConnection(), this.mark, (Function0)new Function0<Unit>(this){
                    final /* synthetic */ Seance this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @Nullable
                    public final Unit invoke() {
                        Unit unit;
                        Seance.access$before(this.this$0);
                        Seance.access$getMark$p(this.this$0).run((Function0)new Function0<Unit>(this.this$0){
                            final /* synthetic */ Seance this$0;
                            {
                                this.this$0 = $receiver;
                                super(0);
                            }

                            public final void invoke() {
                                Seance.access$getRemoteSeance$p(this.this$0).execute();
                            }
                        });
                        int count = this.this$0.getAffectedRowsCount();
                        if (count > 0) {
                            Seance.access$getSession$p(this.this$0).getConnection().getAuditService().updateCount(count, Seance.access$getMark$p(this.this$0));
                        }
                        Seance.access$setResultSet$p(this.this$0, Seance.access$getRemoteSeance$p(this.this$0).getDefaultResultSet());
                        RemoteResultSet remoteResultSet = Seance.access$getResultSet$p(this.this$0);
                        if (remoteResultSet != null) {
                            RemoteResultSet remoteResultSet2 = remoteResultSet;
                            Seance seance2 = this.this$0;
                            RemoteResultSet it2 = remoteResultSet2;
                            boolean bl = false;
                            Seance.access$setMyResultSetInvocation$p(seance2, new OneTimeInvocation((Function0<Unit>)((Function0)new Function0<Unit>(seance2, it2){
                                final /* synthetic */ Seance this$0;
                                final /* synthetic */ RemoteResultSet $it;
                                {
                                    this.this$0 = $receiver;
                                    this.$it = $it;
                                    super(0);
                                }

                                public final void invoke() {
                                    Seance.access$getSession$p(this.this$0).getConnection().getAuditService().resultsProcessed(Seance.access$getMark$p(this.this$0));
                                    Seance.access$getSession$p(this.this$0).getConnection().getAuditService().beforeResultsClosing(this.$it, Seance.access$getMark$p(this.this$0));
                                }
                            })));
                            unit = Unit.INSTANCE;
                        } else {
                            unit = null;
                        }
                        return unit;
                    }
                });
            }
            finally {
                this.session.getConnection().getAuditService().afterStatement(this.mark);
            }
        }

        public final void disconnect() {
            block3: {
                for (Cursor<?> openedCursor : this.openedCursors) {
                    openedCursor.disconnect();
                }
                this.openedCursors.clear();
                if (this.session.isClosed()) {
                    return;
                }
                OneTimeInvocation oneTimeInvocation = this.myResultSetInvocation;
                if (oneTimeInvocation != null) {
                    oneTimeInvocation.run();
                }
                OneTimeInvocation oneTimeInvocation2 = this.myStatementInvocation;
                if (oneTimeInvocation2 == null) break block3;
                oneTimeInvocation2.run();
            }
        }

        private final void before() {
            if (this.parameters != null) {
                this.beforePrepared();
                return;
            }
            this.session.getConnection().getAuditService().beforeSimpleStatement(this.sql, this.mark);
        }

        private final void beforePrepared() {
            StatementParameters builder = new StatementParameters();
            Intrinsics.checkNotNull((Object)this.parameters);
            for (Object value2 : this.parameters) {
                builder.obj(value2);
            }
            this.session.getConnection().getAuditService().beforeParameterizedStatement(builder.asData(this.sql), this.mark);
        }

        @Nullable
        public <I> I getSpecificService(@NotNull Class<I> serviceClass, @NotNull String serviceName) {
            Intrinsics.checkNotNullParameter(serviceClass, (String)"serviceClass");
            Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
            return switch (serviceName) {
                case "jdbc-result-set" -> Companion.castTo(serviceClass, this.resultSet);
                case "jdbc-statement" -> Companion.castTo(serviceClass, this.statement);
                case "jdbc-connection" -> this.session.getSpecificService(serviceClass, serviceName);
                default -> null;
            };
        }

        public static final /* synthetic */ ArrayList access$getOpenedCursors$p(Seance $this) {
            return $this.openedCursors;
        }

        public static final /* synthetic */ void access$before(Seance $this) {
            $this.before();
        }

        public static final /* synthetic */ mark.1 access$getMark$p(Seance $this) {
            return $this.mark;
        }

        public static final /* synthetic */ RemoteSeance access$getRemoteSeance$p(Seance $this) {
            return $this.remoteSeance;
        }

        public static final /* synthetic */ Session access$getSession$p(Seance $this) {
            return $this.session;
        }

        public static final /* synthetic */ void access$setResultSet$p(Seance $this, RemoteResultSet remoteResultSet) {
            $this.resultSet = remoteResultSet;
        }

        public static final /* synthetic */ RemoteResultSet access$getResultSet$p(Seance $this) {
            return $this.resultSet;
        }

        public static final /* synthetic */ void access$setMyResultSetInvocation$p(Seance $this, OneTimeInvocation oneTimeInvocation) {
            $this.myResultSetInvocation = oneTimeInvocation;
        }

        public static final /* synthetic */ RemoteStatement access$getStatement$p(Seance $this) {
            return $this.statement;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0010\u001a\u00020\bH\u0016J\u0006\u0010\u0011\u001a\u00020\bJ+\u0010\u0012\u001a\u0004\u0018\u0001H\u0013\"\u0004\b\u0000\u0010\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00130\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016\u00a2\u0006\u0002\u0010\u0018J\b\u0010\u0019\u001a\u00020\u001aH\u0016J)\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00172\u0012\u0010\u001e\u001a\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010 \u0018\u00010\u001fH\u0016\u00a2\u0006\u0002\u0010!R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u000e0\rj\b\u0012\u0004\u0012\u00020\u000e`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/database/dialects/base/introspector/AuditFacade$Session;", "Lcom/intellij/database/remote/jdba/intermediate/PrimeIntermediateSession;", "remoteSession", "Lcom/intellij/database/remote/jdba/RemoteSession;", "connection", "Lcom/intellij/database/dataSource/DatabaseConnectionCore;", "disposalCallback", "Lkotlin/Function1;", "", "(Lcom/intellij/database/remote/jdba/RemoteSession;Lcom/intellij/database/dataSource/DatabaseConnectionCore;Lkotlin/jvm/functions/Function1;)V", "getConnection", "()Lcom/intellij/database/dataSource/DatabaseConnectionCore;", "openedSeances", "Ljava/util/ArrayList;", "Lcom/intellij/database/dialects/base/introspector/AuditFacade$Seance;", "Lkotlin/collections/ArrayList;", "close", "disconnect", "getSpecificService", "I", "serviceClass", "Ljava/lang/Class;", "serviceName", "", "(Ljava/lang/Class;Ljava/lang/String;)Ljava/lang/Object;", "isClosed", "", "openSeance", "Lcom/intellij/database/remote/jdba/intermediate/PrimeIntermediateSeance;", "statementText", "outParameters", "", "Lcom/intellij/database/remote/jdba/core/ParameterDef;", "(Ljava/lang/String;[Lcom/intellij/database/remote/jdba/core/ParameterDef;)Lcom/intellij/database/remote/jdba/intermediate/PrimeIntermediateSeance;", "intellij.database.dialects.base"})
    private static final class Session
    implements PrimeIntermediateSession {
        @NotNull
        private final RemoteSession remoteSession;
        @NotNull
        private final DatabaseConnectionCore connection;
        @NotNull
        private final Function1<Session, Unit> disposalCallback;
        @NotNull
        private final ArrayList<Seance> openedSeances;

        public Session(@NotNull RemoteSession remoteSession, @NotNull DatabaseConnectionCore connection2, @NotNull Function1<? super Session, Unit> disposalCallback) {
            Intrinsics.checkNotNullParameter((Object)remoteSession, (String)"remoteSession");
            Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
            Intrinsics.checkNotNullParameter(disposalCallback, (String)"disposalCallback");
            this.remoteSession = remoteSession;
            this.connection = connection2;
            this.disposalCallback = disposalCallback;
            this.openedSeances = new ArrayList();
        }

        @NotNull
        public final DatabaseConnectionCore getConnection() {
            return this.connection;
        }

        @NotNull
        public PrimeIntermediateSeance openSeance(@NotNull String statementText, @Nullable ParameterDef[] outParameters) {
            Intrinsics.checkNotNullParameter((Object)statementText, (String)"statementText");
            RemoteSeance remoteSeance = this.remoteSession.openSeance(statementText, outParameters);
            Intrinsics.checkNotNullExpressionValue((Object)remoteSeance, (String)"openSeance(...)");
            Seance seance2 = new Seance(remoteSeance, this, statementText, (Function1<? super Seance, Unit>)((Function1)new Function1<Seance, Unit>(this){
                final /* synthetic */ Session this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull Seance it2) {
                    Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                    ((Collection)Session.access$getOpenedSeances$p(this.this$0)).remove(it2);
                }
            }));
            ((Collection)this.openedSeances).add(seance2);
            return seance2;
        }

        public boolean isClosed() {
            return this.remoteSession.isClosed();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            try {
                this.disposalCallback.invoke((Object)this);
                this.disconnect();
            }
            finally {
                this.remoteSession.close();
            }
        }

        public final void disconnect() {
            for (Seance openedSeance : this.openedSeances) {
                openedSeance.disconnect();
            }
            this.openedSeances.clear();
        }

        @Nullable
        public <I> I getSpecificService(@NotNull Class<I> serviceClass, @NotNull String serviceName) {
            Intrinsics.checkNotNullParameter(serviceClass, (String)"serviceClass");
            Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
            String string = serviceName;
            return (I)(Intrinsics.areEqual((Object)string, (Object)"jdbc-connection") ? Companion.castTo(serviceClass, this.connection) : (Intrinsics.areEqual((Object)string, (Object)"jdbc-metadata") ? Companion.castTo(serviceClass, this.connection.getRemoteMetaData()) : null));
        }

        public static final /* synthetic */ ArrayList access$getOpenedSeances$p(Session $this) {
            return $this.openedSeances;
        }
    }
}

