/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.generator;

import com.intellij.database.dialects.base.generator.Operation;
import com.intellij.database.dialects.base.generator.Scenario;
import com.intellij.database.dialects.base.generator.ScenarioDot;
import com.intellij.database.dialects.base.generator.ScriptGeneratorDiagnosticListener;
import com.intellij.database.dialects.base.generator.producers.AlterProducer;
import com.intellij.database.dialects.base.generator.producers.Flag;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.script.generator.DelegateScriptingOptions;
import com.intellij.database.script.generator.ScriptGenerators;
import com.intellij.database.script.generator.ScriptingAlterTask;
import com.intellij.database.script.generator.ScriptingOptionStatic;
import com.intellij.database.script.generator.ScriptingResult;
import com.intellij.database.script.generator.ScriptingSingleModelTask;
import com.intellij.database.script.generator.ScriptingTask;
import com.intellij.database.script.generator.ScriptingTaskBuilder;
import com.intellij.database.script.generator.ScriptingTaskKt;
import com.intellij.database.script.generator.ScriptingTaskSerialisation;
import com.intellij.database.script.generator.ui.ScriptOptionsPanel;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.view.DatabaseDialogsHelper;
import com.intellij.database.view.editors.DatabaseEditorUtil;
import com.intellij.database.view.editors.ShutSplitter;
import com.intellij.database.view.ui.DsUiDefaults;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.impl.RunnerContentUi;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.PinActiveTabAction;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.PathChooserDialog;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.FrameWrapper;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.tools.Tool;
import com.intellij.tools.ToolManager;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.ui.content.Content;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Insets;
import java.awt.event.InputEvent;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScriptGeneratorDiagnosticTool
implements ScriptGeneratorDiagnosticListener {
    private static final Logger LOG = Logger.getInstance(ScriptGeneratorDiagnosticTool.class);
    private static final String PLACE = "script.generator.diagnostic";
    private final Project myProject;
    private volatile Dialog myFrame;

    public ScriptGeneratorDiagnosticTool(@NotNull Project project) {
        if (project == null) {
            ScriptGeneratorDiagnosticTool.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @Override
    public void bump() {
        this.ensureShown();
    }

    @Override
    public void onStart(@NotNull ScriptingTask task) {
        if (task == null) {
            ScriptGeneratorDiagnosticTool.$$$reportNull$$$0(1);
        }
        if (task.getOptions().get(ScriptingOptionStatic.DUMP_TASK).booleanValue()) {
            DumpTaskAction.dump(task);
        }
        if (!ScriptGeneratorDiagnosticTool.shouldRunDiagnostic(task).booleanValue()) {
            return;
        }
        ScriptingTask snapshot = ScriptingTaskSerialisation.snapshot(task);
        String taskId = Dialog.getId(task);
        SwingUtilities.invokeLater(() -> this.ensureShown().onStart(taskId, snapshot));
    }

    @NotNull
    private static Boolean shouldRunDiagnostic(@NotNull ScriptingTask task) {
        if (task == null) {
            ScriptGeneratorDiagnosticTool.$$$reportNull$$$0(2);
        }
        Boolean bl = task.getOptions().get(ScriptingOptionStatic.RUN_DIAGNOSTIC);
        if (bl == null) {
            ScriptGeneratorDiagnosticTool.$$$reportNull$$$0(3);
        }
        return bl;
    }

    private Dialog ensureShown() {
        if (this.myFrame == null) {
            this.myFrame = this.showDialog();
        }
        return this.myFrame;
    }

    @NotNull
    private Dialog showDialog() {
        Dialog frame = new Dialog(this.myProject);
        Disposer.register((Disposable)frame, () -> {
            if (this.myFrame == frame) {
                this.myFrame = null;
            }
        });
        frame.show();
        Dialog dialog = frame;
        if (dialog == null) {
            ScriptGeneratorDiagnosticTool.$$$reportNull$$$0(4);
        }
        return dialog;
    }

    @Override
    public void onGraphReady(@NotNull ScriptingTask task, @NotNull Scenario scenario) {
        if (task == null) {
            ScriptGeneratorDiagnosticTool.$$$reportNull$$$0(5);
        }
        if (scenario == null) {
            ScriptGeneratorDiagnosticTool.$$$reportNull$$$0(6);
        }
        if (!ScriptGeneratorDiagnosticTool.shouldRunDiagnostic(task).booleanValue()) {
            return;
        }
        String taskId = Dialog.getId(task);
        ScenarioDiagnostics diagnostics = new ScenarioDiagnostics(scenario);
        SwingUtilities.invokeLater(() -> this.ensureShown().onGraphReady(taskId, diagnostics));
    }

    @Override
    public void onOperationsReady(@NotNull ScriptingTask task, @NotNull List<Operation> operations) {
        if (task == null) {
            ScriptGeneratorDiagnosticTool.$$$reportNull$$$0(7);
        }
        if (operations == null) {
            ScriptGeneratorDiagnosticTool.$$$reportNull$$$0(8);
        }
        if (!ScriptGeneratorDiagnosticTool.shouldRunDiagnostic(task).booleanValue()) {
            return;
        }
        String taskId = Dialog.getId(task);
        OperationsDiagnostics diagnostics = new OperationsDiagnostics(operations);
        SwingUtilities.invokeLater(() -> this.ensureShown().onOperationsReady(taskId, diagnostics));
    }

    @Nullable
    private static TaskContent getTaskContent(@NotNull AnActionEvent e2) {
        RunnerContentUi ui;
        if (e2 == null) {
            ScriptGeneratorDiagnosticTool.$$$reportNull$$$0(9);
        }
        Content content = (ui = (RunnerContentUi)e2.getData(RunnerContentUi.KEY)) == null ? null : ui.getContentManager().getSelectedContent();
        return (TaskContent)ObjectUtils.tryCast((Object)(content == null ? null : content.getComponent()), TaskContent.class);
    }

    @Nullable
    @NonNls
    private static String getDotActionId() {
        return PropertiesComponent.getInstance().getValue("DotToolActionId");
    }

    private static void setDotActionId(@Nullable String id) {
        PropertiesComponent.getInstance().setValue("DotToolActionId", id);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/base/generator/ScriptGeneratorDiagnosticTool";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scenario";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operations";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/base/generator/ScriptGeneratorDiagnosticTool";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "shouldRunDiagnostic";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "showDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "onStart";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "shouldRunDiagnostic";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "onGraphReady";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "onOperationsReady";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getTaskContent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }

    private static class Dialog
    extends FrameWrapper {
        @NotNull
        private final RunnerLayoutUi myLayout;
        @NotNull
        private final Project myProject;

        protected Dialog(@NotNull Project project) {
            if (project == null) {
                Dialog.$$$reportNull$$$0(0);
            }
            super(project, Dialog.class.getName(), true, "Script Generator Diagnostic");
            this.myProject = project;
            Disposer.register((Disposable)project.getMessageBus(), (Disposable)this);
            this.myLayout = RunnerLayoutUi.Factory.getInstance((Project)project).create("ScriptGeneratorDiagnosticTool", this.getTitle(), this.getTitle(), (Disposable)this);
            this.myLayout.getOptions().setTabPopupActions((ActionGroup)new DefaultActionGroup(new AnAction[]{new PinActiveTabAction.Toggle(), ActionManager.getInstance().getAction("Runner.View.Popup")}));
            JComponent toolbar2 = ActionUtil.createToolbarComponent((JComponent)this.myLayout.getComponent(), (String)ScriptGeneratorDiagnosticTool.PLACE, (ActionGroup)Dialog.getActions(), (boolean)false);
            JPanel panel2 = new JPanel(new BorderLayout());
            panel2.add((Component)toolbar2, "West");
            panel2.add((Component)this.myLayout.getComponent(), "Center");
            this.setComponent(panel2);
            this.closeOnEsc();
            this.getFrame().setModalExclusionType(Dialog.ModalExclusionType.TOOLKIT_EXCLUDE);
        }

        @NotNull
        private static DefaultActionGroup getActions() {
            DefaultActionGroup res2 = new DefaultActionGroup();
            res2.add((AnAction)new LoadTaskAction());
            res2.add((AnAction)new DumpTaskAction());
            res2.add((AnAction)new ViewDotAction());
            res2.add((AnAction)new ViewDotSetUpAction());
            res2.add((AnAction)new GeneratorAction());
            DefaultActionGroup defaultActionGroup = res2;
            if (defaultActionGroup == null) {
                Dialog.$$$reportNull$$$0(1);
            }
            return defaultActionGroup;
        }

        public void onStart(@NotNull String taskId, @NotNull ScriptingTask taskSnapshot) {
            if (taskId == null) {
                Dialog.$$$reportNull$$$0(2);
            }
            if (taskSnapshot == null) {
                Dialog.$$$reportNull$$$0(3);
            }
            for (Content c2 : this.myLayout.getContents()) {
                if (c2.isPinned()) continue;
                this.myLayout.removeContent(c2, true);
            }
            Content content = this.createContent(taskId, taskSnapshot);
            this.myLayout.addContent(content);
        }

        public void onGraphReady(@NotNull String taskId, @NotNull ScenarioDiagnostics diagnostics) {
            Content content;
            TaskContent taskContent;
            if (taskId == null) {
                Dialog.$$$reportNull$$$0(4);
            }
            if (diagnostics == null) {
                Dialog.$$$reportNull$$$0(5);
            }
            TaskContent taskContent2 = taskContent = (content = this.myLayout.findContent(taskId)) == null ? null : (TaskContent)ObjectUtils.tryCast((Object)content.getComponent(), TaskContent.class);
            if (taskContent != null) {
                taskContent.addDiagnostics(diagnostics);
            }
        }

        public void onOperationsReady(@NotNull String taskId, @NotNull OperationsDiagnostics diagnostics) {
            Content content;
            TaskContent taskContent;
            if (taskId == null) {
                Dialog.$$$reportNull$$$0(6);
            }
            if (diagnostics == null) {
                Dialog.$$$reportNull$$$0(7);
            }
            TaskContent taskContent2 = taskContent = (content = this.myLayout.findContent(taskId)) == null ? null : (TaskContent)ObjectUtils.tryCast((Object)content.getComponent(), TaskContent.class);
            if (taskContent != null) {
                taskContent.addDiagnostics(diagnostics);
            }
        }

        @NotNull
        private Content createContent(@NotNull String taskId, @NotNull ScriptingTask task) {
            if (taskId == null) {
                Dialog.$$$reportNull$$$0(8);
            }
            if (task == null) {
                Dialog.$$$reportNull$$$0(9);
            }
            long t = System.currentTimeMillis();
            String name2 = task.getCategory().getDisplayName() + " " + DateFormatUtil.formatDate((long)t) + " " + DateFormatUtil.formatTimeWithSeconds((long)t);
            TaskContent component2 = new TaskContent(this.myProject, task);
            Content content = this.myLayout.createContent(taskId, (JComponent)component2, name2, null, null);
            content.setPinnable(true);
            Content content2 = content;
            if (content2 == null) {
                Dialog.$$$reportNull$$$0(10);
            }
            return content2;
        }

        @NotNull
        private static String getId(@NotNull ScriptingTask task) {
            if (task == null) {
                Dialog.$$$reportNull$$$0(11);
            }
            String string = String.valueOf(System.identityHashCode(task));
            if (string == null) {
                Dialog.$$$reportNull$$$0(12);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 10, 12 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 10: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dialects/base/generator/ScriptGeneratorDiagnosticTool$Dialog";
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "taskId";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "taskSnapshot";
                    break;
                }
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "diagnostics";
                    break;
                }
                case 9: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "task";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dialects/base/generator/ScriptGeneratorDiagnosticTool$Dialog";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActions";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createContent";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 10: 
                case 12: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "onStart";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "onGraphReady";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "onOperationsReady";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "createContent";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "getId";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 10, 12 -> new IllegalStateException(string);
            };
        }
    }

    private static class DumpTaskAction
    extends DumbAwareAction {
        DumpTaskAction() {
            super("Dump", null, AllIcons.Actions.Dump);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                DumpTaskAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e2) {
            if (e2 == null) {
                DumpTaskAction.$$$reportNull$$$0(1);
            }
            e2.getPresentation().setEnabledAndVisible(ScriptGeneratorDiagnosticTool.getTaskContent(e2) != null);
        }

        public void actionPerformed(@NotNull AnActionEvent e2) {
            TaskContent task;
            if (e2 == null) {
                DumpTaskAction.$$$reportNull$$$0(2);
            }
            if ((task = ScriptGeneratorDiagnosticTool.getTaskContent(e2)) == null) {
                return;
            }
            DumpTaskAction.dump(task.myTask);
        }

        private static void dump(ScriptingTask task) {
            try {
                File dumpDir = FileUtil.createTempDirectory((String)"scriptingTaskDump", null);
                File file = ScriptingTaskSerialisation.dumpTask(dumpDir, task);
                UIUtil.invokeLaterIfNeeded(() -> RevealFileAction.openFile((File)file));
            }
            catch (IOException ex) {
                LOG.error((Throwable)ex);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dialects/base/generator/ScriptGeneratorDiagnosticTool$DumpTaskAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dialects/base/generator/ScriptGeneratorDiagnosticTool$DumpTaskAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class ScenarioDiagnostics {
        public final String graphDump;

        private ScenarioDiagnostics(@NotNull Scenario scenario) {
            if (scenario == null) {
                ScenarioDiagnostics.$$$reportNull$$$0(0);
            }
            this.graphDump = new ScenarioDot(scenario).withUnsatisfied(false).withAlteredFlags(true).build(new StringBuilder()).toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scenario", "com/intellij/database/dialects/base/generator/ScriptGeneratorDiagnosticTool$ScenarioDiagnostics", "<init>"));
        }
    }

    private static class OperationsDiagnostics {
        public final String alteredFlags;

        private OperationsDiagnostics(@NotNull List<Operation> operations) {
            if (operations == null) {
                OperationsDiagnostics.$$$reportNull$$$0(0);
            }
            Comparator<Operation> comparator2 = Comparator.comparing(o2 -> o2.getProducer().getPreliminaryOrder());
            List sorted = ContainerUtil.sorted(operations, comparator2);
            this.alteredFlags = OperationsDiagnostics.getAlteredFlags(sorted);
        }

        @Nullable
        private static String getAlteredFlags(List<Operation> operations) {
            StringBuilder res2 = new StringBuilder();
            for (Operation op : operations) {
                AlterProducer ap = (AlterProducer)ObjectUtils.tryCast((Object)op.getProducer(), AlterProducer.class);
                if (ap == null || ap.isEmpty()) continue;
                res2.append(ObjectPaths.of(ap.getData().getElement()).getDisplayName()).append("\n");
                for (Flag flag : ap.getData().getFlags().all()) {
                    if (!flag.getV()) continue;
                    res2.append("  * ").append(flag.getId().name).append("\n");
                }
                res2.append("\n");
            }
            return res2.length() == 0 ? null : res2.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operations", "com/intellij/database/dialects/base/generator/ScriptGeneratorDiagnosticTool$OperationsDiagnostics", "<init>"));
        }
    }

    private static class TaskContent
    extends JPanel {
        private final Project myProject;
        private final ScriptingTask myTask;
        private final JBTabbedPane myTabbedPane;
        private Runnable myGeneratorUpdater;
        private ScenarioDiagnostics myScenarioDiagnostics;

        private TaskContent(@NotNull Project project, @NotNull ScriptingTask task) {
            if (project == null) {
                TaskContent.$$$reportNull$$$0(0);
            }
            if (task == null) {
                TaskContent.$$$reportNull$$$0(1);
            }
            super(new BorderLayout());
            this.myProject = project;
            this.myTask = task;
            this.myTabbedPane = new JBTabbedPane();
            this.myTabbedPane.setTabPlacement(1);
            this.add((Component)this.myTabbedPane, "Center");
            this.addTab("Info", this.createInfoPage());
            this.myTabbedPane.setSelectedIndex(0);
        }

        private JComponent createInfoPage() {
            HtmlBuilder sb = new HtmlBuilder();
            sb.append(this.myTask.getCategory().toString()).br();
            sb.append("DBMS: ").append(ScriptingTaskKt.getDbms(this.myTask).getDisplayName()).append(" (ver. ").append(this.myTask.getVersion().toString()).append(")").br();
            BasicNamespace cur = (BasicNamespace)ObjectUtils.chooseNotNull((Object)this.myTask.getCurrentSchema(), (Object)this.myTask.getCurrentDatabase());
            sb.append("Current namespace: ").append(cur == null ? "null" : ObjectPaths.of(cur).getDisplayName()).br();
            if (this.myTask instanceof ScriptingSingleModelTask) {
                count = ((ScriptingSingleModelTask)this.myTask).getElements().size();
                sb.append("Objects: ").append(String.valueOf(count)).br();
            } else if (this.myTask instanceof ScriptingAlterTask) {
                count = ((ScriptingAlterTask)this.myTask).getCorrespondence().size();
                sb.append("Pairs: ").append(String.valueOf(count)).br();
            }
            JPanel panel2 = new JPanel(new BorderLayout());
            panel2.add((Component)new JBLabel(sb.wrapWithHtmlBody().toString()), "North");
            return panel2;
        }

        public void addDiagnostics(ScenarioDiagnostics diagnostics) {
            this.myScenarioDiagnostics = diagnostics;
            this.addTab("Graph", this.createViewer(diagnostics.graphDump, "aaa.dot"));
        }

        private void addTab(String title, JComponent tab2) {
            this.myTabbedPane.addTab(title, (Component)tab2);
            tab2.setOpaque(true);
            Insets insets = UIUtil.PANEL_REGULAR_INSETS;
            tab2.setBorder((Border)JBUI.Borders.empty((int)insets.top, (int)insets.left, (int)0, (int)0));
        }

        public void addDiagnostics(OperationsDiagnostics diagnostics) {
            if (diagnostics.alteredFlags != null) {
                this.addTab("Altered Flags", this.createViewer(diagnostics.alteredFlags, "aaa.txt"));
            }
        }

        @NotNull
        private JComponent createViewer(String text2, String fileName) {
            FileType fileType = FileTypeRegistry.getInstance().getFileTypeByFileName(fileName);
            Document document = EditorFactory.getInstance().createDocument((CharSequence)text2);
            EditorTextField field = new EditorTextField(document, this.myProject, fileType, true, false);
            field.addSettingsProvider(editor2 -> {
                editor2.getScrollPane().setBorder(null);
                editor2.setVerticalScrollbarVisible(true);
                editor2.setHorizontalScrollbarVisible(true);
            });
            EditorTextField editorTextField2 = field;
            if (editorTextField2 == null) {
                TaskContent.$$$reportNull$$$0(2);
            }
            return editorTextField2;
        }

        public void addGenerator() {
            if (this.myGeneratorUpdater != null) {
                this.myGeneratorUpdater.run();
            } else {
                this.addTab("Generator", this.createGenerator());
            }
        }

        private JComponent createGenerator() {
            EditorTextField editor2 = DatabaseDialogsHelper.createLanguageEditorArea(this.myProject, ScriptingTaskKt.getDbms(this.myTask), null, null, "", true);
            ScriptOptionsPanel settings = new ScriptOptionsPanel((Function0<Unit>)((Function0)() -> {
                if (this.myGeneratorUpdater != null) {
                    this.myGeneratorUpdater.run();
                }
                return null;
            }));
            this.myGeneratorUpdater = () -> {
                ScriptingTaskBuilder task = ScriptingTaskSerialisation.copyTask(this.myTask, false);
                if (task != null) {
                    task.setOptions(settings.gatherOptions());
                    ScriptingResult result2 = ScriptGenerators.INSTANCE.makeScript(this.myProject, task.build());
                    editor2.setText(result2.getScriptText());
                }
            };
            ShutSplitter splitter = DatabaseEditorUtil.createHideableSplitter("Settings", (JComponent)editor2, settings.getComponent(), null, 0.5f);
            settings.getComponent().setBorder(DsUiDefaults.DEFAULT_PANEL_BORDER);
            DelegateScriptingOptions options2 = new DelegateScriptingOptions(this.myTask.getOptions());
            options2.set(ScriptingOptionStatic.RUN_DIAGNOSTIC, false);
            options2.set(ScriptingOptionStatic.DUMP_TASK, false);
            settings.adjustOptionsUI(this.myTask, options2);
            this.myGeneratorUpdater.run();
            return splitter;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "task";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dialects/base/generator/ScriptGeneratorDiagnosticTool$TaskContent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dialects/base/generator/ScriptGeneratorDiagnosticTool$TaskContent";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createViewer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    public static class ShowAction
    extends DumbAwareAction {
        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                ShowAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e2) {
            if (e2 == null) {
                ShowAction.$$$reportNull$$$0(1);
            }
            e2.getPresentation().setEnabledAndVisible(e2.getProject() != null);
        }

        public void actionPerformed(@NotNull AnActionEvent e2) {
            Project project;
            if (e2 == null) {
                ShowAction.$$$reportNull$$$0(2);
            }
            if ((project = e2.getProject()) != null) {
                ((ScriptGeneratorDiagnosticListener)project.getMessageBus().syncPublisher(ScriptGeneratorDiagnosticListener.TOPIC)).bump();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dialects/base/generator/ScriptGeneratorDiagnosticTool$ShowAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dialects/base/generator/ScriptGeneratorDiagnosticTool$ShowAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class LoadTaskAction
    extends DumbAwareAction {
        LoadTaskAction() {
            super("Load", null, AllIcons.Actions.AddFile);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                LoadTaskAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void actionPerformed(@NotNull AnActionEvent e2) {
            if (e2 == null) {
                LoadTaskAction.$$$reportNull$$$0(1);
            }
            FileChooserDescriptor descriptor2 = new FileChooserDescriptor(true, false, false, false, false, false){

                public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
                    return file.isDirectory() || file.getName().equals("task.xml");
                }
            };
            Project project = e2.getProject();
            PathChooserDialog chooser = FileChooserFactory.getInstance().createPathChooser(descriptor2, project, null);
            chooser.choose(null, vfile -> {
                File dir;
                VirtualFile item = (VirtualFile)ContainerUtil.getFirstItem((List)vfile);
                if (item == null) {
                    return;
                }
                Path path = LocalFileSystem.getInstance().getNioPath(item);
                File file = path == null ? null : path.toFile();
                File file2 = dir = file == null ? null : file.getParentFile();
                if (dir == null) {
                    return;
                }
                LoadTaskAction.loadFromDir(project, dir);
            });
        }

        private static void loadFromDir(Project project, File dir) {
            try {
                ScriptingTaskBuilder task = ScriptingTaskSerialisation.loadTask(dir);
                if (!task.getOptions().get(ScriptingOptionStatic.RUN_DIAGNOSTIC).booleanValue()) {
                    DelegateScriptingOptions options2 = new DelegateScriptingOptions(task.getOptions());
                    options2.set(ScriptingOptionStatic.RUN_DIAGNOSTIC, true);
                    task.setOptions(options2);
                }
                ScriptGenerators.INSTANCE.makeScript(project, task.build());
            }
            catch (IOException ex) {
                LOG.error((Throwable)ex);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dialects/base/generator/ScriptGeneratorDiagnosticTool$LoadTaskAction";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dialects/base/generator/ScriptGeneratorDiagnosticTool$LoadTaskAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class ViewDotAction
    extends DumbAwareAction {
        ViewDotAction() {
            super("View", null, AllIcons.General.LayoutPreviewOnly);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                ViewDotAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e2) {
            if (e2 == null) {
                ViewDotAction.$$$reportNull$$$0(1);
            }
            TaskContent content = ScriptGeneratorDiagnosticTool.getTaskContent(e2);
            Tool tool = ViewDotAction.getTool();
            e2.getPresentation().setVisible(content != null);
            e2.getPresentation().setEnabled(tool != null);
            e2.getPresentation().setDescription(tool == null ? "No dot tool configured" : null);
        }

        @Nullable
        private static Tool getTool() {
            String id = ScriptGeneratorDiagnosticTool.getDotActionId();
            return id == null ? null : (Tool)ContainerUtil.find((Iterable)ToolManager.getInstance().getTools(), t -> t.getActionId().equals(id));
        }

        public void actionPerformed(@NotNull AnActionEvent e2) {
            if (e2 == null) {
                ViewDotAction.$$$reportNull$$$0(2);
            }
            Tool tool = ViewDotAction.getTool();
            TaskContent content = ScriptGeneratorDiagnosticTool.getTaskContent(e2);
            if (tool == null || content == null || content.myScenarioDiagnostics == null) {
                return;
            }
            AnAction action = ActionManager.getInstance().getAction(tool.getActionId());
            if (action == null) {
                return;
            }
            AnActionEvent event = ViewDotAction.patchEvent(e2, content.myScenarioDiagnostics);
            if (event == null) {
                return;
            }
            ActionUtil.performActionDumbAwareWithCallbacks((AnAction)action, (AnActionEvent)event);
        }

        @Nullable
        private static AnActionEvent patchEvent(@NotNull AnActionEvent e2, ScenarioDiagnostics scenarioDiagnostics) {
            if (e2 == null) {
                ViewDotAction.$$$reportNull$$$0(3);
            }
            try {
                File temp = FileUtil.createTempFile((String)"scenario", (String)".dot", (boolean)true);
                FileUtil.writeToFile((File)temp, (String)scenarioDiagnostics.graphDump);
                VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(temp);
                if (file == null) {
                    return null;
                }
                DataContext context = SimpleDataContext.getSimpleContext((DataKey)CommonDataKeys.VIRTUAL_FILE, (Object)file, (DataContext)e2.getDataContext());
                return AnActionEvent.createFromDataContext((String)e2.getPlace(), (Presentation)e2.getPresentation(), (DataContext)context);
            }
            catch (IOException ex) {
                LOG.warn((Throwable)ex);
                return null;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dialects/base/generator/ScriptGeneratorDiagnosticTool$ViewDotAction";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dialects/base/generator/ScriptGeneratorDiagnosticTool$ViewDotAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "patchEvent";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class GeneratorAction
    extends DumbAwareAction {
        GeneratorAction() {
            super("Add Script Generator", null, AllIcons.Actions.Execute);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                GeneratorAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void actionPerformed(@NotNull AnActionEvent e2) {
            TaskContent content;
            if (e2 == null) {
                GeneratorAction.$$$reportNull$$$0(1);
            }
            if ((content = ScriptGeneratorDiagnosticTool.getTaskContent(e2)) != null) {
                content.addGenerator();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dialects/base/generator/ScriptGeneratorDiagnosticTool$GeneratorAction";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dialects/base/generator/ScriptGeneratorDiagnosticTool$GeneratorAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class ViewDotSetUpAction
    extends DumbAwareAction {
        ViewDotSetUpAction() {
            super("Set Up Viewer", null, AllIcons.General.GearPlain);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                ViewDotSetUpAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void actionPerformed(@NotNull AnActionEvent e2) {
            Component component2;
            if (e2 == null) {
                ViewDotSetUpAction.$$$reportNull$$$0(1);
            }
            List tools = ToolManager.getInstance().getTools();
            JBPopup popup2 = JBPopupFactory.getInstance().createPopupChooserBuilder(tools).setRenderer((ListCellRenderer)new ColoredListCellRenderer<Tool>(){

                protected void customizeCellRenderer(@NotNull JList<? extends Tool> list, Tool value2, int index2, boolean selected, boolean hasFocus) {
                    if (list == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (value2 == null) {
                        return;
                    }
                    this.setIcon(value2.getActionId().equals(ScriptGeneratorDiagnosticTool.getDotActionId()) ? AllIcons.Actions.Checked : EmptyIcon.ICON_13);
                    this.append(value2.getName());
                    String description = value2.getDescription();
                    if (description != null) {
                        this.append(description, SimpleTextAttributes.GRAY_ATTRIBUTES, 10, 4);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/database/dialects/base/generator/ScriptGeneratorDiagnosticTool$ViewDotSetUpAction$1", "customizeCellRenderer"));
                }
            }).setItemChosenCallback(tool -> {
                String id = tool.getActionId();
                ScriptGeneratorDiagnosticTool.setDotActionId(id.equals(ScriptGeneratorDiagnosticTool.getDotActionId()) ? null : id);
            }).createPopup();
            InputEvent inputEvent = e2.getInputEvent();
            Component component3 = component2 = inputEvent == null ? null : inputEvent.getComponent();
            if (component2 != null) {
                popup2.showUnderneathOf(component2);
            } else {
                popup2.showInBestPositionFor(e2.getDataContext());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dialects/base/generator/ScriptGeneratorDiagnosticTool$ViewDotSetUpAction";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dialects/base/generator/ScriptGeneratorDiagnosticTool$ViewDotSetUpAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    }
}

