/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.generator;

import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\f\u001a\u00020\rJ\r\u0010\u000e\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u000fR\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/dialects/base/generator/LinkedPriorityQueue;", "T", "", "cmp", "Ljava/util/Comparator;", "(Ljava/util/Comparator;)V", "map", "Ljava/util/TreeMap;", "add", "", "t", "(Ljava/lang/Object;)V", "isEmpty", "", "poll", "()Ljava/lang/Object;", "intellij.database.dialects.base"})
final class LinkedPriorityQueue<T> {
    @NotNull
    private final TreeMap<T, Object> map;

    public LinkedPriorityQueue(@NotNull Comparator<T> cmp) {
        Intrinsics.checkNotNullParameter(cmp, (String)"cmp");
        this.map = new TreeMap(cmp);
    }

    public final void add(T t) {
        Object v2 = this.map.get(t);
        if (v2 == null) {
            Map map2 = this.map;
            Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type kotlin.Any");
            map2.put(t, t);
        } else if (!Intrinsics.areEqual((Object)v2, t)) {
            if (TypeIntrinsics.isMutableCollection((Object)v2)) {
                TypeIntrinsics.asMutableCollection((Object)v2).add(t);
            } else {
                Map map3 = this.map;
                Object[] objectArray = new Object[]{v2, t};
                LinkedHashSet linkedHashSet = ContainerUtil.newLinkedHashSet((Object[])objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)linkedHashSet, (String)"newLinkedHashSet(...)");
                LinkedHashSet linkedHashSet2 = linkedHashSet;
                map3.put(t, linkedHashSet2);
            }
        }
    }

    @Nullable
    public final T poll() {
        Object object;
        Map.Entry<T, Object> entry = this.map.firstEntry();
        if (entry == null) {
            return null;
        }
        Map.Entry<T, Object> entry2 = entry;
        T k = entry2.getKey();
        Object v2 = entry2.getValue();
        if (TypeIntrinsics.isMutableCollection((Object)v2)) {
            Iterator it2 = ((Collection)v2).iterator();
            boolean bl = it2.hasNext();
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            Object res2 = it2.next();
            it2.remove();
            if (!it2.hasNext()) {
                this.map.remove(k);
            }
            object = res2;
        } else {
            this.map.remove(k);
            object = v2;
        }
        return (T)object;
    }

    public final boolean isEmpty() {
        return this.map.isEmpty();
    }
}

