/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.generator;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.generator.AbstractCodeGenerator;
import com.intellij.database.dialects.base.generator.AbstractCodeGeneratorKt;
import com.intellij.database.dialects.base.generator.AbstractScriptGenerator;
import com.intellij.database.dialects.base.generator.AbstractScriptGeneratorKt;
import com.intellij.database.dialects.base.generator.AbstractTransitionCodeGenerator;
import com.intellij.database.dialects.base.generator.BaseAlterGenerator;
import com.intellij.database.dialects.base.generator.BaseCreateGenerator;
import com.intellij.database.dialects.base.generator.BaseDropGenerator;
import com.intellij.database.dialects.base.generator.BaseEnableDisableGenerator;
import com.intellij.database.dialects.base.generator.BaseNativeDefinitionsGenerator;
import com.intellij.database.dialects.base.generator.BaseRecompileGenerator;
import com.intellij.database.dialects.base.generator.BaseRefreshMatViewGenerator;
import com.intellij.database.dialects.base.generator.BaseTruncateGenerator;
import com.intellij.database.dialects.base.generator.Operation;
import com.intellij.database.dialects.base.generator.OrSupportedImpl;
import com.intellij.database.dialects.base.generator.ScriptGeneratorDiagnosticListener;
import com.intellij.database.dialects.base.generator.ScriptGeneratorHelper;
import com.intellij.database.dialects.base.generator.ScriptingCapabilitiesImpl;
import com.intellij.database.dialects.base.generator.ScriptingContext;
import com.intellij.database.dialects.base.generator.SupportedSinceImpl;
import com.intellij.database.dialects.base.generator.producers.AlterProducer;
import com.intellij.database.dialects.base.generator.producers.CreateProducer;
import com.intellij.database.dialects.base.generator.producers.DropProducer;
import com.intellij.database.dialects.base.generator.producers.RecompileProducer;
import com.intellij.database.dialects.base.generator.producers.TruncateProducer;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ElementAlteration;
import com.intellij.database.model.PerObjectVersion;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIndex;
import com.intellij.database.model.basic.BasicKey;
import com.intellij.database.model.basic.BasicMatView;
import com.intellij.database.model.basic.BasicRoutine;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.model.meta.BasicMetaId;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaPropertyId;
import com.intellij.database.model.properties.CompositeText;
import com.intellij.database.script.generator.CodeTextBuilder;
import com.intellij.database.script.generator.DefaultScriptingOptions;
import com.intellij.database.script.generator.ScriptCategory;
import com.intellij.database.script.generator.ScriptGenerator;
import com.intellij.database.script.generator.ScriptingCapabilities;
import com.intellij.database.script.generator.ScriptingInternalTask;
import com.intellij.database.script.generator.ScriptingOption;
import com.intellij.database.script.generator.ScriptingOptionStatic;
import com.intellij.database.script.generator.ScriptingOptions;
import com.intellij.database.script.generator.ScriptingResult;
import com.intellij.database.script.generator.ScriptingTask;
import com.intellij.database.script.generator.ScriptingTaskKt;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.Version;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00c8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001:\u0002PQB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0011\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0013\u0018\u00010\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\"\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u001f2\u0006\u0010 \u001a\u00020\u00192\u0006\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020#J\u0010\u0010$\u001a\u00020%2\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\u0016\u0010&\u001a\u00020\u001d2\u0006\u0010'\u001a\u00020(2\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010)\u001a\u00020*2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010+\u001a\u00020,2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010-\u001a\u00020.2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010/\u001a\u00020.2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u00100\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020#H\u0002J\u0015\u00101\u001a\u00020.2\u0006\u0010\u001c\u001a\u00020\u001dH\u0010\u00a2\u0006\u0002\b2J\u0010\u00103\u001a\u00020.2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u00104\u001a\u00020.2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u00105\u001a\u0002062\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u001a\u00107\u001a\u0004\u0018\u0001082\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010'\u001a\u00020(H\u0002J\u0018\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020>H\u0016J \u0010?\u001a\u00020:2\u0006\u0010 \u001a\u00020\u00192\u0006\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020#H\u0016J\u0018\u0010@\u001a\u00020:2\u0006\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020DH\u0016J\u0014\u0010E\u001a\u00020:2\n\u0010F\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0016J\u0018\u0010G\u001a\u00020H2\u0006\u0010'\u001a\u00020(2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010I\u001a\u00020J2\u0006\u0010;\u001a\u00020<H\u0016J\u001a\u0010K\u001a\u0004\u0018\u00010L2\u0006\u0010'\u001a\u00020(2\u0006\u0010M\u001a\u00020NH\u0016J\b\u0010O\u001a\u00020JH\u0016R\u0012\u0010\u0005\u001a\u00060\u0006R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0012\u0010\r\u001a\u00020\u000eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006R"}, d2={"Lcom/intellij/database/dialects/base/generator/AbstractScriptGenerator;", "Lcom/intellij/database/script/generator/ScriptGenerator;", "dbms", "Lcom/intellij/database/Dbms;", "(Lcom/intellij/database/Dbms;)V", "caps", "Lcom/intellij/database/dialects/base/generator/AbstractScriptGenerator$CapabilitiesCollector;", "createVersion", "Lcom/intellij/database/model/PerObjectVersion;", "getCreateVersion", "()Lcom/intellij/database/model/PerObjectVersion;", "getDbms", "()Lcom/intellij/database/Dbms;", "generatorHelper", "Lcom/intellij/database/dialects/base/generator/ScriptGeneratorHelper;", "getGeneratorHelper", "()Lcom/intellij/database/dialects/base/generator/ScriptGeneratorHelper;", "availableOptions", "", "Lcom/intellij/database/script/generator/ScriptingOption;", "task", "Lcom/intellij/database/script/generator/ScriptingTask;", "capabilities", "Lcom/intellij/database/script/generator/ScriptingCapabilities;", "element", "Lcom/intellij/database/model/basic/BasicElement;", "createAlterGenerator", "Lcom/intellij/database/dialects/base/generator/BaseAlterGenerator;", "context", "Lcom/intellij/database/dialects/base/generator/ScriptingContext;", "createAlterProducer", "Lcom/intellij/database/dialects/base/generator/producers/AlterProducer;", "e1", "e2", "options", "Lcom/intellij/database/script/generator/ScriptingOptions;", "createCapsKey", "", "createContext", "project", "Lcom/intellij/openapi/project/Project;", "createCreatingGenerator", "Lcom/intellij/database/dialects/base/generator/BaseCreateGenerator;", "createDropGenerator", "Lcom/intellij/database/dialects/base/generator/BaseDropGenerator;", "createEnableDisableGenerator", "Lcom/intellij/database/dialects/base/generator/AbstractCodeGenerator;", "createExecuteGenerator", "createFakeContext", "createGenerator", "createGenerator$intellij_database_dialects_base", "createNativeDefinitionsGenerator", "createRefreshingGenerator", "createTruncateGenerator", "Lcom/intellij/database/dialects/base/generator/BaseTruncateGenerator;", "getDiagnosticTool", "Lcom/intellij/database/dialects/base/generator/ScriptGeneratorDiagnosticListener;", "isDefaultSize", "", "dt", "Lcom/intellij/database/model/DataType;", "version", "Lcom/intellij/database/util/Version;", "isEqual", "isIndexExplicitFor", "index", "Lcom/intellij/database/model/basic/BasicIndex;", "key", "Lcom/intellij/database/model/basic/BasicKey;", "isOptionSupported", "option", "makeScript", "Lcom/intellij/database/script/generator/ScriptingResult;", "prettyPrint", "", "reviseSource", "Lcom/intellij/database/model/properties/CompositeText;", "e", "Lcom/intellij/database/model/basic/BasicSourceAware;", "toString", "CapabilitiesCollector", "StupidGenerator", "intellij.database.dialects.base"})
@SourceDebugExtension(value={"SMAP\nAbstractScriptGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractScriptGenerator.kt\ncom/intellij/database/dialects/base/generator/AbstractScriptGenerator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,338:1\n1#2:339\n*E\n"})
public abstract class AbstractScriptGenerator
implements ScriptGenerator {
    @NotNull
    private final Dbms dbms;
    @NotNull
    private final CapabilitiesCollector caps;
    @NotNull
    private final PerObjectVersion createVersion;

    public AbstractScriptGenerator(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        this.dbms = dbms;
        this.caps = new CapabilitiesCollector();
        this.createVersion = new PerObjectVersion();
    }

    @NotNull
    public final Dbms getDbms() {
        return this.dbms;
    }

    @NotNull
    protected final PerObjectVersion getCreateVersion() {
        return this.createVersion;
    }

    @NotNull
    public abstract ScriptGeneratorHelper getGeneratorHelper();

    @Override
    public boolean isIndexExplicitFor(@NotNull BasicIndex index2, @NotNull BasicKey key2) {
        Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        return this.getGeneratorHelper().isIndexExplicitFor(this.createFakeContext(DefaultScriptingOptions.INSTANCE), index2, key2);
    }

    @Override
    public boolean isDefaultSize(@NotNull DataType dt, @NotNull Version version) {
        Intrinsics.checkNotNullParameter((Object)dt, (String)"dt");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        return this.getGeneratorHelper().isDefaultSize(dt, version);
    }

    @Override
    @NotNull
    public ScriptingResult makeScript(@NotNull Project project, @NotNull ScriptingTask task) {
        ScriptGeneratorDiagnosticListener diagnosticTool;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        boolean bl2 = bl = Intrinsics.areEqual((Object)this.dbms, (Object)Dbms.UNKNOWN) || Intrinsics.areEqual((Object)ScriptingTaskKt.getDbms(task), (Object)this.dbms);
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-AbstractScriptGenerator$makeScript$22 = false;
            String $i$a$-assert-AbstractScriptGenerator$makeScript$22 = "wrong model: " + ScriptingTaskKt.getDbms(task) + " vs " + this.dbms;
            throw new AssertionError((Object)$i$a$-assert-AbstractScriptGenerator$makeScript$22);
        }
        ScriptGeneratorDiagnosticListener scriptGeneratorDiagnosticListener = diagnosticTool = this.getDiagnosticTool(task, project);
        if (scriptGeneratorDiagnosticListener != null) {
            scriptGeneratorDiagnosticListener.onStart(task);
        }
        ScriptingContext context = this.createContext(project, task);
        AbstractCodeGenerator generator = this.createGenerator$intellij_database_dialects_base(context);
        if (!(generator instanceof AbstractTransitionCodeGenerator)) {
            generator.prepareScenario();
            ScriptGeneratorDiagnosticListener scriptGeneratorDiagnosticListener2 = diagnosticTool;
            if (scriptGeneratorDiagnosticListener2 != null) {
                scriptGeneratorDiagnosticListener2.onOperationsReady(task, generator.preparedOperations$intellij_database_dialects_base());
            }
            generator.resolve();
            generator.transform();
            ScriptGeneratorDiagnosticListener scriptGeneratorDiagnosticListener3 = diagnosticTool;
            if (scriptGeneratorDiagnosticListener3 != null) {
                scriptGeneratorDiagnosticListener3.onGraphReady(task, generator.getScenario$intellij_database_dialects_base());
            }
            generator.produce();
        } else {
            ((AbstractTransitionCodeGenerator)generator).generate();
        }
        generator.flush();
        ScriptingResult scriptingResult = context.getResult();
        if (scriptingResult == null) {
            scriptingResult = AbstractCodeGeneratorKt.createResult(context);
        }
        return scriptingResult;
    }

    private final ScriptGeneratorDiagnosticListener getDiagnosticTool(ScriptingTask task, Project project) {
        ScriptGeneratorDiagnosticListener scriptGeneratorDiagnosticListener;
        if (task.getOptions().get(ScriptingOptionStatic.RUN_DIAGNOSTIC).booleanValue() || task.getOptions().get(ScriptingOptionStatic.DUMP_TASK).booleanValue()) {
            MessageBus messageBus = project.getMessageBus();
            Topic<ScriptGeneratorDiagnosticListener> topic = ScriptGeneratorDiagnosticListener.TOPIC;
            Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
            scriptGeneratorDiagnosticListener = (ScriptGeneratorDiagnosticListener)messageBus.syncPublisher(topic);
        } else {
            scriptGeneratorDiagnosticListener = null;
        }
        return scriptGeneratorDiagnosticListener;
    }

    @NotNull
    public final ScriptingContext createContext(@NotNull Project project, @NotNull ScriptingTask task) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        return new ScriptingContext(project, task, this.getGeneratorHelper());
    }

    @NotNull
    public AbstractCodeGenerator createGenerator$intellij_database_dialects_base(@NotNull ScriptingContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return switch (WhenMappings.$EnumSwitchMapping$0[context.getTask().getCategory().ordinal()]) {
            case 1, 2 -> this.createCreatingGenerator(context);
            case 3 -> this.createNativeDefinitionsGenerator(context);
            case 4, 5 -> this.createEnableDisableGenerator(context);
            case 6 -> this.createRefreshingGenerator(context);
            case 7 -> this.createExecuteGenerator(context);
            case 8 -> this.createAlterGenerator(context);
            case 9 -> this.createDropGenerator(context);
            case 10 -> this.createTruncateGenerator(context);
            case 11 -> new BaseRecompileGenerator(context);
            default -> new StupidGenerator(context);
        };
    }

    private final BaseCreateGenerator createCreatingGenerator(ScriptingContext context) {
        return new BaseCreateGenerator(context, null, 2, null);
    }

    @NotNull
    public AbstractCodeGenerator createNativeDefinitionsGenerator(@NotNull ScriptingContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new BaseNativeDefinitionsGenerator(context);
    }

    @NotNull
    public AbstractCodeGenerator createEnableDisableGenerator(@NotNull ScriptingContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new BaseEnableDisableGenerator(context);
    }

    @NotNull
    public AbstractCodeGenerator createRefreshingGenerator(@NotNull ScriptingContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new BaseRefreshMatViewGenerator(context);
    }

    @NotNull
    public AbstractCodeGenerator createExecuteGenerator(@NotNull ScriptingContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new StupidGenerator(context);
    }

    private final BaseDropGenerator createDropGenerator(ScriptingContext context) {
        return new BaseDropGenerator(context, null, 2, null);
    }

    @NotNull
    public BaseTruncateGenerator createTruncateGenerator(@NotNull ScriptingContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new BaseTruncateGenerator(context);
    }

    @NotNull
    public BaseAlterGenerator createAlterGenerator(@NotNull ScriptingContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Operation it2 = AbstractCodeGeneratorKt.createRootOperation(context);
        boolean bl = false;
        return new BaseAlterGenerator(context, it2, new BaseCreateGenerator(context, it2), new BaseDropGenerator(context, it2));
    }

    @NotNull
    public String toString() {
        return "ScriptingService for " + this.dbms + ".";
    }

    @Override
    @NotNull
    public ScriptingCapabilities capabilities(@NotNull BasicElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        return this.caps.get(element2);
    }

    @Override
    public boolean isEqual(@NotNull BasicElement e1, @NotNull BasicElement e2, @NotNull ScriptingOptions options2) {
        Intrinsics.checkNotNullParameter((Object)e1, (String)"e1");
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e2");
        Intrinsics.checkNotNullParameter((Object)options2, (String)"options");
        return this.createAlterProducer(e1, e2, options2).isEmpty();
    }

    @NotNull
    public final AlterProducer<?> createAlterProducer(@NotNull BasicElement e1, @NotNull BasicElement e2, @NotNull ScriptingOptions options2) {
        Intrinsics.checkNotNullParameter((Object)e1, (String)"e1");
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e2");
        Intrinsics.checkNotNullParameter((Object)options2, (String)"options");
        ScriptingContext context = this.createFakeContext(options2);
        ElementAlteration<BasicElement> elements2 = new ElementAlteration<BasicElement>(e1, e2);
        ((Map)context.getBySource()).put(e1, elements2);
        ((Map)context.getByTarget()).put(e2, elements2);
        return this.getGeneratorHelper().createAlterProducer(context, elements2);
    }

    private final ScriptingContext createFakeContext(ScriptingOptions options2) {
        Project project = DbImplUtilCore.getAnyProject();
        if (project == null) {
            project = ProjectManager.getInstance().getDefaultProject();
        }
        Project project2 = project;
        Intrinsics.checkNotNull((Object)project2);
        Project project3 = project2;
        return this.createContext(project3, new ScriptingInternalTask(this.dbms, ScriptCategory.CREATE_COMPLETE, options2));
    }

    @Override
    @Nullable
    public CompositeText reviseSource(@NotNull Project project, @NotNull BasicSourceAware e2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        ScriptingInternalTask task = new ScriptingInternalTask(this.dbms, ScriptCategory.CREATE_COMPLETE, null, 4, null);
        return this.getGeneratorHelper().createProducer(this.createContext(project, task), e2).revisedSource();
    }

    @Override
    @NotNull
    public String prettyPrint(@NotNull DataType dt) {
        Intrinsics.checkNotNullParameter((Object)dt, (String)"dt");
        return this.getGeneratorHelper().script(dt, null, null);
    }

    @Override
    @Nullable
    public Set<ScriptingOption<?>> availableOptions(@NotNull ScriptingTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        return this.getGeneratorHelper().availableOptions(task);
    }

    @Override
    public boolean isOptionSupported(@NotNull ScriptingOption<?> option) {
        Intrinsics.checkNotNullParameter(option, (String)"option");
        return this.getGeneratorHelper().isOptionSupported(option);
    }

    @NotNull
    protected Object createCapsKey(@NotNull BasicElement element2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        BasicMetaObject<?> it2 = element2.getMetaObject();
        boolean bl = false;
        BasicElement basicElement = element2;
        if (basicElement instanceof BasicRoutine) {
            object = TuplesKt.to(it2, (Object)((Object)((BasicRoutine)element2).getRoutineKind()));
        } else if (basicElement instanceof BasicKey) {
            object = TuplesKt.to(it2, (Object)((BasicKey)element2).isPrimary());
        } else {
            Intrinsics.checkNotNull(it2);
            object = it2;
        }
        return object;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J/\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u001a\u0010\t\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u000b0\n\"\u0006\u0012\u0002\b\u00030\u000bH\u0002\u00a2\u0006\u0002\u0010\fJ \u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0010\u0010\r\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\u0007H\u0002J\u000e\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J3\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u001e\u0010\t\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\n\"\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002\u00a2\u0006\u0002\u0010\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/database/dialects/base/generator/AbstractScriptGenerator$CapabilitiesCollector;", "", "(Lcom/intellij/database/dialects/base/generator/AbstractScriptGenerator;)V", "caps", "Ljava/util/HashMap;", "Lcom/intellij/database/script/generator/ScriptingCapabilities;", "extractVersions", "", "Lcom/intellij/database/util/Version;", "vs", "", "Lcom/intellij/database/script/generator/ScriptingCapabilities$VersionedCapability;", "([Lcom/intellij/database/script/generator/ScriptingCapabilities$VersionedCapability;)Ljava/lang/Iterable;", "iter", "get", "element", "Lcom/intellij/database/model/basic/BasicElement;", "getCaps", "Lcom/intellij/database/dialects/base/generator/ScriptingCapabilitiesImpl;", "project", "Lcom/intellij/openapi/project/Project;", "merge", "([Ljava/lang/Iterable;)Ljava/lang/Iterable;", "intellij.database.dialects.base"})
    @SourceDebugExtension(value={"SMAP\nAbstractScriptGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractScriptGenerator.kt\ncom/intellij/database/dialects/base/generator/AbstractScriptGenerator$CapabilitiesCollector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,338:1\n1#2:339\n13309#3,2:340\n*S KotlinDebug\n*F\n+ 1 AbstractScriptGenerator.kt\ncom/intellij/database/dialects/base/generator/AbstractScriptGenerator$CapabilitiesCollector\n*L\n230#1:340,2\n*E\n"})
    private final class CapabilitiesCollector {
        @NotNull
        private final HashMap<Object, ScriptingCapabilities> caps = new HashMap();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final ScriptingCapabilities get(@NotNull BasicElement element2) {
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            Object key2 = AbstractScriptGenerator.this.createCapsKey(element2);
            ScriptingCapabilities scriptingCapabilities = this.caps.get(key2);
            if (scriptingCapabilities != null) {
                ScriptingCapabilities it2 = scriptingCapabilities;
                boolean bl = false;
                return it2;
            }
            Project project = DbImplUtilCore.getAnyProject();
            if (project == null) {
                project = ProjectManager.getInstance().getDefaultProject();
            }
            Project project2 = project;
            Intrinsics.checkNotNull((Object)project2);
            Project project3 = project2;
            ScriptingCapabilitiesImpl cap = this.getCaps(project3, element2);
            HashMap<Object, ScriptingCapabilities> hashMap = this.caps;
            synchronized (hashMap) {
                boolean bl = false;
                ((Map)this.caps).put(key2, cap);
                Unit unit = Unit.INSTANCE;
            }
            return cap;
        }

        private final ScriptingCapabilitiesImpl getCaps(Project project, BasicElement element2) {
            ScriptingInternalTask task = new ScriptingInternalTask(AbstractScriptGenerator.this.getDbms(), ScriptCategory.CREATE_COMPLETE, null, 4, null);
            ScriptingContext context = AbstractScriptGenerator.this.createContext(project, task);
            CreateProducer<?> c2 = AbstractScriptGenerator.this.getGeneratorHelper().createProducer(context, element2);
            DropProducer<?> d2 = AbstractScriptGenerator.this.getGeneratorHelper().createDropProducer(context, element2);
            AlterProducer<?> a = AbstractScriptGenerator.this.getGeneratorHelper().createAlterProducer(context, new ElementAlteration<BasicElement>(element2, element2));
            TruncateProducer<?> t = AbstractScriptGenerator.this.getGeneratorHelper().createTruncateProducer(context, element2);
            RecompileProducer<?> r = AbstractScriptGenerator.this.getGeneratorHelper().createRecompileProducer(context, element2);
            ScriptingCapabilities.VersionedCapability<Boolean> create2 = c2.canCreate();
            ScriptingCapabilities.VersionedCapability<Boolean> createAlone = c2.canCreateAlone();
            ScriptingCapabilities.VersionedCapability<Boolean> drop = d2.canDrop();
            ScriptingCapabilities.VersionedCapability<Boolean> alterAnything = a.canAlterAnything();
            ScriptingCapabilities.VersionedCapability<Boolean> truncate = t.canTruncate();
            ScriptingCapabilities.VersionedCapability<Boolean> refresh2 = ScriptCategory.REFRESH.getApplicableDbs().value((Object)AbstractScriptGenerator.this.getDbms()) && element2 instanceof BasicMatView ? AbstractScriptGeneratorKt.getSUPPORTED() : AbstractScriptGeneratorKt.getUNSUPPORTED();
            ScriptingCapabilities.VersionedCapability<Boolean> recompile = r.canRecompile();
            JBIterable jBIterable = element2.getMetaObject().getAllProperties().map(arg_0 -> CapabilitiesCollector.getCaps$lambda$2(getCaps.properties.1.INSTANCE, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"map(...)");
            Iterable iterable = (Iterable)jBIterable;
            ScriptGeneratorHelper scriptGeneratorHelper = AbstractScriptGenerator.this.getGeneratorHelper();
            BasicMetaObject<?> basicMetaObject = element2.getMetaObject();
            Intrinsics.checkNotNullExpressionValue(basicMetaObject, (String)"getMetaObject(...)");
            List properties2 = CollectionsKt.plus((Iterable)iterable, (Iterable)scriptGeneratorHelper.extraProperties(basicMetaObject));
            Sequence props = CollectionsKt.asSequence((Iterable)properties2);
            Map createCaps2 = MapsKt.toMap((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)props, (Function1)((Function1)new Function1<BasicMetaId, Pair<? extends BasicMetaId, ? extends ScriptingCapabilities.VersionedCapability<? extends Boolean>>>(c2){
                final /* synthetic */ CreateProducer<?> $c;
                {
                    this.$c = $c;
                    super(1);
                }

                @NotNull
                public final Pair<BasicMetaId, ScriptingCapabilities.VersionedCapability<Boolean>> invoke(@NotNull BasicMetaId it2) {
                    Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                    return TuplesKt.to((Object)it2, this.$c.canCreateWith(it2));
                }
            })), (Function1)getCaps.createCaps.2.INSTANCE));
            Map alterCaps2 = MapsKt.toMap((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)props, (Function1)((Function1)new Function1<BasicMetaId, Pair<? extends BasicMetaId, ? extends ScriptingCapabilities.VersionedCapability<? extends Boolean>>>(a){
                final /* synthetic */ AlterProducer<?> $a;
                {
                    this.$a = $a;
                    super(1);
                }

                @NotNull
                public final Pair<BasicMetaId, ScriptingCapabilities.VersionedCapability<Boolean>> invoke(@NotNull BasicMetaId it2) {
                    Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                    return TuplesKt.to((Object)it2, this.$a.canAlter(it2));
                }
            })), (Function1)getCaps.alterCaps.2.INSTANCE));
            HashSet conditionals2 = SequencesKt.toHashSet((Sequence)SequencesKt.filter((Sequence)props, (Function1)((Function1)new Function1<BasicMetaId, Boolean>(c2){
                final /* synthetic */ CreateProducer<?> $c;
                {
                    this.$c = $c;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull BasicMetaId it2) {
                    Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                    return this.$c.isConditional(it2);
                }
            })));
            Map supportedValues2 = MapsKt.toMap((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)properties2), (Function1)getCaps.supportedValues.1.INSTANCE), (Function1)new Function1<BasicMetaPropertyId<Enum<?>>, Pair<? extends BasicMetaPropertyId<Enum<?>>, ? extends List<? extends Enum<?>>>>(c2){
                final /* synthetic */ CreateProducer<?> $c;
                {
                    this.$c = $c;
                    super(1);
                }

                @Nullable
                public final Pair<BasicMetaPropertyId<Enum<?>>, List<Enum<?>>> invoke(@NotNull BasicMetaPropertyId<Enum<?>> it2) {
                    Pair pair;
                    Intrinsics.checkNotNullParameter(it2, (String)"it");
                    List<Enum<?>> list = this.$c.supportedValues(it2);
                    if (list != null) {
                        List<Enum<?>> v2 = list;
                        boolean bl = false;
                        pair = TuplesKt.to(it2, v2);
                    } else {
                        pair = null;
                    }
                    return pair;
                }
            }));
            Iterable[] iterableArray = new Iterable[6];
            iterableArray[0] = c2.edgeVersions();
            iterableArray[1] = d2.edgeVersions();
            iterableArray[2] = a.edgeVersions();
            ScriptingCapabilities.VersionedCapability[] versionedCapabilityArray = new ScriptingCapabilities.VersionedCapability[]{create2, createAlone, drop, truncate, refresh2, recompile};
            iterableArray[3] = this.extractVersions(versionedCapabilityArray);
            iterableArray[4] = this.extractVersions(createCaps2.values());
            iterableArray[5] = this.extractVersions(alterCaps2.values());
            return new ScriptingCapabilitiesImpl(create2, createAlone, c2.createVersion(), drop, alterAnything, truncate, refresh2, recompile, createCaps2, alterCaps2, conditionals2, supportedValues2, this.merge(iterableArray));
        }

        private final Iterable<Version> extractVersions(ScriptingCapabilities.VersionedCapability<?> ... vs) {
            JBIterable jBIterable = JBIterable.of((Object[])Arrays.copyOf(vs, vs.length));
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"of(...)");
            return this.extractVersions((Iterable)jBIterable);
        }

        private final Iterable<Version> extractVersions(Iterable<? extends ScriptingCapabilities.VersionedCapability<?>> iter) {
            JBIterable jBIterable = JBIterable.from(iter).flatMap(arg_0 -> CapabilitiesCollector.extractVersions$lambda$3((Function1)new Function1<ScriptingCapabilities.VersionedCapability<?>, Iterable<? extends Version>>(this){
                final /* synthetic */ CapabilitiesCollector this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final Iterable<Version> invoke(ScriptingCapabilities.VersionedCapability<?> it2) {
                    JBIterable jBIterable;
                    ScriptingCapabilities.VersionedCapability<?> versionedCapability = it2;
                    if (versionedCapability instanceof SupportedSinceImpl) {
                        JBIterable jBIterable2 = JBIterable.of((Object)((SupportedSinceImpl)it2).getSince());
                        jBIterable = jBIterable2;
                        Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"of(...)");
                    } else if (versionedCapability instanceof OrSupportedImpl) {
                        JBIterable jBIterable3 = JBIterable.from(((OrSupportedImpl)it2).getTerms()).flatMap(arg_0 -> extractVersions.1.invoke$lambda$0((Function1)new Function1<ScriptingCapabilities.VersionedCapability<? extends Boolean>, Iterable<? extends Version>>(this.this$0){
                            final /* synthetic */ CapabilitiesCollector this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final Iterable<Version> invoke(ScriptingCapabilities.VersionedCapability<Boolean> it2) {
                                ScriptingCapabilities.VersionedCapability[] versionedCapabilityArray = new ScriptingCapabilities.VersionedCapability[1];
                                Intrinsics.checkNotNull(it2);
                                versionedCapabilityArray[0] = it2;
                                return CapabilitiesCollector.access$extractVersions(this.this$0, versionedCapabilityArray);
                            }
                        }, arg_0));
                        jBIterable = jBIterable3;
                        Intrinsics.checkNotNullExpressionValue((Object)jBIterable3, (String)"flatMap(...)");
                    } else {
                        JBIterable jBIterable4 = JBIterable.empty();
                        jBIterable = jBIterable4;
                        Intrinsics.checkNotNullExpressionValue((Object)jBIterable4, (String)"empty(...)");
                    }
                    return (Iterable)jBIterable;
                }

                private static final Iterable invoke$lambda$0(Function1 $tmp0, Object p0) {
                    Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                    return (Iterable)$tmp0.invoke(p0);
                }
            }, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"flatMap(...)");
            return (Iterable)jBIterable;
        }

        private final Iterable<Version> merge(Iterable<Version> ... vs) {
            TreeSet res2 = new TreeSet();
            Iterable<Version>[] $this$forEach$iv = vs;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int j = 0; j < n; ++j) {
                Iterable<Version> element$iv;
                Iterable<Version> it2 = element$iv = $this$forEach$iv[j];
                boolean bl = false;
                CollectionsKt.toCollection(it2, (Collection)res2);
            }
            return CollectionsKt.toList((Iterable)res2);
        }

        private static final BasicMetaPropertyId getCaps$lambda$2(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (BasicMetaPropertyId)$tmp0.invoke(p0);
        }

        private static final Iterable extractVersions$lambda$3(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Iterable)$tmp0.invoke(p0);
        }

        public static final /* synthetic */ Iterable access$extractVersions(CapabilitiesCollector $this, ScriptingCapabilities.VersionedCapability ... vs) {
            return $this.extractVersions(vs);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0084\u0004\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\u0006H\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/database/dialects/base/generator/AbstractScriptGenerator$StupidGenerator;", "Lcom/intellij/database/dialects/base/generator/AbstractTransitionCodeGenerator;", "context", "Lcom/intellij/database/dialects/base/generator/ScriptingContext;", "(Lcom/intellij/database/dialects/base/generator/AbstractScriptGenerator;Lcom/intellij/database/dialects/base/generator/ScriptingContext;)V", "generateElement", "", "element", "Lcom/intellij/database/model/basic/BasicElement;", "prepareScenario", "intellij.database.dialects.base"})
    protected final class StupidGenerator
    extends AbstractTransitionCodeGenerator {
        public StupidGenerator(ScriptingContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            super(context);
            AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(){

                public final void invoke() {
                    CodeTextBuilder.append$default(this.getBuilder(), "-- We don't know how to generate " + this.getContext().getTask().getCategory().name() + " :(", null, false, null, 14, null);
                }
            }, 3, null);
        }

        @Override
        public void prepareScenario() {
        }

        @Override
        protected void generateElement(@NotNull BasicElement element2) {
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, element2){
                final /* synthetic */ StupidGenerator this$0;
                final /* synthetic */ BasicElement $element;
                {
                    this.this$0 = $receiver;
                    this.$element = $element;
                    super(0);
                }

                public final void invoke() {
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), "-- " + this.$element.getKind().code() + " " + this.$element.getName(), null, false, null, 14, null);
                }
            }, 3, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ScriptCategory.values().length];
            try {
                nArray[ScriptCategory.CREATE_DEFINITION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScriptCategory.CREATE_COMPLETE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScriptCategory.NATIVE_DEFINITION.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScriptCategory.ENABLE_CONSTRAINTS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScriptCategory.DISABLE_CONSTRAINTS.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScriptCategory.REFRESH.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScriptCategory.EXECUTE.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScriptCategory.ALTER.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScriptCategory.DROP_COMPLETE.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScriptCategory.TRUNCATE.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScriptCategory.RECOMPILE.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

