/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base;

import com.intellij.database.Dbms;
import com.intellij.database.console.JdbcEngine;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.console.session.DatabaseSessionManager;
import com.intellij.database.console.session.DatabaseSessionStateListener;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.DbOptionProvider;
import com.intellij.database.dataSource.ui.DbmsOutputOptionProvider;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.dialects.base.Db2DbmsOutputHandler;
import com.intellij.database.dialects.base.DbmsOutputHandler;
import com.intellij.database.dialects.base.DumbDbmsOutputNothingDoer;
import com.intellij.database.dialects.base.OracleDbmsOutputHandler;
import com.intellij.database.util.DbImplUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import java.sql.SQLException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001b\u001cB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\tH\u0002J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\rH\u0016J\u0018\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0004H\u0016J\u0010\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\rH\u0016J\u0018\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u0004H\u0002R\u0018\u0010\u0003\u001a\u00020\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u0004\u0018\u00010\t*\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lcom/intellij/database/dialects/base/ProcessDbmsOutputAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "()V", "dbmsOutputState", "", "Lcom/intellij/database/dataSource/DatabaseConnectionPoint;", "getDbmsOutputState", "(Lcom/intellij/database/dataSource/DatabaseConnectionPoint;)Z", "ifSupported", "Lcom/intellij/database/console/session/DatabaseSession;", "getIfSupported", "(Lcom/intellij/database/console/session/DatabaseSession;)Lcom/intellij/database/console/session/DatabaseSession;", "sessionIfSupported", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getSessionIfSupported", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)Lcom/intellij/database/console/session/DatabaseSession;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "initStateFor", "", "session", "isSelected", "e", "setSelected", "state", "update", "updateStateFor", "Companion", "MyDataAuditor", "intellij.database.dialects.base.ex"})
@SourceDebugExtension(value={"SMAP\nProcessDbmsOutputAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProcessDbmsOutputAction.kt\ncom/intellij/database/dialects/base/ProcessDbmsOutputAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,238:1\n1855#2:239\n1856#2:241\n1#3:240\n*S KotlinDebug\n*F\n+ 1 ProcessDbmsOutputAction.kt\ncom/intellij/database/dialects/base/ProcessDbmsOutputAction\n*L\n39#1:239\n39#1:241\n*E\n"})
public final class ProcessDbmsOutputAction
extends ToggleAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Key<MyDataAuditor> DBMS_LISTENER;

    public ProcessDbmsOutputAction() {
        Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
        Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
        for (Project project : projectArray) {
            Intrinsics.checkNotNull((Object)project);
            Iterable $this$forEach$iv = DatabaseSessionManager.getSessions(project);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DatabaseSession it2;
                DatabaseSession session2 = (DatabaseSession)element$iv;
                boolean bl = false;
                if (this.getIfSupported(session2) == null) continue;
                boolean bl2 = false;
                this.initStateFor(it2);
            }
        }
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(DatabaseSession.Companion.getTopic(), (Object)new DatabaseSessionStateListener.Adapter(){

            @Override
            public void stateChanged(@NotNull DatabaseSessionStateListener.ChangeEvent session2) {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
                    if (session2.getType() != DatabaseSessionStateListener.ChangeEvent.EventType.PUBLISHED) break block1;
                    DatabaseSession databaseSession = session2.getSession();
                    Intrinsics.checkNotNullExpressionValue((Object)databaseSession, (String)"getSession(...)");
                    DatabaseSession databaseSession2 = this.getIfSupported(databaseSession);
                    if (databaseSession2 != null) {
                        DatabaseSession databaseSession3 = databaseSession2;
                        ProcessDbmsOutputAction processDbmsOutputAction = this;
                        DatabaseSession it2 = databaseSession3;
                        boolean bl = false;
                        processDbmsOutputAction.initStateFor(it2);
                    }
                }
            }
        });
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e2) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        DatabaseSession session2 = this.getSessionIfSupported(e2);
        e2.getPresentation().setEnabledAndVisible(session2 != null);
        if (session2 != null) {
            super.update(e2);
        }
    }

    public boolean isSelected(@NotNull AnActionEvent e2) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        DatabaseSession databaseSession = this.getSessionIfSupported(e2);
        return (databaseSession != null ? (MyDataAuditor)databaseSession.getUserData(DBMS_LISTENER) : null) != null;
    }

    public void setSelected(@NotNull AnActionEvent e2, boolean state) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
            DatabaseSession databaseSession = this.getSessionIfSupported(e2);
            if (databaseSession == null) break block0;
            DatabaseSession it2 = databaseSession;
            boolean bl = false;
            this.updateStateFor(it2, state);
        }
    }

    private final void initStateFor(DatabaseSession session2) {
        Object object = session2.getTarget();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getTarget(...)");
        if (this.getDbmsOutputState((DatabaseConnectionPoint)object)) {
            this.updateStateFor(session2, true);
        }
    }

    private final void updateStateFor(DatabaseSession session2, boolean state) {
        block1: {
            block0: {
                if (!state) break block0;
                MyDataAuditor listener2 = new MyDataAuditor(session2);
                Disposer.register((Disposable)session2, (Disposable)listener2);
                session2.getMessageBus().addAuditor(listener2);
                session2.putUserData(DBMS_LISTENER, listener2);
                break block1;
            }
            MyDataAuditor myDataAuditor = (MyDataAuditor)session2.getUserData(DBMS_LISTENER);
            if (myDataAuditor == null) break block1;
            MyDataAuditor listener3 = myDataAuditor;
            boolean bl = false;
            session2.putUserData(DBMS_LISTENER, null);
            Disposer.dispose((Disposable)listener3);
        }
    }

    private final DatabaseSession getSessionIfSupported(AnActionEvent $this$sessionIfSupported) {
        DatabaseSession databaseSession = DatabaseSessionManager.findSession($this$sessionIfSupported);
        return databaseSession != null ? this.getIfSupported(databaseSession) : null;
    }

    private final DatabaseSession getIfSupported(DatabaseSession $this$ifSupported) {
        DatabaseSession databaseSession;
        DatabaseSession it2 = databaseSession = $this$ifSupported;
        boolean bl = false;
        return DbImplUtil.supportsDbmsOutput(((DatabaseConnectionPoint)$this$ifSupported.getTarget()).getDbms()) ? databaseSession : null;
    }

    private final boolean getDbmsOutputState(DatabaseConnectionPoint $this$dbmsOutputState) {
        return Intrinsics.areEqual(DbOptionProvider.getOptionValue($this$dbmsOutputState, DbmsOutputOptionProvider.class), (Object)true);
    }

    static {
        Key key2 = Key.create((String)"DBMS_LISTENER");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        DBMS_LISTENER = key2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R!\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\t\u0018\u00010\t\u00a2\u0006\u0002\b\n*\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/dialects/base/ProcessDbmsOutputAction$Companion;", "", "()V", "DBMS_LISTENER", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/database/dialects/base/ProcessDbmsOutputAction$MyDataAuditor;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "connection", "Lcom/intellij/database/dataSource/DatabaseConnection;", "Lorg/jetbrains/annotations/Nullable;", "Lcom/intellij/database/datagrid/DataRequest$Context;", "getConnection", "(Lcom/intellij/database/datagrid/DataRequest$Context;)Lcom/intellij/database/dataSource/DatabaseConnection;", "intellij.database.dialects.base.ex"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final DatabaseConnection getConnection(@NotNull DataRequest.Context $this$connection) {
            Intrinsics.checkNotNullParameter((Object)((Object)$this$connection), (String)"<this>");
            DataProducer dataProducer = $this$connection.producer;
            JdbcEngine jdbcEngine = dataProducer instanceof JdbcEngine ? (JdbcEngine)dataProducer : null;
            return jdbcEngine != null ? jdbcEngine.getCurrentConnectionIfReady() : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\tH\u0016J\u001f\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000fH\u0082\bJ\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/database/dialects/base/ProcessDbmsOutputAction$MyDataAuditor;", "Lcom/intellij/database/datagrid/DataAuditor;", "Lcom/intellij/openapi/Disposable;", "session", "Lcom/intellij/database/console/session/DatabaseSession;", "(Lcom/intellij/database/console/session/DatabaseSession;)V", "helper", "Lcom/intellij/database/dialects/base/DbmsOutputHandler;", "beforeStatement", "", "context", "Lcom/intellij/database/datagrid/DataRequest$Context;", "dispose", "handle", "call", "Lkotlin/Function0;", "requestFinished", "intellij.database.dialects.base.ex"})
    @SourceDebugExtension(value={"SMAP\nProcessDbmsOutputAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProcessDbmsOutputAction.kt\ncom/intellij/database/dialects/base/ProcessDbmsOutputAction$MyDataAuditor\n*L\n1#1,238:1\n62#1,7:239\n62#1,7:246\n*S KotlinDebug\n*F\n+ 1 ProcessDbmsOutputAction.kt\ncom/intellij/database/dialects/base/ProcessDbmsOutputAction$MyDataAuditor\n*L\n72#1:239,7\n86#1:246,7\n*E\n"})
    private static final class MyDataAuditor
    implements DataAuditor,
    Disposable {
        @NotNull
        private final DatabaseSession session;
        @NotNull
        private final DbmsOutputHandler helper;

        public MyDataAuditor(@NotNull DatabaseSession session2) {
            DbmsOutputHandler dbmsOutputHandler;
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            this.session = session2;
            Dbms dbms = ((DatabaseConnectionPoint)this.session.getTarget()).getDbms();
            if (Intrinsics.areEqual((Object)dbms, (Object)Dbms.ORACLE)) {
                dbmsOutputHandler = new OracleDbmsOutputHandler();
            } else if (Intrinsics.areEqual((Object)dbms, (Object)Dbms.DB2_LUW)) {
                Dbms dbms2 = ((DatabaseConnectionPoint)this.session.getTarget()).getDbms();
                Intrinsics.checkNotNullExpressionValue((Object)dbms2, (String)"getDbms(...)");
                dbmsOutputHandler = new Db2DbmsOutputHandler(dbms2);
            } else {
                dbmsOutputHandler = DumbDbmsOutputNothingDoer.INSTANCE;
            }
            this.helper = dbmsOutputHandler;
        }

        private final void handle(DataRequest.Context context, Function0<Unit> call2) {
            boolean $i$f$handle = false;
            try {
                call2.invoke();
            }
            catch (Exception e2) {
                context.error(e2);
            }
        }

        @Override
        public void beforeStatement(@NotNull DataRequest.Context context) {
            Intrinsics.checkNotNullParameter((Object)((Object)context), (String)"context");
            DatabaseConnection databaseConnection = Companion.getConnection(context);
            if (databaseConnection == null) {
                return;
            }
            DatabaseConnection connection2 = databaseConnection;
            MyDataAuditor this_$iv = this;
            boolean $i$f$handle = false;
            try {
                boolean bl = false;
                DbmsOutputHandler.enable$default(this.helper, connection2, 0, 2, null);
            }
            catch (Exception e$iv) {
                context.error(e$iv);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void requestFinished(@NotNull DataRequest.Context context) {
            Intrinsics.checkNotNullParameter((Object)((Object)context), (String)"context");
            DatabaseConnection databaseConnection = Companion.getConnection(context);
            if (databaseConnection == null) {
                return;
            }
            DatabaseConnection connection2 = databaseConnection;
            try {
                this.helper.processOutput(connection2, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(context){
                    final /* synthetic */ DataRequest.Context $context;
                    {
                        this.$context = $context;
                        super(1);
                    }

                    public final void invoke(@NotNull String line) {
                        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                        this.$context.warn(line, true);
                    }
                }));
            }
            catch (SQLException this_$iv) {
            }
            catch (Exception e2) {
                context.error(e2);
            }
            finally {
                MyDataAuditor this_$iv = this;
                boolean $i$f$handle = false;
                try {
                    boolean bl = false;
                    this.helper.disable(connection2);
                }
                catch (Exception e$iv) {
                    context.error(e$iv);
                }
            }
        }

        public void dispose() {
        }
    }
}

