/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base;

import com.intellij.database.Dbms;
import com.intellij.database.datagrid.HookUpHelper;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.SearchPath;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlPsiFacade;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J6\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J6\u0010\u0012\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u0012\u0010\u0014\u001a\u00020\f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u0012\u0010\u0015\u001a\u00020\f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0018\u001a\u00020\f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u0012\u0010\u0019\u001a\u00020\f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u0012\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J\u0012\u0010\u001e\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001f"}, d2={"Lcom/intellij/database/dialects/base/BaseHookUpHelper;", "Lcom/intellij/database/datagrid/HookUpHelper;", "dbms", "Lcom/intellij/database/Dbms;", "(Lcom/intellij/database/Dbms;)V", "getDbms", "()Lcom/intellij/database/Dbms;", "createFilterCodeFragment", "Lcom/intellij/psi/PsiCodeFragment;", "project", "Lcom/intellij/openapi/project/Project;", "filterText", "", "queryText", "dataSource", "Lcom/intellij/database/psi/DbDataSource;", "table", "Lcom/intellij/database/model/DasObject;", "createSortingCodeFragment", "sortingText", "getFilterEmptyText", "getFilterPrefix", "getFilterSortLanguage", "Lcom/intellij/sql/dialects/SqlLanguageDialect;", "getSortingEmptyText", "getSortingPrefix", "isFilterApplicable", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "isSortingApplicable", "intellij.database.dialects.base"})
public abstract class BaseHookUpHelper
implements HookUpHelper {
    @NotNull
    private final Dbms dbms;

    public BaseHookUpHelper(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        this.dbms = dbms;
    }

    @NotNull
    protected final Dbms getDbms() {
        return this.dbms;
    }

    @NotNull
    public SqlLanguageDialect getFilterSortLanguage(@NotNull DbDataSource dataSource2) {
        Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
        SqlLanguageDialect sqlLanguageDialect = DbSqlUtilCore.getSqlDialect(dataSource2);
        Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialect, (String)"getSqlDialect(...)");
        return sqlLanguageDialect;
    }

    @Override
    public boolean isFilterApplicable(@Nullable ObjectKind kind) {
        return true;
    }

    @Override
    @NotNull
    public String getFilterPrefix(@Nullable DasObject table) {
        return "WHERE";
    }

    @Override
    @NotNull
    public String getFilterEmptyText(@Nullable DasObject table) {
        return "";
    }

    @Override
    @Nullable
    public PsiCodeFragment createFilterCodeFragment(@NotNull Project project, @NotNull String filterText, @Nullable String queryText2, @NotNull DbDataSource dataSource2, @Nullable DasObject table) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)filterText, (String)"filterText");
        Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
        if (queryText2 == null) {
            return null;
        }
        SqlPsiFacade sqlPsiFacade = SqlPsiFacade.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)sqlPsiFacade, (String)"getInstance(...)");
        SqlPsiFacade psiFacade2 = sqlPsiFacade;
        SearchPath searchPath = DbImplUtilCore.getSearchPath(dataSource2, table);
        return (PsiCodeFragment)psiFacade2.createExpressionFragment((Language)this.getFilterSortLanguage(dataSource2), dataSource2, searchPath, filterText, queryText2);
    }

    @Override
    public boolean isSortingApplicable(@Nullable ObjectKind kind) {
        return true;
    }

    @Override
    @NotNull
    public String getSortingPrefix(@Nullable DasObject table) {
        return "ORDER BY";
    }

    @Override
    @NotNull
    public String getSortingEmptyText(@Nullable DasObject table) {
        return "";
    }

    @Override
    @Nullable
    public PsiCodeFragment createSortingCodeFragment(@NotNull Project project, @NotNull String sortingText, @Nullable String queryText2, @NotNull DbDataSource dataSource2, @Nullable DasObject table) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sortingText, (String)"sortingText");
        Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
        if (queryText2 == null) {
            return null;
        }
        SqlPsiFacade sqlPsiFacade = SqlPsiFacade.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)sqlPsiFacade, (String)"getInstance(...)");
        SqlPsiFacade psiFacade2 = sqlPsiFacade;
        SearchPath searchPath = DbImplUtilCore.getSearchPath(dataSource2, table);
        return (PsiCodeFragment)psiFacade2.createOrderByFragment((Language)this.getFilterSortLanguage(dataSource2), dataSource2, searchPath, sortingText, queryText2);
    }
}

